<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_f_list = new product_f_list();

// Run the page
$product_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_flist = currentForm = new ew.Form("fproduct_flist", "list");
fproduct_flist.formKeyCountName = '<?php echo $product_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_flist.lists["x_grp"] = <?php echo $product_f_list->grp->Lookup->toClientList() ?>;
fproduct_flist.lists["x_grp"].options = <?php echo JsonEncode($product_f_list->grp->options(FALSE, TRUE)) ?>;
fproduct_flist.lists["x_s_grp"] = <?php echo $product_f_list->s_grp->Lookup->toClientList() ?>;
fproduct_flist.lists["x_s_grp"].options = <?php echo JsonEncode($product_f_list->s_grp->lookupOptions()) ?>;
fproduct_flist.lists["x_status"] = <?php echo $product_f_list->status->Lookup->toClientList() ?>;
fproduct_flist.lists["x_status"].options = <?php echo JsonEncode($product_f_list->status->options(FALSE, TRUE)) ?>;
fproduct_flist.lists["x_operator"] = <?php echo $product_f_list->operator->Lookup->toClientList() ?>;
fproduct_flist.lists["x_operator"].options = <?php echo JsonEncode($product_f_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_flistsrch = currentSearchForm = new ew.Form("fproduct_flistsrch");

// Validate function for search
fproduct_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_f->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_flistsrch.lists["x_grp"] = <?php echo $product_f_list->grp->Lookup->toClientList() ?>;
fproduct_flistsrch.lists["x_grp"].options = <?php echo JsonEncode($product_f_list->grp->options(FALSE, TRUE)) ?>;
fproduct_flistsrch.lists["x_s_grp"] = <?php echo $product_f_list->s_grp->Lookup->toClientList() ?>;
fproduct_flistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($product_f_list->s_grp->lookupOptions()) ?>;

// Filters
fproduct_flistsrch.filterList = <?php echo $product_f_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_f_list->TotalRecs > 0 && $product_f_list->ExportOptions->visible()) { ?>
<?php $product_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_f_list->ImportOptions->visible()) { ?>
<?php $product_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_f_list->SearchOptions->visible()) { ?>
<?php $product_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_f_list->FilterOptions->visible()) { ?>
<?php $product_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_f->isExport() && !$product_f->CurrentAction) { ?>
<form name="fproduct_flistsrch" id="fproduct_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_f->RowType = ROWTYPE_SEARCH;

// Render row
$product_f->resetAttributes();
$product_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_f->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $product_f->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $product_f->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_f->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_grp" data-value-separator="<?php echo $product_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_f->grp->editAttributes() ?>>
		<?php echo $product_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($product_f->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $product_f->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_s_grp" data-value-separator="<?php echo $product_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_f->s_grp->editAttributes() ?>>
		<?php echo $product_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_f->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $product_f->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_f" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->product->getPlaceHolder()) ?>" value="<?php echo $product_f->product->EditValue ?>"<?php echo $product_f->product->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_f_list->showPageHeader(); ?>
<?php
$product_f_list->showMessage();
?>
<?php if ($product_f_list->TotalRecs > 0 || $product_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_f">
<?php if (!$product_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_f_list->Pager)) $product_f_list->Pager = new PrevNextPager($product_f_list->StartRec, $product_f_list->DisplayRecs, $product_f_list->TotalRecs, $product_f_list->AutoHidePager) ?>
<?php if ($product_f_list->Pager->RecordCount > 0 && $product_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_f_list->TotalRecs > 0 && (!$product_f_list->AutoHidePageSizeSelector || $product_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_flist" id="fproduct_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_f">
<div id="gmp_product_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_f_list->TotalRecs > 0 || $product_f->isGridEdit()) { ?>
<table id="tbl_product_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_f_list->renderListOptions();

// Render list options (header, left)
$product_f_list->ListOptions->render("header", "left");
?>
<?php if ($product_f->id->Visible) { // id ?>
	<?php if ($product_f->sortUrl($product_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_f->id->headerCellClass() ?>"><div id="elh_product_f_id" class="product_f_id"><div class="ew-table-header-caption"><?php echo $product_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->id) ?>',2);"><div id="elh_product_f_id" class="product_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->grp->Visible) { // grp ?>
	<?php if ($product_f->sortUrl($product_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_f->grp->headerCellClass() ?>"><div id="elh_product_f_grp" class="product_f_grp"><div class="ew-table-header-caption"><?php echo $product_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->grp) ?>',2);"><div id="elh_product_f_grp" class="product_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->s_grp->Visible) { // s_grp ?>
	<?php if ($product_f->sortUrl($product_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_f->s_grp->headerCellClass() ?>"><div id="elh_product_f_s_grp" class="product_f_s_grp"><div class="ew-table-header-caption"><?php echo $product_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->s_grp) ?>',2);"><div id="elh_product_f_s_grp" class="product_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->product->Visible) { // product ?>
	<?php if ($product_f->sortUrl($product_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_f->product->headerCellClass() ?>"><div id="elh_product_f_product" class="product_f_product"><div class="ew-table-header-caption"><?php echo $product_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->product) ?>',2);"><div id="elh_product_f_product" class="product_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->remarks->Visible) { // remarks ?>
	<?php if ($product_f->sortUrl($product_f->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $product_f->remarks->headerCellClass() ?>"><div id="elh_product_f_remarks" class="product_f_remarks"><div class="ew-table-header-caption"><?php echo $product_f->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $product_f->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->remarks) ?>',2);"><div id="elh_product_f_remarks" class="product_f_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->status->Visible) { // status ?>
	<?php if ($product_f->sortUrl($product_f->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_f->status->headerCellClass() ?>"><div id="elh_product_f_status" class="product_f_status"><div class="ew-table-header-caption"><?php echo $product_f->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_f->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->status) ?>',2);"><div id="elh_product_f_status" class="product_f_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->operator->Visible) { // operator ?>
	<?php if ($product_f->sortUrl($product_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_f->operator->headerCellClass() ?>"><div id="elh_product_f_operator" class="product_f_operator"><div class="ew-table-header-caption"><?php echo $product_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->operator) ?>',2);"><div id="elh_product_f_operator" class="product_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_f->datetime->Visible) { // datetime ?>
	<?php if ($product_f->sortUrl($product_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_f->datetime->headerCellClass() ?>"><div id="elh_product_f_datetime" class="product_f_datetime"><div class="ew-table-header-caption"><?php echo $product_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_f->SortUrl($product_f->datetime) ?>',2);"><div id="elh_product_f_datetime" class="product_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_f->ExportAll && $product_f->isExport()) {
	$product_f_list->StopRec = $product_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_f_list->TotalRecs > $product_f_list->StartRec + $product_f_list->DisplayRecs - 1)
		$product_f_list->StopRec = $product_f_list->StartRec + $product_f_list->DisplayRecs - 1;
	else
		$product_f_list->StopRec = $product_f_list->TotalRecs;
}
$product_f_list->RecCnt = $product_f_list->StartRec - 1;
if ($product_f_list->Recordset && !$product_f_list->Recordset->EOF) {
	$product_f_list->Recordset->moveFirst();
	$selectLimit = $product_f_list->UseSelectLimit;
	if (!$selectLimit && $product_f_list->StartRec > 1)
		$product_f_list->Recordset->move($product_f_list->StartRec - 1);
} elseif (!$product_f->AllowAddDeleteRow && $product_f_list->StopRec == 0) {
	$product_f_list->StopRec = $product_f->GridAddRowCount;
}

// Initialize aggregate
$product_f->RowType = ROWTYPE_AGGREGATEINIT;
$product_f->resetAttributes();
$product_f_list->renderRow();
while ($product_f_list->RecCnt < $product_f_list->StopRec) {
	$product_f_list->RecCnt++;
	if ($product_f_list->RecCnt >= $product_f_list->StartRec) {
		$product_f_list->RowCnt++;

		// Set up key count
		$product_f_list->KeyCount = $product_f_list->RowIndex;

		// Init row class and style
		$product_f->resetAttributes();
		$product_f->CssClass = "";
		if ($product_f->isGridAdd()) {
		} else {
			$product_f_list->loadRowValues($product_f_list->Recordset); // Load row values
		}
		$product_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_f->RowAttrs = array_merge($product_f->RowAttrs, array('data-rowindex'=>$product_f_list->RowCnt, 'id'=>'r' . $product_f_list->RowCnt . '_product_f', 'data-rowtype'=>$product_f->RowType));

		// Render row
		$product_f_list->renderRow();

		// Render list options
		$product_f_list->renderListOptions();
?>
	<tr<?php echo $product_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_f_list->ListOptions->render("body", "left", $product_f_list->RowCnt);
?>
	<?php if ($product_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_f->id->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_id" class="product_f_id">
<span<?php echo $product_f->id->viewAttributes() ?>>
<?php echo $product_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_f->grp->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_grp" class="product_f_grp">
<span<?php echo $product_f->grp->viewAttributes() ?>>
<?php echo $product_f->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_f->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_s_grp" class="product_f_s_grp">
<span<?php echo $product_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_f->s_grp->getViewValue())) && $product_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_f->s_grp->linkAttributes() ?>><?php echo $product_f->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_f->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_f->product->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_product" class="product_f_product">
<span<?php echo $product_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_f->product->getViewValue())) && $product_f->product->linkAttributes() <> "") { ?>
<a<?php echo $product_f->product->linkAttributes() ?>><?php echo $product_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $product_f->remarks->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_remarks" class="product_f_remarks">
<span<?php echo $product_f->remarks->viewAttributes() ?>>
<?php echo $product_f->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_f->status->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_status" class="product_f_status">
<span<?php echo $product_f->status->viewAttributes() ?>>
<?php echo $product_f->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_f->operator->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_operator" class="product_f_operator">
<span<?php echo $product_f->operator->viewAttributes() ?>>
<?php echo $product_f->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_f_list->RowCnt ?>_product_f_datetime" class="product_f_datetime">
<span<?php echo $product_f->datetime->viewAttributes() ?>>
<?php echo $product_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_f_list->ListOptions->render("body", "right", $product_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_f->isGridAdd())
		$product_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_f_list->Recordset)
	$product_f_list->Recordset->Close();
?>
<?php if (!$product_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_f_list->Pager)) $product_f_list->Pager = new PrevNextPager($product_f_list->StartRec, $product_f_list->DisplayRecs, $product_f_list->TotalRecs, $product_f_list->AutoHidePager) ?>
<?php if ($product_f_list->Pager->RecordCount > 0 && $product_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_f_list->pageUrl() ?>start=<?php echo $product_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_f_list->TotalRecs > 0 && (!$product_f_list->AutoHidePageSizeSelector || $product_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_f_list->TotalRecs == 0 && !$product_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_f_list->terminate();
?>