<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_fp_add = new product_fp_add();

// Run the page
$product_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduct_fpadd = currentForm = new ew.Form("fproduct_fpadd", "add");

// Validate form
fproduct_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_fp_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->grp->caption(), $product_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->s_grp->caption(), $product_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->product->caption(), $product_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product_fp->product->errorMessage()) ?>");
		<?php if ($product_fp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->remarks->caption(), $product_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->status->caption(), $product_fp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->operator->caption(), $product_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->datetime->caption(), $product_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fpadd.lists["x_grp"] = <?php echo $product_fp_add->grp->Lookup->toClientList() ?>;
fproduct_fpadd.lists["x_grp"].options = <?php echo JsonEncode($product_fp_add->grp->options(FALSE, TRUE)) ?>;
fproduct_fpadd.lists["x_s_grp"] = <?php echo $product_fp_add->s_grp->Lookup->toClientList() ?>;
fproduct_fpadd.lists["x_s_grp"].options = <?php echo JsonEncode($product_fp_add->s_grp->lookupOptions()) ?>;
fproduct_fpadd.lists["x_status"] = <?php echo $product_fp_add->status->Lookup->toClientList() ?>;
fproduct_fpadd.lists["x_status"].options = <?php echo JsonEncode($product_fp_add->status->options(FALSE, TRUE)) ?>;
fproduct_fpadd.lists["x_operator"] = <?php echo $product_fp_add->operator->Lookup->toClientList() ?>;
fproduct_fpadd.lists["x_operator"].options = <?php echo JsonEncode($product_fp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_fp_add->showPageHeader(); ?>
<?php
$product_fp_add->showMessage();
?>
<form name="fproduct_fpadd" id="fproduct_fpadd" class="<?php echo $product_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$product_fp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($product_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_product_fp_grp" for="x_grp" class="<?php echo $product_fp_add->LeftColumnClass ?>"><?php echo $product_fp->grp->caption() ?><?php echo ($product_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_fp_add->RightColumnClass ?>"><div<?php echo $product_fp->grp->cellAttributes() ?>>
<span id="el_product_fp_grp">
<?php $product_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_grp" data-value-separator="<?php echo $product_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_fp->grp->editAttributes() ?>>
		<?php echo $product_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $product_fp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_product_fp_s_grp" for="x_s_grp" class="<?php echo $product_fp_add->LeftColumnClass ?>"><?php echo $product_fp->s_grp->caption() ?><?php echo ($product_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_fp_add->RightColumnClass ?>"><div<?php echo $product_fp->s_grp->cellAttributes() ?>>
<span id="el_product_fp_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_s_grp" data-value-separator="<?php echo $product_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_fp->s_grp->editAttributes() ?>>
		<?php echo $product_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $product_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_product_fp_product" for="x_product" class="<?php echo $product_fp_add->LeftColumnClass ?>"><?php echo $product_fp->product->caption() ?><?php echo ($product_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_fp_add->RightColumnClass ?>"><div<?php echo $product_fp->product->cellAttributes() ?>>
<span id="el_product_fp_product">
<input type="text" data-table="product_fp" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->product->getPlaceHolder()) ?>" value="<?php echo $product_fp->product->EditValue ?>"<?php echo $product_fp->product->editAttributes() ?>>
</span>
<?php echo $product_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_product_fp_remarks" for="x_remarks" class="<?php echo $product_fp_add->LeftColumnClass ?>"><?php echo $product_fp->remarks->caption() ?><?php echo ($product_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_fp_add->RightColumnClass ?>"><div<?php echo $product_fp->remarks->cellAttributes() ?>>
<span id="el_product_fp_remarks">
<input type="text" data-table="product_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $product_fp->remarks->EditValue ?>"<?php echo $product_fp->remarks->editAttributes() ?>>
</span>
<?php echo $product_fp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_fp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_fp_status" for="x_status" class="<?php echo $product_fp_add->LeftColumnClass ?>"><?php echo $product_fp->status->caption() ?><?php echo ($product_fp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_fp_add->RightColumnClass ?>"><div<?php echo $product_fp->status->cellAttributes() ?>>
<span id="el_product_fp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_status" data-value-separator="<?php echo $product_fp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_fp->status->editAttributes() ?>>
		<?php echo $product_fp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $product_fp->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_fp_add->terminate();
?>