<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_fp_addopt = new product_fp_addopt();

// Run the page
$product_fp_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_fp_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fproduct_fpaddopt = currentForm = new ew.Form("fproduct_fpaddopt", "addopt");

// Validate form
fproduct_fpaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_fp_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->grp->caption(), $product_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->s_grp->caption(), $product_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->product->caption(), $product_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product_fp->product->errorMessage()) ?>");
		<?php if ($product_fp_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->remarks->caption(), $product_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->status->caption(), $product_fp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->operator->caption(), $product_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_fp_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_fp->datetime->caption(), $product_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_fpaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fpaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fpaddopt.lists["x_grp"] = <?php echo $product_fp_addopt->grp->Lookup->toClientList() ?>;
fproduct_fpaddopt.lists["x_grp"].options = <?php echo JsonEncode($product_fp_addopt->grp->options(FALSE, TRUE)) ?>;
fproduct_fpaddopt.lists["x_s_grp"] = <?php echo $product_fp_addopt->s_grp->Lookup->toClientList() ?>;
fproduct_fpaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($product_fp_addopt->s_grp->lookupOptions()) ?>;
fproduct_fpaddopt.lists["x_status"] = <?php echo $product_fp_addopt->status->Lookup->toClientList() ?>;
fproduct_fpaddopt.lists["x_status"].options = <?php echo JsonEncode($product_fp_addopt->status->options(FALSE, TRUE)) ?>;
fproduct_fpaddopt.lists["x_operator"] = <?php echo $product_fp_addopt->operator->Lookup->toClientList() ?>;
fproduct_fpaddopt.lists["x_operator"].options = <?php echo JsonEncode($product_fp_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_fp_addopt->showPageHeader(); ?>
<?php
$product_fp_addopt->showMessage();
?>
<form name="fproduct_fpaddopt" id="fproduct_fpaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($product_fp_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_fp_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $product_fp_addopt->TableVar ?>">
<?php if ($product_fp->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $product_fp->grp->caption() ?><?php echo ($product_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $product_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_grp" data-value-separator="<?php echo $product_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_fp->grp->editAttributes() ?>>
		<?php echo $product_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_fp->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $product_fp->s_grp->caption() ?><?php echo ($product_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_s_grp" data-value-separator="<?php echo $product_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_fp->s_grp->editAttributes() ?>>
		<?php echo $product_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $product_fp->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_fp->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $product_fp->product->caption() ?><?php echo ($product_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product_fp" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->product->getPlaceHolder()) ?>" value="<?php echo $product_fp->product->EditValue ?>"<?php echo $product_fp->product->editAttributes() ?>>
<?php echo $product_fp->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_fp->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $product_fp->remarks->caption() ?><?php echo ($product_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $product_fp->remarks->EditValue ?>"<?php echo $product_fp->remarks->editAttributes() ?>>
<?php echo $product_fp->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_fp->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $product_fp->status->caption() ?><?php echo ($product_fp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_status" data-value-separator="<?php echo $product_fp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_fp->status->editAttributes() ?>>
		<?php echo $product_fp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $product_fp->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_fp->operator->Visible) { // operator ?>
	<input type="hidden" data-table="product_fp" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($product_fp->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($product_fp->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="product_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($product_fp->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$product_fp_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$product_fp_addopt->terminate();
?>