<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_fp_list = new product_fp_list();

// Run the page
$product_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_fplist = currentForm = new ew.Form("fproduct_fplist", "list");
fproduct_fplist.formKeyCountName = '<?php echo $product_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fplist.lists["x_grp"] = <?php echo $product_fp_list->grp->Lookup->toClientList() ?>;
fproduct_fplist.lists["x_grp"].options = <?php echo JsonEncode($product_fp_list->grp->options(FALSE, TRUE)) ?>;
fproduct_fplist.lists["x_s_grp"] = <?php echo $product_fp_list->s_grp->Lookup->toClientList() ?>;
fproduct_fplist.lists["x_s_grp"].options = <?php echo JsonEncode($product_fp_list->s_grp->lookupOptions()) ?>;
fproduct_fplist.lists["x_status"] = <?php echo $product_fp_list->status->Lookup->toClientList() ?>;
fproduct_fplist.lists["x_status"].options = <?php echo JsonEncode($product_fp_list->status->options(FALSE, TRUE)) ?>;
fproduct_fplist.lists["x_operator"] = <?php echo $product_fp_list->operator->Lookup->toClientList() ?>;
fproduct_fplist.lists["x_operator"].options = <?php echo JsonEncode($product_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_fplistsrch = currentSearchForm = new ew.Form("fproduct_fplistsrch");

// Validate function for search
fproduct_fplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_fp->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_fplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fplistsrch.lists["x_grp"] = <?php echo $product_fp_list->grp->Lookup->toClientList() ?>;
fproduct_fplistsrch.lists["x_grp"].options = <?php echo JsonEncode($product_fp_list->grp->options(FALSE, TRUE)) ?>;
fproduct_fplistsrch.lists["x_s_grp"] = <?php echo $product_fp_list->s_grp->Lookup->toClientList() ?>;
fproduct_fplistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($product_fp_list->s_grp->lookupOptions()) ?>;

// Filters
fproduct_fplistsrch.filterList = <?php echo $product_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_fp_list->TotalRecs > 0 && $product_fp_list->ExportOptions->visible()) { ?>
<?php $product_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_fp_list->ImportOptions->visible()) { ?>
<?php $product_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_fp_list->SearchOptions->visible()) { ?>
<?php $product_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_fp_list->FilterOptions->visible()) { ?>
<?php $product_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_fp->isExport() && !$product_fp->CurrentAction) { ?>
<form name="fproduct_fplistsrch" id="fproduct_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_fp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_fp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_fp->RowType = ROWTYPE_SEARCH;

// Render row
$product_fp->resetAttributes();
$product_fp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_fp->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $product_fp->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $product_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_grp" data-value-separator="<?php echo $product_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_fp->grp->editAttributes() ?>>
		<?php echo $product_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $product_fp->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_s_grp" data-value-separator="<?php echo $product_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_fp->s_grp->editAttributes() ?>>
		<?php echo $product_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_fp->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $product_fp->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_fp" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->product->getPlaceHolder()) ?>" value="<?php echo $product_fp->product->EditValue ?>"<?php echo $product_fp->product->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_fp_list->showPageHeader(); ?>
<?php
$product_fp_list->showMessage();
?>
<?php if ($product_fp_list->TotalRecs > 0 || $product_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_fp">
<?php if (!$product_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_fp_list->Pager)) $product_fp_list->Pager = new PrevNextPager($product_fp_list->StartRec, $product_fp_list->DisplayRecs, $product_fp_list->TotalRecs, $product_fp_list->AutoHidePager) ?>
<?php if ($product_fp_list->Pager->RecordCount > 0 && $product_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_fp_list->TotalRecs > 0 && (!$product_fp_list->AutoHidePageSizeSelector || $product_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_fplist" id="fproduct_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_fp">
<div id="gmp_product_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_fp_list->TotalRecs > 0 || $product_fp->isGridEdit()) { ?>
<table id="tbl_product_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_fp_list->renderListOptions();

// Render list options (header, left)
$product_fp_list->ListOptions->render("header", "left");
?>
<?php if ($product_fp->id->Visible) { // id ?>
	<?php if ($product_fp->sortUrl($product_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_fp->id->headerCellClass() ?>"><div id="elh_product_fp_id" class="product_fp_id"><div class="ew-table-header-caption"><?php echo $product_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->id) ?>',2);"><div id="elh_product_fp_id" class="product_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->grp->Visible) { // grp ?>
	<?php if ($product_fp->sortUrl($product_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_fp->grp->headerCellClass() ?>"><div id="elh_product_fp_grp" class="product_fp_grp"><div class="ew-table-header-caption"><?php echo $product_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->grp) ?>',2);"><div id="elh_product_fp_grp" class="product_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
	<?php if ($product_fp->sortUrl($product_fp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_fp->s_grp->headerCellClass() ?>"><div id="elh_product_fp_s_grp" class="product_fp_s_grp"><div class="ew-table-header-caption"><?php echo $product_fp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_fp->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->s_grp) ?>',2);"><div id="elh_product_fp_s_grp" class="product_fp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_fp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->product->Visible) { // product ?>
	<?php if ($product_fp->sortUrl($product_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_fp->product->headerCellClass() ?>"><div id="elh_product_fp_product" class="product_fp_product"><div class="ew-table-header-caption"><?php echo $product_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->product) ?>',2);"><div id="elh_product_fp_product" class="product_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->remarks->Visible) { // remarks ?>
	<?php if ($product_fp->sortUrl($product_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $product_fp->remarks->headerCellClass() ?>"><div id="elh_product_fp_remarks" class="product_fp_remarks"><div class="ew-table-header-caption"><?php echo $product_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $product_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->remarks) ?>',2);"><div id="elh_product_fp_remarks" class="product_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->status->Visible) { // status ?>
	<?php if ($product_fp->sortUrl($product_fp->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_fp->status->headerCellClass() ?>"><div id="elh_product_fp_status" class="product_fp_status"><div class="ew-table-header-caption"><?php echo $product_fp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_fp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->status) ?>',2);"><div id="elh_product_fp_status" class="product_fp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_fp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->operator->Visible) { // operator ?>
	<?php if ($product_fp->sortUrl($product_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_fp->operator->headerCellClass() ?>"><div id="elh_product_fp_operator" class="product_fp_operator"><div class="ew-table-header-caption"><?php echo $product_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->operator) ?>',2);"><div id="elh_product_fp_operator" class="product_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_fp->datetime->Visible) { // datetime ?>
	<?php if ($product_fp->sortUrl($product_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_fp->datetime->headerCellClass() ?>"><div id="elh_product_fp_datetime" class="product_fp_datetime"><div class="ew-table-header-caption"><?php echo $product_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_fp->SortUrl($product_fp->datetime) ?>',2);"><div id="elh_product_fp_datetime" class="product_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_fp->ExportAll && $product_fp->isExport()) {
	$product_fp_list->StopRec = $product_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_fp_list->TotalRecs > $product_fp_list->StartRec + $product_fp_list->DisplayRecs - 1)
		$product_fp_list->StopRec = $product_fp_list->StartRec + $product_fp_list->DisplayRecs - 1;
	else
		$product_fp_list->StopRec = $product_fp_list->TotalRecs;
}
$product_fp_list->RecCnt = $product_fp_list->StartRec - 1;
if ($product_fp_list->Recordset && !$product_fp_list->Recordset->EOF) {
	$product_fp_list->Recordset->moveFirst();
	$selectLimit = $product_fp_list->UseSelectLimit;
	if (!$selectLimit && $product_fp_list->StartRec > 1)
		$product_fp_list->Recordset->move($product_fp_list->StartRec - 1);
} elseif (!$product_fp->AllowAddDeleteRow && $product_fp_list->StopRec == 0) {
	$product_fp_list->StopRec = $product_fp->GridAddRowCount;
}

// Initialize aggregate
$product_fp->RowType = ROWTYPE_AGGREGATEINIT;
$product_fp->resetAttributes();
$product_fp_list->renderRow();
while ($product_fp_list->RecCnt < $product_fp_list->StopRec) {
	$product_fp_list->RecCnt++;
	if ($product_fp_list->RecCnt >= $product_fp_list->StartRec) {
		$product_fp_list->RowCnt++;

		// Set up key count
		$product_fp_list->KeyCount = $product_fp_list->RowIndex;

		// Init row class and style
		$product_fp->resetAttributes();
		$product_fp->CssClass = "";
		if ($product_fp->isGridAdd()) {
		} else {
			$product_fp_list->loadRowValues($product_fp_list->Recordset); // Load row values
		}
		$product_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_fp->RowAttrs = array_merge($product_fp->RowAttrs, array('data-rowindex'=>$product_fp_list->RowCnt, 'id'=>'r' . $product_fp_list->RowCnt . '_product_fp', 'data-rowtype'=>$product_fp->RowType));

		// Render row
		$product_fp_list->renderRow();

		// Render list options
		$product_fp_list->renderListOptions();
?>
	<tr<?php echo $product_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_fp_list->ListOptions->render("body", "left", $product_fp_list->RowCnt);
?>
	<?php if ($product_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_fp->id->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_id" class="product_fp_id">
<span<?php echo $product_fp->id->viewAttributes() ?>>
<?php echo $product_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_grp" class="product_fp_grp">
<span<?php echo $product_fp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_fp->grp->getViewValue())) && $product_fp->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_fp->grp->linkAttributes() ?>><?php echo $product_fp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_fp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_fp->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_s_grp" class="product_fp_s_grp">
<span<?php echo $product_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_fp->s_grp->getViewValue())) && $product_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_fp->s_grp->linkAttributes() ?>><?php echo $product_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_fp->product->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_product" class="product_fp_product">
<span<?php echo $product_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_fp->product->getViewValue())) && $product_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $product_fp->product->linkAttributes() ?>><?php echo $product_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $product_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_remarks" class="product_fp_remarks">
<span<?php echo $product_fp->remarks->viewAttributes() ?>>
<?php echo $product_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_fp->status->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_status" class="product_fp_status">
<span<?php echo $product_fp->status->viewAttributes() ?>>
<?php echo $product_fp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_operator" class="product_fp_operator">
<span<?php echo $product_fp->operator->viewAttributes() ?>>
<?php echo $product_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_fp_list->RowCnt ?>_product_fp_datetime" class="product_fp_datetime">
<span<?php echo $product_fp->datetime->viewAttributes() ?>>
<?php echo $product_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_fp_list->ListOptions->render("body", "right", $product_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_fp->isGridAdd())
		$product_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_fp_list->Recordset)
	$product_fp_list->Recordset->Close();
?>
<?php if (!$product_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_fp_list->Pager)) $product_fp_list->Pager = new PrevNextPager($product_fp_list->StartRec, $product_fp_list->DisplayRecs, $product_fp_list->TotalRecs, $product_fp_list->AutoHidePager) ?>
<?php if ($product_fp_list->Pager->RecordCount > 0 && $product_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_fp_list->pageUrl() ?>start=<?php echo $product_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_fp_list->TotalRecs > 0 && (!$product_fp_list->AutoHidePageSizeSelector || $product_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_fp_list->TotalRecs == 0 && !$product_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_fp_list->terminate();
?>