<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_fp_search = new product_fp_search();

// Run the page
$product_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_fp_search->IsModal) { ?>
var fproduct_fpsearch = currentAdvancedSearchForm = new ew.Form("fproduct_fpsearch", "search");
<?php } else { ?>
var fproduct_fpsearch = currentForm = new ew.Form("fproduct_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fpsearch.lists["x_grp"] = <?php echo $product_fp_search->grp->Lookup->toClientList() ?>;
fproduct_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($product_fp_search->grp->options(FALSE, TRUE)) ?>;
fproduct_fpsearch.lists["x_s_grp"] = <?php echo $product_fp_search->s_grp->Lookup->toClientList() ?>;
fproduct_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($product_fp_search->s_grp->lookupOptions()) ?>;
fproduct_fpsearch.lists["x_status"] = <?php echo $product_fp_search->status->Lookup->toClientList() ?>;
fproduct_fpsearch.lists["x_status"].options = <?php echo JsonEncode($product_fp_search->status->options(FALSE, TRUE)) ?>;
fproduct_fpsearch.lists["x_operator"] = <?php echo $product_fp_search->operator->Lookup->toClientList() ?>;
fproduct_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($product_fp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduct_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_fp->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_fp->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_fp_search->showPageHeader(); ?>
<?php
$product_fp_search->showMessage();
?>
<form name="fproduct_fpsearch" id="fproduct_fpsearch" class="<?php echo $product_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_id"><?php echo $product_fp->id->caption() ?></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_id" id="z_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($product_fp->id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_product_fp_id">
<input type="text" data-table="product_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_fp->id->getPlaceHolder()) ?>" value="<?php echo $product_fp->id->EditValue ?>"<?php echo $product_fp->id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_product_fp_id" class="btw1_id d-none">
<input type="text" data-table="product_fp" data-field="x_id" name="y_id" id="y_id" placeholder="<?php echo HtmlEncode($product_fp->id->getPlaceHolder()) ?>" value="<?php echo $product_fp->id->EditValue2 ?>"<?php echo $product_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_grp"><?php echo $product_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->grp->cellAttributes() ?>>
			<span id="el_product_fp_grp">
<?php $product_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_grp" data-value-separator="<?php echo $product_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_fp->grp->editAttributes() ?>>
		<?php echo $product_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_s_grp"><?php echo $product_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->s_grp->cellAttributes() ?>>
			<span id="el_product_fp_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_s_grp" data-value-separator="<?php echo $product_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_fp->s_grp->editAttributes() ?>>
		<?php echo $product_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_product"><?php echo $product_fp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->product->cellAttributes() ?>>
			<span id="el_product_fp_product">
<input type="text" data-table="product_fp" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->product->getPlaceHolder()) ?>" value="<?php echo $product_fp->product->EditValue ?>"<?php echo $product_fp->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_remarks"><?php echo $product_fp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->remarks->cellAttributes() ?>>
			<span id="el_product_fp_remarks">
<input type="text" data-table="product_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $product_fp->remarks->EditValue ?>"<?php echo $product_fp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_status"><?php echo $product_fp->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->status->cellAttributes() ?>>
			<span id="el_product_fp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_status" data-value-separator="<?php echo $product_fp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_fp->status->editAttributes() ?>>
		<?php echo $product_fp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_operator"><?php echo $product_fp->operator->caption() ?></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->operator->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_operator" id="z_operator" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($product_fp->operator->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_product_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_operator" data-value-separator="<?php echo $product_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $product_fp->operator->editAttributes() ?>>
		<?php echo $product_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $product_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
			<span class="ew-search-cond btw1_operator d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_product_fp_operator" class="btw1_operator d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_fp" data-field="x_operator" data-value-separator="<?php echo $product_fp->operator->displayValueSeparatorAttribute() ?>" id="y_operator" name="y_operator"<?php echo $product_fp->operator->editAttributes() ?>>
		<?php echo $product_fp->operator->selectOptionListHtml("y_operator") ?>
	</select>
</div>
<?php echo $product_fp->operator->Lookup->getParamTag("p_y_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_fp_search->LeftColumnClass ?>"><span id="elh_product_fp_datetime"><?php echo $product_fp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_fp_search->RightColumnClass ?>"><div<?php echo $product_fp->datetime->cellAttributes() ?>>
			<span id="el_product_fp_datetime">
<input type="text" data-table="product_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $product_fp->datetime->EditValue ?>"<?php echo $product_fp->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_fp_search->terminate();
?>