<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_f_search = new product_f_search();

// Run the page
$product_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_f_search->IsModal) { ?>
var fproduct_fsearch = currentAdvancedSearchForm = new ew.Form("fproduct_fsearch", "search");
<?php } else { ?>
var fproduct_fsearch = currentForm = new ew.Form("fproduct_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fsearch.lists["x_grp"] = <?php echo $product_f_search->grp->Lookup->toClientList() ?>;
fproduct_fsearch.lists["x_grp"].options = <?php echo JsonEncode($product_f_search->grp->options(FALSE, TRUE)) ?>;
fproduct_fsearch.lists["x_s_grp"] = <?php echo $product_f_search->s_grp->Lookup->toClientList() ?>;
fproduct_fsearch.lists["x_s_grp"].options = <?php echo JsonEncode($product_f_search->s_grp->lookupOptions()) ?>;
fproduct_fsearch.lists["x_status"] = <?php echo $product_f_search->status->Lookup->toClientList() ?>;
fproduct_fsearch.lists["x_status"].options = <?php echo JsonEncode($product_f_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fproduct_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_f->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_f_search->showPageHeader(); ?>
<?php
$product_f_search->showMessage();
?>
<form name="fproduct_fsearch" id="fproduct_fsearch" class="<?php echo $product_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $product_f_search->LeftColumnClass ?>"><span id="elh_product_f_grp"><?php echo $product_f->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_f_search->RightColumnClass ?>"><div<?php echo $product_f->grp->cellAttributes() ?>>
			<span id="el_product_f_grp">
<?php $product_f->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_f->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_grp" data-value-separator="<?php echo $product_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_f->grp->editAttributes() ?>>
		<?php echo $product_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $product_f_search->LeftColumnClass ?>"><span id="elh_product_f_s_grp"><?php echo $product_f->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_f_search->RightColumnClass ?>"><div<?php echo $product_f->s_grp->cellAttributes() ?>>
			<span id="el_product_f_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_s_grp" data-value-separator="<?php echo $product_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_f->s_grp->editAttributes() ?>>
		<?php echo $product_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_f_search->LeftColumnClass ?>"><span id="elh_product_f_product"><?php echo $product_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_f_search->RightColumnClass ?>"><div<?php echo $product_f->product->cellAttributes() ?>>
			<span id="el_product_f_product">
<input type="text" data-table="product_f" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->product->getPlaceHolder()) ?>" value="<?php echo $product_f->product->EditValue ?>"<?php echo $product_f->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_f_search->LeftColumnClass ?>"><span id="elh_product_f_remarks"><?php echo $product_f->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_f_search->RightColumnClass ?>"><div<?php echo $product_f->remarks->cellAttributes() ?>>
			<span id="el_product_f_remarks">
<input type="text" data-table="product_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->remarks->getPlaceHolder()) ?>" value="<?php echo $product_f->remarks->EditValue ?>"<?php echo $product_f->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_f->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_f_search->LeftColumnClass ?>"><span id="elh_product_f_status"><?php echo $product_f->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_f_search->RightColumnClass ?>"><div<?php echo $product_f->status->cellAttributes() ?>>
			<span id="el_product_f_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_status" data-value-separator="<?php echo $product_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_f->status->editAttributes() ?>>
		<?php echo $product_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_f_search->terminate();
?>