<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_g_edit = new product_g_edit();

// Run the page
$product_g_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_g_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproduct_gedit = currentForm = new ew.Form("fproduct_gedit", "edit");

// Validate form
fproduct_gedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_g_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->id->caption(), $product_g->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->grp->caption(), $product_g->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->s_grp->caption(), $product_g->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->product->caption(), $product_g->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product_g->product->errorMessage()) ?>");
		<?php if ($product_g_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->remarks->caption(), $product_g->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->status->caption(), $product_g->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->company_id->caption(), $product_g->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->operator->caption(), $product_g->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_g_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_g->datetime->caption(), $product_g->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_gedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_gedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_gedit.lists["x_grp[]"] = <?php echo $product_g_edit->grp->Lookup->toClientList() ?>;
fproduct_gedit.lists["x_grp[]"].options = <?php echo JsonEncode($product_g_edit->grp->lookupOptions()) ?>;
fproduct_gedit.lists["x_status"] = <?php echo $product_g_edit->status->Lookup->toClientList() ?>;
fproduct_gedit.lists["x_status"].options = <?php echo JsonEncode($product_g_edit->status->options(FALSE, TRUE)) ?>;
fproduct_gedit.lists["x_company_id"] = <?php echo $product_g_edit->company_id->Lookup->toClientList() ?>;
fproduct_gedit.lists["x_company_id"].options = <?php echo JsonEncode($product_g_edit->company_id->lookupOptions()) ?>;
fproduct_gedit.lists["x_operator"] = <?php echo $product_g_edit->operator->Lookup->toClientList() ?>;
fproduct_gedit.lists["x_operator"].options = <?php echo JsonEncode($product_g_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_g_edit->showPageHeader(); ?>
<?php
$product_g_edit->showMessage();
?>
<form name="fproduct_gedit" id="fproduct_gedit" class="<?php echo $product_g_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_g_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_g_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_g">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$product_g_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($product_g->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_product_g_id" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->id->caption() ?><?php echo ($product_g->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->id->cellAttributes() ?>>
<span id="el_product_g_id">
<span<?php echo $product_g->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_g->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="product_g" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($product_g->id->CurrentValue) ?>">
<?php echo $product_g->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_product_g_grp" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->grp->caption() ?><?php echo ($product_g->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->grp->cellAttributes() ?>>
<span id="el_product_g_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product_g" data-field="x_grp" data-value-separator="<?php echo $product_g->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product_g->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product_g->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product_g->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $product_g->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_product_g_s_grp" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->s_grp->caption() ?><?php echo ($product_g->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->s_grp->cellAttributes() ?>>
<span id="el_product_g_s_grp">
<input type="text" data-table="product_g" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($product_g->s_grp->getPlaceHolder()) ?>" value="<?php echo $product_g->s_grp->EditValue ?>"<?php echo $product_g->s_grp->editAttributes() ?>>
</span>
<?php echo $product_g->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_product_g_product" for="x_product" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->product->caption() ?><?php echo ($product_g->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->product->cellAttributes() ?>>
<span id="el_product_g_product">
<input type="text" data-table="product_g" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_g->product->getPlaceHolder()) ?>" value="<?php echo $product_g->product->EditValue ?>"<?php echo $product_g->product->editAttributes() ?>>
</span>
<?php echo $product_g->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_product_g_remarks" for="x_remarks" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->remarks->caption() ?><?php echo ($product_g->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->remarks->cellAttributes() ?>>
<span id="el_product_g_remarks">
<input type="text" data-table="product_g" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_g->remarks->getPlaceHolder()) ?>" value="<?php echo $product_g->remarks->EditValue ?>"<?php echo $product_g->remarks->editAttributes() ?>>
</span>
<?php echo $product_g->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_g_status" for="x_status" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->status->caption() ?><?php echo ($product_g->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->status->cellAttributes() ?>>
<span id="el_product_g_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_status" data-value-separator="<?php echo $product_g->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_g->status->editAttributes() ?>>
		<?php echo $product_g->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $product_g->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_g->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_product_g_company_id" for="x_company_id" class="<?php echo $product_g_edit->LeftColumnClass ?>"><?php echo $product_g->company_id->caption() ?><?php echo ($product_g->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_g_edit->RightColumnClass ?>"><div<?php echo $product_g->company_id->cellAttributes() ?>>
<span id="el_product_g_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_company_id" data-value-separator="<?php echo $product_g->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product_g->company_id->editAttributes() ?>>
		<?php echo $product_g->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product_g->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $product_g->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_g_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_g_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_g_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_g_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_g_edit->terminate();
?>