<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_g_list = new product_g_list();

// Run the page
$product_g_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_g_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_g->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_glist = currentForm = new ew.Form("fproduct_glist", "list");
fproduct_glist.formKeyCountName = '<?php echo $product_g_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_glist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_glist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_glist.lists["x_status"] = <?php echo $product_g_list->status->Lookup->toClientList() ?>;
fproduct_glist.lists["x_status"].options = <?php echo JsonEncode($product_g_list->status->options(FALSE, TRUE)) ?>;
fproduct_glist.lists["x_company_id"] = <?php echo $product_g_list->company_id->Lookup->toClientList() ?>;
fproduct_glist.lists["x_company_id"].options = <?php echo JsonEncode($product_g_list->company_id->lookupOptions()) ?>;
fproduct_glist.lists["x_operator"] = <?php echo $product_g_list->operator->Lookup->toClientList() ?>;
fproduct_glist.lists["x_operator"].options = <?php echo JsonEncode($product_g_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_glistsrch = currentSearchForm = new ew.Form("fproduct_glistsrch");

// Validate function for search
fproduct_glistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_g->s_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_g->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_glistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_glistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fproduct_glistsrch.filterList = <?php echo $product_g_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_glistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_g->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_g_list->TotalRecs > 0 && $product_g_list->ExportOptions->visible()) { ?>
<?php $product_g_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_g_list->ImportOptions->visible()) { ?>
<?php $product_g_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_g_list->SearchOptions->visible()) { ?>
<?php $product_g_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_g_list->FilterOptions->visible()) { ?>
<?php $product_g_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_g_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_g->isExport() && !$product_g->CurrentAction) { ?>
<form name="fproduct_glistsrch" id="fproduct_glistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_g_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_glistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_g">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_g_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_g->RowType = ROWTYPE_SEARCH;

// Render row
$product_g->resetAttributes();
$product_g_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_g->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $product_g->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="product_g" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($product_g->s_grp->getPlaceHolder()) ?>" value="<?php echo $product_g->s_grp->EditValue ?>"<?php echo $product_g->s_grp->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($product_g->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $product_g->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_g" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_g->product->getPlaceHolder()) ?>" value="<?php echo $product_g->product->EditValue ?>"<?php echo $product_g->product->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_g_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_g_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_g_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_g_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_g_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_g_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_g_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_g_list->showPageHeader(); ?>
<?php
$product_g_list->showMessage();
?>
<?php if ($product_g_list->TotalRecs > 0 || $product_g->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_g_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_g">
<?php if (!$product_g->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_g_list->Pager)) $product_g_list->Pager = new PrevNextPager($product_g_list->StartRec, $product_g_list->DisplayRecs, $product_g_list->TotalRecs, $product_g_list->AutoHidePager) ?>
<?php if ($product_g_list->Pager->RecordCount > 0 && $product_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_g_list->TotalRecs > 0 && (!$product_g_list->AutoHidePageSizeSelector || $product_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_glist" id="fproduct_glist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_g_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_g_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_g">
<div id="gmp_product_g" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_g_list->TotalRecs > 0 || $product_g->isGridEdit()) { ?>
<table id="tbl_product_glist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_g_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_g_list->renderListOptions();

// Render list options (header, left)
$product_g_list->ListOptions->render("header", "left");
?>
<?php if ($product_g->id->Visible) { // id ?>
	<?php if ($product_g->sortUrl($product_g->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_g->id->headerCellClass() ?>"><div id="elh_product_g_id" class="product_g_id"><div class="ew-table-header-caption"><?php echo $product_g->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_g->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->id) ?>',2);"><div id="elh_product_g_id" class="product_g_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_g->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->s_grp->Visible) { // s_grp ?>
	<?php if ($product_g->sortUrl($product_g->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_g->s_grp->headerCellClass() ?>"><div id="elh_product_g_s_grp" class="product_g_s_grp"><div class="ew-table-header-caption"><?php echo $product_g->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_g->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->s_grp) ?>',2);"><div id="elh_product_g_s_grp" class="product_g_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->s_grp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_g->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->product->Visible) { // product ?>
	<?php if ($product_g->sortUrl($product_g->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_g->product->headerCellClass() ?>"><div id="elh_product_g_product" class="product_g_product"><div class="ew-table-header-caption"><?php echo $product_g->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_g->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->product) ?>',2);"><div id="elh_product_g_product" class="product_g_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_g->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->remarks->Visible) { // remarks ?>
	<?php if ($product_g->sortUrl($product_g->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $product_g->remarks->headerCellClass() ?>"><div id="elh_product_g_remarks" class="product_g_remarks"><div class="ew-table-header-caption"><?php echo $product_g->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $product_g->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->remarks) ?>',2);"><div id="elh_product_g_remarks" class="product_g_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_g->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->status->Visible) { // status ?>
	<?php if ($product_g->sortUrl($product_g->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_g->status->headerCellClass() ?>"><div id="elh_product_g_status" class="product_g_status"><div class="ew-table-header-caption"><?php echo $product_g->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_g->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->status) ?>',2);"><div id="elh_product_g_status" class="product_g_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_g->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->company_id->Visible) { // company_id ?>
	<?php if ($product_g->sortUrl($product_g->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product_g->company_id->headerCellClass() ?>"><div id="elh_product_g_company_id" class="product_g_company_id"><div class="ew-table-header-caption"><?php echo $product_g->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product_g->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->company_id) ?>',2);"><div id="elh_product_g_company_id" class="product_g_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_g->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->operator->Visible) { // operator ?>
	<?php if ($product_g->sortUrl($product_g->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_g->operator->headerCellClass() ?>"><div id="elh_product_g_operator" class="product_g_operator"><div class="ew-table-header-caption"><?php echo $product_g->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_g->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->operator) ?>',2);"><div id="elh_product_g_operator" class="product_g_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_g->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_g->datetime->Visible) { // datetime ?>
	<?php if ($product_g->sortUrl($product_g->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_g->datetime->headerCellClass() ?>"><div id="elh_product_g_datetime" class="product_g_datetime"><div class="ew-table-header-caption"><?php echo $product_g->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_g->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_g->SortUrl($product_g->datetime) ?>',2);"><div id="elh_product_g_datetime" class="product_g_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_g->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_g->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_g->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_g_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_g->ExportAll && $product_g->isExport()) {
	$product_g_list->StopRec = $product_g_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_g_list->TotalRecs > $product_g_list->StartRec + $product_g_list->DisplayRecs - 1)
		$product_g_list->StopRec = $product_g_list->StartRec + $product_g_list->DisplayRecs - 1;
	else
		$product_g_list->StopRec = $product_g_list->TotalRecs;
}
$product_g_list->RecCnt = $product_g_list->StartRec - 1;
if ($product_g_list->Recordset && !$product_g_list->Recordset->EOF) {
	$product_g_list->Recordset->moveFirst();
	$selectLimit = $product_g_list->UseSelectLimit;
	if (!$selectLimit && $product_g_list->StartRec > 1)
		$product_g_list->Recordset->move($product_g_list->StartRec - 1);
} elseif (!$product_g->AllowAddDeleteRow && $product_g_list->StopRec == 0) {
	$product_g_list->StopRec = $product_g->GridAddRowCount;
}

// Initialize aggregate
$product_g->RowType = ROWTYPE_AGGREGATEINIT;
$product_g->resetAttributes();
$product_g_list->renderRow();
while ($product_g_list->RecCnt < $product_g_list->StopRec) {
	$product_g_list->RecCnt++;
	if ($product_g_list->RecCnt >= $product_g_list->StartRec) {
		$product_g_list->RowCnt++;

		// Set up key count
		$product_g_list->KeyCount = $product_g_list->RowIndex;

		// Init row class and style
		$product_g->resetAttributes();
		$product_g->CssClass = "";
		if ($product_g->isGridAdd()) {
		} else {
			$product_g_list->loadRowValues($product_g_list->Recordset); // Load row values
		}
		$product_g->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_g->RowAttrs = array_merge($product_g->RowAttrs, array('data-rowindex'=>$product_g_list->RowCnt, 'id'=>'r' . $product_g_list->RowCnt . '_product_g', 'data-rowtype'=>$product_g->RowType));

		// Render row
		$product_g_list->renderRow();

		// Render list options
		$product_g_list->renderListOptions();
?>
	<tr<?php echo $product_g->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_g_list->ListOptions->render("body", "left", $product_g_list->RowCnt);
?>
	<?php if ($product_g->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_g->id->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_id" class="product_g_id">
<span<?php echo $product_g->id->viewAttributes() ?>>
<?php echo $product_g->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_g->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_s_grp" class="product_g_s_grp">
<span<?php echo $product_g->s_grp->viewAttributes() ?>>
<?php echo $product_g->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_g->product->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_product" class="product_g_product">
<span<?php echo $product_g->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_g->product->getViewValue())) && $product_g->product->linkAttributes() <> "") { ?>
<a<?php echo $product_g->product->linkAttributes() ?>><?php echo $product_g->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_g->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $product_g->remarks->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_remarks" class="product_g_remarks">
<span<?php echo $product_g->remarks->viewAttributes() ?>>
<?php echo $product_g->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_g->status->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_status" class="product_g_status">
<span<?php echo $product_g->status->viewAttributes() ?>>
<?php echo $product_g->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product_g->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_company_id" class="product_g_company_id">
<span<?php echo $product_g->company_id->viewAttributes() ?>>
<?php echo $product_g->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_g->operator->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_operator" class="product_g_operator">
<span<?php echo $product_g->operator->viewAttributes() ?>>
<?php echo $product_g->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_g->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_g->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_g_list->RowCnt ?>_product_g_datetime" class="product_g_datetime">
<span<?php echo $product_g->datetime->viewAttributes() ?>>
<?php echo $product_g->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_g_list->ListOptions->render("body", "right", $product_g_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_g->isGridAdd())
		$product_g_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_g->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_g_list->Recordset)
	$product_g_list->Recordset->Close();
?>
<?php if (!$product_g->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_g_list->Pager)) $product_g_list->Pager = new PrevNextPager($product_g_list->StartRec, $product_g_list->DisplayRecs, $product_g_list->TotalRecs, $product_g_list->AutoHidePager) ?>
<?php if ($product_g_list->Pager->RecordCount > 0 && $product_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_g_list->pageUrl() ?>start=<?php echo $product_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_g_list->TotalRecs > 0 && (!$product_g_list->AutoHidePageSizeSelector || $product_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_g_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_g_list->TotalRecs == 0 && !$product_g->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_g_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_g->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_g->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_g", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_g_list->terminate();
?>