<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_group_list = new product_group_list();

// Run the page
$product_group_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_group_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_group->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_grouplist = currentForm = new ew.Form("fproduct_grouplist", "list");
fproduct_grouplist.formKeyCountName = '<?php echo $product_group_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_grouplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_grouplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_grouplist.lists["x_grp"] = <?php echo $product_group_list->grp->Lookup->toClientList() ?>;
fproduct_grouplist.lists["x_grp"].options = <?php echo JsonEncode($product_group_list->grp->lookupOptions()) ?>;
fproduct_grouplist.lists["x_calculation_method"] = <?php echo $product_group_list->calculation_method->Lookup->toClientList() ?>;
fproduct_grouplist.lists["x_calculation_method"].options = <?php echo JsonEncode($product_group_list->calculation_method->lookupOptions()) ?>;
fproduct_grouplist.lists["x_process"] = <?php echo $product_group_list->process->Lookup->toClientList() ?>;
fproduct_grouplist.lists["x_process"].options = <?php echo JsonEncode($product_group_list->process->lookupOptions()) ?>;
fproduct_grouplist.lists["x_status"] = <?php echo $product_group_list->status->Lookup->toClientList() ?>;
fproduct_grouplist.lists["x_status"].options = <?php echo JsonEncode($product_group_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fproduct_grouplistsrch = currentSearchForm = new ew.Form("fproduct_grouplistsrch");

// Validate function for search
fproduct_grouplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_grouplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_grouplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_grouplistsrch.lists["x_grp"] = <?php echo $product_group_list->grp->Lookup->toClientList() ?>;
fproduct_grouplistsrch.lists["x_grp"].options = <?php echo JsonEncode($product_group_list->grp->lookupOptions()) ?>;
fproduct_grouplistsrch.lists["x_status"] = <?php echo $product_group_list->status->Lookup->toClientList() ?>;
fproduct_grouplistsrch.lists["x_status"].options = <?php echo JsonEncode($product_group_list->status->options(FALSE, TRUE)) ?>;

// Filters
fproduct_grouplistsrch.filterList = <?php echo $product_group_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_grouplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_group_list->TotalRecs > 0 && $product_group_list->ExportOptions->visible()) { ?>
<?php $product_group_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_group_list->ImportOptions->visible()) { ?>
<?php $product_group_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_group_list->SearchOptions->visible()) { ?>
<?php $product_group_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_group_list->FilterOptions->visible()) { ?>
<?php $product_group_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_group_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_group->isExport() && !$product_group->CurrentAction) { ?>
<form name="fproduct_grouplistsrch" id="fproduct_grouplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_group_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_grouplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_group">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_group_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_group->RowType = ROWTYPE_SEARCH;

// Render row
$product_group->resetAttributes();
$product_group_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_group->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $product_group->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_grp" data-value-separator="<?php echo $product_group->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_group->grp->editAttributes() ?>>
		<?php echo $product_group->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_group->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_group->product_group->Visible) { // product_group ?>
	<div id="xsc_product_group" class="ew-cell form-group">
		<label for="x_product_group" class="ew-search-caption ew-label"><?php echo $product_group->product_group->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_group" id="z_product_group" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_group" data-field="x_product_group" name="x_product_group" id="x_product_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->product_group->getPlaceHolder()) ?>" value="<?php echo $product_group->product_group->EditValue ?>"<?php echo $product_group->product_group->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($product_group->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $product_group->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_status" data-value-separator="<?php echo $product_group->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_group->status->editAttributes() ?>>
		<?php echo $product_group->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_group_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_group_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_group_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_group_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_group_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_group_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_group_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_group_list->showPageHeader(); ?>
<?php
$product_group_list->showMessage();
?>
<?php if ($product_group_list->TotalRecs > 0 || $product_group->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_group_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_group">
<?php if (!$product_group->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_group->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_group_list->Pager)) $product_group_list->Pager = new PrevNextPager($product_group_list->StartRec, $product_group_list->DisplayRecs, $product_group_list->TotalRecs, $product_group_list->AutoHidePager) ?>
<?php if ($product_group_list->Pager->RecordCount > 0 && $product_group_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_group_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_group_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_group_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_group_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_group_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_group_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_group_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_group_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_group_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_group_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_group_list->TotalRecs > 0 && (!$product_group_list->AutoHidePageSizeSelector || $product_group_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_group">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_group_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_group_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_group_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_group_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_group_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_group->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_group_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_grouplist" id="fproduct_grouplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_group_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_group_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_group">
<div id="gmp_product_group" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_group_list->TotalRecs > 0 || $product_group->isGridEdit()) { ?>
<table id="tbl_product_grouplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_group_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_group_list->renderListOptions();

// Render list options (header, left)
$product_group_list->ListOptions->render("header", "left");
?>
<?php if ($product_group->id->Visible) { // id ?>
	<?php if ($product_group->sortUrl($product_group->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_group->id->headerCellClass() ?>"><div id="elh_product_group_id" class="product_group_id"><div class="ew-table-header-caption"><?php echo $product_group->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_group->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->id) ?>',2);"><div id="elh_product_group_id" class="product_group_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->grp->Visible) { // grp ?>
	<?php if ($product_group->sortUrl($product_group->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_group->grp->headerCellClass() ?>"><div id="elh_product_group_grp" class="product_group_grp"><div class="ew-table-header-caption"><?php echo $product_group->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_group->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->grp) ?>',2);"><div id="elh_product_group_grp" class="product_group_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->product_group->Visible) { // product_group ?>
	<?php if ($product_group->sortUrl($product_group->product_group) == "") { ?>
		<th data-name="product_group" class="<?php echo $product_group->product_group->headerCellClass() ?>"><div id="elh_product_group_product_group" class="product_group_product_group"><div class="ew-table-header-caption"><?php echo $product_group->product_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_group" class="<?php echo $product_group->product_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->product_group) ?>',2);"><div id="elh_product_group_product_group" class="product_group_product_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->product_group->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->product_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->product_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->calculation_method->Visible) { // calculation_method ?>
	<?php if ($product_group->sortUrl($product_group->calculation_method) == "") { ?>
		<th data-name="calculation_method" class="<?php echo $product_group->calculation_method->headerCellClass() ?>"><div id="elh_product_group_calculation_method" class="product_group_calculation_method"><div class="ew-table-header-caption"><?php echo $product_group->calculation_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="calculation_method" class="<?php echo $product_group->calculation_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->calculation_method) ?>',2);"><div id="elh_product_group_calculation_method" class="product_group_calculation_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->calculation_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->calculation_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->calculation_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->shape->Visible) { // shape ?>
	<?php if ($product_group->sortUrl($product_group->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $product_group->shape->headerCellClass() ?>"><div id="elh_product_group_shape" class="product_group_shape"><div class="ew-table-header-caption"><?php echo $product_group->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $product_group->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->shape) ?>',2);"><div id="elh_product_group_shape" class="product_group_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->shape->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->sqm->Visible) { // sqm ?>
	<?php if ($product_group->sortUrl($product_group->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $product_group->sqm->headerCellClass() ?>"><div id="elh_product_group_sqm" class="product_group_sqm"><div class="ew-table-header-caption"><?php echo $product_group->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $product_group->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->sqm) ?>',2);"><div id="elh_product_group_sqm" class="product_group_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->cbm->Visible) { // cbm ?>
	<?php if ($product_group->sortUrl($product_group->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $product_group->cbm->headerCellClass() ?>"><div id="elh_product_group_cbm" class="product_group_cbm"><div class="ew-table-header-caption"><?php echo $product_group->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $product_group->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->cbm) ?>',2);"><div id="elh_product_group_cbm" class="product_group_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->process->Visible) { // process ?>
	<?php if ($product_group->sortUrl($product_group->process) == "") { ?>
		<th data-name="process" class="<?php echo $product_group->process->headerCellClass() ?>"><div id="elh_product_group_process" class="product_group_process"><div class="ew-table-header-caption"><?php echo $product_group->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $product_group->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->process) ?>',2);"><div id="elh_product_group_process" class="product_group_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->status->Visible) { // status ?>
	<?php if ($product_group->sortUrl($product_group->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_group->status->headerCellClass() ?>"><div id="elh_product_group_status" class="product_group_status"><div class="ew-table-header-caption"><?php echo $product_group->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_group->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->status) ?>',2);"><div id="elh_product_group_status" class="product_group_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_00->Visible) { // v_00 ?>
	<?php if ($product_group->sortUrl($product_group->v_00) == "") { ?>
		<th data-name="v_00" class="<?php echo $product_group->v_00->headerCellClass() ?>"><div id="elh_product_group_v_00" class="product_group_v_00"><div class="ew-table-header-caption"><?php echo $product_group->v_00->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_00" class="<?php echo $product_group->v_00->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_00) ?>',2);"><div id="elh_product_group_v_00" class="product_group_v_00">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_00->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_00->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_00->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_01->Visible) { // v_01 ?>
	<?php if ($product_group->sortUrl($product_group->v_01) == "") { ?>
		<th data-name="v_01" class="<?php echo $product_group->v_01->headerCellClass() ?>"><div id="elh_product_group_v_01" class="product_group_v_01"><div class="ew-table-header-caption"><?php echo $product_group->v_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_01" class="<?php echo $product_group->v_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_01) ?>',2);"><div id="elh_product_group_v_01" class="product_group_v_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_01_validation->Visible) { // v_01_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_01_validation) == "") { ?>
		<th data-name="v_01_validation" class="<?php echo $product_group->v_01_validation->headerCellClass() ?>"><div id="elh_product_group_v_01_validation" class="product_group_v_01_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_01_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_01_validation" class="<?php echo $product_group->v_01_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_01_validation) ?>',2);"><div id="elh_product_group_v_01_validation" class="product_group_v_01_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_01_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_01_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_01_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_02->Visible) { // v_02 ?>
	<?php if ($product_group->sortUrl($product_group->v_02) == "") { ?>
		<th data-name="v_02" class="<?php echo $product_group->v_02->headerCellClass() ?>"><div id="elh_product_group_v_02" class="product_group_v_02"><div class="ew-table-header-caption"><?php echo $product_group->v_02->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_02" class="<?php echo $product_group->v_02->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_02) ?>',2);"><div id="elh_product_group_v_02" class="product_group_v_02">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_02->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_02->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_02->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_02_validation->Visible) { // v_02_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_02_validation) == "") { ?>
		<th data-name="v_02_validation" class="<?php echo $product_group->v_02_validation->headerCellClass() ?>"><div id="elh_product_group_v_02_validation" class="product_group_v_02_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_02_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_02_validation" class="<?php echo $product_group->v_02_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_02_validation) ?>',2);"><div id="elh_product_group_v_02_validation" class="product_group_v_02_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_02_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_02_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_02_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_03->Visible) { // v_03 ?>
	<?php if ($product_group->sortUrl($product_group->v_03) == "") { ?>
		<th data-name="v_03" class="<?php echo $product_group->v_03->headerCellClass() ?>"><div id="elh_product_group_v_03" class="product_group_v_03"><div class="ew-table-header-caption"><?php echo $product_group->v_03->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_03" class="<?php echo $product_group->v_03->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_03) ?>',2);"><div id="elh_product_group_v_03" class="product_group_v_03">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_03->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_03->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_03->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_03_validation->Visible) { // v_03_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_03_validation) == "") { ?>
		<th data-name="v_03_validation" class="<?php echo $product_group->v_03_validation->headerCellClass() ?>"><div id="elh_product_group_v_03_validation" class="product_group_v_03_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_03_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_03_validation" class="<?php echo $product_group->v_03_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_03_validation) ?>',2);"><div id="elh_product_group_v_03_validation" class="product_group_v_03_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_03_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_03_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_03_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_04->Visible) { // v_04 ?>
	<?php if ($product_group->sortUrl($product_group->v_04) == "") { ?>
		<th data-name="v_04" class="<?php echo $product_group->v_04->headerCellClass() ?>"><div id="elh_product_group_v_04" class="product_group_v_04"><div class="ew-table-header-caption"><?php echo $product_group->v_04->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_04" class="<?php echo $product_group->v_04->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_04) ?>',2);"><div id="elh_product_group_v_04" class="product_group_v_04">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_04->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_04->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_04->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_04_validation->Visible) { // v_04_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_04_validation) == "") { ?>
		<th data-name="v_04_validation" class="<?php echo $product_group->v_04_validation->headerCellClass() ?>"><div id="elh_product_group_v_04_validation" class="product_group_v_04_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_04_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_04_validation" class="<?php echo $product_group->v_04_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_04_validation) ?>',2);"><div id="elh_product_group_v_04_validation" class="product_group_v_04_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_04_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_04_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_04_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_05->Visible) { // v_05 ?>
	<?php if ($product_group->sortUrl($product_group->v_05) == "") { ?>
		<th data-name="v_05" class="<?php echo $product_group->v_05->headerCellClass() ?>"><div id="elh_product_group_v_05" class="product_group_v_05"><div class="ew-table-header-caption"><?php echo $product_group->v_05->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_05" class="<?php echo $product_group->v_05->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_05) ?>',2);"><div id="elh_product_group_v_05" class="product_group_v_05">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_05->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_05->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_05->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_05_validation->Visible) { // v_05_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_05_validation) == "") { ?>
		<th data-name="v_05_validation" class="<?php echo $product_group->v_05_validation->headerCellClass() ?>"><div id="elh_product_group_v_05_validation" class="product_group_v_05_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_05_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_05_validation" class="<?php echo $product_group->v_05_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_05_validation) ?>',2);"><div id="elh_product_group_v_05_validation" class="product_group_v_05_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_05_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_05_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_05_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_06->Visible) { // v_06 ?>
	<?php if ($product_group->sortUrl($product_group->v_06) == "") { ?>
		<th data-name="v_06" class="<?php echo $product_group->v_06->headerCellClass() ?>"><div id="elh_product_group_v_06" class="product_group_v_06"><div class="ew-table-header-caption"><?php echo $product_group->v_06->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_06" class="<?php echo $product_group->v_06->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_06) ?>',2);"><div id="elh_product_group_v_06" class="product_group_v_06">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_06->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_06->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_06->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_06_validation->Visible) { // v_06_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_06_validation) == "") { ?>
		<th data-name="v_06_validation" class="<?php echo $product_group->v_06_validation->headerCellClass() ?>"><div id="elh_product_group_v_06_validation" class="product_group_v_06_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_06_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_06_validation" class="<?php echo $product_group->v_06_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_06_validation) ?>',2);"><div id="elh_product_group_v_06_validation" class="product_group_v_06_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_06_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_06_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_06_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_07->Visible) { // v_07 ?>
	<?php if ($product_group->sortUrl($product_group->v_07) == "") { ?>
		<th data-name="v_07" class="<?php echo $product_group->v_07->headerCellClass() ?>"><div id="elh_product_group_v_07" class="product_group_v_07"><div class="ew-table-header-caption"><?php echo $product_group->v_07->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_07" class="<?php echo $product_group->v_07->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_07) ?>',2);"><div id="elh_product_group_v_07" class="product_group_v_07">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_07->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_07->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_07->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_07_validation->Visible) { // v_07_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_07_validation) == "") { ?>
		<th data-name="v_07_validation" class="<?php echo $product_group->v_07_validation->headerCellClass() ?>"><div id="elh_product_group_v_07_validation" class="product_group_v_07_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_07_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_07_validation" class="<?php echo $product_group->v_07_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_07_validation) ?>',2);"><div id="elh_product_group_v_07_validation" class="product_group_v_07_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_07_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_07_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_07_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_08->Visible) { // v_08 ?>
	<?php if ($product_group->sortUrl($product_group->v_08) == "") { ?>
		<th data-name="v_08" class="<?php echo $product_group->v_08->headerCellClass() ?>"><div id="elh_product_group_v_08" class="product_group_v_08"><div class="ew-table-header-caption"><?php echo $product_group->v_08->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_08" class="<?php echo $product_group->v_08->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_08) ?>',2);"><div id="elh_product_group_v_08" class="product_group_v_08">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_08->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_08->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_08->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_08_validation->Visible) { // v_08_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_08_validation) == "") { ?>
		<th data-name="v_08_validation" class="<?php echo $product_group->v_08_validation->headerCellClass() ?>"><div id="elh_product_group_v_08_validation" class="product_group_v_08_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_08_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_08_validation" class="<?php echo $product_group->v_08_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_08_validation) ?>',2);"><div id="elh_product_group_v_08_validation" class="product_group_v_08_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_08_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_08_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_08_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_09->Visible) { // v_09 ?>
	<?php if ($product_group->sortUrl($product_group->v_09) == "") { ?>
		<th data-name="v_09" class="<?php echo $product_group->v_09->headerCellClass() ?>"><div id="elh_product_group_v_09" class="product_group_v_09"><div class="ew-table-header-caption"><?php echo $product_group->v_09->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_09" class="<?php echo $product_group->v_09->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_09) ?>',2);"><div id="elh_product_group_v_09" class="product_group_v_09">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_09->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_09->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_09->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_09_validation->Visible) { // v_09_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_09_validation) == "") { ?>
		<th data-name="v_09_validation" class="<?php echo $product_group->v_09_validation->headerCellClass() ?>"><div id="elh_product_group_v_09_validation" class="product_group_v_09_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_09_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_09_validation" class="<?php echo $product_group->v_09_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_09_validation) ?>',2);"><div id="elh_product_group_v_09_validation" class="product_group_v_09_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_09_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_09_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_09_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_10->Visible) { // v_10 ?>
	<?php if ($product_group->sortUrl($product_group->v_10) == "") { ?>
		<th data-name="v_10" class="<?php echo $product_group->v_10->headerCellClass() ?>"><div id="elh_product_group_v_10" class="product_group_v_10"><div class="ew-table-header-caption"><?php echo $product_group->v_10->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_10" class="<?php echo $product_group->v_10->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_10) ?>',2);"><div id="elh_product_group_v_10" class="product_group_v_10">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_10->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_10->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_10->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->v_10_validation->Visible) { // v_10_validation ?>
	<?php if ($product_group->sortUrl($product_group->v_10_validation) == "") { ?>
		<th data-name="v_10_validation" class="<?php echo $product_group->v_10_validation->headerCellClass() ?>"><div id="elh_product_group_v_10_validation" class="product_group_v_10_validation"><div class="ew-table-header-caption"><?php echo $product_group->v_10_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_10_validation" class="<?php echo $product_group->v_10_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->v_10_validation) ?>',2);"><div id="elh_product_group_v_10_validation" class="product_group_v_10_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->v_10_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->v_10_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->v_10_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_01_head->Visible) { // b_01_head ?>
	<?php if ($product_group->sortUrl($product_group->b_01_head) == "") { ?>
		<th data-name="b_01_head" class="<?php echo $product_group->b_01_head->headerCellClass() ?>"><div id="elh_product_group_b_01_head" class="product_group_b_01_head"><div class="ew-table-header-caption"><?php echo $product_group->b_01_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_01_head" class="<?php echo $product_group->b_01_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_01_head) ?>',2);"><div id="elh_product_group_b_01_head" class="product_group_b_01_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_01_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_01_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_01_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_02_head->Visible) { // b_02_head ?>
	<?php if ($product_group->sortUrl($product_group->b_02_head) == "") { ?>
		<th data-name="b_02_head" class="<?php echo $product_group->b_02_head->headerCellClass() ?>"><div id="elh_product_group_b_02_head" class="product_group_b_02_head"><div class="ew-table-header-caption"><?php echo $product_group->b_02_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_02_head" class="<?php echo $product_group->b_02_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_02_head) ?>',2);"><div id="elh_product_group_b_02_head" class="product_group_b_02_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_02_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_02_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_02_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_03_head->Visible) { // b_03_head ?>
	<?php if ($product_group->sortUrl($product_group->b_03_head) == "") { ?>
		<th data-name="b_03_head" class="<?php echo $product_group->b_03_head->headerCellClass() ?>"><div id="elh_product_group_b_03_head" class="product_group_b_03_head"><div class="ew-table-header-caption"><?php echo $product_group->b_03_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_03_head" class="<?php echo $product_group->b_03_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_03_head) ?>',2);"><div id="elh_product_group_b_03_head" class="product_group_b_03_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_03_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_03_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_03_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_04_head->Visible) { // b_04_head ?>
	<?php if ($product_group->sortUrl($product_group->b_04_head) == "") { ?>
		<th data-name="b_04_head" class="<?php echo $product_group->b_04_head->headerCellClass() ?>"><div id="elh_product_group_b_04_head" class="product_group_b_04_head"><div class="ew-table-header-caption"><?php echo $product_group->b_04_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_04_head" class="<?php echo $product_group->b_04_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_04_head) ?>',2);"><div id="elh_product_group_b_04_head" class="product_group_b_04_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_04_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_04_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_04_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_05_head->Visible) { // b_05_head ?>
	<?php if ($product_group->sortUrl($product_group->b_05_head) == "") { ?>
		<th data-name="b_05_head" class="<?php echo $product_group->b_05_head->headerCellClass() ?>"><div id="elh_product_group_b_05_head" class="product_group_b_05_head"><div class="ew-table-header-caption"><?php echo $product_group->b_05_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_05_head" class="<?php echo $product_group->b_05_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_05_head) ?>',2);"><div id="elh_product_group_b_05_head" class="product_group_b_05_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_05_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_05_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_05_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_06_head->Visible) { // b_06_head ?>
	<?php if ($product_group->sortUrl($product_group->b_06_head) == "") { ?>
		<th data-name="b_06_head" class="<?php echo $product_group->b_06_head->headerCellClass() ?>"><div id="elh_product_group_b_06_head" class="product_group_b_06_head"><div class="ew-table-header-caption"><?php echo $product_group->b_06_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_06_head" class="<?php echo $product_group->b_06_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_06_head) ?>',2);"><div id="elh_product_group_b_06_head" class="product_group_b_06_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_06_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_06_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_06_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_07_head->Visible) { // b_07_head ?>
	<?php if ($product_group->sortUrl($product_group->b_07_head) == "") { ?>
		<th data-name="b_07_head" class="<?php echo $product_group->b_07_head->headerCellClass() ?>"><div id="elh_product_group_b_07_head" class="product_group_b_07_head"><div class="ew-table-header-caption"><?php echo $product_group->b_07_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_07_head" class="<?php echo $product_group->b_07_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_07_head) ?>',2);"><div id="elh_product_group_b_07_head" class="product_group_b_07_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_07_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_07_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_07_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_08_head->Visible) { // b_08_head ?>
	<?php if ($product_group->sortUrl($product_group->b_08_head) == "") { ?>
		<th data-name="b_08_head" class="<?php echo $product_group->b_08_head->headerCellClass() ?>"><div id="elh_product_group_b_08_head" class="product_group_b_08_head"><div class="ew-table-header-caption"><?php echo $product_group->b_08_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_08_head" class="<?php echo $product_group->b_08_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_08_head) ?>',2);"><div id="elh_product_group_b_08_head" class="product_group_b_08_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_08_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_08_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_08_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_09_head->Visible) { // b_09_head ?>
	<?php if ($product_group->sortUrl($product_group->b_09_head) == "") { ?>
		<th data-name="b_09_head" class="<?php echo $product_group->b_09_head->headerCellClass() ?>"><div id="elh_product_group_b_09_head" class="product_group_b_09_head"><div class="ew-table-header-caption"><?php echo $product_group->b_09_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_09_head" class="<?php echo $product_group->b_09_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_09_head) ?>',2);"><div id="elh_product_group_b_09_head" class="product_group_b_09_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_09_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_09_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_09_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_10_head->Visible) { // b_10_head ?>
	<?php if ($product_group->sortUrl($product_group->b_10_head) == "") { ?>
		<th data-name="b_10_head" class="<?php echo $product_group->b_10_head->headerCellClass() ?>"><div id="elh_product_group_b_10_head" class="product_group_b_10_head"><div class="ew-table-header-caption"><?php echo $product_group->b_10_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_10_head" class="<?php echo $product_group->b_10_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_10_head) ?>',2);"><div id="elh_product_group_b_10_head" class="product_group_b_10_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_10_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_10_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_10_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_11_head->Visible) { // b_11_head ?>
	<?php if ($product_group->sortUrl($product_group->b_11_head) == "") { ?>
		<th data-name="b_11_head" class="<?php echo $product_group->b_11_head->headerCellClass() ?>"><div id="elh_product_group_b_11_head" class="product_group_b_11_head"><div class="ew-table-header-caption"><?php echo $product_group->b_11_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_11_head" class="<?php echo $product_group->b_11_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_11_head) ?>',2);"><div id="elh_product_group_b_11_head" class="product_group_b_11_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_11_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_11_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_11_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_12_head->Visible) { // b_12_head ?>
	<?php if ($product_group->sortUrl($product_group->b_12_head) == "") { ?>
		<th data-name="b_12_head" class="<?php echo $product_group->b_12_head->headerCellClass() ?>"><div id="elh_product_group_b_12_head" class="product_group_b_12_head"><div class="ew-table-header-caption"><?php echo $product_group->b_12_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_12_head" class="<?php echo $product_group->b_12_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_12_head) ?>',2);"><div id="elh_product_group_b_12_head" class="product_group_b_12_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_12_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_12_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_12_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_13_head->Visible) { // b_13_head ?>
	<?php if ($product_group->sortUrl($product_group->b_13_head) == "") { ?>
		<th data-name="b_13_head" class="<?php echo $product_group->b_13_head->headerCellClass() ?>"><div id="elh_product_group_b_13_head" class="product_group_b_13_head"><div class="ew-table-header-caption"><?php echo $product_group->b_13_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_13_head" class="<?php echo $product_group->b_13_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_13_head) ?>',2);"><div id="elh_product_group_b_13_head" class="product_group_b_13_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_13_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_13_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_13_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_14_head->Visible) { // b_14_head ?>
	<?php if ($product_group->sortUrl($product_group->b_14_head) == "") { ?>
		<th data-name="b_14_head" class="<?php echo $product_group->b_14_head->headerCellClass() ?>"><div id="elh_product_group_b_14_head" class="product_group_b_14_head"><div class="ew-table-header-caption"><?php echo $product_group->b_14_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_14_head" class="<?php echo $product_group->b_14_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_14_head) ?>',2);"><div id="elh_product_group_b_14_head" class="product_group_b_14_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_14_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_14_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_14_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->b_15_head->Visible) { // b_15_head ?>
	<?php if ($product_group->sortUrl($product_group->b_15_head) == "") { ?>
		<th data-name="b_15_head" class="<?php echo $product_group->b_15_head->headerCellClass() ?>"><div id="elh_product_group_b_15_head" class="product_group_b_15_head"><div class="ew-table-header-caption"><?php echo $product_group->b_15_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_15_head" class="<?php echo $product_group->b_15_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->b_15_head) ?>',2);"><div id="elh_product_group_b_15_head" class="product_group_b_15_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->b_15_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->b_15_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->b_15_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->q_sku->Visible) { // q_sku ?>
	<?php if ($product_group->sortUrl($product_group->q_sku) == "") { ?>
		<th data-name="q_sku" class="<?php echo $product_group->q_sku->headerCellClass() ?>"><div id="elh_product_group_q_sku" class="product_group_q_sku"><div class="ew-table-header-caption"><?php echo $product_group->q_sku->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="q_sku" class="<?php echo $product_group->q_sku->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->q_sku) ?>',2);"><div id="elh_product_group_q_sku" class="product_group_q_sku">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->q_sku->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_group->q_sku->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->q_sku->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_01_head->Visible) { // t_01_head ?>
	<?php if ($product_group->sortUrl($product_group->t_01_head) == "") { ?>
		<th data-name="t_01_head" class="<?php echo $product_group->t_01_head->headerCellClass() ?>"><div id="elh_product_group_t_01_head" class="product_group_t_01_head"><div class="ew-table-header-caption"><?php echo $product_group->t_01_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_01_head" class="<?php echo $product_group->t_01_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_01_head) ?>',2);"><div id="elh_product_group_t_01_head" class="product_group_t_01_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_01_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_01_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_01_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_02_head->Visible) { // t_02_head ?>
	<?php if ($product_group->sortUrl($product_group->t_02_head) == "") { ?>
		<th data-name="t_02_head" class="<?php echo $product_group->t_02_head->headerCellClass() ?>"><div id="elh_product_group_t_02_head" class="product_group_t_02_head"><div class="ew-table-header-caption"><?php echo $product_group->t_02_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_02_head" class="<?php echo $product_group->t_02_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_02_head) ?>',2);"><div id="elh_product_group_t_02_head" class="product_group_t_02_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_02_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_02_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_02_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_03_head->Visible) { // t_03_head ?>
	<?php if ($product_group->sortUrl($product_group->t_03_head) == "") { ?>
		<th data-name="t_03_head" class="<?php echo $product_group->t_03_head->headerCellClass() ?>"><div id="elh_product_group_t_03_head" class="product_group_t_03_head"><div class="ew-table-header-caption"><?php echo $product_group->t_03_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_03_head" class="<?php echo $product_group->t_03_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_03_head) ?>',2);"><div id="elh_product_group_t_03_head" class="product_group_t_03_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_03_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_03_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_03_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_04_head->Visible) { // t_04_head ?>
	<?php if ($product_group->sortUrl($product_group->t_04_head) == "") { ?>
		<th data-name="t_04_head" class="<?php echo $product_group->t_04_head->headerCellClass() ?>"><div id="elh_product_group_t_04_head" class="product_group_t_04_head"><div class="ew-table-header-caption"><?php echo $product_group->t_04_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_04_head" class="<?php echo $product_group->t_04_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_04_head) ?>',2);"><div id="elh_product_group_t_04_head" class="product_group_t_04_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_04_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_04_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_04_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_05_head->Visible) { // t_05_head ?>
	<?php if ($product_group->sortUrl($product_group->t_05_head) == "") { ?>
		<th data-name="t_05_head" class="<?php echo $product_group->t_05_head->headerCellClass() ?>"><div id="elh_product_group_t_05_head" class="product_group_t_05_head"><div class="ew-table-header-caption"><?php echo $product_group->t_05_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_05_head" class="<?php echo $product_group->t_05_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_05_head) ?>',2);"><div id="elh_product_group_t_05_head" class="product_group_t_05_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_05_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_05_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_05_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_06_head->Visible) { // t_06_head ?>
	<?php if ($product_group->sortUrl($product_group->t_06_head) == "") { ?>
		<th data-name="t_06_head" class="<?php echo $product_group->t_06_head->headerCellClass() ?>"><div id="elh_product_group_t_06_head" class="product_group_t_06_head"><div class="ew-table-header-caption"><?php echo $product_group->t_06_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_06_head" class="<?php echo $product_group->t_06_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_06_head) ?>',2);"><div id="elh_product_group_t_06_head" class="product_group_t_06_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_06_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_06_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_06_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_07_head->Visible) { // t_07_head ?>
	<?php if ($product_group->sortUrl($product_group->t_07_head) == "") { ?>
		<th data-name="t_07_head" class="<?php echo $product_group->t_07_head->headerCellClass() ?>"><div id="elh_product_group_t_07_head" class="product_group_t_07_head"><div class="ew-table-header-caption"><?php echo $product_group->t_07_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_07_head" class="<?php echo $product_group->t_07_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_07_head) ?>',2);"><div id="elh_product_group_t_07_head" class="product_group_t_07_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_07_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_07_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_07_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_08_head->Visible) { // t_08_head ?>
	<?php if ($product_group->sortUrl($product_group->t_08_head) == "") { ?>
		<th data-name="t_08_head" class="<?php echo $product_group->t_08_head->headerCellClass() ?>"><div id="elh_product_group_t_08_head" class="product_group_t_08_head"><div class="ew-table-header-caption"><?php echo $product_group->t_08_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_08_head" class="<?php echo $product_group->t_08_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_08_head) ?>',2);"><div id="elh_product_group_t_08_head" class="product_group_t_08_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_08_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_08_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_08_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_09_head->Visible) { // t_09_head ?>
	<?php if ($product_group->sortUrl($product_group->t_09_head) == "") { ?>
		<th data-name="t_09_head" class="<?php echo $product_group->t_09_head->headerCellClass() ?>"><div id="elh_product_group_t_09_head" class="product_group_t_09_head"><div class="ew-table-header-caption"><?php echo $product_group->t_09_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_09_head" class="<?php echo $product_group->t_09_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_09_head) ?>',2);"><div id="elh_product_group_t_09_head" class="product_group_t_09_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_09_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_09_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_09_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_10_head->Visible) { // t_10_head ?>
	<?php if ($product_group->sortUrl($product_group->t_10_head) == "") { ?>
		<th data-name="t_10_head" class="<?php echo $product_group->t_10_head->headerCellClass() ?>"><div id="elh_product_group_t_10_head" class="product_group_t_10_head"><div class="ew-table-header-caption"><?php echo $product_group->t_10_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_10_head" class="<?php echo $product_group->t_10_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_10_head) ?>',2);"><div id="elh_product_group_t_10_head" class="product_group_t_10_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_10_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_10_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_10_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_11_head->Visible) { // t_11_head ?>
	<?php if ($product_group->sortUrl($product_group->t_11_head) == "") { ?>
		<th data-name="t_11_head" class="<?php echo $product_group->t_11_head->headerCellClass() ?>"><div id="elh_product_group_t_11_head" class="product_group_t_11_head"><div class="ew-table-header-caption"><?php echo $product_group->t_11_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_11_head" class="<?php echo $product_group->t_11_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_11_head) ?>',2);"><div id="elh_product_group_t_11_head" class="product_group_t_11_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_11_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_11_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_11_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_12_head->Visible) { // t_12_head ?>
	<?php if ($product_group->sortUrl($product_group->t_12_head) == "") { ?>
		<th data-name="t_12_head" class="<?php echo $product_group->t_12_head->headerCellClass() ?>"><div id="elh_product_group_t_12_head" class="product_group_t_12_head"><div class="ew-table-header-caption"><?php echo $product_group->t_12_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_12_head" class="<?php echo $product_group->t_12_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_12_head) ?>',2);"><div id="elh_product_group_t_12_head" class="product_group_t_12_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_12_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_12_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_12_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_13_head->Visible) { // t_13_head ?>
	<?php if ($product_group->sortUrl($product_group->t_13_head) == "") { ?>
		<th data-name="t_13_head" class="<?php echo $product_group->t_13_head->headerCellClass() ?>"><div id="elh_product_group_t_13_head" class="product_group_t_13_head"><div class="ew-table-header-caption"><?php echo $product_group->t_13_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_13_head" class="<?php echo $product_group->t_13_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_13_head) ?>',2);"><div id="elh_product_group_t_13_head" class="product_group_t_13_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_13_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_13_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_13_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_14_head->Visible) { // t_14_head ?>
	<?php if ($product_group->sortUrl($product_group->t_14_head) == "") { ?>
		<th data-name="t_14_head" class="<?php echo $product_group->t_14_head->headerCellClass() ?>"><div id="elh_product_group_t_14_head" class="product_group_t_14_head"><div class="ew-table-header-caption"><?php echo $product_group->t_14_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_14_head" class="<?php echo $product_group->t_14_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_14_head) ?>',2);"><div id="elh_product_group_t_14_head" class="product_group_t_14_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_14_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_14_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_14_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->t_15_head->Visible) { // t_15_head ?>
	<?php if ($product_group->sortUrl($product_group->t_15_head) == "") { ?>
		<th data-name="t_15_head" class="<?php echo $product_group->t_15_head->headerCellClass() ?>"><div id="elh_product_group_t_15_head" class="product_group_t_15_head"><div class="ew-table-header-caption"><?php echo $product_group->t_15_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_15_head" class="<?php echo $product_group->t_15_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->t_15_head) ?>',2);"><div id="elh_product_group_t_15_head" class="product_group_t_15_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->t_15_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->t_15_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->t_15_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_01_head->Visible) { // po_01_head ?>
	<?php if ($product_group->sortUrl($product_group->po_01_head) == "") { ?>
		<th data-name="po_01_head" class="<?php echo $product_group->po_01_head->headerCellClass() ?>"><div id="elh_product_group_po_01_head" class="product_group_po_01_head"><div class="ew-table-header-caption"><?php echo $product_group->po_01_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_01_head" class="<?php echo $product_group->po_01_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_01_head) ?>',2);"><div id="elh_product_group_po_01_head" class="product_group_po_01_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_01_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_01_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_01_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_02_head->Visible) { // po_02_head ?>
	<?php if ($product_group->sortUrl($product_group->po_02_head) == "") { ?>
		<th data-name="po_02_head" class="<?php echo $product_group->po_02_head->headerCellClass() ?>"><div id="elh_product_group_po_02_head" class="product_group_po_02_head"><div class="ew-table-header-caption"><?php echo $product_group->po_02_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_02_head" class="<?php echo $product_group->po_02_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_02_head) ?>',2);"><div id="elh_product_group_po_02_head" class="product_group_po_02_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_02_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_02_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_02_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_03_head->Visible) { // po_03_head ?>
	<?php if ($product_group->sortUrl($product_group->po_03_head) == "") { ?>
		<th data-name="po_03_head" class="<?php echo $product_group->po_03_head->headerCellClass() ?>"><div id="elh_product_group_po_03_head" class="product_group_po_03_head"><div class="ew-table-header-caption"><?php echo $product_group->po_03_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_03_head" class="<?php echo $product_group->po_03_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_03_head) ?>',2);"><div id="elh_product_group_po_03_head" class="product_group_po_03_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_03_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_03_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_03_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_04_head->Visible) { // po_04_head ?>
	<?php if ($product_group->sortUrl($product_group->po_04_head) == "") { ?>
		<th data-name="po_04_head" class="<?php echo $product_group->po_04_head->headerCellClass() ?>"><div id="elh_product_group_po_04_head" class="product_group_po_04_head"><div class="ew-table-header-caption"><?php echo $product_group->po_04_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_04_head" class="<?php echo $product_group->po_04_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_04_head) ?>',2);"><div id="elh_product_group_po_04_head" class="product_group_po_04_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_04_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_04_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_04_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_05_head->Visible) { // po_05_head ?>
	<?php if ($product_group->sortUrl($product_group->po_05_head) == "") { ?>
		<th data-name="po_05_head" class="<?php echo $product_group->po_05_head->headerCellClass() ?>"><div id="elh_product_group_po_05_head" class="product_group_po_05_head"><div class="ew-table-header-caption"><?php echo $product_group->po_05_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_05_head" class="<?php echo $product_group->po_05_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_05_head) ?>',2);"><div id="elh_product_group_po_05_head" class="product_group_po_05_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_05_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_05_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_05_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_06_head->Visible) { // po_06_head ?>
	<?php if ($product_group->sortUrl($product_group->po_06_head) == "") { ?>
		<th data-name="po_06_head" class="<?php echo $product_group->po_06_head->headerCellClass() ?>"><div id="elh_product_group_po_06_head" class="product_group_po_06_head"><div class="ew-table-header-caption"><?php echo $product_group->po_06_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_06_head" class="<?php echo $product_group->po_06_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_06_head) ?>',2);"><div id="elh_product_group_po_06_head" class="product_group_po_06_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_06_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_06_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_06_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_07_head->Visible) { // po_07_head ?>
	<?php if ($product_group->sortUrl($product_group->po_07_head) == "") { ?>
		<th data-name="po_07_head" class="<?php echo $product_group->po_07_head->headerCellClass() ?>"><div id="elh_product_group_po_07_head" class="product_group_po_07_head"><div class="ew-table-header-caption"><?php echo $product_group->po_07_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_07_head" class="<?php echo $product_group->po_07_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_07_head) ?>',2);"><div id="elh_product_group_po_07_head" class="product_group_po_07_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_07_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_07_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_07_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_08_head->Visible) { // po_08_head ?>
	<?php if ($product_group->sortUrl($product_group->po_08_head) == "") { ?>
		<th data-name="po_08_head" class="<?php echo $product_group->po_08_head->headerCellClass() ?>"><div id="elh_product_group_po_08_head" class="product_group_po_08_head"><div class="ew-table-header-caption"><?php echo $product_group->po_08_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_08_head" class="<?php echo $product_group->po_08_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_08_head) ?>',2);"><div id="elh_product_group_po_08_head" class="product_group_po_08_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_08_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_08_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_08_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_17_head->Visible) { // po_17_head ?>
	<?php if ($product_group->sortUrl($product_group->po_17_head) == "") { ?>
		<th data-name="po_17_head" class="<?php echo $product_group->po_17_head->headerCellClass() ?>"><div id="elh_product_group_po_17_head" class="product_group_po_17_head"><div class="ew-table-header-caption"><?php echo $product_group->po_17_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_17_head" class="<?php echo $product_group->po_17_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_17_head) ?>',2);"><div id="elh_product_group_po_17_head" class="product_group_po_17_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_17_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_17_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_17_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_18_head->Visible) { // po_18_head ?>
	<?php if ($product_group->sortUrl($product_group->po_18_head) == "") { ?>
		<th data-name="po_18_head" class="<?php echo $product_group->po_18_head->headerCellClass() ?>"><div id="elh_product_group_po_18_head" class="product_group_po_18_head"><div class="ew-table-header-caption"><?php echo $product_group->po_18_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_18_head" class="<?php echo $product_group->po_18_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_18_head) ?>',2);"><div id="elh_product_group_po_18_head" class="product_group_po_18_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_18_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_18_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_18_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_19_head->Visible) { // po_19_head ?>
	<?php if ($product_group->sortUrl($product_group->po_19_head) == "") { ?>
		<th data-name="po_19_head" class="<?php echo $product_group->po_19_head->headerCellClass() ?>"><div id="elh_product_group_po_19_head" class="product_group_po_19_head"><div class="ew-table-header-caption"><?php echo $product_group->po_19_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_19_head" class="<?php echo $product_group->po_19_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_19_head) ?>',2);"><div id="elh_product_group_po_19_head" class="product_group_po_19_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_19_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_19_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_19_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->po_20_head->Visible) { // po_20_head ?>
	<?php if ($product_group->sortUrl($product_group->po_20_head) == "") { ?>
		<th data-name="po_20_head" class="<?php echo $product_group->po_20_head->headerCellClass() ?>"><div id="elh_product_group_po_20_head" class="product_group_po_20_head"><div class="ew-table-header-caption"><?php echo $product_group->po_20_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_20_head" class="<?php echo $product_group->po_20_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->po_20_head) ?>',2);"><div id="elh_product_group_po_20_head" class="product_group_po_20_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->po_20_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->po_20_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->po_20_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_01_head->Visible) { // jc_01_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_01_head) == "") { ?>
		<th data-name="jc_01_head" class="<?php echo $product_group->jc_01_head->headerCellClass() ?>"><div id="elh_product_group_jc_01_head" class="product_group_jc_01_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_01_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_01_head" class="<?php echo $product_group->jc_01_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_01_head) ?>',2);"><div id="elh_product_group_jc_01_head" class="product_group_jc_01_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_01_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_01_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_01_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_02_head->Visible) { // jc_02_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_02_head) == "") { ?>
		<th data-name="jc_02_head" class="<?php echo $product_group->jc_02_head->headerCellClass() ?>"><div id="elh_product_group_jc_02_head" class="product_group_jc_02_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_02_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_02_head" class="<?php echo $product_group->jc_02_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_02_head) ?>',2);"><div id="elh_product_group_jc_02_head" class="product_group_jc_02_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_02_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_02_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_02_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_03_head->Visible) { // jc_03_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_03_head) == "") { ?>
		<th data-name="jc_03_head" class="<?php echo $product_group->jc_03_head->headerCellClass() ?>"><div id="elh_product_group_jc_03_head" class="product_group_jc_03_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_03_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_03_head" class="<?php echo $product_group->jc_03_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_03_head) ?>',2);"><div id="elh_product_group_jc_03_head" class="product_group_jc_03_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_03_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_03_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_03_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_04_head->Visible) { // jc_04_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_04_head) == "") { ?>
		<th data-name="jc_04_head" class="<?php echo $product_group->jc_04_head->headerCellClass() ?>"><div id="elh_product_group_jc_04_head" class="product_group_jc_04_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_04_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_04_head" class="<?php echo $product_group->jc_04_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_04_head) ?>',2);"><div id="elh_product_group_jc_04_head" class="product_group_jc_04_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_04_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_04_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_04_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_05_head->Visible) { // jc_05_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_05_head) == "") { ?>
		<th data-name="jc_05_head" class="<?php echo $product_group->jc_05_head->headerCellClass() ?>"><div id="elh_product_group_jc_05_head" class="product_group_jc_05_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_05_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_05_head" class="<?php echo $product_group->jc_05_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_05_head) ?>',2);"><div id="elh_product_group_jc_05_head" class="product_group_jc_05_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_05_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_05_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_05_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_06_head->Visible) { // jc_06_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_06_head) == "") { ?>
		<th data-name="jc_06_head" class="<?php echo $product_group->jc_06_head->headerCellClass() ?>"><div id="elh_product_group_jc_06_head" class="product_group_jc_06_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_06_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_06_head" class="<?php echo $product_group->jc_06_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_06_head) ?>',2);"><div id="elh_product_group_jc_06_head" class="product_group_jc_06_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_06_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_06_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_06_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_07_head->Visible) { // jc_07_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_07_head) == "") { ?>
		<th data-name="jc_07_head" class="<?php echo $product_group->jc_07_head->headerCellClass() ?>"><div id="elh_product_group_jc_07_head" class="product_group_jc_07_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_07_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_07_head" class="<?php echo $product_group->jc_07_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_07_head) ?>',2);"><div id="elh_product_group_jc_07_head" class="product_group_jc_07_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_07_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_07_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_07_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_08_head->Visible) { // jc_08_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_08_head) == "") { ?>
		<th data-name="jc_08_head" class="<?php echo $product_group->jc_08_head->headerCellClass() ?>"><div id="elh_product_group_jc_08_head" class="product_group_jc_08_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_08_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_08_head" class="<?php echo $product_group->jc_08_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_08_head) ?>',2);"><div id="elh_product_group_jc_08_head" class="product_group_jc_08_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_08_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_08_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_08_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_09_head->Visible) { // jc_09_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_09_head) == "") { ?>
		<th data-name="jc_09_head" class="<?php echo $product_group->jc_09_head->headerCellClass() ?>"><div id="elh_product_group_jc_09_head" class="product_group_jc_09_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_09_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_09_head" class="<?php echo $product_group->jc_09_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_09_head) ?>',2);"><div id="elh_product_group_jc_09_head" class="product_group_jc_09_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_09_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_09_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_09_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->jc_10_head->Visible) { // jc_10_head ?>
	<?php if ($product_group->sortUrl($product_group->jc_10_head) == "") { ?>
		<th data-name="jc_10_head" class="<?php echo $product_group->jc_10_head->headerCellClass() ?>"><div id="elh_product_group_jc_10_head" class="product_group_jc_10_head"><div class="ew-table-header-caption"><?php echo $product_group->jc_10_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_10_head" class="<?php echo $product_group->jc_10_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->jc_10_head) ?>',2);"><div id="elh_product_group_jc_10_head" class="product_group_jc_10_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->jc_10_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->jc_10_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->jc_10_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_shape->Visible) { // pc_shape ?>
	<?php if ($product_group->sortUrl($product_group->pc_shape) == "") { ?>
		<th data-name="pc_shape" class="<?php echo $product_group->pc_shape->headerCellClass() ?>"><div id="elh_product_group_pc_shape" class="product_group_pc_shape"><div class="ew-table-header-caption"><?php echo $product_group->pc_shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_shape" class="<?php echo $product_group->pc_shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_shape) ?>',2);"><div id="elh_product_group_pc_shape" class="product_group_pc_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_shape->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_unit->Visible) { // pc_unit ?>
	<?php if ($product_group->sortUrl($product_group->pc_unit) == "") { ?>
		<th data-name="pc_unit" class="<?php echo $product_group->pc_unit->headerCellClass() ?>"><div id="elh_product_group_pc_unit" class="product_group_pc_unit"><div class="ew-table-header-caption"><?php echo $product_group->pc_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_unit" class="<?php echo $product_group->pc_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_unit) ?>',2);"><div id="elh_product_group_pc_unit" class="product_group_pc_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_w->Visible) { // pc_w ?>
	<?php if ($product_group->sortUrl($product_group->pc_w) == "") { ?>
		<th data-name="pc_w" class="<?php echo $product_group->pc_w->headerCellClass() ?>"><div id="elh_product_group_pc_w" class="product_group_pc_w"><div class="ew-table-header-caption"><?php echo $product_group->pc_w->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_w" class="<?php echo $product_group->pc_w->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_w) ?>',2);"><div id="elh_product_group_pc_w" class="product_group_pc_w">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_w->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_w->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_w->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_l->Visible) { // pc_l ?>
	<?php if ($product_group->sortUrl($product_group->pc_l) == "") { ?>
		<th data-name="pc_l" class="<?php echo $product_group->pc_l->headerCellClass() ?>"><div id="elh_product_group_pc_l" class="product_group_pc_l"><div class="ew-table-header-caption"><?php echo $product_group->pc_l->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_l" class="<?php echo $product_group->pc_l->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_l) ?>',2);"><div id="elh_product_group_pc_l" class="product_group_pc_l">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_l->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_l->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_l->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_h->Visible) { // pc_h ?>
	<?php if ($product_group->sortUrl($product_group->pc_h) == "") { ?>
		<th data-name="pc_h" class="<?php echo $product_group->pc_h->headerCellClass() ?>"><div id="elh_product_group_pc_h" class="product_group_pc_h"><div class="ew-table-header-caption"><?php echo $product_group->pc_h->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_h" class="<?php echo $product_group->pc_h->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_h) ?>',2);"><div id="elh_product_group_pc_h" class="product_group_pc_h">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_h->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_h->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_h->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_partner_size->Visible) { // pc_partner_size ?>
	<?php if ($product_group->sortUrl($product_group->pc_partner_size) == "") { ?>
		<th data-name="pc_partner_size" class="<?php echo $product_group->pc_partner_size->headerCellClass() ?>"><div id="elh_product_group_pc_partner_size" class="product_group_pc_partner_size"><div class="ew-table-header-caption"><?php echo $product_group->pc_partner_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_partner_size" class="<?php echo $product_group->pc_partner_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_partner_size) ?>',2);"><div id="elh_product_group_pc_partner_size" class="product_group_pc_partner_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_partner_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_partner_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_partner_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_sqm->Visible) { // pc_sqm ?>
	<?php if ($product_group->sortUrl($product_group->pc_sqm) == "") { ?>
		<th data-name="pc_sqm" class="<?php echo $product_group->pc_sqm->headerCellClass() ?>"><div id="elh_product_group_pc_sqm" class="product_group_pc_sqm"><div class="ew-table-header-caption"><?php echo $product_group->pc_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_sqm" class="<?php echo $product_group->pc_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_sqm) ?>',2);"><div id="elh_product_group_pc_sqm" class="product_group_pc_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_01_head->Visible) { // pc_01_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_01_head) == "") { ?>
		<th data-name="pc_01_head" class="<?php echo $product_group->pc_01_head->headerCellClass() ?>"><div id="elh_product_group_pc_01_head" class="product_group_pc_01_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_01_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_01_head" class="<?php echo $product_group->pc_01_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_01_head) ?>',2);"><div id="elh_product_group_pc_01_head" class="product_group_pc_01_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_01_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_01_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_01_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_02_head->Visible) { // pc_02_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_02_head) == "") { ?>
		<th data-name="pc_02_head" class="<?php echo $product_group->pc_02_head->headerCellClass() ?>"><div id="elh_product_group_pc_02_head" class="product_group_pc_02_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_02_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_02_head" class="<?php echo $product_group->pc_02_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_02_head) ?>',2);"><div id="elh_product_group_pc_02_head" class="product_group_pc_02_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_02_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_02_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_02_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_03_head->Visible) { // pc_03_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_03_head) == "") { ?>
		<th data-name="pc_03_head" class="<?php echo $product_group->pc_03_head->headerCellClass() ?>"><div id="elh_product_group_pc_03_head" class="product_group_pc_03_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_03_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_03_head" class="<?php echo $product_group->pc_03_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_03_head) ?>',2);"><div id="elh_product_group_pc_03_head" class="product_group_pc_03_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_03_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_03_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_03_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_04_head->Visible) { // pc_04_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_04_head) == "") { ?>
		<th data-name="pc_04_head" class="<?php echo $product_group->pc_04_head->headerCellClass() ?>"><div id="elh_product_group_pc_04_head" class="product_group_pc_04_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_04_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_04_head" class="<?php echo $product_group->pc_04_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_04_head) ?>',2);"><div id="elh_product_group_pc_04_head" class="product_group_pc_04_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_04_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_04_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_04_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_05_head->Visible) { // pc_05_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_05_head) == "") { ?>
		<th data-name="pc_05_head" class="<?php echo $product_group->pc_05_head->headerCellClass() ?>"><div id="elh_product_group_pc_05_head" class="product_group_pc_05_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_05_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_05_head" class="<?php echo $product_group->pc_05_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_05_head) ?>',2);"><div id="elh_product_group_pc_05_head" class="product_group_pc_05_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_05_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_05_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_05_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_06_head->Visible) { // pc_06_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_06_head) == "") { ?>
		<th data-name="pc_06_head" class="<?php echo $product_group->pc_06_head->headerCellClass() ?>"><div id="elh_product_group_pc_06_head" class="product_group_pc_06_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_06_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_06_head" class="<?php echo $product_group->pc_06_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_06_head) ?>',2);"><div id="elh_product_group_pc_06_head" class="product_group_pc_06_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_06_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_06_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_06_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_07_head->Visible) { // pc_07_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_07_head) == "") { ?>
		<th data-name="pc_07_head" class="<?php echo $product_group->pc_07_head->headerCellClass() ?>"><div id="elh_product_group_pc_07_head" class="product_group_pc_07_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_07_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_07_head" class="<?php echo $product_group->pc_07_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_07_head) ?>',2);"><div id="elh_product_group_pc_07_head" class="product_group_pc_07_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_07_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_07_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_07_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_08_head->Visible) { // pc_08_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_08_head) == "") { ?>
		<th data-name="pc_08_head" class="<?php echo $product_group->pc_08_head->headerCellClass() ?>"><div id="elh_product_group_pc_08_head" class="product_group_pc_08_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_08_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_08_head" class="<?php echo $product_group->pc_08_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_08_head) ?>',2);"><div id="elh_product_group_pc_08_head" class="product_group_pc_08_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_08_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_08_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_08_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_09_head->Visible) { // pc_09_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_09_head) == "") { ?>
		<th data-name="pc_09_head" class="<?php echo $product_group->pc_09_head->headerCellClass() ?>"><div id="elh_product_group_pc_09_head" class="product_group_pc_09_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_09_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_09_head" class="<?php echo $product_group->pc_09_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_09_head) ?>',2);"><div id="elh_product_group_pc_09_head" class="product_group_pc_09_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_09_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_09_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_09_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_10_head->Visible) { // pc_10_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_10_head) == "") { ?>
		<th data-name="pc_10_head" class="<?php echo $product_group->pc_10_head->headerCellClass() ?>"><div id="elh_product_group_pc_10_head" class="product_group_pc_10_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_10_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_10_head" class="<?php echo $product_group->pc_10_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_10_head) ?>',2);"><div id="elh_product_group_pc_10_head" class="product_group_pc_10_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_10_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_10_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_10_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_11_head->Visible) { // pc_11_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_11_head) == "") { ?>
		<th data-name="pc_11_head" class="<?php echo $product_group->pc_11_head->headerCellClass() ?>"><div id="elh_product_group_pc_11_head" class="product_group_pc_11_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_11_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_11_head" class="<?php echo $product_group->pc_11_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_11_head) ?>',2);"><div id="elh_product_group_pc_11_head" class="product_group_pc_11_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_11_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_11_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_11_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->pc_12_head->Visible) { // pc_12_head ?>
	<?php if ($product_group->sortUrl($product_group->pc_12_head) == "") { ?>
		<th data-name="pc_12_head" class="<?php echo $product_group->pc_12_head->headerCellClass() ?>"><div id="elh_product_group_pc_12_head" class="product_group_pc_12_head"><div class="ew-table-header-caption"><?php echo $product_group->pc_12_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pc_12_head" class="<?php echo $product_group->pc_12_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->pc_12_head) ?>',2);"><div id="elh_product_group_pc_12_head" class="product_group_pc_12_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->pc_12_head->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->pc_12_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->pc_12_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->operator->Visible) { // operator ?>
	<?php if ($product_group->sortUrl($product_group->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_group->operator->headerCellClass() ?>"><div id="elh_product_group_operator" class="product_group_operator"><div class="ew-table-header-caption"><?php echo $product_group->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_group->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->operator) ?>',2);"><div id="elh_product_group_operator" class="product_group_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->datetime->Visible) { // datetime ?>
	<?php if ($product_group->sortUrl($product_group->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_group->datetime->headerCellClass() ?>"><div id="elh_product_group_datetime" class="product_group_datetime"><div class="ew-table-header-caption"><?php echo $product_group->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_group->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->datetime) ?>',2);"><div id="elh_product_group_datetime" class="product_group_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_group->image->Visible) { // image ?>
	<?php if ($product_group->sortUrl($product_group->image) == "") { ?>
		<th data-name="image" class="<?php echo $product_group->image->headerCellClass() ?>"><div id="elh_product_group_image" class="product_group_image"><div class="ew-table-header-caption"><?php echo $product_group->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $product_group->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_group->SortUrl($product_group->image) ?>',2);"><div id="elh_product_group_image" class="product_group_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_group->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_group->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_group->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_group_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_group->ExportAll && $product_group->isExport()) {
	$product_group_list->StopRec = $product_group_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_group_list->TotalRecs > $product_group_list->StartRec + $product_group_list->DisplayRecs - 1)
		$product_group_list->StopRec = $product_group_list->StartRec + $product_group_list->DisplayRecs - 1;
	else
		$product_group_list->StopRec = $product_group_list->TotalRecs;
}
$product_group_list->RecCnt = $product_group_list->StartRec - 1;
if ($product_group_list->Recordset && !$product_group_list->Recordset->EOF) {
	$product_group_list->Recordset->moveFirst();
	$selectLimit = $product_group_list->UseSelectLimit;
	if (!$selectLimit && $product_group_list->StartRec > 1)
		$product_group_list->Recordset->move($product_group_list->StartRec - 1);
} elseif (!$product_group->AllowAddDeleteRow && $product_group_list->StopRec == 0) {
	$product_group_list->StopRec = $product_group->GridAddRowCount;
}

// Initialize aggregate
$product_group->RowType = ROWTYPE_AGGREGATEINIT;
$product_group->resetAttributes();
$product_group_list->renderRow();
while ($product_group_list->RecCnt < $product_group_list->StopRec) {
	$product_group_list->RecCnt++;
	if ($product_group_list->RecCnt >= $product_group_list->StartRec) {
		$product_group_list->RowCnt++;

		// Set up key count
		$product_group_list->KeyCount = $product_group_list->RowIndex;

		// Init row class and style
		$product_group->resetAttributes();
		$product_group->CssClass = "";
		if ($product_group->isGridAdd()) {
		} else {
			$product_group_list->loadRowValues($product_group_list->Recordset); // Load row values
		}
		$product_group->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_group->RowAttrs = array_merge($product_group->RowAttrs, array('data-rowindex'=>$product_group_list->RowCnt, 'id'=>'r' . $product_group_list->RowCnt . '_product_group', 'data-rowtype'=>$product_group->RowType));

		// Render row
		$product_group_list->renderRow();

		// Render list options
		$product_group_list->renderListOptions();
?>
	<tr<?php echo $product_group->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_group_list->ListOptions->render("body", "left", $product_group_list->RowCnt);
?>
	<?php if ($product_group->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_group->id->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_id" class="product_group_id">
<span<?php echo $product_group->id->viewAttributes() ?>>
<?php echo $product_group->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_group->grp->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_grp" class="product_group_grp">
<span<?php echo $product_group->grp->viewAttributes() ?>>
<?php echo $product_group->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->product_group->Visible) { // product_group ?>
		<td data-name="product_group"<?php echo $product_group->product_group->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_product_group" class="product_group_product_group">
<span<?php echo $product_group->product_group->viewAttributes() ?>>
<?php echo $product_group->product_group->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->calculation_method->Visible) { // calculation_method ?>
		<td data-name="calculation_method"<?php echo $product_group->calculation_method->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_calculation_method" class="product_group_calculation_method">
<span<?php echo $product_group->calculation_method->viewAttributes() ?>>
<?php echo $product_group->calculation_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $product_group->shape->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_shape" class="product_group_shape">
<span<?php echo $product_group->shape->viewAttributes() ?>>
<?php echo $product_group->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $product_group->sqm->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_sqm" class="product_group_sqm">
<span<?php echo $product_group->sqm->viewAttributes() ?>>
<?php echo $product_group->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $product_group->cbm->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_cbm" class="product_group_cbm">
<span<?php echo $product_group->cbm->viewAttributes() ?>>
<?php echo $product_group->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->process->Visible) { // process ?>
		<td data-name="process"<?php echo $product_group->process->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_process" class="product_group_process">
<span<?php echo $product_group->process->viewAttributes() ?>>
<?php echo $product_group->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_group->status->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_status" class="product_group_status">
<span<?php echo $product_group->status->viewAttributes() ?>>
<?php echo $product_group->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_00->Visible) { // v_00 ?>
		<td data-name="v_00"<?php echo $product_group->v_00->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_00" class="product_group_v_00">
<span<?php echo $product_group->v_00->viewAttributes() ?>>
<?php echo $product_group->v_00->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_01->Visible) { // v_01 ?>
		<td data-name="v_01"<?php echo $product_group->v_01->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_01" class="product_group_v_01">
<span<?php echo $product_group->v_01->viewAttributes() ?>>
<?php echo $product_group->v_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_01_validation->Visible) { // v_01_validation ?>
		<td data-name="v_01_validation"<?php echo $product_group->v_01_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_01_validation" class="product_group_v_01_validation">
<span<?php echo $product_group->v_01_validation->viewAttributes() ?>>
<?php echo $product_group->v_01_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_02->Visible) { // v_02 ?>
		<td data-name="v_02"<?php echo $product_group->v_02->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_02" class="product_group_v_02">
<span<?php echo $product_group->v_02->viewAttributes() ?>>
<?php echo $product_group->v_02->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_02_validation->Visible) { // v_02_validation ?>
		<td data-name="v_02_validation"<?php echo $product_group->v_02_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_02_validation" class="product_group_v_02_validation">
<span<?php echo $product_group->v_02_validation->viewAttributes() ?>>
<?php echo $product_group->v_02_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_03->Visible) { // v_03 ?>
		<td data-name="v_03"<?php echo $product_group->v_03->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_03" class="product_group_v_03">
<span<?php echo $product_group->v_03->viewAttributes() ?>>
<?php echo $product_group->v_03->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_03_validation->Visible) { // v_03_validation ?>
		<td data-name="v_03_validation"<?php echo $product_group->v_03_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_03_validation" class="product_group_v_03_validation">
<span<?php echo $product_group->v_03_validation->viewAttributes() ?>>
<?php echo $product_group->v_03_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_04->Visible) { // v_04 ?>
		<td data-name="v_04"<?php echo $product_group->v_04->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_04" class="product_group_v_04">
<span<?php echo $product_group->v_04->viewAttributes() ?>>
<?php echo $product_group->v_04->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_04_validation->Visible) { // v_04_validation ?>
		<td data-name="v_04_validation"<?php echo $product_group->v_04_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_04_validation" class="product_group_v_04_validation">
<span<?php echo $product_group->v_04_validation->viewAttributes() ?>>
<?php echo $product_group->v_04_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_05->Visible) { // v_05 ?>
		<td data-name="v_05"<?php echo $product_group->v_05->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_05" class="product_group_v_05">
<span<?php echo $product_group->v_05->viewAttributes() ?>>
<?php echo $product_group->v_05->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_05_validation->Visible) { // v_05_validation ?>
		<td data-name="v_05_validation"<?php echo $product_group->v_05_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_05_validation" class="product_group_v_05_validation">
<span<?php echo $product_group->v_05_validation->viewAttributes() ?>>
<?php echo $product_group->v_05_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_06->Visible) { // v_06 ?>
		<td data-name="v_06"<?php echo $product_group->v_06->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_06" class="product_group_v_06">
<span<?php echo $product_group->v_06->viewAttributes() ?>>
<?php echo $product_group->v_06->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_06_validation->Visible) { // v_06_validation ?>
		<td data-name="v_06_validation"<?php echo $product_group->v_06_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_06_validation" class="product_group_v_06_validation">
<span<?php echo $product_group->v_06_validation->viewAttributes() ?>>
<?php echo $product_group->v_06_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_07->Visible) { // v_07 ?>
		<td data-name="v_07"<?php echo $product_group->v_07->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_07" class="product_group_v_07">
<span<?php echo $product_group->v_07->viewAttributes() ?>>
<?php echo $product_group->v_07->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_07_validation->Visible) { // v_07_validation ?>
		<td data-name="v_07_validation"<?php echo $product_group->v_07_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_07_validation" class="product_group_v_07_validation">
<span<?php echo $product_group->v_07_validation->viewAttributes() ?>>
<?php echo $product_group->v_07_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_08->Visible) { // v_08 ?>
		<td data-name="v_08"<?php echo $product_group->v_08->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_08" class="product_group_v_08">
<span<?php echo $product_group->v_08->viewAttributes() ?>>
<?php echo $product_group->v_08->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_08_validation->Visible) { // v_08_validation ?>
		<td data-name="v_08_validation"<?php echo $product_group->v_08_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_08_validation" class="product_group_v_08_validation">
<span<?php echo $product_group->v_08_validation->viewAttributes() ?>>
<?php echo $product_group->v_08_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_09->Visible) { // v_09 ?>
		<td data-name="v_09"<?php echo $product_group->v_09->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_09" class="product_group_v_09">
<span<?php echo $product_group->v_09->viewAttributes() ?>>
<?php echo $product_group->v_09->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_09_validation->Visible) { // v_09_validation ?>
		<td data-name="v_09_validation"<?php echo $product_group->v_09_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_09_validation" class="product_group_v_09_validation">
<span<?php echo $product_group->v_09_validation->viewAttributes() ?>>
<?php echo $product_group->v_09_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_10->Visible) { // v_10 ?>
		<td data-name="v_10"<?php echo $product_group->v_10->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_10" class="product_group_v_10">
<span<?php echo $product_group->v_10->viewAttributes() ?>>
<?php echo $product_group->v_10->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->v_10_validation->Visible) { // v_10_validation ?>
		<td data-name="v_10_validation"<?php echo $product_group->v_10_validation->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_v_10_validation" class="product_group_v_10_validation">
<span<?php echo $product_group->v_10_validation->viewAttributes() ?>>
<?php echo $product_group->v_10_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_01_head->Visible) { // b_01_head ?>
		<td data-name="b_01_head"<?php echo $product_group->b_01_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_01_head" class="product_group_b_01_head">
<span<?php echo $product_group->b_01_head->viewAttributes() ?>>
<?php echo $product_group->b_01_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_02_head->Visible) { // b_02_head ?>
		<td data-name="b_02_head"<?php echo $product_group->b_02_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_02_head" class="product_group_b_02_head">
<span<?php echo $product_group->b_02_head->viewAttributes() ?>>
<?php echo $product_group->b_02_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_03_head->Visible) { // b_03_head ?>
		<td data-name="b_03_head"<?php echo $product_group->b_03_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_03_head" class="product_group_b_03_head">
<span<?php echo $product_group->b_03_head->viewAttributes() ?>>
<?php echo $product_group->b_03_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_04_head->Visible) { // b_04_head ?>
		<td data-name="b_04_head"<?php echo $product_group->b_04_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_04_head" class="product_group_b_04_head">
<span<?php echo $product_group->b_04_head->viewAttributes() ?>>
<?php echo $product_group->b_04_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_05_head->Visible) { // b_05_head ?>
		<td data-name="b_05_head"<?php echo $product_group->b_05_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_05_head" class="product_group_b_05_head">
<span<?php echo $product_group->b_05_head->viewAttributes() ?>>
<?php echo $product_group->b_05_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_06_head->Visible) { // b_06_head ?>
		<td data-name="b_06_head"<?php echo $product_group->b_06_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_06_head" class="product_group_b_06_head">
<span<?php echo $product_group->b_06_head->viewAttributes() ?>>
<?php echo $product_group->b_06_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_07_head->Visible) { // b_07_head ?>
		<td data-name="b_07_head"<?php echo $product_group->b_07_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_07_head" class="product_group_b_07_head">
<span<?php echo $product_group->b_07_head->viewAttributes() ?>>
<?php echo $product_group->b_07_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_08_head->Visible) { // b_08_head ?>
		<td data-name="b_08_head"<?php echo $product_group->b_08_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_08_head" class="product_group_b_08_head">
<span<?php echo $product_group->b_08_head->viewAttributes() ?>>
<?php echo $product_group->b_08_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_09_head->Visible) { // b_09_head ?>
		<td data-name="b_09_head"<?php echo $product_group->b_09_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_09_head" class="product_group_b_09_head">
<span<?php echo $product_group->b_09_head->viewAttributes() ?>>
<?php echo $product_group->b_09_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_10_head->Visible) { // b_10_head ?>
		<td data-name="b_10_head"<?php echo $product_group->b_10_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_10_head" class="product_group_b_10_head">
<span<?php echo $product_group->b_10_head->viewAttributes() ?>>
<?php echo $product_group->b_10_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_11_head->Visible) { // b_11_head ?>
		<td data-name="b_11_head"<?php echo $product_group->b_11_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_11_head" class="product_group_b_11_head">
<span<?php echo $product_group->b_11_head->viewAttributes() ?>>
<?php echo $product_group->b_11_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_12_head->Visible) { // b_12_head ?>
		<td data-name="b_12_head"<?php echo $product_group->b_12_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_12_head" class="product_group_b_12_head">
<span<?php echo $product_group->b_12_head->viewAttributes() ?>>
<?php echo $product_group->b_12_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_13_head->Visible) { // b_13_head ?>
		<td data-name="b_13_head"<?php echo $product_group->b_13_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_13_head" class="product_group_b_13_head">
<span<?php echo $product_group->b_13_head->viewAttributes() ?>>
<?php echo $product_group->b_13_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_14_head->Visible) { // b_14_head ?>
		<td data-name="b_14_head"<?php echo $product_group->b_14_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_14_head" class="product_group_b_14_head">
<span<?php echo $product_group->b_14_head->viewAttributes() ?>>
<?php echo $product_group->b_14_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->b_15_head->Visible) { // b_15_head ?>
		<td data-name="b_15_head"<?php echo $product_group->b_15_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_b_15_head" class="product_group_b_15_head">
<span<?php echo $product_group->b_15_head->viewAttributes() ?>>
<?php echo $product_group->b_15_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->q_sku->Visible) { // q_sku ?>
		<td data-name="q_sku"<?php echo $product_group->q_sku->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_q_sku" class="product_group_q_sku">
<span<?php echo $product_group->q_sku->viewAttributes() ?>>
<?php echo $product_group->q_sku->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_01_head->Visible) { // t_01_head ?>
		<td data-name="t_01_head"<?php echo $product_group->t_01_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_01_head" class="product_group_t_01_head">
<span<?php echo $product_group->t_01_head->viewAttributes() ?>>
<?php echo $product_group->t_01_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_02_head->Visible) { // t_02_head ?>
		<td data-name="t_02_head"<?php echo $product_group->t_02_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_02_head" class="product_group_t_02_head">
<span<?php echo $product_group->t_02_head->viewAttributes() ?>>
<?php echo $product_group->t_02_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_03_head->Visible) { // t_03_head ?>
		<td data-name="t_03_head"<?php echo $product_group->t_03_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_03_head" class="product_group_t_03_head">
<span<?php echo $product_group->t_03_head->viewAttributes() ?>>
<?php echo $product_group->t_03_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_04_head->Visible) { // t_04_head ?>
		<td data-name="t_04_head"<?php echo $product_group->t_04_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_04_head" class="product_group_t_04_head">
<span<?php echo $product_group->t_04_head->viewAttributes() ?>>
<?php echo $product_group->t_04_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_05_head->Visible) { // t_05_head ?>
		<td data-name="t_05_head"<?php echo $product_group->t_05_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_05_head" class="product_group_t_05_head">
<span<?php echo $product_group->t_05_head->viewAttributes() ?>>
<?php echo $product_group->t_05_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_06_head->Visible) { // t_06_head ?>
		<td data-name="t_06_head"<?php echo $product_group->t_06_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_06_head" class="product_group_t_06_head">
<span<?php echo $product_group->t_06_head->viewAttributes() ?>>
<?php echo $product_group->t_06_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_07_head->Visible) { // t_07_head ?>
		<td data-name="t_07_head"<?php echo $product_group->t_07_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_07_head" class="product_group_t_07_head">
<span<?php echo $product_group->t_07_head->viewAttributes() ?>>
<?php echo $product_group->t_07_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_08_head->Visible) { // t_08_head ?>
		<td data-name="t_08_head"<?php echo $product_group->t_08_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_08_head" class="product_group_t_08_head">
<span<?php echo $product_group->t_08_head->viewAttributes() ?>>
<?php echo $product_group->t_08_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_09_head->Visible) { // t_09_head ?>
		<td data-name="t_09_head"<?php echo $product_group->t_09_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_09_head" class="product_group_t_09_head">
<span<?php echo $product_group->t_09_head->viewAttributes() ?>>
<?php echo $product_group->t_09_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_10_head->Visible) { // t_10_head ?>
		<td data-name="t_10_head"<?php echo $product_group->t_10_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_10_head" class="product_group_t_10_head">
<span<?php echo $product_group->t_10_head->viewAttributes() ?>>
<?php echo $product_group->t_10_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_11_head->Visible) { // t_11_head ?>
		<td data-name="t_11_head"<?php echo $product_group->t_11_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_11_head" class="product_group_t_11_head">
<span<?php echo $product_group->t_11_head->viewAttributes() ?>>
<?php echo $product_group->t_11_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_12_head->Visible) { // t_12_head ?>
		<td data-name="t_12_head"<?php echo $product_group->t_12_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_12_head" class="product_group_t_12_head">
<span<?php echo $product_group->t_12_head->viewAttributes() ?>>
<?php echo $product_group->t_12_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_13_head->Visible) { // t_13_head ?>
		<td data-name="t_13_head"<?php echo $product_group->t_13_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_13_head" class="product_group_t_13_head">
<span<?php echo $product_group->t_13_head->viewAttributes() ?>>
<?php echo $product_group->t_13_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_14_head->Visible) { // t_14_head ?>
		<td data-name="t_14_head"<?php echo $product_group->t_14_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_14_head" class="product_group_t_14_head">
<span<?php echo $product_group->t_14_head->viewAttributes() ?>>
<?php echo $product_group->t_14_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->t_15_head->Visible) { // t_15_head ?>
		<td data-name="t_15_head"<?php echo $product_group->t_15_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_t_15_head" class="product_group_t_15_head">
<span<?php echo $product_group->t_15_head->viewAttributes() ?>>
<?php echo $product_group->t_15_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_01_head->Visible) { // po_01_head ?>
		<td data-name="po_01_head"<?php echo $product_group->po_01_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_01_head" class="product_group_po_01_head">
<span<?php echo $product_group->po_01_head->viewAttributes() ?>>
<?php echo $product_group->po_01_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_02_head->Visible) { // po_02_head ?>
		<td data-name="po_02_head"<?php echo $product_group->po_02_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_02_head" class="product_group_po_02_head">
<span<?php echo $product_group->po_02_head->viewAttributes() ?>>
<?php echo $product_group->po_02_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_03_head->Visible) { // po_03_head ?>
		<td data-name="po_03_head"<?php echo $product_group->po_03_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_03_head" class="product_group_po_03_head">
<span<?php echo $product_group->po_03_head->viewAttributes() ?>>
<?php echo $product_group->po_03_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_04_head->Visible) { // po_04_head ?>
		<td data-name="po_04_head"<?php echo $product_group->po_04_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_04_head" class="product_group_po_04_head">
<span<?php echo $product_group->po_04_head->viewAttributes() ?>>
<?php echo $product_group->po_04_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_05_head->Visible) { // po_05_head ?>
		<td data-name="po_05_head"<?php echo $product_group->po_05_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_05_head" class="product_group_po_05_head">
<span<?php echo $product_group->po_05_head->viewAttributes() ?>>
<?php echo $product_group->po_05_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_06_head->Visible) { // po_06_head ?>
		<td data-name="po_06_head"<?php echo $product_group->po_06_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_06_head" class="product_group_po_06_head">
<span<?php echo $product_group->po_06_head->viewAttributes() ?>>
<?php echo $product_group->po_06_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_07_head->Visible) { // po_07_head ?>
		<td data-name="po_07_head"<?php echo $product_group->po_07_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_07_head" class="product_group_po_07_head">
<span<?php echo $product_group->po_07_head->viewAttributes() ?>>
<?php echo $product_group->po_07_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_08_head->Visible) { // po_08_head ?>
		<td data-name="po_08_head"<?php echo $product_group->po_08_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_08_head" class="product_group_po_08_head">
<span<?php echo $product_group->po_08_head->viewAttributes() ?>>
<?php echo $product_group->po_08_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_17_head->Visible) { // po_17_head ?>
		<td data-name="po_17_head"<?php echo $product_group->po_17_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_17_head" class="product_group_po_17_head">
<span<?php echo $product_group->po_17_head->viewAttributes() ?>>
<?php echo $product_group->po_17_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_18_head->Visible) { // po_18_head ?>
		<td data-name="po_18_head"<?php echo $product_group->po_18_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_18_head" class="product_group_po_18_head">
<span<?php echo $product_group->po_18_head->viewAttributes() ?>>
<?php echo $product_group->po_18_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_19_head->Visible) { // po_19_head ?>
		<td data-name="po_19_head"<?php echo $product_group->po_19_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_19_head" class="product_group_po_19_head">
<span<?php echo $product_group->po_19_head->viewAttributes() ?>>
<?php echo $product_group->po_19_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->po_20_head->Visible) { // po_20_head ?>
		<td data-name="po_20_head"<?php echo $product_group->po_20_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_po_20_head" class="product_group_po_20_head">
<span<?php echo $product_group->po_20_head->viewAttributes() ?>>
<?php echo $product_group->po_20_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_01_head->Visible) { // jc_01_head ?>
		<td data-name="jc_01_head"<?php echo $product_group->jc_01_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_01_head" class="product_group_jc_01_head">
<span<?php echo $product_group->jc_01_head->viewAttributes() ?>>
<?php echo $product_group->jc_01_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_02_head->Visible) { // jc_02_head ?>
		<td data-name="jc_02_head"<?php echo $product_group->jc_02_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_02_head" class="product_group_jc_02_head">
<span<?php echo $product_group->jc_02_head->viewAttributes() ?>>
<?php echo $product_group->jc_02_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_03_head->Visible) { // jc_03_head ?>
		<td data-name="jc_03_head"<?php echo $product_group->jc_03_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_03_head" class="product_group_jc_03_head">
<span<?php echo $product_group->jc_03_head->viewAttributes() ?>>
<?php echo $product_group->jc_03_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_04_head->Visible) { // jc_04_head ?>
		<td data-name="jc_04_head"<?php echo $product_group->jc_04_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_04_head" class="product_group_jc_04_head">
<span<?php echo $product_group->jc_04_head->viewAttributes() ?>>
<?php echo $product_group->jc_04_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_05_head->Visible) { // jc_05_head ?>
		<td data-name="jc_05_head"<?php echo $product_group->jc_05_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_05_head" class="product_group_jc_05_head">
<span<?php echo $product_group->jc_05_head->viewAttributes() ?>>
<?php echo $product_group->jc_05_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_06_head->Visible) { // jc_06_head ?>
		<td data-name="jc_06_head"<?php echo $product_group->jc_06_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_06_head" class="product_group_jc_06_head">
<span<?php echo $product_group->jc_06_head->viewAttributes() ?>>
<?php echo $product_group->jc_06_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_07_head->Visible) { // jc_07_head ?>
		<td data-name="jc_07_head"<?php echo $product_group->jc_07_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_07_head" class="product_group_jc_07_head">
<span<?php echo $product_group->jc_07_head->viewAttributes() ?>>
<?php echo $product_group->jc_07_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_08_head->Visible) { // jc_08_head ?>
		<td data-name="jc_08_head"<?php echo $product_group->jc_08_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_08_head" class="product_group_jc_08_head">
<span<?php echo $product_group->jc_08_head->viewAttributes() ?>>
<?php echo $product_group->jc_08_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_09_head->Visible) { // jc_09_head ?>
		<td data-name="jc_09_head"<?php echo $product_group->jc_09_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_09_head" class="product_group_jc_09_head">
<span<?php echo $product_group->jc_09_head->viewAttributes() ?>>
<?php echo $product_group->jc_09_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->jc_10_head->Visible) { // jc_10_head ?>
		<td data-name="jc_10_head"<?php echo $product_group->jc_10_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_jc_10_head" class="product_group_jc_10_head">
<span<?php echo $product_group->jc_10_head->viewAttributes() ?>>
<?php echo $product_group->jc_10_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_shape->Visible) { // pc_shape ?>
		<td data-name="pc_shape"<?php echo $product_group->pc_shape->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_shape" class="product_group_pc_shape">
<span<?php echo $product_group->pc_shape->viewAttributes() ?>>
<?php echo $product_group->pc_shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_unit->Visible) { // pc_unit ?>
		<td data-name="pc_unit"<?php echo $product_group->pc_unit->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_unit" class="product_group_pc_unit">
<span<?php echo $product_group->pc_unit->viewAttributes() ?>>
<?php echo $product_group->pc_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_w->Visible) { // pc_w ?>
		<td data-name="pc_w"<?php echo $product_group->pc_w->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_w" class="product_group_pc_w">
<span<?php echo $product_group->pc_w->viewAttributes() ?>>
<?php echo $product_group->pc_w->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_l->Visible) { // pc_l ?>
		<td data-name="pc_l"<?php echo $product_group->pc_l->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_l" class="product_group_pc_l">
<span<?php echo $product_group->pc_l->viewAttributes() ?>>
<?php echo $product_group->pc_l->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_h->Visible) { // pc_h ?>
		<td data-name="pc_h"<?php echo $product_group->pc_h->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_h" class="product_group_pc_h">
<span<?php echo $product_group->pc_h->viewAttributes() ?>>
<?php echo $product_group->pc_h->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_partner_size->Visible) { // pc_partner_size ?>
		<td data-name="pc_partner_size"<?php echo $product_group->pc_partner_size->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_partner_size" class="product_group_pc_partner_size">
<span<?php echo $product_group->pc_partner_size->viewAttributes() ?>>
<?php echo $product_group->pc_partner_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_sqm->Visible) { // pc_sqm ?>
		<td data-name="pc_sqm"<?php echo $product_group->pc_sqm->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_sqm" class="product_group_pc_sqm">
<span<?php echo $product_group->pc_sqm->viewAttributes() ?>>
<?php echo $product_group->pc_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_01_head->Visible) { // pc_01_head ?>
		<td data-name="pc_01_head"<?php echo $product_group->pc_01_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_01_head" class="product_group_pc_01_head">
<span<?php echo $product_group->pc_01_head->viewAttributes() ?>>
<?php echo $product_group->pc_01_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_02_head->Visible) { // pc_02_head ?>
		<td data-name="pc_02_head"<?php echo $product_group->pc_02_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_02_head" class="product_group_pc_02_head">
<span<?php echo $product_group->pc_02_head->viewAttributes() ?>>
<?php echo $product_group->pc_02_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_03_head->Visible) { // pc_03_head ?>
		<td data-name="pc_03_head"<?php echo $product_group->pc_03_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_03_head" class="product_group_pc_03_head">
<span<?php echo $product_group->pc_03_head->viewAttributes() ?>>
<?php echo $product_group->pc_03_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_04_head->Visible) { // pc_04_head ?>
		<td data-name="pc_04_head"<?php echo $product_group->pc_04_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_04_head" class="product_group_pc_04_head">
<span<?php echo $product_group->pc_04_head->viewAttributes() ?>>
<?php echo $product_group->pc_04_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_05_head->Visible) { // pc_05_head ?>
		<td data-name="pc_05_head"<?php echo $product_group->pc_05_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_05_head" class="product_group_pc_05_head">
<span<?php echo $product_group->pc_05_head->viewAttributes() ?>>
<?php echo $product_group->pc_05_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_06_head->Visible) { // pc_06_head ?>
		<td data-name="pc_06_head"<?php echo $product_group->pc_06_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_06_head" class="product_group_pc_06_head">
<span<?php echo $product_group->pc_06_head->viewAttributes() ?>>
<?php echo $product_group->pc_06_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_07_head->Visible) { // pc_07_head ?>
		<td data-name="pc_07_head"<?php echo $product_group->pc_07_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_07_head" class="product_group_pc_07_head">
<span<?php echo $product_group->pc_07_head->viewAttributes() ?>>
<?php echo $product_group->pc_07_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_08_head->Visible) { // pc_08_head ?>
		<td data-name="pc_08_head"<?php echo $product_group->pc_08_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_08_head" class="product_group_pc_08_head">
<span<?php echo $product_group->pc_08_head->viewAttributes() ?>>
<?php echo $product_group->pc_08_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_09_head->Visible) { // pc_09_head ?>
		<td data-name="pc_09_head"<?php echo $product_group->pc_09_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_09_head" class="product_group_pc_09_head">
<span<?php echo $product_group->pc_09_head->viewAttributes() ?>>
<?php echo $product_group->pc_09_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_10_head->Visible) { // pc_10_head ?>
		<td data-name="pc_10_head"<?php echo $product_group->pc_10_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_10_head" class="product_group_pc_10_head">
<span<?php echo $product_group->pc_10_head->viewAttributes() ?>>
<?php echo $product_group->pc_10_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_11_head->Visible) { // pc_11_head ?>
		<td data-name="pc_11_head"<?php echo $product_group->pc_11_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_11_head" class="product_group_pc_11_head">
<span<?php echo $product_group->pc_11_head->viewAttributes() ?>>
<?php echo $product_group->pc_11_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->pc_12_head->Visible) { // pc_12_head ?>
		<td data-name="pc_12_head"<?php echo $product_group->pc_12_head->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_pc_12_head" class="product_group_pc_12_head">
<span<?php echo $product_group->pc_12_head->viewAttributes() ?>>
<?php echo $product_group->pc_12_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_group->operator->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_operator" class="product_group_operator">
<span<?php echo $product_group->operator->viewAttributes() ?>>
<?php echo $product_group->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_group->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_datetime" class="product_group_datetime">
<span<?php echo $product_group->datetime->viewAttributes() ?>>
<?php echo $product_group->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_group->image->Visible) { // image ?>
		<td data-name="image"<?php echo $product_group->image->cellAttributes() ?>>
<span id="el<?php echo $product_group_list->RowCnt ?>_product_group_image" class="product_group_image">
<span>
<?php echo GetFileViewTag($product_group->image, $product_group->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_group_list->ListOptions->render("body", "right", $product_group_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_group->isGridAdd())
		$product_group_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_group->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_group_list->Recordset)
	$product_group_list->Recordset->Close();
?>
<?php if (!$product_group->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_group->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_group_list->Pager)) $product_group_list->Pager = new PrevNextPager($product_group_list->StartRec, $product_group_list->DisplayRecs, $product_group_list->TotalRecs, $product_group_list->AutoHidePager) ?>
<?php if ($product_group_list->Pager->RecordCount > 0 && $product_group_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_group_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_group_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_group_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_group_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_group_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_group_list->pageUrl() ?>start=<?php echo $product_group_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_group_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_group_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_group_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_group_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_group_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_group_list->TotalRecs > 0 && (!$product_group_list->AutoHidePageSizeSelector || $product_group_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_group">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_group_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_group_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_group_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_group_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_group_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_group->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_group_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_group_list->TotalRecs == 0 && !$product_group->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_group_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_group_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_group->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_group->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_group", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_group_list->terminate();
?>