<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_group_search = new product_group_search();

// Run the page
$product_group_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_group_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_group_search->IsModal) { ?>
var fproduct_groupsearch = currentAdvancedSearchForm = new ew.Form("fproduct_groupsearch", "search");
<?php } else { ?>
var fproduct_groupsearch = currentForm = new ew.Form("fproduct_groupsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_groupsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_groupsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fproduct_groupsearch.multiPage = new ew.MultiPage("fproduct_groupsearch");

// Dynamic selection lists
fproduct_groupsearch.lists["x_grp"] = <?php echo $product_group_search->grp->Lookup->toClientList() ?>;
fproduct_groupsearch.lists["x_grp"].options = <?php echo JsonEncode($product_group_search->grp->lookupOptions()) ?>;
fproduct_groupsearch.lists["x_calculation_method"] = <?php echo $product_group_search->calculation_method->Lookup->toClientList() ?>;
fproduct_groupsearch.lists["x_calculation_method"].options = <?php echo JsonEncode($product_group_search->calculation_method->lookupOptions()) ?>;
fproduct_groupsearch.lists["x_process"] = <?php echo $product_group_search->process->Lookup->toClientList() ?>;
fproduct_groupsearch.lists["x_process"].options = <?php echo JsonEncode($product_group_search->process->lookupOptions()) ?>;
fproduct_groupsearch.lists["x_status"] = <?php echo $product_group_search->status->Lookup->toClientList() ?>;
fproduct_groupsearch.lists["x_status"].options = <?php echo JsonEncode($product_group_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fproduct_groupsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_group->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_group->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_group->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_group_search->showPageHeader(); ?>
<?php
$product_group_search->showMessage();
?>
<form name="fproduct_groupsearch" id="fproduct_groupsearch" class="<?php echo $product_group_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_group_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_group_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_group">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_group_search->IsModal ?>">
<?php if ($product_group_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($product_group->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_grp"><?php echo $product_group->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->grp->cellAttributes() ?>>
			<span id="el_product_group_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_grp" data-page="0" data-value-separator="<?php echo $product_group->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_group->grp->editAttributes() ?>>
		<?php echo $product_group->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_group->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->product_group->Visible) { // product_group ?>
	<div id="r_product_group" class="form-group row">
		<label for="x_product_group" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_product_group"><?php echo $product_group->product_group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_group" id="z_product_group" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->product_group->cellAttributes() ?>>
			<span id="el_product_group_product_group">
<input type="text" data-table="product_group" data-field="x_product_group" data-page="0" name="x_product_group" id="x_product_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->product_group->getPlaceHolder()) ?>" value="<?php echo $product_group->product_group->EditValue ?>"<?php echo $product_group->product_group->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->calculation_method->Visible) { // calculation_method ?>
	<div id="r_calculation_method" class="form-group row">
		<label for="x_calculation_method" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_calculation_method"><?php echo $product_group->calculation_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_calculation_method" id="z_calculation_method" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->calculation_method->cellAttributes() ?>>
			<span id="el_product_group_calculation_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_calculation_method" data-page="0" data-value-separator="<?php echo $product_group->calculation_method->displayValueSeparatorAttribute() ?>" id="x_calculation_method" name="x_calculation_method"<?php echo $product_group->calculation_method->editAttributes() ?>>
		<?php echo $product_group->calculation_method->selectOptionListHtml("x_calculation_method") ?>
	</select>
</div>
<?php echo $product_group->calculation_method->Lookup->getParamTag("p_x_calculation_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_shape"><?php echo $product_group->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shape" id="z_shape" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->shape->cellAttributes() ?>>
			<span id="el_product_group_shape">
<input type="text" data-table="product_group" data-field="x_shape" data-page="0" name="x_shape" id="x_shape" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->shape->getPlaceHolder()) ?>" value="<?php echo $product_group->shape->EditValue ?>"<?php echo $product_group->shape->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_sqm"><?php echo $product_group->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sqm" id="z_sqm" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->sqm->cellAttributes() ?>>
			<span id="el_product_group_sqm">
<input type="text" data-table="product_group" data-field="x_sqm" data-page="0" name="x_sqm" id="x_sqm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->sqm->getPlaceHolder()) ?>" value="<?php echo $product_group->sqm->EditValue ?>"<?php echo $product_group->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_cbm"><?php echo $product_group->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cbm" id="z_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->cbm->cellAttributes() ?>>
			<span id="el_product_group_cbm">
<input type="text" data-table="product_group" data-field="x_cbm" data-page="0" name="x_cbm" id="x_cbm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->cbm->getPlaceHolder()) ?>" value="<?php echo $product_group->cbm->EditValue ?>"<?php echo $product_group->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_process"><?php echo $product_group->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->process->cellAttributes() ?>>
			<span id="el_product_group_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_process" data-page="0" data-value-separator="<?php echo $product_group->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $product_group->process->editAttributes() ?>>
		<?php echo $product_group->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $product_group->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_status"><?php echo $product_group->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->status->cellAttributes() ?>>
			<span id="el_product_group_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_group" data-field="x_status" data-page="0" data-value-separator="<?php echo $product_group->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_group->status->editAttributes() ?>>
		<?php echo $product_group->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_operator"><?php echo $product_group->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->operator->cellAttributes() ?>>
			<span id="el_product_group_operator">
<input type="text" data-table="product_group" data-field="x_operator" data-page="0" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($product_group->operator->getPlaceHolder()) ?>" value="<?php echo $product_group->operator->EditValue ?>"<?php echo $product_group->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_datetime"><?php echo $product_group->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->datetime->cellAttributes() ?>>
			<span id="el_product_group_datetime">
<input type="text" data-table="product_group" data-field="x_datetime" data-page="0" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_group->datetime->getPlaceHolder()) ?>" value="<?php echo $product_group->datetime->EditValue ?>"<?php echo $product_group->datetime->editAttributes() ?>>
<?php if (!$product_group->datetime->ReadOnly && !$product_group->datetime->Disabled && !isset($product_group->datetime->EditAttrs["readonly"]) && !isset($product_group->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduct_groupsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_image"><?php echo $product_group->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->image->cellAttributes() ?>>
			<span id="el_product_group_image">
<input type="text" data-table="product_group" data-field="x_image" data-page="0" name="x_image" id="x_image" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($product_group->image->getPlaceHolder()) ?>" value="<?php echo $product_group->image->EditValue ?>"<?php echo $product_group->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="product_group_search"><!-- multi-page tabs -->
	<ul class="<?php echo $product_group_search->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("1") ?>" href="#tab_product_group1" data-toggle="tab"><?php echo $product_group->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("2") ?>" href="#tab_product_group2" data-toggle="tab"><?php echo $product_group->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("3") ?>" href="#tab_product_group3" data-toggle="tab"><?php echo $product_group->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("4") ?>" href="#tab_product_group4" data-toggle="tab"><?php echo $product_group->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("5") ?>" href="#tab_product_group5" data-toggle="tab"><?php echo $product_group->pageCaption(5) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_search->MultiPages->pageStyle("6") ?>" href="#tab_product_group6" data-toggle="tab"><?php echo $product_group->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("1") ?>" id="tab_product_group1"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_id"><?php echo $product_group->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->id->cellAttributes() ?>>
			<span id="el_product_group_id">
<input type="text" data-table="product_group" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_group->id->getPlaceHolder()) ?>" value="<?php echo $product_group->id->EditValue ?>"<?php echo $product_group->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_00->Visible) { // v_00 ?>
	<div id="r_v_00" class="form-group row">
		<label for="x_v_00" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_00"><?php echo $product_group->v_00->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_00" id="z_v_00" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_00->cellAttributes() ?>>
			<span id="el_product_group_v_00">
<input type="text" data-table="product_group" data-field="x_v_00" data-page="1" name="x_v_00" id="x_v_00" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_00->getPlaceHolder()) ?>" value="<?php echo $product_group->v_00->EditValue ?>"<?php echo $product_group->v_00->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_01->Visible) { // v_01 ?>
	<div id="r_v_01" class="form-group row">
		<label for="x_v_01" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_01"><?php echo $product_group->v_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_01" id="z_v_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_01->cellAttributes() ?>>
			<span id="el_product_group_v_01">
<input type="text" data-table="product_group" data-field="x_v_01" data-page="1" name="x_v_01" id="x_v_01" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($product_group->v_01->getPlaceHolder()) ?>" value="<?php echo $product_group->v_01->EditValue ?>"<?php echo $product_group->v_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_01_validation->Visible) { // v_01_validation ?>
	<div id="r_v_01_validation" class="form-group row">
		<label for="x_v_01_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_01_validation"><?php echo $product_group->v_01_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_01_validation" id="z_v_01_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_01_validation->cellAttributes() ?>>
			<span id="el_product_group_v_01_validation">
<input type="text" data-table="product_group" data-field="x_v_01_validation" data-page="1" name="x_v_01_validation" id="x_v_01_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_01_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_01_validation->EditValue ?>"<?php echo $product_group->v_01_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_02->Visible) { // v_02 ?>
	<div id="r_v_02" class="form-group row">
		<label for="x_v_02" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_02"><?php echo $product_group->v_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_02" id="z_v_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_02->cellAttributes() ?>>
			<span id="el_product_group_v_02">
<input type="text" data-table="product_group" data-field="x_v_02" data-page="1" name="x_v_02" id="x_v_02" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($product_group->v_02->getPlaceHolder()) ?>" value="<?php echo $product_group->v_02->EditValue ?>"<?php echo $product_group->v_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_02_validation->Visible) { // v_02_validation ?>
	<div id="r_v_02_validation" class="form-group row">
		<label for="x_v_02_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_02_validation"><?php echo $product_group->v_02_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_02_validation" id="z_v_02_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_02_validation->cellAttributes() ?>>
			<span id="el_product_group_v_02_validation">
<input type="text" data-table="product_group" data-field="x_v_02_validation" data-page="1" name="x_v_02_validation" id="x_v_02_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_02_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_02_validation->EditValue ?>"<?php echo $product_group->v_02_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_03->Visible) { // v_03 ?>
	<div id="r_v_03" class="form-group row">
		<label for="x_v_03" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_03"><?php echo $product_group->v_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_03" id="z_v_03" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_03->cellAttributes() ?>>
			<span id="el_product_group_v_03">
<input type="text" data-table="product_group" data-field="x_v_03" data-page="1" name="x_v_03" id="x_v_03" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($product_group->v_03->getPlaceHolder()) ?>" value="<?php echo $product_group->v_03->EditValue ?>"<?php echo $product_group->v_03->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_03_validation->Visible) { // v_03_validation ?>
	<div id="r_v_03_validation" class="form-group row">
		<label for="x_v_03_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_03_validation"><?php echo $product_group->v_03_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_03_validation" id="z_v_03_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_03_validation->cellAttributes() ?>>
			<span id="el_product_group_v_03_validation">
<input type="text" data-table="product_group" data-field="x_v_03_validation" data-page="1" name="x_v_03_validation" id="x_v_03_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_03_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_03_validation->EditValue ?>"<?php echo $product_group->v_03_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_04->Visible) { // v_04 ?>
	<div id="r_v_04" class="form-group row">
		<label for="x_v_04" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_04"><?php echo $product_group->v_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_04" id="z_v_04" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_04->cellAttributes() ?>>
			<span id="el_product_group_v_04">
<input type="text" data-table="product_group" data-field="x_v_04" data-page="1" name="x_v_04" id="x_v_04" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($product_group->v_04->getPlaceHolder()) ?>" value="<?php echo $product_group->v_04->EditValue ?>"<?php echo $product_group->v_04->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_04_validation->Visible) { // v_04_validation ?>
	<div id="r_v_04_validation" class="form-group row">
		<label for="x_v_04_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_04_validation"><?php echo $product_group->v_04_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_04_validation" id="z_v_04_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_04_validation->cellAttributes() ?>>
			<span id="el_product_group_v_04_validation">
<input type="text" data-table="product_group" data-field="x_v_04_validation" data-page="1" name="x_v_04_validation" id="x_v_04_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_04_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_04_validation->EditValue ?>"<?php echo $product_group->v_04_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_05->Visible) { // v_05 ?>
	<div id="r_v_05" class="form-group row">
		<label for="x_v_05" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_05"><?php echo $product_group->v_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_05" id="z_v_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_05->cellAttributes() ?>>
			<span id="el_product_group_v_05">
<input type="text" data-table="product_group" data-field="x_v_05" data-page="1" name="x_v_05" id="x_v_05" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($product_group->v_05->getPlaceHolder()) ?>" value="<?php echo $product_group->v_05->EditValue ?>"<?php echo $product_group->v_05->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_05_validation->Visible) { // v_05_validation ?>
	<div id="r_v_05_validation" class="form-group row">
		<label for="x_v_05_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_05_validation"><?php echo $product_group->v_05_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_05_validation" id="z_v_05_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_05_validation->cellAttributes() ?>>
			<span id="el_product_group_v_05_validation">
<input type="text" data-table="product_group" data-field="x_v_05_validation" data-page="1" name="x_v_05_validation" id="x_v_05_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_05_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_05_validation->EditValue ?>"<?php echo $product_group->v_05_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_06->Visible) { // v_06 ?>
	<div id="r_v_06" class="form-group row">
		<label for="x_v_06" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_06"><?php echo $product_group->v_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_06" id="z_v_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_06->cellAttributes() ?>>
			<span id="el_product_group_v_06">
<input type="text" data-table="product_group" data-field="x_v_06" data-page="1" name="x_v_06" id="x_v_06" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_06->getPlaceHolder()) ?>" value="<?php echo $product_group->v_06->EditValue ?>"<?php echo $product_group->v_06->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_06_validation->Visible) { // v_06_validation ?>
	<div id="r_v_06_validation" class="form-group row">
		<label for="x_v_06_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_06_validation"><?php echo $product_group->v_06_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_06_validation" id="z_v_06_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_06_validation->cellAttributes() ?>>
			<span id="el_product_group_v_06_validation">
<input type="text" data-table="product_group" data-field="x_v_06_validation" data-page="1" name="x_v_06_validation" id="x_v_06_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_06_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_06_validation->EditValue ?>"<?php echo $product_group->v_06_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_07->Visible) { // v_07 ?>
	<div id="r_v_07" class="form-group row">
		<label for="x_v_07" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_07"><?php echo $product_group->v_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_07" id="z_v_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_07->cellAttributes() ?>>
			<span id="el_product_group_v_07">
<input type="text" data-table="product_group" data-field="x_v_07" data-page="1" name="x_v_07" id="x_v_07" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_07->getPlaceHolder()) ?>" value="<?php echo $product_group->v_07->EditValue ?>"<?php echo $product_group->v_07->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_07_validation->Visible) { // v_07_validation ?>
	<div id="r_v_07_validation" class="form-group row">
		<label for="x_v_07_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_07_validation"><?php echo $product_group->v_07_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_07_validation" id="z_v_07_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_07_validation->cellAttributes() ?>>
			<span id="el_product_group_v_07_validation">
<input type="text" data-table="product_group" data-field="x_v_07_validation" data-page="1" name="x_v_07_validation" id="x_v_07_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_07_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_07_validation->EditValue ?>"<?php echo $product_group->v_07_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_08->Visible) { // v_08 ?>
	<div id="r_v_08" class="form-group row">
		<label for="x_v_08" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_08"><?php echo $product_group->v_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_08" id="z_v_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_08->cellAttributes() ?>>
			<span id="el_product_group_v_08">
<input type="text" data-table="product_group" data-field="x_v_08" data-page="1" name="x_v_08" id="x_v_08" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_08->getPlaceHolder()) ?>" value="<?php echo $product_group->v_08->EditValue ?>"<?php echo $product_group->v_08->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_08_validation->Visible) { // v_08_validation ?>
	<div id="r_v_08_validation" class="form-group row">
		<label for="x_v_08_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_08_validation"><?php echo $product_group->v_08_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_08_validation" id="z_v_08_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_08_validation->cellAttributes() ?>>
			<span id="el_product_group_v_08_validation">
<input type="text" data-table="product_group" data-field="x_v_08_validation" data-page="1" name="x_v_08_validation" id="x_v_08_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_08_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_08_validation->EditValue ?>"<?php echo $product_group->v_08_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_09->Visible) { // v_09 ?>
	<div id="r_v_09" class="form-group row">
		<label for="x_v_09" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_09"><?php echo $product_group->v_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_09" id="z_v_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_09->cellAttributes() ?>>
			<span id="el_product_group_v_09">
<input type="text" data-table="product_group" data-field="x_v_09" data-page="1" name="x_v_09" id="x_v_09" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_09->getPlaceHolder()) ?>" value="<?php echo $product_group->v_09->EditValue ?>"<?php echo $product_group->v_09->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_09_validation->Visible) { // v_09_validation ?>
	<div id="r_v_09_validation" class="form-group row">
		<label for="x_v_09_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_09_validation"><?php echo $product_group->v_09_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_09_validation" id="z_v_09_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_09_validation->cellAttributes() ?>>
			<span id="el_product_group_v_09_validation">
<input type="text" data-table="product_group" data-field="x_v_09_validation" data-page="1" name="x_v_09_validation" id="x_v_09_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_09_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_09_validation->EditValue ?>"<?php echo $product_group->v_09_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_10->Visible) { // v_10 ?>
	<div id="r_v_10" class="form-group row">
		<label for="x_v_10" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_10"><?php echo $product_group->v_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_10" id="z_v_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_10->cellAttributes() ?>>
			<span id="el_product_group_v_10">
<input type="text" data-table="product_group" data-field="x_v_10" data-page="1" name="x_v_10" id="x_v_10" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->v_10->getPlaceHolder()) ?>" value="<?php echo $product_group->v_10->EditValue ?>"<?php echo $product_group->v_10->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->v_10_validation->Visible) { // v_10_validation ?>
	<div id="r_v_10_validation" class="form-group row">
		<label for="x_v_10_validation" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_v_10_validation"><?php echo $product_group->v_10_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_10_validation" id="z_v_10_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->v_10_validation->cellAttributes() ?>>
			<span id="el_product_group_v_10_validation">
<input type="text" data-table="product_group" data-field="x_v_10_validation" data-page="1" name="x_v_10_validation" id="x_v_10_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($product_group->v_10_validation->getPlaceHolder()) ?>" value="<?php echo $product_group->v_10_validation->EditValue ?>"<?php echo $product_group->v_10_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label for="x_q_sku" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_q_sku"><?php echo $product_group->q_sku->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_q_sku" id="z_q_sku" value="="></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->q_sku->cellAttributes() ?>>
			<span id="el_product_group_q_sku">
<input type="text" data-table="product_group" data-field="x_q_sku" data-page="1" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($product_group->q_sku->getPlaceHolder()) ?>" value="<?php echo $product_group->q_sku->EditValue ?>"<?php echo $product_group->q_sku->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("2") ?>" id="tab_product_group2"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->b_01_head->Visible) { // b_01_head ?>
	<div id="r_b_01_head" class="form-group row">
		<label for="x_b_01_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_01_head"><?php echo $product_group->b_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_01_head" id="z_b_01_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_01_head->cellAttributes() ?>>
			<span id="el_product_group_b_01_head">
<input type="text" data-table="product_group" data-field="x_b_01_head" data-page="2" name="x_b_01_head" id="x_b_01_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_01_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_01_head->EditValue ?>"<?php echo $product_group->b_01_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_02_head->Visible) { // b_02_head ?>
	<div id="r_b_02_head" class="form-group row">
		<label for="x_b_02_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_02_head"><?php echo $product_group->b_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_02_head" id="z_b_02_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_02_head->cellAttributes() ?>>
			<span id="el_product_group_b_02_head">
<input type="text" data-table="product_group" data-field="x_b_02_head" data-page="2" name="x_b_02_head" id="x_b_02_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_02_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_02_head->EditValue ?>"<?php echo $product_group->b_02_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_03_head->Visible) { // b_03_head ?>
	<div id="r_b_03_head" class="form-group row">
		<label for="x_b_03_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_03_head"><?php echo $product_group->b_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_03_head" id="z_b_03_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_03_head->cellAttributes() ?>>
			<span id="el_product_group_b_03_head">
<input type="text" data-table="product_group" data-field="x_b_03_head" data-page="2" name="x_b_03_head" id="x_b_03_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_03_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_03_head->EditValue ?>"<?php echo $product_group->b_03_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_04_head->Visible) { // b_04_head ?>
	<div id="r_b_04_head" class="form-group row">
		<label for="x_b_04_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_04_head"><?php echo $product_group->b_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_04_head" id="z_b_04_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_04_head->cellAttributes() ?>>
			<span id="el_product_group_b_04_head">
<input type="text" data-table="product_group" data-field="x_b_04_head" data-page="2" name="x_b_04_head" id="x_b_04_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_04_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_04_head->EditValue ?>"<?php echo $product_group->b_04_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_05_head->Visible) { // b_05_head ?>
	<div id="r_b_05_head" class="form-group row">
		<label for="x_b_05_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_05_head"><?php echo $product_group->b_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_05_head" id="z_b_05_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_05_head->cellAttributes() ?>>
			<span id="el_product_group_b_05_head">
<input type="text" data-table="product_group" data-field="x_b_05_head" data-page="2" name="x_b_05_head" id="x_b_05_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_05_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_05_head->EditValue ?>"<?php echo $product_group->b_05_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_06_head->Visible) { // b_06_head ?>
	<div id="r_b_06_head" class="form-group row">
		<label for="x_b_06_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_06_head"><?php echo $product_group->b_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_06_head" id="z_b_06_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_06_head->cellAttributes() ?>>
			<span id="el_product_group_b_06_head">
<input type="text" data-table="product_group" data-field="x_b_06_head" data-page="2" name="x_b_06_head" id="x_b_06_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_06_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_06_head->EditValue ?>"<?php echo $product_group->b_06_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_07_head->Visible) { // b_07_head ?>
	<div id="r_b_07_head" class="form-group row">
		<label for="x_b_07_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_07_head"><?php echo $product_group->b_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_07_head" id="z_b_07_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_07_head->cellAttributes() ?>>
			<span id="el_product_group_b_07_head">
<input type="text" data-table="product_group" data-field="x_b_07_head" data-page="2" name="x_b_07_head" id="x_b_07_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_07_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_07_head->EditValue ?>"<?php echo $product_group->b_07_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_08_head->Visible) { // b_08_head ?>
	<div id="r_b_08_head" class="form-group row">
		<label for="x_b_08_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_08_head"><?php echo $product_group->b_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_08_head" id="z_b_08_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_08_head->cellAttributes() ?>>
			<span id="el_product_group_b_08_head">
<input type="text" data-table="product_group" data-field="x_b_08_head" data-page="2" name="x_b_08_head" id="x_b_08_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_08_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_08_head->EditValue ?>"<?php echo $product_group->b_08_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_09_head->Visible) { // b_09_head ?>
	<div id="r_b_09_head" class="form-group row">
		<label for="x_b_09_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_09_head"><?php echo $product_group->b_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_09_head" id="z_b_09_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_09_head->cellAttributes() ?>>
			<span id="el_product_group_b_09_head">
<input type="text" data-table="product_group" data-field="x_b_09_head" data-page="2" name="x_b_09_head" id="x_b_09_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_09_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_09_head->EditValue ?>"<?php echo $product_group->b_09_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_10_head->Visible) { // b_10_head ?>
	<div id="r_b_10_head" class="form-group row">
		<label for="x_b_10_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_10_head"><?php echo $product_group->b_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_10_head" id="z_b_10_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_10_head->cellAttributes() ?>>
			<span id="el_product_group_b_10_head">
<input type="text" data-table="product_group" data-field="x_b_10_head" data-page="2" name="x_b_10_head" id="x_b_10_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_10_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_10_head->EditValue ?>"<?php echo $product_group->b_10_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_11_head->Visible) { // b_11_head ?>
	<div id="r_b_11_head" class="form-group row">
		<label for="x_b_11_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_11_head"><?php echo $product_group->b_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_11_head" id="z_b_11_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_11_head->cellAttributes() ?>>
			<span id="el_product_group_b_11_head">
<input type="text" data-table="product_group" data-field="x_b_11_head" data-page="2" name="x_b_11_head" id="x_b_11_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->b_11_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_11_head->EditValue ?>"<?php echo $product_group->b_11_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_12_head->Visible) { // b_12_head ?>
	<div id="r_b_12_head" class="form-group row">
		<label for="x_b_12_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_12_head"><?php echo $product_group->b_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_12_head" id="z_b_12_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_12_head->cellAttributes() ?>>
			<span id="el_product_group_b_12_head">
<input type="text" data-table="product_group" data-field="x_b_12_head" data-page="2" name="x_b_12_head" id="x_b_12_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->b_12_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_12_head->EditValue ?>"<?php echo $product_group->b_12_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_13_head->Visible) { // b_13_head ?>
	<div id="r_b_13_head" class="form-group row">
		<label for="x_b_13_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_13_head"><?php echo $product_group->b_13_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_13_head" id="z_b_13_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_13_head->cellAttributes() ?>>
			<span id="el_product_group_b_13_head">
<input type="text" data-table="product_group" data-field="x_b_13_head" data-page="2" name="x_b_13_head" id="x_b_13_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->b_13_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_13_head->EditValue ?>"<?php echo $product_group->b_13_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_14_head->Visible) { // b_14_head ?>
	<div id="r_b_14_head" class="form-group row">
		<label for="x_b_14_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_14_head"><?php echo $product_group->b_14_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_14_head" id="z_b_14_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_14_head->cellAttributes() ?>>
			<span id="el_product_group_b_14_head">
<input type="text" data-table="product_group" data-field="x_b_14_head" data-page="2" name="x_b_14_head" id="x_b_14_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->b_14_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_14_head->EditValue ?>"<?php echo $product_group->b_14_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->b_15_head->Visible) { // b_15_head ?>
	<div id="r_b_15_head" class="form-group row">
		<label for="x_b_15_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_b_15_head"><?php echo $product_group->b_15_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_15_head" id="z_b_15_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->b_15_head->cellAttributes() ?>>
			<span id="el_product_group_b_15_head">
<input type="text" data-table="product_group" data-field="x_b_15_head" data-page="2" name="x_b_15_head" id="x_b_15_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->b_15_head->getPlaceHolder()) ?>" value="<?php echo $product_group->b_15_head->EditValue ?>"<?php echo $product_group->b_15_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("3") ?>" id="tab_product_group3"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->t_01_head->Visible) { // t_01_head ?>
	<div id="r_t_01_head" class="form-group row">
		<label for="x_t_01_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_01_head"><?php echo $product_group->t_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_01_head" id="z_t_01_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_01_head->cellAttributes() ?>>
			<span id="el_product_group_t_01_head">
<input type="text" data-table="product_group" data-field="x_t_01_head" data-page="3" name="x_t_01_head" id="x_t_01_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_01_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_01_head->EditValue ?>"<?php echo $product_group->t_01_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_02_head->Visible) { // t_02_head ?>
	<div id="r_t_02_head" class="form-group row">
		<label for="x_t_02_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_02_head"><?php echo $product_group->t_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_02_head" id="z_t_02_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_02_head->cellAttributes() ?>>
			<span id="el_product_group_t_02_head">
<input type="text" data-table="product_group" data-field="x_t_02_head" data-page="3" name="x_t_02_head" id="x_t_02_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_02_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_02_head->EditValue ?>"<?php echo $product_group->t_02_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_03_head->Visible) { // t_03_head ?>
	<div id="r_t_03_head" class="form-group row">
		<label for="x_t_03_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_03_head"><?php echo $product_group->t_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_03_head" id="z_t_03_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_03_head->cellAttributes() ?>>
			<span id="el_product_group_t_03_head">
<input type="text" data-table="product_group" data-field="x_t_03_head" data-page="3" name="x_t_03_head" id="x_t_03_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_03_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_03_head->EditValue ?>"<?php echo $product_group->t_03_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_04_head->Visible) { // t_04_head ?>
	<div id="r_t_04_head" class="form-group row">
		<label for="x_t_04_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_04_head"><?php echo $product_group->t_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_04_head" id="z_t_04_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_04_head->cellAttributes() ?>>
			<span id="el_product_group_t_04_head">
<input type="text" data-table="product_group" data-field="x_t_04_head" data-page="3" name="x_t_04_head" id="x_t_04_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_04_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_04_head->EditValue ?>"<?php echo $product_group->t_04_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_05_head->Visible) { // t_05_head ?>
	<div id="r_t_05_head" class="form-group row">
		<label for="x_t_05_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_05_head"><?php echo $product_group->t_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_05_head" id="z_t_05_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_05_head->cellAttributes() ?>>
			<span id="el_product_group_t_05_head">
<input type="text" data-table="product_group" data-field="x_t_05_head" data-page="3" name="x_t_05_head" id="x_t_05_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_05_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_05_head->EditValue ?>"<?php echo $product_group->t_05_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_06_head->Visible) { // t_06_head ?>
	<div id="r_t_06_head" class="form-group row">
		<label for="x_t_06_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_06_head"><?php echo $product_group->t_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_06_head" id="z_t_06_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_06_head->cellAttributes() ?>>
			<span id="el_product_group_t_06_head">
<input type="text" data-table="product_group" data-field="x_t_06_head" data-page="3" name="x_t_06_head" id="x_t_06_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_06_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_06_head->EditValue ?>"<?php echo $product_group->t_06_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_07_head->Visible) { // t_07_head ?>
	<div id="r_t_07_head" class="form-group row">
		<label for="x_t_07_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_07_head"><?php echo $product_group->t_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_07_head" id="z_t_07_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_07_head->cellAttributes() ?>>
			<span id="el_product_group_t_07_head">
<input type="text" data-table="product_group" data-field="x_t_07_head" data-page="3" name="x_t_07_head" id="x_t_07_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_07_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_07_head->EditValue ?>"<?php echo $product_group->t_07_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_08_head->Visible) { // t_08_head ?>
	<div id="r_t_08_head" class="form-group row">
		<label for="x_t_08_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_08_head"><?php echo $product_group->t_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_08_head" id="z_t_08_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_08_head->cellAttributes() ?>>
			<span id="el_product_group_t_08_head">
<input type="text" data-table="product_group" data-field="x_t_08_head" data-page="3" name="x_t_08_head" id="x_t_08_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_08_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_08_head->EditValue ?>"<?php echo $product_group->t_08_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_09_head->Visible) { // t_09_head ?>
	<div id="r_t_09_head" class="form-group row">
		<label for="x_t_09_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_09_head"><?php echo $product_group->t_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_09_head" id="z_t_09_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_09_head->cellAttributes() ?>>
			<span id="el_product_group_t_09_head">
<input type="text" data-table="product_group" data-field="x_t_09_head" data-page="3" name="x_t_09_head" id="x_t_09_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_09_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_09_head->EditValue ?>"<?php echo $product_group->t_09_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_10_head->Visible) { // t_10_head ?>
	<div id="r_t_10_head" class="form-group row">
		<label for="x_t_10_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_10_head"><?php echo $product_group->t_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_10_head" id="z_t_10_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_10_head->cellAttributes() ?>>
			<span id="el_product_group_t_10_head">
<input type="text" data-table="product_group" data-field="x_t_10_head" data-page="3" name="x_t_10_head" id="x_t_10_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_10_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_10_head->EditValue ?>"<?php echo $product_group->t_10_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_11_head->Visible) { // t_11_head ?>
	<div id="r_t_11_head" class="form-group row">
		<label for="x_t_11_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_11_head"><?php echo $product_group->t_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_11_head" id="z_t_11_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_11_head->cellAttributes() ?>>
			<span id="el_product_group_t_11_head">
<input type="text" data-table="product_group" data-field="x_t_11_head" data-page="3" name="x_t_11_head" id="x_t_11_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_11_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_11_head->EditValue ?>"<?php echo $product_group->t_11_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_12_head->Visible) { // t_12_head ?>
	<div id="r_t_12_head" class="form-group row">
		<label for="x_t_12_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_12_head"><?php echo $product_group->t_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_12_head" id="z_t_12_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_12_head->cellAttributes() ?>>
			<span id="el_product_group_t_12_head">
<input type="text" data-table="product_group" data-field="x_t_12_head" data-page="3" name="x_t_12_head" id="x_t_12_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_12_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_12_head->EditValue ?>"<?php echo $product_group->t_12_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_13_head->Visible) { // t_13_head ?>
	<div id="r_t_13_head" class="form-group row">
		<label for="x_t_13_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_13_head"><?php echo $product_group->t_13_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_13_head" id="z_t_13_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_13_head->cellAttributes() ?>>
			<span id="el_product_group_t_13_head">
<input type="text" data-table="product_group" data-field="x_t_13_head" data-page="3" name="x_t_13_head" id="x_t_13_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_13_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_13_head->EditValue ?>"<?php echo $product_group->t_13_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_14_head->Visible) { // t_14_head ?>
	<div id="r_t_14_head" class="form-group row">
		<label for="x_t_14_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_14_head"><?php echo $product_group->t_14_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_14_head" id="z_t_14_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_14_head->cellAttributes() ?>>
			<span id="el_product_group_t_14_head">
<input type="text" data-table="product_group" data-field="x_t_14_head" data-page="3" name="x_t_14_head" id="x_t_14_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_14_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_14_head->EditValue ?>"<?php echo $product_group->t_14_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->t_15_head->Visible) { // t_15_head ?>
	<div id="r_t_15_head" class="form-group row">
		<label for="x_t_15_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_t_15_head"><?php echo $product_group->t_15_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_15_head" id="z_t_15_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->t_15_head->cellAttributes() ?>>
			<span id="el_product_group_t_15_head">
<input type="text" data-table="product_group" data-field="x_t_15_head" data-page="3" name="x_t_15_head" id="x_t_15_head" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_group->t_15_head->getPlaceHolder()) ?>" value="<?php echo $product_group->t_15_head->EditValue ?>"<?php echo $product_group->t_15_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("4") ?>" id="tab_product_group4"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->po_01_head->Visible) { // po_01_head ?>
	<div id="r_po_01_head" class="form-group row">
		<label for="x_po_01_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_01_head"><?php echo $product_group->po_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_01_head" id="z_po_01_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_01_head->cellAttributes() ?>>
			<span id="el_product_group_po_01_head">
<input type="text" data-table="product_group" data-field="x_po_01_head" data-page="4" name="x_po_01_head" id="x_po_01_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_01_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_01_head->EditValue ?>"<?php echo $product_group->po_01_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_02_head->Visible) { // po_02_head ?>
	<div id="r_po_02_head" class="form-group row">
		<label for="x_po_02_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_02_head"><?php echo $product_group->po_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_02_head" id="z_po_02_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_02_head->cellAttributes() ?>>
			<span id="el_product_group_po_02_head">
<input type="text" data-table="product_group" data-field="x_po_02_head" data-page="4" name="x_po_02_head" id="x_po_02_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_02_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_02_head->EditValue ?>"<?php echo $product_group->po_02_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_03_head->Visible) { // po_03_head ?>
	<div id="r_po_03_head" class="form-group row">
		<label for="x_po_03_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_03_head"><?php echo $product_group->po_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_03_head" id="z_po_03_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_03_head->cellAttributes() ?>>
			<span id="el_product_group_po_03_head">
<input type="text" data-table="product_group" data-field="x_po_03_head" data-page="4" name="x_po_03_head" id="x_po_03_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_03_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_03_head->EditValue ?>"<?php echo $product_group->po_03_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_04_head->Visible) { // po_04_head ?>
	<div id="r_po_04_head" class="form-group row">
		<label for="x_po_04_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_04_head"><?php echo $product_group->po_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_04_head" id="z_po_04_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_04_head->cellAttributes() ?>>
			<span id="el_product_group_po_04_head">
<input type="text" data-table="product_group" data-field="x_po_04_head" data-page="4" name="x_po_04_head" id="x_po_04_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_04_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_04_head->EditValue ?>"<?php echo $product_group->po_04_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_05_head->Visible) { // po_05_head ?>
	<div id="r_po_05_head" class="form-group row">
		<label for="x_po_05_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_05_head"><?php echo $product_group->po_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_05_head" id="z_po_05_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_05_head->cellAttributes() ?>>
			<span id="el_product_group_po_05_head">
<input type="text" data-table="product_group" data-field="x_po_05_head" data-page="4" name="x_po_05_head" id="x_po_05_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_05_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_05_head->EditValue ?>"<?php echo $product_group->po_05_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_06_head->Visible) { // po_06_head ?>
	<div id="r_po_06_head" class="form-group row">
		<label for="x_po_06_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_06_head"><?php echo $product_group->po_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_06_head" id="z_po_06_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_06_head->cellAttributes() ?>>
			<span id="el_product_group_po_06_head">
<input type="text" data-table="product_group" data-field="x_po_06_head" data-page="4" name="x_po_06_head" id="x_po_06_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_06_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_06_head->EditValue ?>"<?php echo $product_group->po_06_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_07_head->Visible) { // po_07_head ?>
	<div id="r_po_07_head" class="form-group row">
		<label for="x_po_07_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_07_head"><?php echo $product_group->po_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_07_head" id="z_po_07_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_07_head->cellAttributes() ?>>
			<span id="el_product_group_po_07_head">
<input type="text" data-table="product_group" data-field="x_po_07_head" data-page="4" name="x_po_07_head" id="x_po_07_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_07_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_07_head->EditValue ?>"<?php echo $product_group->po_07_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_08_head->Visible) { // po_08_head ?>
	<div id="r_po_08_head" class="form-group row">
		<label for="x_po_08_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_08_head"><?php echo $product_group->po_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_08_head" id="z_po_08_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_08_head->cellAttributes() ?>>
			<span id="el_product_group_po_08_head">
<input type="text" data-table="product_group" data-field="x_po_08_head" data-page="4" name="x_po_08_head" id="x_po_08_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_08_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_08_head->EditValue ?>"<?php echo $product_group->po_08_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_17_head->Visible) { // po_17_head ?>
	<div id="r_po_17_head" class="form-group row">
		<label for="x_po_17_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_17_head"><?php echo $product_group->po_17_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_17_head" id="z_po_17_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_17_head->cellAttributes() ?>>
			<span id="el_product_group_po_17_head">
<input type="text" data-table="product_group" data-field="x_po_17_head" data-page="4" name="x_po_17_head" id="x_po_17_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_17_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_17_head->EditValue ?>"<?php echo $product_group->po_17_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_18_head->Visible) { // po_18_head ?>
	<div id="r_po_18_head" class="form-group row">
		<label for="x_po_18_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_18_head"><?php echo $product_group->po_18_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_18_head" id="z_po_18_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_18_head->cellAttributes() ?>>
			<span id="el_product_group_po_18_head">
<input type="text" data-table="product_group" data-field="x_po_18_head" data-page="4" name="x_po_18_head" id="x_po_18_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_18_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_18_head->EditValue ?>"<?php echo $product_group->po_18_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_19_head->Visible) { // po_19_head ?>
	<div id="r_po_19_head" class="form-group row">
		<label for="x_po_19_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_19_head"><?php echo $product_group->po_19_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_19_head" id="z_po_19_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_19_head->cellAttributes() ?>>
			<span id="el_product_group_po_19_head">
<input type="text" data-table="product_group" data-field="x_po_19_head" data-page="4" name="x_po_19_head" id="x_po_19_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_19_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_19_head->EditValue ?>"<?php echo $product_group->po_19_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->po_20_head->Visible) { // po_20_head ?>
	<div id="r_po_20_head" class="form-group row">
		<label for="x_po_20_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_po_20_head"><?php echo $product_group->po_20_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_20_head" id="z_po_20_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->po_20_head->cellAttributes() ?>>
			<span id="el_product_group_po_20_head">
<input type="text" data-table="product_group" data-field="x_po_20_head" data-page="4" name="x_po_20_head" id="x_po_20_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->po_20_head->getPlaceHolder()) ?>" value="<?php echo $product_group->po_20_head->EditValue ?>"<?php echo $product_group->po_20_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("5") ?>" id="tab_product_group5"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->jc_01_head->Visible) { // jc_01_head ?>
	<div id="r_jc_01_head" class="form-group row">
		<label for="x_jc_01_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_01_head"><?php echo $product_group->jc_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_01_head" id="z_jc_01_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_01_head->cellAttributes() ?>>
			<span id="el_product_group_jc_01_head">
<input type="text" data-table="product_group" data-field="x_jc_01_head" data-page="5" name="x_jc_01_head" id="x_jc_01_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_01_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_01_head->EditValue ?>"<?php echo $product_group->jc_01_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_02_head->Visible) { // jc_02_head ?>
	<div id="r_jc_02_head" class="form-group row">
		<label for="x_jc_02_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_02_head"><?php echo $product_group->jc_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_02_head" id="z_jc_02_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_02_head->cellAttributes() ?>>
			<span id="el_product_group_jc_02_head">
<input type="text" data-table="product_group" data-field="x_jc_02_head" data-page="5" name="x_jc_02_head" id="x_jc_02_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_02_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_02_head->EditValue ?>"<?php echo $product_group->jc_02_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_03_head->Visible) { // jc_03_head ?>
	<div id="r_jc_03_head" class="form-group row">
		<label for="x_jc_03_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_03_head"><?php echo $product_group->jc_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_03_head" id="z_jc_03_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_03_head->cellAttributes() ?>>
			<span id="el_product_group_jc_03_head">
<input type="text" data-table="product_group" data-field="x_jc_03_head" data-page="5" name="x_jc_03_head" id="x_jc_03_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_03_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_03_head->EditValue ?>"<?php echo $product_group->jc_03_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_04_head->Visible) { // jc_04_head ?>
	<div id="r_jc_04_head" class="form-group row">
		<label for="x_jc_04_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_04_head"><?php echo $product_group->jc_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_04_head" id="z_jc_04_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_04_head->cellAttributes() ?>>
			<span id="el_product_group_jc_04_head">
<input type="text" data-table="product_group" data-field="x_jc_04_head" data-page="5" name="x_jc_04_head" id="x_jc_04_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_04_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_04_head->EditValue ?>"<?php echo $product_group->jc_04_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_05_head->Visible) { // jc_05_head ?>
	<div id="r_jc_05_head" class="form-group row">
		<label for="x_jc_05_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_05_head"><?php echo $product_group->jc_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_05_head" id="z_jc_05_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_05_head->cellAttributes() ?>>
			<span id="el_product_group_jc_05_head">
<input type="text" data-table="product_group" data-field="x_jc_05_head" data-page="5" name="x_jc_05_head" id="x_jc_05_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_05_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_05_head->EditValue ?>"<?php echo $product_group->jc_05_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_06_head->Visible) { // jc_06_head ?>
	<div id="r_jc_06_head" class="form-group row">
		<label for="x_jc_06_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_06_head"><?php echo $product_group->jc_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_06_head" id="z_jc_06_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_06_head->cellAttributes() ?>>
			<span id="el_product_group_jc_06_head">
<input type="text" data-table="product_group" data-field="x_jc_06_head" data-page="5" name="x_jc_06_head" id="x_jc_06_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_06_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_06_head->EditValue ?>"<?php echo $product_group->jc_06_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_07_head->Visible) { // jc_07_head ?>
	<div id="r_jc_07_head" class="form-group row">
		<label for="x_jc_07_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_07_head"><?php echo $product_group->jc_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_07_head" id="z_jc_07_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_07_head->cellAttributes() ?>>
			<span id="el_product_group_jc_07_head">
<input type="text" data-table="product_group" data-field="x_jc_07_head" data-page="5" name="x_jc_07_head" id="x_jc_07_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_07_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_07_head->EditValue ?>"<?php echo $product_group->jc_07_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_08_head->Visible) { // jc_08_head ?>
	<div id="r_jc_08_head" class="form-group row">
		<label for="x_jc_08_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_08_head"><?php echo $product_group->jc_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_08_head" id="z_jc_08_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_08_head->cellAttributes() ?>>
			<span id="el_product_group_jc_08_head">
<input type="text" data-table="product_group" data-field="x_jc_08_head" data-page="5" name="x_jc_08_head" id="x_jc_08_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_08_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_08_head->EditValue ?>"<?php echo $product_group->jc_08_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_09_head->Visible) { // jc_09_head ?>
	<div id="r_jc_09_head" class="form-group row">
		<label for="x_jc_09_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_09_head"><?php echo $product_group->jc_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_09_head" id="z_jc_09_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_09_head->cellAttributes() ?>>
			<span id="el_product_group_jc_09_head">
<input type="text" data-table="product_group" data-field="x_jc_09_head" data-page="5" name="x_jc_09_head" id="x_jc_09_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_09_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_09_head->EditValue ?>"<?php echo $product_group->jc_09_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->jc_10_head->Visible) { // jc_10_head ?>
	<div id="r_jc_10_head" class="form-group row">
		<label for="x_jc_10_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_jc_10_head"><?php echo $product_group->jc_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jc_10_head" id="z_jc_10_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->jc_10_head->cellAttributes() ?>>
			<span id="el_product_group_jc_10_head">
<input type="text" data-table="product_group" data-field="x_jc_10_head" data-page="5" name="x_jc_10_head" id="x_jc_10_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->jc_10_head->getPlaceHolder()) ?>" value="<?php echo $product_group->jc_10_head->EditValue ?>"<?php echo $product_group->jc_10_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $product_group_search->MultiPages->pageStyle("6") ?>" id="tab_product_group6"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($product_group->pc_shape->Visible) { // pc_shape ?>
	<div id="r_pc_shape" class="form-group row">
		<label for="x_pc_shape" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_shape"><?php echo $product_group->pc_shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_shape" id="z_pc_shape" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_shape->cellAttributes() ?>>
			<span id="el_product_group_pc_shape">
<input type="text" data-table="product_group" data-field="x_pc_shape" data-page="6" name="x_pc_shape" id="x_pc_shape" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_shape->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_shape->EditValue ?>"<?php echo $product_group->pc_shape->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_unit->Visible) { // pc_unit ?>
	<div id="r_pc_unit" class="form-group row">
		<label for="x_pc_unit" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_unit"><?php echo $product_group->pc_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_unit" id="z_pc_unit" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_unit->cellAttributes() ?>>
			<span id="el_product_group_pc_unit">
<input type="text" data-table="product_group" data-field="x_pc_unit" data-page="6" name="x_pc_unit" id="x_pc_unit" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_unit->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_unit->EditValue ?>"<?php echo $product_group->pc_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_w->Visible) { // pc_w ?>
	<div id="r_pc_w" class="form-group row">
		<label for="x_pc_w" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_w"><?php echo $product_group->pc_w->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_w" id="z_pc_w" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_w->cellAttributes() ?>>
			<span id="el_product_group_pc_w">
<input type="text" data-table="product_group" data-field="x_pc_w" data-page="6" name="x_pc_w" id="x_pc_w" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_w->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_w->EditValue ?>"<?php echo $product_group->pc_w->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_l->Visible) { // pc_l ?>
	<div id="r_pc_l" class="form-group row">
		<label for="x_pc_l" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_l"><?php echo $product_group->pc_l->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_l" id="z_pc_l" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_l->cellAttributes() ?>>
			<span id="el_product_group_pc_l">
<input type="text" data-table="product_group" data-field="x_pc_l" data-page="6" name="x_pc_l" id="x_pc_l" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_l->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_l->EditValue ?>"<?php echo $product_group->pc_l->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_h->Visible) { // pc_h ?>
	<div id="r_pc_h" class="form-group row">
		<label for="x_pc_h" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_h"><?php echo $product_group->pc_h->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_h" id="z_pc_h" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_h->cellAttributes() ?>>
			<span id="el_product_group_pc_h">
<input type="text" data-table="product_group" data-field="x_pc_h" data-page="6" name="x_pc_h" id="x_pc_h" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_h->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_h->EditValue ?>"<?php echo $product_group->pc_h->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_partner_size->Visible) { // pc_partner_size ?>
	<div id="r_pc_partner_size" class="form-group row">
		<label for="x_pc_partner_size" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_partner_size"><?php echo $product_group->pc_partner_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_partner_size" id="z_pc_partner_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_partner_size->cellAttributes() ?>>
			<span id="el_product_group_pc_partner_size">
<input type="text" data-table="product_group" data-field="x_pc_partner_size" data-page="6" name="x_pc_partner_size" id="x_pc_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_partner_size->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_partner_size->EditValue ?>"<?php echo $product_group->pc_partner_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_sqm->Visible) { // pc_sqm ?>
	<div id="r_pc_sqm" class="form-group row">
		<label for="x_pc_sqm" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_sqm"><?php echo $product_group->pc_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_sqm" id="z_pc_sqm" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_sqm->cellAttributes() ?>>
			<span id="el_product_group_pc_sqm">
<input type="text" data-table="product_group" data-field="x_pc_sqm" data-page="6" name="x_pc_sqm" id="x_pc_sqm" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_sqm->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_sqm->EditValue ?>"<?php echo $product_group->pc_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_01_head->Visible) { // pc_01_head ?>
	<div id="r_pc_01_head" class="form-group row">
		<label for="x_pc_01_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_01_head"><?php echo $product_group->pc_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_01_head" id="z_pc_01_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_01_head->cellAttributes() ?>>
			<span id="el_product_group_pc_01_head">
<input type="text" data-table="product_group" data-field="x_pc_01_head" data-page="6" name="x_pc_01_head" id="x_pc_01_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_01_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_01_head->EditValue ?>"<?php echo $product_group->pc_01_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_02_head->Visible) { // pc_02_head ?>
	<div id="r_pc_02_head" class="form-group row">
		<label for="x_pc_02_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_02_head"><?php echo $product_group->pc_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_02_head" id="z_pc_02_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_02_head->cellAttributes() ?>>
			<span id="el_product_group_pc_02_head">
<input type="text" data-table="product_group" data-field="x_pc_02_head" data-page="6" name="x_pc_02_head" id="x_pc_02_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_02_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_02_head->EditValue ?>"<?php echo $product_group->pc_02_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_03_head->Visible) { // pc_03_head ?>
	<div id="r_pc_03_head" class="form-group row">
		<label for="x_pc_03_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_03_head"><?php echo $product_group->pc_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_03_head" id="z_pc_03_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_03_head->cellAttributes() ?>>
			<span id="el_product_group_pc_03_head">
<input type="text" data-table="product_group" data-field="x_pc_03_head" data-page="6" name="x_pc_03_head" id="x_pc_03_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_03_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_03_head->EditValue ?>"<?php echo $product_group->pc_03_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_04_head->Visible) { // pc_04_head ?>
	<div id="r_pc_04_head" class="form-group row">
		<label for="x_pc_04_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_04_head"><?php echo $product_group->pc_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_04_head" id="z_pc_04_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_04_head->cellAttributes() ?>>
			<span id="el_product_group_pc_04_head">
<input type="text" data-table="product_group" data-field="x_pc_04_head" data-page="6" name="x_pc_04_head" id="x_pc_04_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_04_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_04_head->EditValue ?>"<?php echo $product_group->pc_04_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_05_head->Visible) { // pc_05_head ?>
	<div id="r_pc_05_head" class="form-group row">
		<label for="x_pc_05_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_05_head"><?php echo $product_group->pc_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_05_head" id="z_pc_05_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_05_head->cellAttributes() ?>>
			<span id="el_product_group_pc_05_head">
<input type="text" data-table="product_group" data-field="x_pc_05_head" data-page="6" name="x_pc_05_head" id="x_pc_05_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_05_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_05_head->EditValue ?>"<?php echo $product_group->pc_05_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_06_head->Visible) { // pc_06_head ?>
	<div id="r_pc_06_head" class="form-group row">
		<label for="x_pc_06_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_06_head"><?php echo $product_group->pc_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_06_head" id="z_pc_06_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_06_head->cellAttributes() ?>>
			<span id="el_product_group_pc_06_head">
<input type="text" data-table="product_group" data-field="x_pc_06_head" data-page="6" name="x_pc_06_head" id="x_pc_06_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_06_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_06_head->EditValue ?>"<?php echo $product_group->pc_06_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_07_head->Visible) { // pc_07_head ?>
	<div id="r_pc_07_head" class="form-group row">
		<label for="x_pc_07_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_07_head"><?php echo $product_group->pc_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_07_head" id="z_pc_07_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_07_head->cellAttributes() ?>>
			<span id="el_product_group_pc_07_head">
<input type="text" data-table="product_group" data-field="x_pc_07_head" data-page="6" name="x_pc_07_head" id="x_pc_07_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_07_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_07_head->EditValue ?>"<?php echo $product_group->pc_07_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_08_head->Visible) { // pc_08_head ?>
	<div id="r_pc_08_head" class="form-group row">
		<label for="x_pc_08_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_08_head"><?php echo $product_group->pc_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_08_head" id="z_pc_08_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_08_head->cellAttributes() ?>>
			<span id="el_product_group_pc_08_head">
<input type="text" data-table="product_group" data-field="x_pc_08_head" data-page="6" name="x_pc_08_head" id="x_pc_08_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_08_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_08_head->EditValue ?>"<?php echo $product_group->pc_08_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_09_head->Visible) { // pc_09_head ?>
	<div id="r_pc_09_head" class="form-group row">
		<label for="x_pc_09_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_09_head"><?php echo $product_group->pc_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_09_head" id="z_pc_09_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_09_head->cellAttributes() ?>>
			<span id="el_product_group_pc_09_head">
<input type="text" data-table="product_group" data-field="x_pc_09_head" data-page="6" name="x_pc_09_head" id="x_pc_09_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_09_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_09_head->EditValue ?>"<?php echo $product_group->pc_09_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_10_head->Visible) { // pc_10_head ?>
	<div id="r_pc_10_head" class="form-group row">
		<label for="x_pc_10_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_10_head"><?php echo $product_group->pc_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_10_head" id="z_pc_10_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_10_head->cellAttributes() ?>>
			<span id="el_product_group_pc_10_head">
<input type="text" data-table="product_group" data-field="x_pc_10_head" data-page="6" name="x_pc_10_head" id="x_pc_10_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_10_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_10_head->EditValue ?>"<?php echo $product_group->pc_10_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_11_head->Visible) { // pc_11_head ?>
	<div id="r_pc_11_head" class="form-group row">
		<label for="x_pc_11_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_11_head"><?php echo $product_group->pc_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_11_head" id="z_pc_11_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_11_head->cellAttributes() ?>>
			<span id="el_product_group_pc_11_head">
<input type="text" data-table="product_group" data-field="x_pc_11_head" data-page="6" name="x_pc_11_head" id="x_pc_11_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_11_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_11_head->EditValue ?>"<?php echo $product_group->pc_11_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_group->pc_12_head->Visible) { // pc_12_head ?>
	<div id="r_pc_12_head" class="form-group row">
		<label for="x_pc_12_head" class="<?php echo $product_group_search->LeftColumnClass ?>"><span id="elh_product_group_pc_12_head"><?php echo $product_group->pc_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pc_12_head" id="z_pc_12_head" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_group_search->RightColumnClass ?>"><div<?php echo $product_group->pc_12_head->cellAttributes() ?>>
			<span id="el_product_group_pc_12_head">
<input type="text" data-table="product_group" data-field="x_pc_12_head" data-page="6" name="x_pc_12_head" id="x_pc_12_head" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_group->pc_12_head->getPlaceHolder()) ?>" value="<?php echo $product_group->pc_12_head->EditValue ?>"<?php echo $product_group->pc_12_head->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$product_group_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_group_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_group_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_group_search->terminate();
?>