<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_group_view = new product_group_view();

// Run the page
$product_group_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_group_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_group->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduct_groupview = currentForm = new ew.Form("fproduct_groupview", "view");

// Form_CustomValidate event
fproduct_groupview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_groupview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fproduct_groupview.multiPage = new ew.MultiPage("fproduct_groupview");

// Dynamic selection lists
fproduct_groupview.lists["x_grp"] = <?php echo $product_group_view->grp->Lookup->toClientList() ?>;
fproduct_groupview.lists["x_grp"].options = <?php echo JsonEncode($product_group_view->grp->lookupOptions()) ?>;
fproduct_groupview.lists["x_calculation_method"] = <?php echo $product_group_view->calculation_method->Lookup->toClientList() ?>;
fproduct_groupview.lists["x_calculation_method"].options = <?php echo JsonEncode($product_group_view->calculation_method->lookupOptions()) ?>;
fproduct_groupview.lists["x_process"] = <?php echo $product_group_view->process->Lookup->toClientList() ?>;
fproduct_groupview.lists["x_process"].options = <?php echo JsonEncode($product_group_view->process->lookupOptions()) ?>;
fproduct_groupview.lists["x_status"] = <?php echo $product_group_view->status->Lookup->toClientList() ?>;
fproduct_groupview.lists["x_status"].options = <?php echo JsonEncode($product_group_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $product_group_view->ExportOptions->render("body") ?>
<?php $product_group_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $product_group_view->showPageHeader(); ?>
<?php
$product_group_view->showMessage();
?>
<form name="fproduct_groupview" id="fproduct_groupview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_group_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_group_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_group">
<input type="hidden" name="modal" value="<?php echo (int)$product_group_view->IsModal ?>">
<?php if ($product_group_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_grp"><?php echo $product_group->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $product_group->grp->cellAttributes() ?>>
<span id="el_product_group_grp" data-page="0">
<span<?php echo $product_group->grp->viewAttributes() ?>>
<?php echo $product_group->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->product_group->Visible) { // product_group ?>
	<tr id="r_product_group">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_product_group"><?php echo $product_group->product_group->caption() ?></span></td>
		<td data-name="product_group"<?php echo $product_group->product_group->cellAttributes() ?>>
<span id="el_product_group_product_group" data-page="0">
<span<?php echo $product_group->product_group->viewAttributes() ?>>
<?php echo $product_group->product_group->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->calculation_method->Visible) { // calculation_method ?>
	<tr id="r_calculation_method">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_calculation_method"><?php echo $product_group->calculation_method->caption() ?></span></td>
		<td data-name="calculation_method"<?php echo $product_group->calculation_method->cellAttributes() ?>>
<span id="el_product_group_calculation_method" data-page="0">
<span<?php echo $product_group->calculation_method->viewAttributes() ?>>
<?php echo $product_group->calculation_method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_shape"><?php echo $product_group->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $product_group->shape->cellAttributes() ?>>
<span id="el_product_group_shape" data-page="0">
<span<?php echo $product_group->shape->viewAttributes() ?>>
<?php echo $product_group->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_sqm"><?php echo $product_group->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $product_group->sqm->cellAttributes() ?>>
<span id="el_product_group_sqm" data-page="0">
<span<?php echo $product_group->sqm->viewAttributes() ?>>
<?php echo $product_group->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_cbm"><?php echo $product_group->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $product_group->cbm->cellAttributes() ?>>
<span id="el_product_group_cbm" data-page="0">
<span<?php echo $product_group->cbm->viewAttributes() ?>>
<?php echo $product_group->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_process"><?php echo $product_group->process->caption() ?></span></td>
		<td data-name="process"<?php echo $product_group->process->cellAttributes() ?>>
<span id="el_product_group_process" data-page="0">
<span<?php echo $product_group->process->viewAttributes() ?>>
<?php echo $product_group->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_status"><?php echo $product_group->status->caption() ?></span></td>
		<td data-name="status"<?php echo $product_group->status->cellAttributes() ?>>
<span id="el_product_group_status" data-page="0">
<span<?php echo $product_group->status->viewAttributes() ?>>
<?php echo $product_group->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_operator"><?php echo $product_group->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $product_group->operator->cellAttributes() ?>>
<span id="el_product_group_operator" data-page="0">
<span<?php echo $product_group->operator->viewAttributes() ?>>
<?php echo $product_group->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_datetime"><?php echo $product_group->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $product_group->datetime->cellAttributes() ?>>
<span id="el_product_group_datetime" data-page="0">
<span<?php echo $product_group->datetime->viewAttributes() ?>>
<?php echo $product_group->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_image"><?php echo $product_group->image->caption() ?></span></td>
		<td data-name="image"<?php echo $product_group->image->cellAttributes() ?>>
<span id="el_product_group_image" data-page="0">
<span>
<?php echo GetFileViewTag($product_group->image, $product_group->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
<div class="ew-multi-page">
<div class="ew-nav-tabs" id="product_group_view"><!-- multi-page tabs -->
	<ul class="<?php echo $product_group_view->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("1") ?>" href="#tab_product_group1" data-toggle="tab"><?php echo $product_group->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("2") ?>" href="#tab_product_group2" data-toggle="tab"><?php echo $product_group->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("3") ?>" href="#tab_product_group3" data-toggle="tab"><?php echo $product_group->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("4") ?>" href="#tab_product_group4" data-toggle="tab"><?php echo $product_group->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("5") ?>" href="#tab_product_group5" data-toggle="tab"><?php echo $product_group->pageCaption(5) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $product_group_view->MultiPages->pageStyle("6") ?>" href="#tab_product_group6" data-toggle="tab"><?php echo $product_group->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content">
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("1") ?>" id="tab_product_group1"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_id"><?php echo $product_group->id->caption() ?></span></td>
		<td data-name="id"<?php echo $product_group->id->cellAttributes() ?>>
<span id="el_product_group_id" data-page="1">
<span<?php echo $product_group->id->viewAttributes() ?>>
<?php echo $product_group->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_00->Visible) { // v_00 ?>
	<tr id="r_v_00">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_00"><?php echo $product_group->v_00->caption() ?></span></td>
		<td data-name="v_00"<?php echo $product_group->v_00->cellAttributes() ?>>
<span id="el_product_group_v_00" data-page="1">
<span<?php echo $product_group->v_00->viewAttributes() ?>>
<?php echo $product_group->v_00->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_01->Visible) { // v_01 ?>
	<tr id="r_v_01">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_01"><?php echo $product_group->v_01->caption() ?></span></td>
		<td data-name="v_01"<?php echo $product_group->v_01->cellAttributes() ?>>
<span id="el_product_group_v_01" data-page="1">
<span<?php echo $product_group->v_01->viewAttributes() ?>>
<?php echo $product_group->v_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_01_validation->Visible) { // v_01_validation ?>
	<tr id="r_v_01_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_01_validation"><?php echo $product_group->v_01_validation->caption() ?></span></td>
		<td data-name="v_01_validation"<?php echo $product_group->v_01_validation->cellAttributes() ?>>
<span id="el_product_group_v_01_validation" data-page="1">
<span<?php echo $product_group->v_01_validation->viewAttributes() ?>>
<?php echo $product_group->v_01_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_02->Visible) { // v_02 ?>
	<tr id="r_v_02">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_02"><?php echo $product_group->v_02->caption() ?></span></td>
		<td data-name="v_02"<?php echo $product_group->v_02->cellAttributes() ?>>
<span id="el_product_group_v_02" data-page="1">
<span<?php echo $product_group->v_02->viewAttributes() ?>>
<?php echo $product_group->v_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_02_validation->Visible) { // v_02_validation ?>
	<tr id="r_v_02_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_02_validation"><?php echo $product_group->v_02_validation->caption() ?></span></td>
		<td data-name="v_02_validation"<?php echo $product_group->v_02_validation->cellAttributes() ?>>
<span id="el_product_group_v_02_validation" data-page="1">
<span<?php echo $product_group->v_02_validation->viewAttributes() ?>>
<?php echo $product_group->v_02_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_03->Visible) { // v_03 ?>
	<tr id="r_v_03">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_03"><?php echo $product_group->v_03->caption() ?></span></td>
		<td data-name="v_03"<?php echo $product_group->v_03->cellAttributes() ?>>
<span id="el_product_group_v_03" data-page="1">
<span<?php echo $product_group->v_03->viewAttributes() ?>>
<?php echo $product_group->v_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_03_validation->Visible) { // v_03_validation ?>
	<tr id="r_v_03_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_03_validation"><?php echo $product_group->v_03_validation->caption() ?></span></td>
		<td data-name="v_03_validation"<?php echo $product_group->v_03_validation->cellAttributes() ?>>
<span id="el_product_group_v_03_validation" data-page="1">
<span<?php echo $product_group->v_03_validation->viewAttributes() ?>>
<?php echo $product_group->v_03_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_04->Visible) { // v_04 ?>
	<tr id="r_v_04">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_04"><?php echo $product_group->v_04->caption() ?></span></td>
		<td data-name="v_04"<?php echo $product_group->v_04->cellAttributes() ?>>
<span id="el_product_group_v_04" data-page="1">
<span<?php echo $product_group->v_04->viewAttributes() ?>>
<?php echo $product_group->v_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_04_validation->Visible) { // v_04_validation ?>
	<tr id="r_v_04_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_04_validation"><?php echo $product_group->v_04_validation->caption() ?></span></td>
		<td data-name="v_04_validation"<?php echo $product_group->v_04_validation->cellAttributes() ?>>
<span id="el_product_group_v_04_validation" data-page="1">
<span<?php echo $product_group->v_04_validation->viewAttributes() ?>>
<?php echo $product_group->v_04_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_05->Visible) { // v_05 ?>
	<tr id="r_v_05">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_05"><?php echo $product_group->v_05->caption() ?></span></td>
		<td data-name="v_05"<?php echo $product_group->v_05->cellAttributes() ?>>
<span id="el_product_group_v_05" data-page="1">
<span<?php echo $product_group->v_05->viewAttributes() ?>>
<?php echo $product_group->v_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_05_validation->Visible) { // v_05_validation ?>
	<tr id="r_v_05_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_05_validation"><?php echo $product_group->v_05_validation->caption() ?></span></td>
		<td data-name="v_05_validation"<?php echo $product_group->v_05_validation->cellAttributes() ?>>
<span id="el_product_group_v_05_validation" data-page="1">
<span<?php echo $product_group->v_05_validation->viewAttributes() ?>>
<?php echo $product_group->v_05_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_06->Visible) { // v_06 ?>
	<tr id="r_v_06">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_06"><?php echo $product_group->v_06->caption() ?></span></td>
		<td data-name="v_06"<?php echo $product_group->v_06->cellAttributes() ?>>
<span id="el_product_group_v_06" data-page="1">
<span<?php echo $product_group->v_06->viewAttributes() ?>>
<?php echo $product_group->v_06->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_06_validation->Visible) { // v_06_validation ?>
	<tr id="r_v_06_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_06_validation"><?php echo $product_group->v_06_validation->caption() ?></span></td>
		<td data-name="v_06_validation"<?php echo $product_group->v_06_validation->cellAttributes() ?>>
<span id="el_product_group_v_06_validation" data-page="1">
<span<?php echo $product_group->v_06_validation->viewAttributes() ?>>
<?php echo $product_group->v_06_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_07->Visible) { // v_07 ?>
	<tr id="r_v_07">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_07"><?php echo $product_group->v_07->caption() ?></span></td>
		<td data-name="v_07"<?php echo $product_group->v_07->cellAttributes() ?>>
<span id="el_product_group_v_07" data-page="1">
<span<?php echo $product_group->v_07->viewAttributes() ?>>
<?php echo $product_group->v_07->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_07_validation->Visible) { // v_07_validation ?>
	<tr id="r_v_07_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_07_validation"><?php echo $product_group->v_07_validation->caption() ?></span></td>
		<td data-name="v_07_validation"<?php echo $product_group->v_07_validation->cellAttributes() ?>>
<span id="el_product_group_v_07_validation" data-page="1">
<span<?php echo $product_group->v_07_validation->viewAttributes() ?>>
<?php echo $product_group->v_07_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_08->Visible) { // v_08 ?>
	<tr id="r_v_08">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_08"><?php echo $product_group->v_08->caption() ?></span></td>
		<td data-name="v_08"<?php echo $product_group->v_08->cellAttributes() ?>>
<span id="el_product_group_v_08" data-page="1">
<span<?php echo $product_group->v_08->viewAttributes() ?>>
<?php echo $product_group->v_08->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_08_validation->Visible) { // v_08_validation ?>
	<tr id="r_v_08_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_08_validation"><?php echo $product_group->v_08_validation->caption() ?></span></td>
		<td data-name="v_08_validation"<?php echo $product_group->v_08_validation->cellAttributes() ?>>
<span id="el_product_group_v_08_validation" data-page="1">
<span<?php echo $product_group->v_08_validation->viewAttributes() ?>>
<?php echo $product_group->v_08_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_09->Visible) { // v_09 ?>
	<tr id="r_v_09">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_09"><?php echo $product_group->v_09->caption() ?></span></td>
		<td data-name="v_09"<?php echo $product_group->v_09->cellAttributes() ?>>
<span id="el_product_group_v_09" data-page="1">
<span<?php echo $product_group->v_09->viewAttributes() ?>>
<?php echo $product_group->v_09->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_09_validation->Visible) { // v_09_validation ?>
	<tr id="r_v_09_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_09_validation"><?php echo $product_group->v_09_validation->caption() ?></span></td>
		<td data-name="v_09_validation"<?php echo $product_group->v_09_validation->cellAttributes() ?>>
<span id="el_product_group_v_09_validation" data-page="1">
<span<?php echo $product_group->v_09_validation->viewAttributes() ?>>
<?php echo $product_group->v_09_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_10->Visible) { // v_10 ?>
	<tr id="r_v_10">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_10"><?php echo $product_group->v_10->caption() ?></span></td>
		<td data-name="v_10"<?php echo $product_group->v_10->cellAttributes() ?>>
<span id="el_product_group_v_10" data-page="1">
<span<?php echo $product_group->v_10->viewAttributes() ?>>
<?php echo $product_group->v_10->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->v_10_validation->Visible) { // v_10_validation ?>
	<tr id="r_v_10_validation">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_v_10_validation"><?php echo $product_group->v_10_validation->caption() ?></span></td>
		<td data-name="v_10_validation"<?php echo $product_group->v_10_validation->cellAttributes() ?>>
<span id="el_product_group_v_10_validation" data-page="1">
<span<?php echo $product_group->v_10_validation->viewAttributes() ?>>
<?php echo $product_group->v_10_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->q_sku->Visible) { // q_sku ?>
	<tr id="r_q_sku">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_q_sku"><?php echo $product_group->q_sku->caption() ?></span></td>
		<td data-name="q_sku"<?php echo $product_group->q_sku->cellAttributes() ?>>
<span id="el_product_group_q_sku" data-page="1">
<span<?php echo $product_group->q_sku->viewAttributes() ?>>
<?php echo $product_group->q_sku->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("2") ?>" id="tab_product_group2"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->b_01_head->Visible) { // b_01_head ?>
	<tr id="r_b_01_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_01_head"><?php echo $product_group->b_01_head->caption() ?></span></td>
		<td data-name="b_01_head"<?php echo $product_group->b_01_head->cellAttributes() ?>>
<span id="el_product_group_b_01_head" data-page="2">
<span<?php echo $product_group->b_01_head->viewAttributes() ?>>
<?php echo $product_group->b_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_02_head->Visible) { // b_02_head ?>
	<tr id="r_b_02_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_02_head"><?php echo $product_group->b_02_head->caption() ?></span></td>
		<td data-name="b_02_head"<?php echo $product_group->b_02_head->cellAttributes() ?>>
<span id="el_product_group_b_02_head" data-page="2">
<span<?php echo $product_group->b_02_head->viewAttributes() ?>>
<?php echo $product_group->b_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_03_head->Visible) { // b_03_head ?>
	<tr id="r_b_03_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_03_head"><?php echo $product_group->b_03_head->caption() ?></span></td>
		<td data-name="b_03_head"<?php echo $product_group->b_03_head->cellAttributes() ?>>
<span id="el_product_group_b_03_head" data-page="2">
<span<?php echo $product_group->b_03_head->viewAttributes() ?>>
<?php echo $product_group->b_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_04_head->Visible) { // b_04_head ?>
	<tr id="r_b_04_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_04_head"><?php echo $product_group->b_04_head->caption() ?></span></td>
		<td data-name="b_04_head"<?php echo $product_group->b_04_head->cellAttributes() ?>>
<span id="el_product_group_b_04_head" data-page="2">
<span<?php echo $product_group->b_04_head->viewAttributes() ?>>
<?php echo $product_group->b_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_05_head->Visible) { // b_05_head ?>
	<tr id="r_b_05_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_05_head"><?php echo $product_group->b_05_head->caption() ?></span></td>
		<td data-name="b_05_head"<?php echo $product_group->b_05_head->cellAttributes() ?>>
<span id="el_product_group_b_05_head" data-page="2">
<span<?php echo $product_group->b_05_head->viewAttributes() ?>>
<?php echo $product_group->b_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_06_head->Visible) { // b_06_head ?>
	<tr id="r_b_06_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_06_head"><?php echo $product_group->b_06_head->caption() ?></span></td>
		<td data-name="b_06_head"<?php echo $product_group->b_06_head->cellAttributes() ?>>
<span id="el_product_group_b_06_head" data-page="2">
<span<?php echo $product_group->b_06_head->viewAttributes() ?>>
<?php echo $product_group->b_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_07_head->Visible) { // b_07_head ?>
	<tr id="r_b_07_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_07_head"><?php echo $product_group->b_07_head->caption() ?></span></td>
		<td data-name="b_07_head"<?php echo $product_group->b_07_head->cellAttributes() ?>>
<span id="el_product_group_b_07_head" data-page="2">
<span<?php echo $product_group->b_07_head->viewAttributes() ?>>
<?php echo $product_group->b_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_08_head->Visible) { // b_08_head ?>
	<tr id="r_b_08_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_08_head"><?php echo $product_group->b_08_head->caption() ?></span></td>
		<td data-name="b_08_head"<?php echo $product_group->b_08_head->cellAttributes() ?>>
<span id="el_product_group_b_08_head" data-page="2">
<span<?php echo $product_group->b_08_head->viewAttributes() ?>>
<?php echo $product_group->b_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_09_head->Visible) { // b_09_head ?>
	<tr id="r_b_09_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_09_head"><?php echo $product_group->b_09_head->caption() ?></span></td>
		<td data-name="b_09_head"<?php echo $product_group->b_09_head->cellAttributes() ?>>
<span id="el_product_group_b_09_head" data-page="2">
<span<?php echo $product_group->b_09_head->viewAttributes() ?>>
<?php echo $product_group->b_09_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_10_head->Visible) { // b_10_head ?>
	<tr id="r_b_10_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_10_head"><?php echo $product_group->b_10_head->caption() ?></span></td>
		<td data-name="b_10_head"<?php echo $product_group->b_10_head->cellAttributes() ?>>
<span id="el_product_group_b_10_head" data-page="2">
<span<?php echo $product_group->b_10_head->viewAttributes() ?>>
<?php echo $product_group->b_10_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_11_head->Visible) { // b_11_head ?>
	<tr id="r_b_11_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_11_head"><?php echo $product_group->b_11_head->caption() ?></span></td>
		<td data-name="b_11_head"<?php echo $product_group->b_11_head->cellAttributes() ?>>
<span id="el_product_group_b_11_head" data-page="2">
<span<?php echo $product_group->b_11_head->viewAttributes() ?>>
<?php echo $product_group->b_11_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_12_head->Visible) { // b_12_head ?>
	<tr id="r_b_12_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_12_head"><?php echo $product_group->b_12_head->caption() ?></span></td>
		<td data-name="b_12_head"<?php echo $product_group->b_12_head->cellAttributes() ?>>
<span id="el_product_group_b_12_head" data-page="2">
<span<?php echo $product_group->b_12_head->viewAttributes() ?>>
<?php echo $product_group->b_12_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_13_head->Visible) { // b_13_head ?>
	<tr id="r_b_13_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_13_head"><?php echo $product_group->b_13_head->caption() ?></span></td>
		<td data-name="b_13_head"<?php echo $product_group->b_13_head->cellAttributes() ?>>
<span id="el_product_group_b_13_head" data-page="2">
<span<?php echo $product_group->b_13_head->viewAttributes() ?>>
<?php echo $product_group->b_13_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_14_head->Visible) { // b_14_head ?>
	<tr id="r_b_14_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_14_head"><?php echo $product_group->b_14_head->caption() ?></span></td>
		<td data-name="b_14_head"<?php echo $product_group->b_14_head->cellAttributes() ?>>
<span id="el_product_group_b_14_head" data-page="2">
<span<?php echo $product_group->b_14_head->viewAttributes() ?>>
<?php echo $product_group->b_14_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->b_15_head->Visible) { // b_15_head ?>
	<tr id="r_b_15_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_b_15_head"><?php echo $product_group->b_15_head->caption() ?></span></td>
		<td data-name="b_15_head"<?php echo $product_group->b_15_head->cellAttributes() ?>>
<span id="el_product_group_b_15_head" data-page="2">
<span<?php echo $product_group->b_15_head->viewAttributes() ?>>
<?php echo $product_group->b_15_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("3") ?>" id="tab_product_group3"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->t_01_head->Visible) { // t_01_head ?>
	<tr id="r_t_01_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_01_head"><?php echo $product_group->t_01_head->caption() ?></span></td>
		<td data-name="t_01_head"<?php echo $product_group->t_01_head->cellAttributes() ?>>
<span id="el_product_group_t_01_head" data-page="3">
<span<?php echo $product_group->t_01_head->viewAttributes() ?>>
<?php echo $product_group->t_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_02_head->Visible) { // t_02_head ?>
	<tr id="r_t_02_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_02_head"><?php echo $product_group->t_02_head->caption() ?></span></td>
		<td data-name="t_02_head"<?php echo $product_group->t_02_head->cellAttributes() ?>>
<span id="el_product_group_t_02_head" data-page="3">
<span<?php echo $product_group->t_02_head->viewAttributes() ?>>
<?php echo $product_group->t_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_03_head->Visible) { // t_03_head ?>
	<tr id="r_t_03_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_03_head"><?php echo $product_group->t_03_head->caption() ?></span></td>
		<td data-name="t_03_head"<?php echo $product_group->t_03_head->cellAttributes() ?>>
<span id="el_product_group_t_03_head" data-page="3">
<span<?php echo $product_group->t_03_head->viewAttributes() ?>>
<?php echo $product_group->t_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_04_head->Visible) { // t_04_head ?>
	<tr id="r_t_04_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_04_head"><?php echo $product_group->t_04_head->caption() ?></span></td>
		<td data-name="t_04_head"<?php echo $product_group->t_04_head->cellAttributes() ?>>
<span id="el_product_group_t_04_head" data-page="3">
<span<?php echo $product_group->t_04_head->viewAttributes() ?>>
<?php echo $product_group->t_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_05_head->Visible) { // t_05_head ?>
	<tr id="r_t_05_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_05_head"><?php echo $product_group->t_05_head->caption() ?></span></td>
		<td data-name="t_05_head"<?php echo $product_group->t_05_head->cellAttributes() ?>>
<span id="el_product_group_t_05_head" data-page="3">
<span<?php echo $product_group->t_05_head->viewAttributes() ?>>
<?php echo $product_group->t_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_06_head->Visible) { // t_06_head ?>
	<tr id="r_t_06_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_06_head"><?php echo $product_group->t_06_head->caption() ?></span></td>
		<td data-name="t_06_head"<?php echo $product_group->t_06_head->cellAttributes() ?>>
<span id="el_product_group_t_06_head" data-page="3">
<span<?php echo $product_group->t_06_head->viewAttributes() ?>>
<?php echo $product_group->t_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_07_head->Visible) { // t_07_head ?>
	<tr id="r_t_07_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_07_head"><?php echo $product_group->t_07_head->caption() ?></span></td>
		<td data-name="t_07_head"<?php echo $product_group->t_07_head->cellAttributes() ?>>
<span id="el_product_group_t_07_head" data-page="3">
<span<?php echo $product_group->t_07_head->viewAttributes() ?>>
<?php echo $product_group->t_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_08_head->Visible) { // t_08_head ?>
	<tr id="r_t_08_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_08_head"><?php echo $product_group->t_08_head->caption() ?></span></td>
		<td data-name="t_08_head"<?php echo $product_group->t_08_head->cellAttributes() ?>>
<span id="el_product_group_t_08_head" data-page="3">
<span<?php echo $product_group->t_08_head->viewAttributes() ?>>
<?php echo $product_group->t_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_09_head->Visible) { // t_09_head ?>
	<tr id="r_t_09_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_09_head"><?php echo $product_group->t_09_head->caption() ?></span></td>
		<td data-name="t_09_head"<?php echo $product_group->t_09_head->cellAttributes() ?>>
<span id="el_product_group_t_09_head" data-page="3">
<span<?php echo $product_group->t_09_head->viewAttributes() ?>>
<?php echo $product_group->t_09_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_10_head->Visible) { // t_10_head ?>
	<tr id="r_t_10_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_10_head"><?php echo $product_group->t_10_head->caption() ?></span></td>
		<td data-name="t_10_head"<?php echo $product_group->t_10_head->cellAttributes() ?>>
<span id="el_product_group_t_10_head" data-page="3">
<span<?php echo $product_group->t_10_head->viewAttributes() ?>>
<?php echo $product_group->t_10_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_11_head->Visible) { // t_11_head ?>
	<tr id="r_t_11_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_11_head"><?php echo $product_group->t_11_head->caption() ?></span></td>
		<td data-name="t_11_head"<?php echo $product_group->t_11_head->cellAttributes() ?>>
<span id="el_product_group_t_11_head" data-page="3">
<span<?php echo $product_group->t_11_head->viewAttributes() ?>>
<?php echo $product_group->t_11_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_12_head->Visible) { // t_12_head ?>
	<tr id="r_t_12_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_12_head"><?php echo $product_group->t_12_head->caption() ?></span></td>
		<td data-name="t_12_head"<?php echo $product_group->t_12_head->cellAttributes() ?>>
<span id="el_product_group_t_12_head" data-page="3">
<span<?php echo $product_group->t_12_head->viewAttributes() ?>>
<?php echo $product_group->t_12_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_13_head->Visible) { // t_13_head ?>
	<tr id="r_t_13_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_13_head"><?php echo $product_group->t_13_head->caption() ?></span></td>
		<td data-name="t_13_head"<?php echo $product_group->t_13_head->cellAttributes() ?>>
<span id="el_product_group_t_13_head" data-page="3">
<span<?php echo $product_group->t_13_head->viewAttributes() ?>>
<?php echo $product_group->t_13_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_14_head->Visible) { // t_14_head ?>
	<tr id="r_t_14_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_14_head"><?php echo $product_group->t_14_head->caption() ?></span></td>
		<td data-name="t_14_head"<?php echo $product_group->t_14_head->cellAttributes() ?>>
<span id="el_product_group_t_14_head" data-page="3">
<span<?php echo $product_group->t_14_head->viewAttributes() ?>>
<?php echo $product_group->t_14_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->t_15_head->Visible) { // t_15_head ?>
	<tr id="r_t_15_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_t_15_head"><?php echo $product_group->t_15_head->caption() ?></span></td>
		<td data-name="t_15_head"<?php echo $product_group->t_15_head->cellAttributes() ?>>
<span id="el_product_group_t_15_head" data-page="3">
<span<?php echo $product_group->t_15_head->viewAttributes() ?>>
<?php echo $product_group->t_15_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("4") ?>" id="tab_product_group4"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->po_01_head->Visible) { // po_01_head ?>
	<tr id="r_po_01_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_01_head"><?php echo $product_group->po_01_head->caption() ?></span></td>
		<td data-name="po_01_head"<?php echo $product_group->po_01_head->cellAttributes() ?>>
<span id="el_product_group_po_01_head" data-page="4">
<span<?php echo $product_group->po_01_head->viewAttributes() ?>>
<?php echo $product_group->po_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_02_head->Visible) { // po_02_head ?>
	<tr id="r_po_02_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_02_head"><?php echo $product_group->po_02_head->caption() ?></span></td>
		<td data-name="po_02_head"<?php echo $product_group->po_02_head->cellAttributes() ?>>
<span id="el_product_group_po_02_head" data-page="4">
<span<?php echo $product_group->po_02_head->viewAttributes() ?>>
<?php echo $product_group->po_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_03_head->Visible) { // po_03_head ?>
	<tr id="r_po_03_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_03_head"><?php echo $product_group->po_03_head->caption() ?></span></td>
		<td data-name="po_03_head"<?php echo $product_group->po_03_head->cellAttributes() ?>>
<span id="el_product_group_po_03_head" data-page="4">
<span<?php echo $product_group->po_03_head->viewAttributes() ?>>
<?php echo $product_group->po_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_04_head->Visible) { // po_04_head ?>
	<tr id="r_po_04_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_04_head"><?php echo $product_group->po_04_head->caption() ?></span></td>
		<td data-name="po_04_head"<?php echo $product_group->po_04_head->cellAttributes() ?>>
<span id="el_product_group_po_04_head" data-page="4">
<span<?php echo $product_group->po_04_head->viewAttributes() ?>>
<?php echo $product_group->po_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_05_head->Visible) { // po_05_head ?>
	<tr id="r_po_05_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_05_head"><?php echo $product_group->po_05_head->caption() ?></span></td>
		<td data-name="po_05_head"<?php echo $product_group->po_05_head->cellAttributes() ?>>
<span id="el_product_group_po_05_head" data-page="4">
<span<?php echo $product_group->po_05_head->viewAttributes() ?>>
<?php echo $product_group->po_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_06_head->Visible) { // po_06_head ?>
	<tr id="r_po_06_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_06_head"><?php echo $product_group->po_06_head->caption() ?></span></td>
		<td data-name="po_06_head"<?php echo $product_group->po_06_head->cellAttributes() ?>>
<span id="el_product_group_po_06_head" data-page="4">
<span<?php echo $product_group->po_06_head->viewAttributes() ?>>
<?php echo $product_group->po_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_07_head->Visible) { // po_07_head ?>
	<tr id="r_po_07_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_07_head"><?php echo $product_group->po_07_head->caption() ?></span></td>
		<td data-name="po_07_head"<?php echo $product_group->po_07_head->cellAttributes() ?>>
<span id="el_product_group_po_07_head" data-page="4">
<span<?php echo $product_group->po_07_head->viewAttributes() ?>>
<?php echo $product_group->po_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_08_head->Visible) { // po_08_head ?>
	<tr id="r_po_08_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_08_head"><?php echo $product_group->po_08_head->caption() ?></span></td>
		<td data-name="po_08_head"<?php echo $product_group->po_08_head->cellAttributes() ?>>
<span id="el_product_group_po_08_head" data-page="4">
<span<?php echo $product_group->po_08_head->viewAttributes() ?>>
<?php echo $product_group->po_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_17_head->Visible) { // po_17_head ?>
	<tr id="r_po_17_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_17_head"><?php echo $product_group->po_17_head->caption() ?></span></td>
		<td data-name="po_17_head"<?php echo $product_group->po_17_head->cellAttributes() ?>>
<span id="el_product_group_po_17_head" data-page="4">
<span<?php echo $product_group->po_17_head->viewAttributes() ?>>
<?php echo $product_group->po_17_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_18_head->Visible) { // po_18_head ?>
	<tr id="r_po_18_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_18_head"><?php echo $product_group->po_18_head->caption() ?></span></td>
		<td data-name="po_18_head"<?php echo $product_group->po_18_head->cellAttributes() ?>>
<span id="el_product_group_po_18_head" data-page="4">
<span<?php echo $product_group->po_18_head->viewAttributes() ?>>
<?php echo $product_group->po_18_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_19_head->Visible) { // po_19_head ?>
	<tr id="r_po_19_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_19_head"><?php echo $product_group->po_19_head->caption() ?></span></td>
		<td data-name="po_19_head"<?php echo $product_group->po_19_head->cellAttributes() ?>>
<span id="el_product_group_po_19_head" data-page="4">
<span<?php echo $product_group->po_19_head->viewAttributes() ?>>
<?php echo $product_group->po_19_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->po_20_head->Visible) { // po_20_head ?>
	<tr id="r_po_20_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_po_20_head"><?php echo $product_group->po_20_head->caption() ?></span></td>
		<td data-name="po_20_head"<?php echo $product_group->po_20_head->cellAttributes() ?>>
<span id="el_product_group_po_20_head" data-page="4">
<span<?php echo $product_group->po_20_head->viewAttributes() ?>>
<?php echo $product_group->po_20_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("5") ?>" id="tab_product_group5"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->jc_01_head->Visible) { // jc_01_head ?>
	<tr id="r_jc_01_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_01_head"><?php echo $product_group->jc_01_head->caption() ?></span></td>
		<td data-name="jc_01_head"<?php echo $product_group->jc_01_head->cellAttributes() ?>>
<span id="el_product_group_jc_01_head" data-page="5">
<span<?php echo $product_group->jc_01_head->viewAttributes() ?>>
<?php echo $product_group->jc_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_02_head->Visible) { // jc_02_head ?>
	<tr id="r_jc_02_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_02_head"><?php echo $product_group->jc_02_head->caption() ?></span></td>
		<td data-name="jc_02_head"<?php echo $product_group->jc_02_head->cellAttributes() ?>>
<span id="el_product_group_jc_02_head" data-page="5">
<span<?php echo $product_group->jc_02_head->viewAttributes() ?>>
<?php echo $product_group->jc_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_03_head->Visible) { // jc_03_head ?>
	<tr id="r_jc_03_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_03_head"><?php echo $product_group->jc_03_head->caption() ?></span></td>
		<td data-name="jc_03_head"<?php echo $product_group->jc_03_head->cellAttributes() ?>>
<span id="el_product_group_jc_03_head" data-page="5">
<span<?php echo $product_group->jc_03_head->viewAttributes() ?>>
<?php echo $product_group->jc_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_04_head->Visible) { // jc_04_head ?>
	<tr id="r_jc_04_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_04_head"><?php echo $product_group->jc_04_head->caption() ?></span></td>
		<td data-name="jc_04_head"<?php echo $product_group->jc_04_head->cellAttributes() ?>>
<span id="el_product_group_jc_04_head" data-page="5">
<span<?php echo $product_group->jc_04_head->viewAttributes() ?>>
<?php echo $product_group->jc_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_05_head->Visible) { // jc_05_head ?>
	<tr id="r_jc_05_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_05_head"><?php echo $product_group->jc_05_head->caption() ?></span></td>
		<td data-name="jc_05_head"<?php echo $product_group->jc_05_head->cellAttributes() ?>>
<span id="el_product_group_jc_05_head" data-page="5">
<span<?php echo $product_group->jc_05_head->viewAttributes() ?>>
<?php echo $product_group->jc_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_06_head->Visible) { // jc_06_head ?>
	<tr id="r_jc_06_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_06_head"><?php echo $product_group->jc_06_head->caption() ?></span></td>
		<td data-name="jc_06_head"<?php echo $product_group->jc_06_head->cellAttributes() ?>>
<span id="el_product_group_jc_06_head" data-page="5">
<span<?php echo $product_group->jc_06_head->viewAttributes() ?>>
<?php echo $product_group->jc_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_07_head->Visible) { // jc_07_head ?>
	<tr id="r_jc_07_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_07_head"><?php echo $product_group->jc_07_head->caption() ?></span></td>
		<td data-name="jc_07_head"<?php echo $product_group->jc_07_head->cellAttributes() ?>>
<span id="el_product_group_jc_07_head" data-page="5">
<span<?php echo $product_group->jc_07_head->viewAttributes() ?>>
<?php echo $product_group->jc_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_08_head->Visible) { // jc_08_head ?>
	<tr id="r_jc_08_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_08_head"><?php echo $product_group->jc_08_head->caption() ?></span></td>
		<td data-name="jc_08_head"<?php echo $product_group->jc_08_head->cellAttributes() ?>>
<span id="el_product_group_jc_08_head" data-page="5">
<span<?php echo $product_group->jc_08_head->viewAttributes() ?>>
<?php echo $product_group->jc_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_09_head->Visible) { // jc_09_head ?>
	<tr id="r_jc_09_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_09_head"><?php echo $product_group->jc_09_head->caption() ?></span></td>
		<td data-name="jc_09_head"<?php echo $product_group->jc_09_head->cellAttributes() ?>>
<span id="el_product_group_jc_09_head" data-page="5">
<span<?php echo $product_group->jc_09_head->viewAttributes() ?>>
<?php echo $product_group->jc_09_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->jc_10_head->Visible) { // jc_10_head ?>
	<tr id="r_jc_10_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_jc_10_head"><?php echo $product_group->jc_10_head->caption() ?></span></td>
		<td data-name="jc_10_head"<?php echo $product_group->jc_10_head->cellAttributes() ?>>
<span id="el_product_group_jc_10_head" data-page="5">
<span<?php echo $product_group->jc_10_head->viewAttributes() ?>>
<?php echo $product_group->jc_10_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
		<div class="tab-pane<?php echo $product_group_view->MultiPages->pageStyle("6") ?>" id="tab_product_group6"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_group->pc_shape->Visible) { // pc_shape ?>
	<tr id="r_pc_shape">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_shape"><?php echo $product_group->pc_shape->caption() ?></span></td>
		<td data-name="pc_shape"<?php echo $product_group->pc_shape->cellAttributes() ?>>
<span id="el_product_group_pc_shape" data-page="6">
<span<?php echo $product_group->pc_shape->viewAttributes() ?>>
<?php echo $product_group->pc_shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_unit->Visible) { // pc_unit ?>
	<tr id="r_pc_unit">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_unit"><?php echo $product_group->pc_unit->caption() ?></span></td>
		<td data-name="pc_unit"<?php echo $product_group->pc_unit->cellAttributes() ?>>
<span id="el_product_group_pc_unit" data-page="6">
<span<?php echo $product_group->pc_unit->viewAttributes() ?>>
<?php echo $product_group->pc_unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_w->Visible) { // pc_w ?>
	<tr id="r_pc_w">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_w"><?php echo $product_group->pc_w->caption() ?></span></td>
		<td data-name="pc_w"<?php echo $product_group->pc_w->cellAttributes() ?>>
<span id="el_product_group_pc_w" data-page="6">
<span<?php echo $product_group->pc_w->viewAttributes() ?>>
<?php echo $product_group->pc_w->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_l->Visible) { // pc_l ?>
	<tr id="r_pc_l">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_l"><?php echo $product_group->pc_l->caption() ?></span></td>
		<td data-name="pc_l"<?php echo $product_group->pc_l->cellAttributes() ?>>
<span id="el_product_group_pc_l" data-page="6">
<span<?php echo $product_group->pc_l->viewAttributes() ?>>
<?php echo $product_group->pc_l->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_h->Visible) { // pc_h ?>
	<tr id="r_pc_h">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_h"><?php echo $product_group->pc_h->caption() ?></span></td>
		<td data-name="pc_h"<?php echo $product_group->pc_h->cellAttributes() ?>>
<span id="el_product_group_pc_h" data-page="6">
<span<?php echo $product_group->pc_h->viewAttributes() ?>>
<?php echo $product_group->pc_h->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_partner_size->Visible) { // pc_partner_size ?>
	<tr id="r_pc_partner_size">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_partner_size"><?php echo $product_group->pc_partner_size->caption() ?></span></td>
		<td data-name="pc_partner_size"<?php echo $product_group->pc_partner_size->cellAttributes() ?>>
<span id="el_product_group_pc_partner_size" data-page="6">
<span<?php echo $product_group->pc_partner_size->viewAttributes() ?>>
<?php echo $product_group->pc_partner_size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_sqm->Visible) { // pc_sqm ?>
	<tr id="r_pc_sqm">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_sqm"><?php echo $product_group->pc_sqm->caption() ?></span></td>
		<td data-name="pc_sqm"<?php echo $product_group->pc_sqm->cellAttributes() ?>>
<span id="el_product_group_pc_sqm" data-page="6">
<span<?php echo $product_group->pc_sqm->viewAttributes() ?>>
<?php echo $product_group->pc_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_01_head->Visible) { // pc_01_head ?>
	<tr id="r_pc_01_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_01_head"><?php echo $product_group->pc_01_head->caption() ?></span></td>
		<td data-name="pc_01_head"<?php echo $product_group->pc_01_head->cellAttributes() ?>>
<span id="el_product_group_pc_01_head" data-page="6">
<span<?php echo $product_group->pc_01_head->viewAttributes() ?>>
<?php echo $product_group->pc_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_02_head->Visible) { // pc_02_head ?>
	<tr id="r_pc_02_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_02_head"><?php echo $product_group->pc_02_head->caption() ?></span></td>
		<td data-name="pc_02_head"<?php echo $product_group->pc_02_head->cellAttributes() ?>>
<span id="el_product_group_pc_02_head" data-page="6">
<span<?php echo $product_group->pc_02_head->viewAttributes() ?>>
<?php echo $product_group->pc_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_03_head->Visible) { // pc_03_head ?>
	<tr id="r_pc_03_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_03_head"><?php echo $product_group->pc_03_head->caption() ?></span></td>
		<td data-name="pc_03_head"<?php echo $product_group->pc_03_head->cellAttributes() ?>>
<span id="el_product_group_pc_03_head" data-page="6">
<span<?php echo $product_group->pc_03_head->viewAttributes() ?>>
<?php echo $product_group->pc_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_04_head->Visible) { // pc_04_head ?>
	<tr id="r_pc_04_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_04_head"><?php echo $product_group->pc_04_head->caption() ?></span></td>
		<td data-name="pc_04_head"<?php echo $product_group->pc_04_head->cellAttributes() ?>>
<span id="el_product_group_pc_04_head" data-page="6">
<span<?php echo $product_group->pc_04_head->viewAttributes() ?>>
<?php echo $product_group->pc_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_05_head->Visible) { // pc_05_head ?>
	<tr id="r_pc_05_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_05_head"><?php echo $product_group->pc_05_head->caption() ?></span></td>
		<td data-name="pc_05_head"<?php echo $product_group->pc_05_head->cellAttributes() ?>>
<span id="el_product_group_pc_05_head" data-page="6">
<span<?php echo $product_group->pc_05_head->viewAttributes() ?>>
<?php echo $product_group->pc_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_06_head->Visible) { // pc_06_head ?>
	<tr id="r_pc_06_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_06_head"><?php echo $product_group->pc_06_head->caption() ?></span></td>
		<td data-name="pc_06_head"<?php echo $product_group->pc_06_head->cellAttributes() ?>>
<span id="el_product_group_pc_06_head" data-page="6">
<span<?php echo $product_group->pc_06_head->viewAttributes() ?>>
<?php echo $product_group->pc_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_07_head->Visible) { // pc_07_head ?>
	<tr id="r_pc_07_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_07_head"><?php echo $product_group->pc_07_head->caption() ?></span></td>
		<td data-name="pc_07_head"<?php echo $product_group->pc_07_head->cellAttributes() ?>>
<span id="el_product_group_pc_07_head" data-page="6">
<span<?php echo $product_group->pc_07_head->viewAttributes() ?>>
<?php echo $product_group->pc_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_08_head->Visible) { // pc_08_head ?>
	<tr id="r_pc_08_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_08_head"><?php echo $product_group->pc_08_head->caption() ?></span></td>
		<td data-name="pc_08_head"<?php echo $product_group->pc_08_head->cellAttributes() ?>>
<span id="el_product_group_pc_08_head" data-page="6">
<span<?php echo $product_group->pc_08_head->viewAttributes() ?>>
<?php echo $product_group->pc_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_09_head->Visible) { // pc_09_head ?>
	<tr id="r_pc_09_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_09_head"><?php echo $product_group->pc_09_head->caption() ?></span></td>
		<td data-name="pc_09_head"<?php echo $product_group->pc_09_head->cellAttributes() ?>>
<span id="el_product_group_pc_09_head" data-page="6">
<span<?php echo $product_group->pc_09_head->viewAttributes() ?>>
<?php echo $product_group->pc_09_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_10_head->Visible) { // pc_10_head ?>
	<tr id="r_pc_10_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_10_head"><?php echo $product_group->pc_10_head->caption() ?></span></td>
		<td data-name="pc_10_head"<?php echo $product_group->pc_10_head->cellAttributes() ?>>
<span id="el_product_group_pc_10_head" data-page="6">
<span<?php echo $product_group->pc_10_head->viewAttributes() ?>>
<?php echo $product_group->pc_10_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_11_head->Visible) { // pc_11_head ?>
	<tr id="r_pc_11_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_11_head"><?php echo $product_group->pc_11_head->caption() ?></span></td>
		<td data-name="pc_11_head"<?php echo $product_group->pc_11_head->cellAttributes() ?>>
<span id="el_product_group_pc_11_head" data-page="6">
<span<?php echo $product_group->pc_11_head->viewAttributes() ?>>
<?php echo $product_group->pc_11_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_group->pc_12_head->Visible) { // pc_12_head ?>
	<tr id="r_pc_12_head">
		<td class="<?php echo $product_group_view->TableLeftColumnClass ?>"><span id="elh_product_group_pc_12_head"><?php echo $product_group->pc_12_head->caption() ?></span></td>
		<td data-name="pc_12_head"<?php echo $product_group->pc_12_head->cellAttributes() ?>>
<span id="el_product_group_pc_12_head" data-page="6">
<span<?php echo $product_group->pc_12_head->viewAttributes() ?>>
<?php echo $product_group->pc_12_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$product_group->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$product_group->isExport()) { ?>
	</div>
</div>
</div>
<?php } ?>
</form>
<?php
$product_group_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_group->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_group_view->terminate();
?>