<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_g_search = new product_g_search();

// Run the page
$product_g_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_g_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_g_search->IsModal) { ?>
var fproduct_gsearch = currentAdvancedSearchForm = new ew.Form("fproduct_gsearch", "search");
<?php } else { ?>
var fproduct_gsearch = currentForm = new ew.Form("fproduct_gsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_gsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_gsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_gsearch.lists["x_grp[]"] = <?php echo $product_g_search->grp->Lookup->toClientList() ?>;
fproduct_gsearch.lists["x_grp[]"].options = <?php echo JsonEncode($product_g_search->grp->lookupOptions()) ?>;
fproduct_gsearch.lists["x_status"] = <?php echo $product_g_search->status->Lookup->toClientList() ?>;
fproduct_gsearch.lists["x_status"].options = <?php echo JsonEncode($product_g_search->status->options(FALSE, TRUE)) ?>;
fproduct_gsearch.lists["x_company_id"] = <?php echo $product_g_search->company_id->Lookup->toClientList() ?>;
fproduct_gsearch.lists["x_company_id"].options = <?php echo JsonEncode($product_g_search->company_id->lookupOptions()) ?>;
fproduct_gsearch.lists["x_operator"] = <?php echo $product_g_search->operator->Lookup->toClientList() ?>;
fproduct_gsearch.lists["x_operator"].options = <?php echo JsonEncode($product_g_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduct_gsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_g->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_g->s_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product_g->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_g->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_g_search->showPageHeader(); ?>
<?php
$product_g_search->showMessage();
?>
<form name="fproduct_gsearch" id="fproduct_gsearch" class="<?php echo $product_g_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_g_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_g_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_g">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_g_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_g->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_id"><?php echo $product_g->id->caption() ?></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_id" id="z_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($product_g->id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($product_g->id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_product_g_id">
<input type="text" data-table="product_g" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_g->id->getPlaceHolder()) ?>" value="<?php echo $product_g->id->EditValue ?>"<?php echo $product_g->id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_product_g_id" class="btw1_id d-none">
<input type="text" data-table="product_g" data-field="x_id" name="y_id" id="y_id" placeholder="<?php echo HtmlEncode($product_g->id->getPlaceHolder()) ?>" value="<?php echo $product_g->id->EditValue2 ?>"<?php echo $product_g->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_grp"><?php echo $product_g->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->grp->cellAttributes() ?>>
			<span id="el_product_g_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product_g" data-field="x_grp" data-value-separator="<?php echo $product_g->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product_g->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product_g->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product_g->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_s_grp"><?php echo $product_g->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->s_grp->cellAttributes() ?>>
			<span id="el_product_g_s_grp">
<input type="text" data-table="product_g" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($product_g->s_grp->getPlaceHolder()) ?>" value="<?php echo $product_g->s_grp->EditValue ?>"<?php echo $product_g->s_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_product"><?php echo $product_g->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->product->cellAttributes() ?>>
			<span id="el_product_g_product">
<input type="text" data-table="product_g" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_g->product->getPlaceHolder()) ?>" value="<?php echo $product_g->product->EditValue ?>"<?php echo $product_g->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_remarks"><?php echo $product_g->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->remarks->cellAttributes() ?>>
			<span id="el_product_g_remarks">
<input type="text" data-table="product_g" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_g->remarks->getPlaceHolder()) ?>" value="<?php echo $product_g->remarks->EditValue ?>"<?php echo $product_g->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_status"><?php echo $product_g->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->status->cellAttributes() ?>>
			<span id="el_product_g_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_status" data-value-separator="<?php echo $product_g->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_g->status->editAttributes() ?>>
		<?php echo $product_g->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_company_id"><?php echo $product_g->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->company_id->cellAttributes() ?>>
			<span id="el_product_g_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_company_id" data-value-separator="<?php echo $product_g->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product_g->company_id->editAttributes() ?>>
		<?php echo $product_g->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product_g->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_operator"><?php echo $product_g->operator->caption() ?></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->operator->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_operator" id="z_operator" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($product_g->operator->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_product_g_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_operator" data-value-separator="<?php echo $product_g->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $product_g->operator->editAttributes() ?>>
		<?php echo $product_g->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $product_g->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
			<span class="ew-search-cond btw1_operator d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_product_g_operator" class="btw1_operator d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_g" data-field="x_operator" data-value-separator="<?php echo $product_g->operator->displayValueSeparatorAttribute() ?>" id="y_operator" name="y_operator"<?php echo $product_g->operator->editAttributes() ?>>
		<?php echo $product_g->operator->selectOptionListHtml("y_operator") ?>
	</select>
</div>
<?php echo $product_g->operator->Lookup->getParamTag("p_y_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_g->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_g_search->LeftColumnClass ?>"><span id="elh_product_g_datetime"><?php echo $product_g->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_g_search->RightColumnClass ?>"><div<?php echo $product_g->datetime->cellAttributes() ?>>
			<span id="el_product_g_datetime">
<input type="text" data-table="product_g" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_g->datetime->getPlaceHolder()) ?>" value="<?php echo $product_g->datetime->EditValue ?>"<?php echo $product_g->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_g_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_g_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_g_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_g_search->terminate();
?>