<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_notify_add = new product_notify_add();

// Run the page
$product_notify_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_notify_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduct_notifyadd = currentForm = new ew.Form("fproduct_notifyadd", "add");

// Validate form
fproduct_notifyadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_notify_add->_userid->Required) { ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_notify->_userid->caption(), $product_notify->_userid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_notify->_userid->errorMessage()) ?>");
		<?php if ($product_notify_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_notify->code->caption(), $product_notify->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_notify->code->errorMessage()) ?>");
		<?php if ($product_notify_add->table_no->Required) { ?>
			elm = this.getElements("x" + infix + "_table_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_notify->table_no->caption(), $product_notify->table_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_table_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_notify->table_no->errorMessage()) ?>");
		<?php if ($product_notify_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_notify->status->caption(), $product_notify->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_notify_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_notify->datetime->caption(), $product_notify->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_notifyadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_notifyadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_notifyadd.lists["x_status"] = <?php echo $product_notify_add->status->Lookup->toClientList() ?>;
fproduct_notifyadd.lists["x_status"].options = <?php echo JsonEncode($product_notify_add->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_notify_add->showPageHeader(); ?>
<?php
$product_notify_add->showMessage();
?>
<form name="fproduct_notifyadd" id="fproduct_notifyadd" class="<?php echo $product_notify_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_notify_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_notify_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_notify">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$product_notify_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($product_notify->_userid->Visible) { // userid ?>
	<div id="r__userid" class="form-group row">
		<label id="elh_product_notify__userid" for="x__userid" class="<?php echo $product_notify_add->LeftColumnClass ?>"><?php echo $product_notify->_userid->caption() ?><?php echo ($product_notify->_userid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_notify_add->RightColumnClass ?>"><div<?php echo $product_notify->_userid->cellAttributes() ?>>
<span id="el_product_notify__userid">
<input type="text" data-table="product_notify" data-field="x__userid" name="x__userid" id="x__userid" size="30" placeholder="<?php echo HtmlEncode($product_notify->_userid->getPlaceHolder()) ?>" value="<?php echo $product_notify->_userid->EditValue ?>"<?php echo $product_notify->_userid->editAttributes() ?>>
</span>
<?php echo $product_notify->_userid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_notify->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_product_notify_code" for="x_code" class="<?php echo $product_notify_add->LeftColumnClass ?>"><?php echo $product_notify->code->caption() ?><?php echo ($product_notify->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_notify_add->RightColumnClass ?>"><div<?php echo $product_notify->code->cellAttributes() ?>>
<span id="el_product_notify_code">
<input type="text" data-table="product_notify" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($product_notify->code->getPlaceHolder()) ?>" value="<?php echo $product_notify->code->EditValue ?>"<?php echo $product_notify->code->editAttributes() ?>>
</span>
<?php echo $product_notify->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_notify->table_no->Visible) { // table_no ?>
	<div id="r_table_no" class="form-group row">
		<label id="elh_product_notify_table_no" for="x_table_no" class="<?php echo $product_notify_add->LeftColumnClass ?>"><?php echo $product_notify->table_no->caption() ?><?php echo ($product_notify->table_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_notify_add->RightColumnClass ?>"><div<?php echo $product_notify->table_no->cellAttributes() ?>>
<span id="el_product_notify_table_no">
<input type="text" data-table="product_notify" data-field="x_table_no" name="x_table_no" id="x_table_no" size="30" placeholder="<?php echo HtmlEncode($product_notify->table_no->getPlaceHolder()) ?>" value="<?php echo $product_notify->table_no->EditValue ?>"<?php echo $product_notify->table_no->editAttributes() ?>>
</span>
<?php echo $product_notify->table_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_notify->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_notify_status" for="x_status" class="<?php echo $product_notify_add->LeftColumnClass ?>"><?php echo $product_notify->status->caption() ?><?php echo ($product_notify->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_notify_add->RightColumnClass ?>"><div<?php echo $product_notify->status->cellAttributes() ?>>
<span id="el_product_notify_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_notify" data-field="x_status" data-value-separator="<?php echo $product_notify->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_notify->status->editAttributes() ?>>
		<?php echo $product_notify->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $product_notify->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_notify_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_notify_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_notify_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_notify_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_notify_add->terminate();
?>