<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_notify_list = new product_notify_list();

// Run the page
$product_notify_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_notify_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_notify->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_notifylist = currentForm = new ew.Form("fproduct_notifylist", "list");
fproduct_notifylist.formKeyCountName = '<?php echo $product_notify_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_notifylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_notifylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_notifylist.lists["x_status"] = <?php echo $product_notify_list->status->Lookup->toClientList() ?>;
fproduct_notifylist.lists["x_status"].options = <?php echo JsonEncode($product_notify_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_notify->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_notify_list->TotalRecs > 0 && $product_notify_list->ExportOptions->visible()) { ?>
<?php $product_notify_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_notify_list->ImportOptions->visible()) { ?>
<?php $product_notify_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_notify_list->renderOtherOptions();
?>
<?php $product_notify_list->showPageHeader(); ?>
<?php
$product_notify_list->showMessage();
?>
<?php if ($product_notify_list->TotalRecs > 0 || $product_notify->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_notify_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_notify">
<?php if (!$product_notify->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_notify->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_notify_list->Pager)) $product_notify_list->Pager = new PrevNextPager($product_notify_list->StartRec, $product_notify_list->DisplayRecs, $product_notify_list->TotalRecs, $product_notify_list->AutoHidePager) ?>
<?php if ($product_notify_list->Pager->RecordCount > 0 && $product_notify_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_notify_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_notify_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_notify_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_notify_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_notify_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_notify_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_notify_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_notify_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_notify_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_notify_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_notify_list->TotalRecs > 0 && (!$product_notify_list->AutoHidePageSizeSelector || $product_notify_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_notify">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_notify_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_notify_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_notify_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_notify_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_notify_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_notify->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_notify_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_notifylist" id="fproduct_notifylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_notify_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_notify_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_notify">
<div id="gmp_product_notify" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_notify_list->TotalRecs > 0 || $product_notify->isGridEdit()) { ?>
<table id="tbl_product_notifylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_notify_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_notify_list->renderListOptions();

// Render list options (header, left)
$product_notify_list->ListOptions->render("header", "left");
?>
<?php if ($product_notify->id->Visible) { // id ?>
	<?php if ($product_notify->sortUrl($product_notify->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_notify->id->headerCellClass() ?>"><div id="elh_product_notify_id" class="product_notify_id"><div class="ew-table-header-caption"><?php echo $product_notify->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_notify->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->id) ?>',2);"><div id="elh_product_notify_id" class="product_notify_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_notify->_userid->Visible) { // userid ?>
	<?php if ($product_notify->sortUrl($product_notify->_userid) == "") { ?>
		<th data-name="_userid" class="<?php echo $product_notify->_userid->headerCellClass() ?>"><div id="elh_product_notify__userid" class="product_notify__userid"><div class="ew-table-header-caption"><?php echo $product_notify->_userid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_userid" class="<?php echo $product_notify->_userid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->_userid) ?>',2);"><div id="elh_product_notify__userid" class="product_notify__userid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->_userid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->_userid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->_userid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_notify->code->Visible) { // code ?>
	<?php if ($product_notify->sortUrl($product_notify->code) == "") { ?>
		<th data-name="code" class="<?php echo $product_notify->code->headerCellClass() ?>"><div id="elh_product_notify_code" class="product_notify_code"><div class="ew-table-header-caption"><?php echo $product_notify->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $product_notify->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->code) ?>',2);"><div id="elh_product_notify_code" class="product_notify_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_notify->table_no->Visible) { // table_no ?>
	<?php if ($product_notify->sortUrl($product_notify->table_no) == "") { ?>
		<th data-name="table_no" class="<?php echo $product_notify->table_no->headerCellClass() ?>"><div id="elh_product_notify_table_no" class="product_notify_table_no"><div class="ew-table-header-caption"><?php echo $product_notify->table_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_no" class="<?php echo $product_notify->table_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->table_no) ?>',2);"><div id="elh_product_notify_table_no" class="product_notify_table_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->table_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->table_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->table_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_notify->status->Visible) { // status ?>
	<?php if ($product_notify->sortUrl($product_notify->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_notify->status->headerCellClass() ?>"><div id="elh_product_notify_status" class="product_notify_status"><div class="ew-table-header-caption"><?php echo $product_notify->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_notify->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->status) ?>',2);"><div id="elh_product_notify_status" class="product_notify_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_notify->datetime->Visible) { // datetime ?>
	<?php if ($product_notify->sortUrl($product_notify->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_notify->datetime->headerCellClass() ?>"><div id="elh_product_notify_datetime" class="product_notify_datetime"><div class="ew-table-header-caption"><?php echo $product_notify->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_notify->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_notify->SortUrl($product_notify->datetime) ?>',2);"><div id="elh_product_notify_datetime" class="product_notify_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_notify->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_notify->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_notify->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_notify_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_notify->ExportAll && $product_notify->isExport()) {
	$product_notify_list->StopRec = $product_notify_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_notify_list->TotalRecs > $product_notify_list->StartRec + $product_notify_list->DisplayRecs - 1)
		$product_notify_list->StopRec = $product_notify_list->StartRec + $product_notify_list->DisplayRecs - 1;
	else
		$product_notify_list->StopRec = $product_notify_list->TotalRecs;
}
$product_notify_list->RecCnt = $product_notify_list->StartRec - 1;
if ($product_notify_list->Recordset && !$product_notify_list->Recordset->EOF) {
	$product_notify_list->Recordset->moveFirst();
	$selectLimit = $product_notify_list->UseSelectLimit;
	if (!$selectLimit && $product_notify_list->StartRec > 1)
		$product_notify_list->Recordset->move($product_notify_list->StartRec - 1);
} elseif (!$product_notify->AllowAddDeleteRow && $product_notify_list->StopRec == 0) {
	$product_notify_list->StopRec = $product_notify->GridAddRowCount;
}

// Initialize aggregate
$product_notify->RowType = ROWTYPE_AGGREGATEINIT;
$product_notify->resetAttributes();
$product_notify_list->renderRow();
while ($product_notify_list->RecCnt < $product_notify_list->StopRec) {
	$product_notify_list->RecCnt++;
	if ($product_notify_list->RecCnt >= $product_notify_list->StartRec) {
		$product_notify_list->RowCnt++;

		// Set up key count
		$product_notify_list->KeyCount = $product_notify_list->RowIndex;

		// Init row class and style
		$product_notify->resetAttributes();
		$product_notify->CssClass = "";
		if ($product_notify->isGridAdd()) {
		} else {
			$product_notify_list->loadRowValues($product_notify_list->Recordset); // Load row values
		}
		$product_notify->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_notify->RowAttrs = array_merge($product_notify->RowAttrs, array('data-rowindex'=>$product_notify_list->RowCnt, 'id'=>'r' . $product_notify_list->RowCnt . '_product_notify', 'data-rowtype'=>$product_notify->RowType));

		// Render row
		$product_notify_list->renderRow();

		// Render list options
		$product_notify_list->renderListOptions();
?>
	<tr<?php echo $product_notify->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_notify_list->ListOptions->render("body", "left", $product_notify_list->RowCnt);
?>
	<?php if ($product_notify->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_notify->id->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify_id" class="product_notify_id">
<span<?php echo $product_notify->id->viewAttributes() ?>>
<?php echo $product_notify->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_notify->_userid->Visible) { // userid ?>
		<td data-name="_userid"<?php echo $product_notify->_userid->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify__userid" class="product_notify__userid">
<span<?php echo $product_notify->_userid->viewAttributes() ?>>
<?php echo $product_notify->_userid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_notify->code->Visible) { // code ?>
		<td data-name="code"<?php echo $product_notify->code->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify_code" class="product_notify_code">
<span<?php echo $product_notify->code->viewAttributes() ?>>
<?php echo $product_notify->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_notify->table_no->Visible) { // table_no ?>
		<td data-name="table_no"<?php echo $product_notify->table_no->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify_table_no" class="product_notify_table_no">
<span<?php echo $product_notify->table_no->viewAttributes() ?>>
<?php echo $product_notify->table_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_notify->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_notify->status->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify_status" class="product_notify_status">
<span<?php echo $product_notify->status->viewAttributes() ?>>
<?php echo $product_notify->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_notify->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_notify->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_notify_list->RowCnt ?>_product_notify_datetime" class="product_notify_datetime">
<span<?php echo $product_notify->datetime->viewAttributes() ?>>
<?php echo $product_notify->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_notify_list->ListOptions->render("body", "right", $product_notify_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_notify->isGridAdd())
		$product_notify_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_notify->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_notify_list->Recordset)
	$product_notify_list->Recordset->Close();
?>
<?php if (!$product_notify->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_notify->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_notify_list->Pager)) $product_notify_list->Pager = new PrevNextPager($product_notify_list->StartRec, $product_notify_list->DisplayRecs, $product_notify_list->TotalRecs, $product_notify_list->AutoHidePager) ?>
<?php if ($product_notify_list->Pager->RecordCount > 0 && $product_notify_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_notify_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_notify_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_notify_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_notify_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_notify_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_notify_list->pageUrl() ?>start=<?php echo $product_notify_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_notify_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_notify_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_notify_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_notify_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_notify_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_notify_list->TotalRecs > 0 && (!$product_notify_list->AutoHidePageSizeSelector || $product_notify_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_notify">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_notify_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_notify_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_notify_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_notify_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_notify_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_notify->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_notify_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_notify_list->TotalRecs == 0 && !$product_notify->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_notify_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_notify_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_notify->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_notify->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_notify", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_notify_list->terminate();
?>