<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_notify_view = new product_notify_view();

// Run the page
$product_notify_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_notify_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_notify->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduct_notifyview = currentForm = new ew.Form("fproduct_notifyview", "view");

// Form_CustomValidate event
fproduct_notifyview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_notifyview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_notifyview.lists["x_status"] = <?php echo $product_notify_view->status->Lookup->toClientList() ?>;
fproduct_notifyview.lists["x_status"].options = <?php echo JsonEncode($product_notify_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_notify->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $product_notify_view->ExportOptions->render("body") ?>
<?php $product_notify_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $product_notify_view->showPageHeader(); ?>
<?php
$product_notify_view->showMessage();
?>
<form name="fproduct_notifyview" id="fproduct_notifyview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_notify_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_notify_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_notify">
<input type="hidden" name="modal" value="<?php echo (int)$product_notify_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_notify->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify_id"><?php echo $product_notify->id->caption() ?></span></td>
		<td data-name="id"<?php echo $product_notify->id->cellAttributes() ?>>
<span id="el_product_notify_id">
<span<?php echo $product_notify->id->viewAttributes() ?>>
<?php echo $product_notify->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_notify->_userid->Visible) { // userid ?>
	<tr id="r__userid">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify__userid"><?php echo $product_notify->_userid->caption() ?></span></td>
		<td data-name="_userid"<?php echo $product_notify->_userid->cellAttributes() ?>>
<span id="el_product_notify__userid">
<span<?php echo $product_notify->_userid->viewAttributes() ?>>
<?php echo $product_notify->_userid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_notify->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify_code"><?php echo $product_notify->code->caption() ?></span></td>
		<td data-name="code"<?php echo $product_notify->code->cellAttributes() ?>>
<span id="el_product_notify_code">
<span<?php echo $product_notify->code->viewAttributes() ?>>
<?php echo $product_notify->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_notify->table_no->Visible) { // table_no ?>
	<tr id="r_table_no">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify_table_no"><?php echo $product_notify->table_no->caption() ?></span></td>
		<td data-name="table_no"<?php echo $product_notify->table_no->cellAttributes() ?>>
<span id="el_product_notify_table_no">
<span<?php echo $product_notify->table_no->viewAttributes() ?>>
<?php echo $product_notify->table_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_notify->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify_status"><?php echo $product_notify->status->caption() ?></span></td>
		<td data-name="status"<?php echo $product_notify->status->cellAttributes() ?>>
<span id="el_product_notify_status">
<span<?php echo $product_notify->status->viewAttributes() ?>>
<?php echo $product_notify->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_notify->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $product_notify_view->TableLeftColumnClass ?>"><span id="elh_product_notify_datetime"><?php echo $product_notify->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $product_notify->datetime->cellAttributes() ?>>
<span id="el_product_notify_datetime">
<span<?php echo $product_notify->datetime->viewAttributes() ?>>
<?php echo $product_notify->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$product_notify_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_notify->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_notify_view->terminate();
?>