<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_refer_edit = new product_refer_edit();

// Run the page
$product_refer_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_refer_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproduct_referedit = currentForm = new ew.Form("fproduct_referedit", "edit");

// Validate form
fproduct_referedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_refer_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->id->caption(), $product_refer->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_refer_edit->_userid->Required) { ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->_userid->caption(), $product_refer->_userid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_refer->_userid->errorMessage()) ?>");
		<?php if ($product_refer_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->url->caption(), $product_refer->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_refer_edit->friend_email->Required) { ?>
			elm = this.getElements("x" + infix + "_friend_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->friend_email->caption(), $product_refer->friend_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_refer_edit->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->product_code->caption(), $product_refer->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_refer->product_code->errorMessage()) ?>");
		<?php if ($product_refer_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->type->caption(), $product_refer->type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_refer->type->errorMessage()) ?>");
		<?php if ($product_refer_edit->comments->Required) { ?>
			elm = this.getElements("x" + infix + "_comments");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->comments->caption(), $product_refer->comments->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_refer_edit->mail_status->Required) { ?>
			elm = this.getElements("x" + infix + "_mail_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->mail_status->caption(), $product_refer->mail_status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mail_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_refer->mail_status->errorMessage()) ?>");
		<?php if ($product_refer_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->datetime->caption(), $product_refer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_refer_edit->product_url->Required) { ?>
			elm = this.getElements("x" + infix + "_product_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_refer->product_url->caption(), $product_refer->product_url->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_referedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_referedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_refer_edit->showPageHeader(); ?>
<?php
$product_refer_edit->showMessage();
?>
<form name="fproduct_referedit" id="fproduct_referedit" class="<?php echo $product_refer_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_refer_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_refer_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_refer">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$product_refer_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($product_refer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_product_refer_id" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->id->caption() ?><?php echo ($product_refer->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->id->cellAttributes() ?>>
<span id="el_product_refer_id">
<span<?php echo $product_refer->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_refer->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="product_refer" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($product_refer->id->CurrentValue) ?>">
<?php echo $product_refer->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->_userid->Visible) { // userid ?>
	<div id="r__userid" class="form-group row">
		<label id="elh_product_refer__userid" for="x__userid" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->_userid->caption() ?><?php echo ($product_refer->_userid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->_userid->cellAttributes() ?>>
<span id="el_product_refer__userid">
<input type="text" data-table="product_refer" data-field="x__userid" name="x__userid" id="x__userid" size="30" placeholder="<?php echo HtmlEncode($product_refer->_userid->getPlaceHolder()) ?>" value="<?php echo $product_refer->_userid->EditValue ?>"<?php echo $product_refer->_userid->editAttributes() ?>>
</span>
<?php echo $product_refer->_userid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_product_refer_url" for="x_url" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->url->caption() ?><?php echo ($product_refer->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->url->cellAttributes() ?>>
<span id="el_product_refer_url">
<textarea data-table="product_refer" data-field="x_url" name="x_url" id="x_url" cols="35" rows="4" placeholder="<?php echo HtmlEncode($product_refer->url->getPlaceHolder()) ?>"<?php echo $product_refer->url->editAttributes() ?>><?php echo $product_refer->url->EditValue ?></textarea>
</span>
<?php echo $product_refer->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->friend_email->Visible) { // friend_email ?>
	<div id="r_friend_email" class="form-group row">
		<label id="elh_product_refer_friend_email" for="x_friend_email" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->friend_email->caption() ?><?php echo ($product_refer->friend_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->friend_email->cellAttributes() ?>>
<span id="el_product_refer_friend_email">
<input type="text" data-table="product_refer" data-field="x_friend_email" name="x_friend_email" id="x_friend_email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($product_refer->friend_email->getPlaceHolder()) ?>" value="<?php echo $product_refer->friend_email->EditValue ?>"<?php echo $product_refer->friend_email->editAttributes() ?>>
</span>
<?php echo $product_refer->friend_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_product_refer_product_code" for="x_product_code" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->product_code->caption() ?><?php echo ($product_refer->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->product_code->cellAttributes() ?>>
<span id="el_product_refer_product_code">
<input type="text" data-table="product_refer" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" placeholder="<?php echo HtmlEncode($product_refer->product_code->getPlaceHolder()) ?>" value="<?php echo $product_refer->product_code->EditValue ?>"<?php echo $product_refer->product_code->editAttributes() ?>>
</span>
<?php echo $product_refer->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_product_refer_type" for="x_type" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->type->caption() ?><?php echo ($product_refer->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->type->cellAttributes() ?>>
<span id="el_product_refer_type">
<input type="text" data-table="product_refer" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($product_refer->type->getPlaceHolder()) ?>" value="<?php echo $product_refer->type->EditValue ?>"<?php echo $product_refer->type->editAttributes() ?>>
</span>
<?php echo $product_refer->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label id="elh_product_refer_comments" for="x_comments" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->comments->caption() ?><?php echo ($product_refer->comments->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->comments->cellAttributes() ?>>
<span id="el_product_refer_comments">
<input type="text" data-table="product_refer" data-field="x_comments" name="x_comments" id="x_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($product_refer->comments->getPlaceHolder()) ?>" value="<?php echo $product_refer->comments->EditValue ?>"<?php echo $product_refer->comments->editAttributes() ?>>
</span>
<?php echo $product_refer->comments->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->mail_status->Visible) { // mail_status ?>
	<div id="r_mail_status" class="form-group row">
		<label id="elh_product_refer_mail_status" for="x_mail_status" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->mail_status->caption() ?><?php echo ($product_refer->mail_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->mail_status->cellAttributes() ?>>
<span id="el_product_refer_mail_status">
<input type="text" data-table="product_refer" data-field="x_mail_status" name="x_mail_status" id="x_mail_status" size="30" placeholder="<?php echo HtmlEncode($product_refer->mail_status->getPlaceHolder()) ?>" value="<?php echo $product_refer->mail_status->EditValue ?>"<?php echo $product_refer->mail_status->editAttributes() ?>>
</span>
<?php echo $product_refer->mail_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_refer->product_url->Visible) { // product_url ?>
	<div id="r_product_url" class="form-group row">
		<label id="elh_product_refer_product_url" for="x_product_url" class="<?php echo $product_refer_edit->LeftColumnClass ?>"><?php echo $product_refer->product_url->caption() ?><?php echo ($product_refer->product_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_refer_edit->RightColumnClass ?>"><div<?php echo $product_refer->product_url->cellAttributes() ?>>
<span id="el_product_refer_product_url">
<textarea data-table="product_refer" data-field="x_product_url" name="x_product_url" id="x_product_url" cols="35" rows="4" placeholder="<?php echo HtmlEncode($product_refer->product_url->getPlaceHolder()) ?>"<?php echo $product_refer->product_url->editAttributes() ?>><?php echo $product_refer->product_url->EditValue ?></textarea>
</span>
<?php echo $product_refer->product_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_refer_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_refer_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_refer_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_refer_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_refer_edit->terminate();
?>