<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_type_list = new product_type_list();

// Run the page
$product_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_typelist = currentForm = new ew.Form("fproduct_typelist", "list");
fproduct_typelist.formKeyCountName = '<?php echo $product_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_typelist.lists["x_status"] = <?php echo $product_type_list->status->Lookup->toClientList() ?>;
fproduct_typelist.lists["x_status"].options = <?php echo JsonEncode($product_type_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fproduct_typelistsrch = currentSearchForm = new ew.Form("fproduct_typelistsrch");

// Filters
fproduct_typelistsrch.filterList = <?php echo $product_type_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_type_list->TotalRecs > 0 && $product_type_list->ExportOptions->visible()) { ?>
<?php $product_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_type_list->ImportOptions->visible()) { ?>
<?php $product_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_type_list->SearchOptions->visible()) { ?>
<?php $product_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_type_list->FilterOptions->visible()) { ?>
<?php $product_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_type->isExport() && !$product_type->CurrentAction) { ?>
<form name="fproduct_typelistsrch" id="fproduct_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_type_list->showPageHeader(); ?>
<?php
$product_type_list->showMessage();
?>
<?php if ($product_type_list->TotalRecs > 0 || $product_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_type">
<?php if (!$product_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_type_list->Pager)) $product_type_list->Pager = new PrevNextPager($product_type_list->StartRec, $product_type_list->DisplayRecs, $product_type_list->TotalRecs, $product_type_list->AutoHidePager) ?>
<?php if ($product_type_list->Pager->RecordCount > 0 && $product_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_type_list->TotalRecs > 0 && (!$product_type_list->AutoHidePageSizeSelector || $product_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_typelist" id="fproduct_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_type">
<div id="gmp_product_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_type_list->TotalRecs > 0 || $product_type->isGridEdit()) { ?>
<table id="tbl_product_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_type_list->renderListOptions();

// Render list options (header, left)
$product_type_list->ListOptions->render("header", "left");
?>
<?php if ($product_type->id->Visible) { // id ?>
	<?php if ($product_type->sortUrl($product_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_type->id->headerCellClass() ?>"><div id="elh_product_type_id" class="product_type_id"><div class="ew-table-header-caption"><?php echo $product_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_type->SortUrl($product_type->id) ?>',2);"><div id="elh_product_type_id" class="product_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_type->item->Visible) { // item ?>
	<?php if ($product_type->sortUrl($product_type->item) == "") { ?>
		<th data-name="item" class="<?php echo $product_type->item->headerCellClass() ?>"><div id="elh_product_type_item" class="product_type_item"><div class="ew-table-header-caption"><?php echo $product_type->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $product_type->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_type->SortUrl($product_type->item) ?>',2);"><div id="elh_product_type_item" class="product_type_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_type->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_type->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_type->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_type->status->Visible) { // status ?>
	<?php if ($product_type->sortUrl($product_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_type->status->headerCellClass() ?>"><div id="elh_product_type_status" class="product_type_status"><div class="ew-table-header-caption"><?php echo $product_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_type->SortUrl($product_type->status) ?>',2);"><div id="elh_product_type_status" class="product_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_type->operator->Visible) { // operator ?>
	<?php if ($product_type->sortUrl($product_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_type->operator->headerCellClass() ?>"><div id="elh_product_type_operator" class="product_type_operator"><div class="ew-table-header-caption"><?php echo $product_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_type->SortUrl($product_type->operator) ?>',2);"><div id="elh_product_type_operator" class="product_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_type->datetime->Visible) { // datetime ?>
	<?php if ($product_type->sortUrl($product_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_type->datetime->headerCellClass() ?>"><div id="elh_product_type_datetime" class="product_type_datetime"><div class="ew-table-header-caption"><?php echo $product_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_type->SortUrl($product_type->datetime) ?>',2);"><div id="elh_product_type_datetime" class="product_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_type->ExportAll && $product_type->isExport()) {
	$product_type_list->StopRec = $product_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_type_list->TotalRecs > $product_type_list->StartRec + $product_type_list->DisplayRecs - 1)
		$product_type_list->StopRec = $product_type_list->StartRec + $product_type_list->DisplayRecs - 1;
	else
		$product_type_list->StopRec = $product_type_list->TotalRecs;
}
$product_type_list->RecCnt = $product_type_list->StartRec - 1;
if ($product_type_list->Recordset && !$product_type_list->Recordset->EOF) {
	$product_type_list->Recordset->moveFirst();
	$selectLimit = $product_type_list->UseSelectLimit;
	if (!$selectLimit && $product_type_list->StartRec > 1)
		$product_type_list->Recordset->move($product_type_list->StartRec - 1);
} elseif (!$product_type->AllowAddDeleteRow && $product_type_list->StopRec == 0) {
	$product_type_list->StopRec = $product_type->GridAddRowCount;
}

// Initialize aggregate
$product_type->RowType = ROWTYPE_AGGREGATEINIT;
$product_type->resetAttributes();
$product_type_list->renderRow();
while ($product_type_list->RecCnt < $product_type_list->StopRec) {
	$product_type_list->RecCnt++;
	if ($product_type_list->RecCnt >= $product_type_list->StartRec) {
		$product_type_list->RowCnt++;

		// Set up key count
		$product_type_list->KeyCount = $product_type_list->RowIndex;

		// Init row class and style
		$product_type->resetAttributes();
		$product_type->CssClass = "";
		if ($product_type->isGridAdd()) {
		} else {
			$product_type_list->loadRowValues($product_type_list->Recordset); // Load row values
		}
		$product_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_type->RowAttrs = array_merge($product_type->RowAttrs, array('data-rowindex'=>$product_type_list->RowCnt, 'id'=>'r' . $product_type_list->RowCnt . '_product_type', 'data-rowtype'=>$product_type->RowType));

		// Render row
		$product_type_list->renderRow();

		// Render list options
		$product_type_list->renderListOptions();
?>
	<tr<?php echo $product_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_type_list->ListOptions->render("body", "left", $product_type_list->RowCnt);
?>
	<?php if ($product_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_type->id->cellAttributes() ?>>
<span id="el<?php echo $product_type_list->RowCnt ?>_product_type_id" class="product_type_id">
<span<?php echo $product_type->id->viewAttributes() ?>>
<?php echo $product_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_type->item->Visible) { // item ?>
		<td data-name="item"<?php echo $product_type->item->cellAttributes() ?>>
<span id="el<?php echo $product_type_list->RowCnt ?>_product_type_item" class="product_type_item">
<span<?php echo $product_type->item->viewAttributes() ?>>
<?php echo $product_type->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_type->status->cellAttributes() ?>>
<span id="el<?php echo $product_type_list->RowCnt ?>_product_type_status" class="product_type_status">
<span<?php echo $product_type->status->viewAttributes() ?>>
<?php echo $product_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_type->operator->cellAttributes() ?>>
<span id="el<?php echo $product_type_list->RowCnt ?>_product_type_operator" class="product_type_operator">
<span<?php echo $product_type->operator->viewAttributes() ?>>
<?php echo $product_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_type_list->RowCnt ?>_product_type_datetime" class="product_type_datetime">
<span<?php echo $product_type->datetime->viewAttributes() ?>>
<?php echo $product_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_type_list->ListOptions->render("body", "right", $product_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_type->isGridAdd())
		$product_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_type_list->Recordset)
	$product_type_list->Recordset->Close();
?>
<?php if (!$product_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_type_list->Pager)) $product_type_list->Pager = new PrevNextPager($product_type_list->StartRec, $product_type_list->DisplayRecs, $product_type_list->TotalRecs, $product_type_list->AutoHidePager) ?>
<?php if ($product_type_list->Pager->RecordCount > 0 && $product_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_type_list->pageUrl() ?>start=<?php echo $product_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_type_list->TotalRecs > 0 && (!$product_type_list->AutoHidePageSizeSelector || $product_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_type_list->TotalRecs == 0 && !$product_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_type_list->terminate();
?>