<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_type_view = new product_type_view();

// Run the page
$product_type_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_type_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduct_typeview = currentForm = new ew.Form("fproduct_typeview", "view");

// Form_CustomValidate event
fproduct_typeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_typeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_typeview.lists["x_status"] = <?php echo $product_type_view->status->Lookup->toClientList() ?>;
fproduct_typeview.lists["x_status"].options = <?php echo JsonEncode($product_type_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $product_type_view->ExportOptions->render("body") ?>
<?php $product_type_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $product_type_view->showPageHeader(); ?>
<?php
$product_type_view->showMessage();
?>
<form name="fproduct_typeview" id="fproduct_typeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_type_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_type_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_type">
<input type="hidden" name="modal" value="<?php echo (int)$product_type_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_type->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $product_type_view->TableLeftColumnClass ?>"><span id="elh_product_type_id"><?php echo $product_type->id->caption() ?></span></td>
		<td data-name="id"<?php echo $product_type->id->cellAttributes() ?>>
<span id="el_product_type_id">
<span<?php echo $product_type->id->viewAttributes() ?>>
<?php echo $product_type->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_type->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $product_type_view->TableLeftColumnClass ?>"><span id="elh_product_type_item"><?php echo $product_type->item->caption() ?></span></td>
		<td data-name="item"<?php echo $product_type->item->cellAttributes() ?>>
<span id="el_product_type_item">
<span<?php echo $product_type->item->viewAttributes() ?>>
<?php echo $product_type->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_type->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $product_type_view->TableLeftColumnClass ?>"><span id="elh_product_type_status"><?php echo $product_type->status->caption() ?></span></td>
		<td data-name="status"<?php echo $product_type->status->cellAttributes() ?>>
<span id="el_product_type_status">
<span<?php echo $product_type->status->viewAttributes() ?>>
<?php echo $product_type->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_type->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $product_type_view->TableLeftColumnClass ?>"><span id="elh_product_type_operator"><?php echo $product_type->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $product_type->operator->cellAttributes() ?>>
<span id="el_product_type_operator">
<span<?php echo $product_type->operator->viewAttributes() ?>>
<?php echo $product_type->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_type->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $product_type_view->TableLeftColumnClass ?>"><span id="elh_product_type_datetime"><?php echo $product_type->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $product_type->datetime->cellAttributes() ?>>
<span id="el_product_type_datetime">
<span<?php echo $product_type->datetime->viewAttributes() ?>>
<?php echo $product_type->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$product_type_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_type_view->terminate();
?>