<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_addopt = new product_addopt();

// Run the page
$product_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fproductaddopt = currentForm = new ew.Form("fproductaddopt", "addopt");

// Validate form
fproductaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->grp->caption(), $product->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->s_grp->caption(), $product->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->product->caption(), $product->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product->product->errorMessage()) ?>");
		<?php if ($product_addopt->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->publish->caption(), $product->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $product->image->caption(), $product->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->status->caption(), $product->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->remarks->caption(), $product->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->company_id->caption(), $product->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->prod_capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_prod_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->prod_capacity->caption(), $product->prod_capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_prod_capacity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product->prod_capacity->errorMessage()) ?>");
		<?php if ($product_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->operator->caption(), $product->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->datetime->caption(), $product->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproductaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproductaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproductaddopt.lists["x_grp[]"] = <?php echo $product_addopt->grp->Lookup->toClientList() ?>;
fproductaddopt.lists["x_grp[]"].options = <?php echo JsonEncode($product_addopt->grp->lookupOptions()) ?>;
fproductaddopt.lists["x_s_grp[]"] = <?php echo $product_addopt->s_grp->Lookup->toClientList() ?>;
fproductaddopt.lists["x_s_grp[]"].options = <?php echo JsonEncode($product_addopt->s_grp->lookupOptions()) ?>;
fproductaddopt.lists["x_publish"] = <?php echo $product_addopt->publish->Lookup->toClientList() ?>;
fproductaddopt.lists["x_publish"].options = <?php echo JsonEncode($product_addopt->publish->options(FALSE, TRUE)) ?>;
fproductaddopt.lists["x_status"] = <?php echo $product_addopt->status->Lookup->toClientList() ?>;
fproductaddopt.lists["x_status"].options = <?php echo JsonEncode($product_addopt->status->options(FALSE, TRUE)) ?>;
fproductaddopt.lists["x_company_id"] = <?php echo $product_addopt->company_id->Lookup->toClientList() ?>;
fproductaddopt.lists["x_company_id"].options = <?php echo JsonEncode($product_addopt->company_id->lookupOptions()) ?>;
fproductaddopt.lists["x_operator"] = <?php echo $product_addopt->operator->Lookup->toClientList() ?>;
fproductaddopt.lists["x_operator"].options = <?php echo JsonEncode($product_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_addopt->showPageHeader(); ?>
<?php
$product_addopt->showMessage();
?>
<form name="fproductaddopt" id="fproductaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($product_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $product_addopt->TableVar ?>">
<?php if ($product->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $product->grp->caption() ?><?php echo ($product->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $product->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$product->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_grp" data-value-separator="<?php echo $product->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $product->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $product->s_grp->caption() ?><?php echo ($product->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_s_grp" data-value-separator="<?php echo $product->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $product->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $product->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $product->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $product->product->caption() ?><?php echo ($product->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->product->getPlaceHolder()) ?>" value="<?php echo $product->product->EditValue ?>"<?php echo $product->product->editAttributes() ?>>
<?php echo $product->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->publish->Visible) { // publish ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_publish"><?php echo $product->publish->caption() ?><?php echo ($product->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_publish" data-value-separator="<?php echo $product->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $product->publish->editAttributes() ?>>
		<?php echo $product->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
<?php echo $product->publish->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->image->Visible) { // image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $product->image->caption() ?><?php echo ($product->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_image">
<span title="<?php echo $product->image->title() ? $product->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($product->image->ReadOnly || $product->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="product" data-field="x_image" name="x_image" id="x_image"<?php echo $product->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $product->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="192">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $product->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $product->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $product->image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $product->status->caption() ?><?php echo ($product->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_status" data-value-separator="<?php echo $product->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product->status->editAttributes() ?>>
		<?php echo $product->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $product->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $product->remarks->caption() ?><?php echo ($product->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->remarks->getPlaceHolder()) ?>" value="<?php echo $product->remarks->EditValue ?>"<?php echo $product->remarks->editAttributes() ?>>
<?php echo $product->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $product->company_id->caption() ?><?php echo ($product->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_company_id" data-value-separator="<?php echo $product->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product->company_id->editAttributes() ?>>
		<?php echo $product->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product->company_id->Lookup->getParamTag("p_x_company_id") ?>
<?php echo $product->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->prod_capacity->Visible) { // prod_capacity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_prod_capacity"><?php echo $product->prod_capacity->caption() ?><?php echo ($product->prod_capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product" data-field="x_prod_capacity" name="x_prod_capacity" id="x_prod_capacity" size="30" placeholder="<?php echo HtmlEncode($product->prod_capacity->getPlaceHolder()) ?>" value="<?php echo $product->prod_capacity->EditValue ?>"<?php echo $product->prod_capacity->editAttributes() ?>>
<?php echo $product->prod_capacity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product->operator->Visible) { // operator ?>
	<input type="hidden" data-table="product" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($product->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($product->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="product" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($product->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$product_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$product_addopt->terminate();
?>