<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_edit = new product_edit();

// Run the page
$product_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproductedit = currentForm = new ew.Form("fproductedit", "edit");

// Validate form
fproductedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->id->caption(), $product->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->grp->caption(), $product->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->s_grp->caption(), $product->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->product->caption(), $product->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product->product->errorMessage()) ?>");
		<?php if ($product_edit->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->publish->caption(), $product->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $product->image->caption(), $product->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->status->caption(), $product->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->remarks->caption(), $product->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->company_id->caption(), $product->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->prod_capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_prod_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->prod_capacity->caption(), $product->prod_capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_prod_capacity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product->prod_capacity->errorMessage()) ?>");
		<?php if ($product_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->operator->caption(), $product->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product->datetime->caption(), $product->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproductedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproductedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproductedit.lists["x_grp[]"] = <?php echo $product_edit->grp->Lookup->toClientList() ?>;
fproductedit.lists["x_grp[]"].options = <?php echo JsonEncode($product_edit->grp->lookupOptions()) ?>;
fproductedit.lists["x_s_grp[]"] = <?php echo $product_edit->s_grp->Lookup->toClientList() ?>;
fproductedit.lists["x_s_grp[]"].options = <?php echo JsonEncode($product_edit->s_grp->lookupOptions()) ?>;
fproductedit.lists["x_publish"] = <?php echo $product_edit->publish->Lookup->toClientList() ?>;
fproductedit.lists["x_publish"].options = <?php echo JsonEncode($product_edit->publish->options(FALSE, TRUE)) ?>;
fproductedit.lists["x_status"] = <?php echo $product_edit->status->Lookup->toClientList() ?>;
fproductedit.lists["x_status"].options = <?php echo JsonEncode($product_edit->status->options(FALSE, TRUE)) ?>;
fproductedit.lists["x_company_id"] = <?php echo $product_edit->company_id->Lookup->toClientList() ?>;
fproductedit.lists["x_company_id"].options = <?php echo JsonEncode($product_edit->company_id->lookupOptions()) ?>;
fproductedit.lists["x_operator"] = <?php echo $product_edit->operator->Lookup->toClientList() ?>;
fproductedit.lists["x_operator"].options = <?php echo JsonEncode($product_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_edit->showPageHeader(); ?>
<?php
$product_edit->showMessage();
?>
<form name="fproductedit" id="fproductedit" class="<?php echo $product_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$product_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($product->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_product_id" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->id->caption() ?><?php echo ($product->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->id->cellAttributes() ?>>
<span id="el_product_id">
<span<?php echo $product->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="product" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($product->id->CurrentValue) ?>">
<?php echo $product->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_product_grp" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->grp->caption() ?><?php echo ($product->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->grp->cellAttributes() ?>>
<span id="el_product_grp">
<?php $product->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$product->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_grp" data-value-separator="<?php echo $product->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $product->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_product_s_grp" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->s_grp->caption() ?><?php echo ($product->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->s_grp->cellAttributes() ?>>
<span id="el_product_s_grp">
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_s_grp" data-value-separator="<?php echo $product->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $product->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $product->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $product->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_product_product" for="x_product" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->product->caption() ?><?php echo ($product->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->product->cellAttributes() ?>>
<span id="el_product_product">
<input type="text" data-table="product" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->product->getPlaceHolder()) ?>" value="<?php echo $product->product->EditValue ?>"<?php echo $product->product->editAttributes() ?>>
</span>
<?php echo $product->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label id="elh_product_publish" for="x_publish" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->publish->caption() ?><?php echo ($product->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->publish->cellAttributes() ?>>
<span id="el_product_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_publish" data-value-separator="<?php echo $product->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $product->publish->editAttributes() ?>>
		<?php echo $product->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
<?php echo $product->publish->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_product_image" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->image->caption() ?><?php echo ($product->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->image->cellAttributes() ?>>
<span id="el_product_image">
<div id="fd_x_image">
<span title="<?php echo $product->image->title() ? $product->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($product->image->ReadOnly || $product->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="product" data-field="x_image" name="x_image" id="x_image"<?php echo $product->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $product->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="192">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $product->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $product->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $product->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_status" for="x_status" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->status->caption() ?><?php echo ($product->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->status->cellAttributes() ?>>
<span id="el_product_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_status" data-value-separator="<?php echo $product->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product->status->editAttributes() ?>>
		<?php echo $product->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $product->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_product_remarks" for="x_remarks" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->remarks->caption() ?><?php echo ($product->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->remarks->cellAttributes() ?>>
<span id="el_product_remarks">
<input type="text" data-table="product" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->remarks->getPlaceHolder()) ?>" value="<?php echo $product->remarks->EditValue ?>"<?php echo $product->remarks->editAttributes() ?>>
</span>
<?php echo $product->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_product_company_id" for="x_company_id" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->company_id->caption() ?><?php echo ($product->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->company_id->cellAttributes() ?>>
<span id="el_product_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_company_id" data-value-separator="<?php echo $product->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product->company_id->editAttributes() ?>>
		<?php echo $product->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $product->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product->prod_capacity->Visible) { // prod_capacity ?>
	<div id="r_prod_capacity" class="form-group row">
		<label id="elh_product_prod_capacity" for="x_prod_capacity" class="<?php echo $product_edit->LeftColumnClass ?>"><?php echo $product->prod_capacity->caption() ?><?php echo ($product->prod_capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_edit->RightColumnClass ?>"><div<?php echo $product->prod_capacity->cellAttributes() ?>>
<span id="el_product_prod_capacity">
<input type="text" data-table="product" data-field="x_prod_capacity" name="x_prod_capacity" id="x_prod_capacity" size="30" placeholder="<?php echo HtmlEncode($product->prod_capacity->getPlaceHolder()) ?>" value="<?php echo $product->prod_capacity->EditValue ?>"<?php echo $product->prod_capacity->editAttributes() ?>>
</span>
<?php echo $product->prod_capacity->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_edit->terminate();
?>