<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_c_view = new production_employee_c_view();

// Run the page
$production_employee_c_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_c_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee_c->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_employee_cview = currentForm = new ew.Form("fproduction_employee_cview", "view");

// Form_CustomValidate event
fproduction_employee_cview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employee_cview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employee_cview.lists["x_grp"] = <?php echo $production_employee_c_view->grp->Lookup->toClientList() ?>;
fproduction_employee_cview.lists["x_grp"].options = <?php echo JsonEncode($production_employee_c_view->grp->options(FALSE, TRUE)) ?>;
fproduction_employee_cview.lists["x_site"] = <?php echo $production_employee_c_view->site->Lookup->toClientList() ?>;
fproduction_employee_cview.lists["x_site"].options = <?php echo JsonEncode($production_employee_c_view->site->lookupOptions()) ?>;
fproduction_employee_cview.lists["x_process[]"] = <?php echo $production_employee_c_view->process->Lookup->toClientList() ?>;
fproduction_employee_cview.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_c_view->process->lookupOptions()) ?>;
fproduction_employee_cview.lists["x_status"] = <?php echo $production_employee_c_view->status->Lookup->toClientList() ?>;
fproduction_employee_cview.lists["x_status"].options = <?php echo JsonEncode($production_employee_c_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_employee_c->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_employee_c_view->ExportOptions->render("body") ?>
<?php $production_employee_c_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_employee_c_view->showPageHeader(); ?>
<?php
$production_employee_c_view->showMessage();
?>
<form name="fproduction_employee_cview" id="fproduction_employee_cview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_c_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_c_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee_c">
<input type="hidden" name="modal" value="<?php echo (int)$production_employee_c_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_employee_c->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_grp"><?php echo $production_employee_c->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_employee_c->grp->cellAttributes() ?>>
<span id="el_production_employee_c_grp">
<span<?php echo $production_employee_c->grp->viewAttributes() ?>>
<?php echo $production_employee_c->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_id"><?php echo $production_employee_c->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_employee_c->id->cellAttributes() ?>>
<span id="el_production_employee_c_id">
<span<?php echo $production_employee_c->id->viewAttributes() ?>>
<?php echo $production_employee_c->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->site->Visible) { // site ?>
	<tr id="r_site">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_site"><?php echo $production_employee_c->site->caption() ?></span></td>
		<td data-name="site"<?php echo $production_employee_c->site->cellAttributes() ?>>
<span id="el_production_employee_c_site">
<span<?php echo $production_employee_c->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_c->site->getViewValue())) && $production_employee_c->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_c->site->linkAttributes() ?>><?php echo $production_employee_c->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_c->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->user_name->Visible) { // user_name ?>
	<tr id="r_user_name">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_user_name"><?php echo $production_employee_c->user_name->caption() ?></span></td>
		<td data-name="user_name"<?php echo $production_employee_c->user_name->cellAttributes() ?>>
<span id="el_production_employee_c_user_name">
<span<?php echo $production_employee_c->user_name->viewAttributes() ?>>
<?php echo $production_employee_c->user_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_address"><?php echo $production_employee_c->address->caption() ?></span></td>
		<td data-name="address"<?php echo $production_employee_c->address->cellAttributes() ?>>
<span id="el_production_employee_c_address">
<span<?php echo $production_employee_c->address->viewAttributes() ?>>
<?php echo $production_employee_c->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_mobile"><?php echo $production_employee_c->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $production_employee_c->mobile->cellAttributes() ?>>
<span id="el_production_employee_c_mobile">
<span<?php echo $production_employee_c->mobile->viewAttributes() ?>>
<?php echo $production_employee_c->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_process"><?php echo $production_employee_c->process->caption() ?></span></td>
		<td data-name="process"<?php echo $production_employee_c->process->cellAttributes() ?>>
<span id="el_production_employee_c_process">
<span<?php echo $production_employee_c->process->viewAttributes() ?>>
<?php echo $production_employee_c->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_status"><?php echo $production_employee_c->status->caption() ?></span></td>
		<td data-name="status"<?php echo $production_employee_c->status->cellAttributes() ?>>
<span id="el_production_employee_c_status">
<span<?php echo $production_employee_c->status->viewAttributes() ?>>
<?php echo $production_employee_c->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_operator"><?php echo $production_employee_c->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_employee_c->operator->cellAttributes() ?>>
<span id="el_production_employee_c_operator">
<span<?php echo $production_employee_c->operator->viewAttributes() ?>>
<?php echo $production_employee_c->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_c->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_employee_c_view->TableLeftColumnClass ?>"><span id="elh_production_employee_c_datetime"><?php echo $production_employee_c->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_employee_c->datetime->cellAttributes() ?>>
<span id="el_production_employee_c_datetime">
<span<?php echo $production_employee_c->datetime->viewAttributes() ?>>
<?php echo $production_employee_c->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$production_employee_c_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee_c->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_c_view->terminate();
?>