<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_fp_list = new production_employee_fp_list();

// Run the page
$production_employee_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_employee_fplist = currentForm = new ew.Form("fproduction_employee_fplist", "list");
fproduction_employee_fplist.formKeyCountName = '<?php echo $production_employee_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_employee_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employee_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employee_fplist.lists["x_grp"] = <?php echo $production_employee_fp_list->grp->Lookup->toClientList() ?>;
fproduction_employee_fplist.lists["x_grp"].options = <?php echo JsonEncode($production_employee_fp_list->grp->options(FALSE, TRUE)) ?>;
fproduction_employee_fplist.lists["x_site"] = <?php echo $production_employee_fp_list->site->Lookup->toClientList() ?>;
fproduction_employee_fplist.lists["x_site"].options = <?php echo JsonEncode($production_employee_fp_list->site->lookupOptions()) ?>;
fproduction_employee_fplist.lists["x_process[]"] = <?php echo $production_employee_fp_list->process->Lookup->toClientList() ?>;
fproduction_employee_fplist.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_fp_list->process->lookupOptions()) ?>;
fproduction_employee_fplist.lists["x_status"] = <?php echo $production_employee_fp_list->status->Lookup->toClientList() ?>;
fproduction_employee_fplist.lists["x_status"].options = <?php echo JsonEncode($production_employee_fp_list->status->options(FALSE, TRUE)) ?>;
fproduction_employee_fplist.lists["x_operator"] = <?php echo $production_employee_fp_list->operator->Lookup->toClientList() ?>;
fproduction_employee_fplist.lists["x_operator"].options = <?php echo JsonEncode($production_employee_fp_list->operator->lookupOptions()) ?>;
fproduction_employee_fplist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fproduction_employee_fplistsrch = currentSearchForm = new ew.Form("fproduction_employee_fplistsrch");

// Filters
fproduction_employee_fplistsrch.filterList = <?php echo $production_employee_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_employee_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_employee_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_employee_fp_list->TotalRecs > 0 && $production_employee_fp_list->ExportOptions->visible()) { ?>
<?php $production_employee_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_fp_list->ImportOptions->visible()) { ?>
<?php $production_employee_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_fp_list->SearchOptions->visible()) { ?>
<?php $production_employee_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_fp_list->FilterOptions->visible()) { ?>
<?php $production_employee_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_employee_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_employee_fp->isExport() && !$production_employee_fp->CurrentAction) { ?>
<form name="fproduction_employee_fplistsrch" id="fproduction_employee_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_employee_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_employee_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_employee_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_employee_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_employee_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_employee_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_employee_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_employee_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_employee_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_employee_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_employee_fp_list->showPageHeader(); ?>
<?php
$production_employee_fp_list->showMessage();
?>
<?php if ($production_employee_fp_list->TotalRecs > 0 || $production_employee_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_employee_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_employee_fp">
<?php if (!$production_employee_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_employee_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_fp_list->Pager)) $production_employee_fp_list->Pager = new PrevNextPager($production_employee_fp_list->StartRec, $production_employee_fp_list->DisplayRecs, $production_employee_fp_list->TotalRecs, $production_employee_fp_list->AutoHidePager) ?>
<?php if ($production_employee_fp_list->Pager->RecordCount > 0 && $production_employee_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_fp_list->TotalRecs > 0 && (!$production_employee_fp_list->AutoHidePageSizeSelector || $production_employee_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_employee_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_employee_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_employee_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_employee_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_employee_fplist" id="fproduction_employee_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee_fp">
<div id="gmp_production_employee_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_employee_fp_list->TotalRecs > 0 || $production_employee_fp->isGridEdit()) { ?>
<table id="tbl_production_employee_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_employee_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_employee_fp_list->renderListOptions();

// Render list options (header, left)
$production_employee_fp_list->ListOptions->render("header", "left");
?>
<?php if ($production_employee_fp->grp->Visible) { // grp ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $production_employee_fp->grp->headerCellClass() ?>"><div id="elh_production_employee_fp_grp" class="production_employee_fp_grp"><div class="ew-table-header-caption"><?php echo $production_employee_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $production_employee_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->grp) ?>',2);"><div id="elh_production_employee_fp_grp" class="production_employee_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->id->Visible) { // id ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_employee_fp->id->headerCellClass() ?>"><div id="elh_production_employee_fp_id" class="production_employee_fp_id"><div class="ew-table-header-caption"><?php echo $production_employee_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_employee_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->id) ?>',2);"><div id="elh_production_employee_fp_id" class="production_employee_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->site->Visible) { // site ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->site) == "") { ?>
		<th data-name="site" class="<?php echo $production_employee_fp->site->headerCellClass() ?>"><div id="elh_production_employee_fp_site" class="production_employee_fp_site"><div class="ew-table-header-caption"><?php echo $production_employee_fp->site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="site" class="<?php echo $production_employee_fp->site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->site) ?>',2);"><div id="elh_production_employee_fp_site" class="production_employee_fp_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->site->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->user_name->Visible) { // user_name ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->user_name) == "") { ?>
		<th data-name="user_name" class="<?php echo $production_employee_fp->user_name->headerCellClass() ?>"><div id="elh_production_employee_fp_user_name" class="production_employee_fp_user_name"><div class="ew-table-header-caption"><?php echo $production_employee_fp->user_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_name" class="<?php echo $production_employee_fp->user_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->user_name) ?>',2);"><div id="elh_production_employee_fp_user_name" class="production_employee_fp_user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->user_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->user_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->user_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->mobile->Visible) { // mobile ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $production_employee_fp->mobile->headerCellClass() ?>"><div id="elh_production_employee_fp_mobile" class="production_employee_fp_mobile"><div class="ew-table-header-caption"><?php echo $production_employee_fp->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $production_employee_fp->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->mobile) ?>',2);"><div id="elh_production_employee_fp_mobile" class="production_employee_fp_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->process->Visible) { // process ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->process) == "") { ?>
		<th data-name="process" class="<?php echo $production_employee_fp->process->headerCellClass() ?>"><div id="elh_production_employee_fp_process" class="production_employee_fp_process"><div class="ew-table-header-caption"><?php echo $production_employee_fp->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $production_employee_fp->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->process) ?>',2);"><div id="elh_production_employee_fp_process" class="production_employee_fp_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->status->Visible) { // status ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->status) == "") { ?>
		<th data-name="status" class="<?php echo $production_employee_fp->status->headerCellClass() ?>"><div id="elh_production_employee_fp_status" class="production_employee_fp_status"><div class="ew-table-header-caption"><?php echo $production_employee_fp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $production_employee_fp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->status) ?>',2);"><div id="elh_production_employee_fp_status" class="production_employee_fp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->operator->Visible) { // operator ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_employee_fp->operator->headerCellClass() ?>"><div id="elh_production_employee_fp_operator" class="production_employee_fp_operator"><div class="ew-table-header-caption"><?php echo $production_employee_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_employee_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->operator) ?>',2);"><div id="elh_production_employee_fp_operator" class="production_employee_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_fp->datetime->Visible) { // datetime ?>
	<?php if ($production_employee_fp->sortUrl($production_employee_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_employee_fp->datetime->headerCellClass() ?>"><div id="elh_production_employee_fp_datetime" class="production_employee_fp_datetime"><div class="ew-table-header-caption"><?php echo $production_employee_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_employee_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_fp->SortUrl($production_employee_fp->datetime) ?>',2);"><div id="elh_production_employee_fp_datetime" class="production_employee_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_employee_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_employee_fp->ExportAll && $production_employee_fp->isExport()) {
	$production_employee_fp_list->StopRec = $production_employee_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_employee_fp_list->TotalRecs > $production_employee_fp_list->StartRec + $production_employee_fp_list->DisplayRecs - 1)
		$production_employee_fp_list->StopRec = $production_employee_fp_list->StartRec + $production_employee_fp_list->DisplayRecs - 1;
	else
		$production_employee_fp_list->StopRec = $production_employee_fp_list->TotalRecs;
}
$production_employee_fp_list->RecCnt = $production_employee_fp_list->StartRec - 1;
if ($production_employee_fp_list->Recordset && !$production_employee_fp_list->Recordset->EOF) {
	$production_employee_fp_list->Recordset->moveFirst();
	$selectLimit = $production_employee_fp_list->UseSelectLimit;
	if (!$selectLimit && $production_employee_fp_list->StartRec > 1)
		$production_employee_fp_list->Recordset->move($production_employee_fp_list->StartRec - 1);
} elseif (!$production_employee_fp->AllowAddDeleteRow && $production_employee_fp_list->StopRec == 0) {
	$production_employee_fp_list->StopRec = $production_employee_fp->GridAddRowCount;
}

// Initialize aggregate
$production_employee_fp->RowType = ROWTYPE_AGGREGATEINIT;
$production_employee_fp->resetAttributes();
$production_employee_fp_list->renderRow();
while ($production_employee_fp_list->RecCnt < $production_employee_fp_list->StopRec) {
	$production_employee_fp_list->RecCnt++;
	if ($production_employee_fp_list->RecCnt >= $production_employee_fp_list->StartRec) {
		$production_employee_fp_list->RowCnt++;

		// Set up key count
		$production_employee_fp_list->KeyCount = $production_employee_fp_list->RowIndex;

		// Init row class and style
		$production_employee_fp->resetAttributes();
		$production_employee_fp->CssClass = "";
		if ($production_employee_fp->isGridAdd()) {
		} else {
			$production_employee_fp_list->loadRowValues($production_employee_fp_list->Recordset); // Load row values
		}
		$production_employee_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_employee_fp->RowAttrs = array_merge($production_employee_fp->RowAttrs, array('data-rowindex'=>$production_employee_fp_list->RowCnt, 'id'=>'r' . $production_employee_fp_list->RowCnt . '_production_employee_fp', 'data-rowtype'=>$production_employee_fp->RowType));

		// Render row
		$production_employee_fp_list->renderRow();

		// Render list options
		$production_employee_fp_list->renderListOptions();
?>
	<tr<?php echo $production_employee_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_employee_fp_list->ListOptions->render("body", "left", $production_employee_fp_list->RowCnt);
?>
	<?php if ($production_employee_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $production_employee_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_grp" class="production_employee_fp_grp">
<span<?php echo $production_employee_fp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->grp->getViewValue())) && $production_employee_fp->grp->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->grp->linkAttributes() ?>><?php echo $production_employee_fp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_employee_fp->id->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_id" class="production_employee_fp_id">
<span<?php echo $production_employee_fp->id->viewAttributes() ?>>
<?php echo $production_employee_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->site->Visible) { // site ?>
		<td data-name="site"<?php echo $production_employee_fp->site->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_site" class="production_employee_fp_site">
<span<?php echo $production_employee_fp->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->site->getViewValue())) && $production_employee_fp->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->site->linkAttributes() ?>><?php echo $production_employee_fp->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->user_name->Visible) { // user_name ?>
		<td data-name="user_name"<?php echo $production_employee_fp->user_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_user_name" class="production_employee_fp_user_name">
<span<?php echo $production_employee_fp->user_name->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->user_name->getViewValue())) && $production_employee_fp->user_name->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->user_name->linkAttributes() ?>><?php echo $production_employee_fp->user_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->user_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $production_employee_fp->mobile->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_mobile" class="production_employee_fp_mobile">
<span<?php echo $production_employee_fp->mobile->viewAttributes() ?>>
<?php echo $production_employee_fp->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->process->Visible) { // process ?>
		<td data-name="process"<?php echo $production_employee_fp->process->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_process" class="production_employee_fp_process">
<span<?php echo $production_employee_fp->process->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->process->getViewValue())) && $production_employee_fp->process->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->process->linkAttributes() ?>><?php echo $production_employee_fp->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $production_employee_fp->status->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_status" class="production_employee_fp_status">
<span<?php echo $production_employee_fp->status->viewAttributes() ?>>
<?php echo $production_employee_fp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_employee_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_operator" class="production_employee_fp_operator">
<span<?php echo $production_employee_fp->operator->viewAttributes() ?>>
<?php echo $production_employee_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_employee_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_employee_fp_list->RowCnt ?>_production_employee_fp_datetime" class="production_employee_fp_datetime">
<span<?php echo $production_employee_fp->datetime->viewAttributes() ?>>
<?php echo $production_employee_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_employee_fp_list->ListOptions->render("body", "right", $production_employee_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_employee_fp->isGridAdd())
		$production_employee_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_employee_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_employee_fp_list->Recordset)
	$production_employee_fp_list->Recordset->Close();
?>
<?php if (!$production_employee_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_employee_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_fp_list->Pager)) $production_employee_fp_list->Pager = new PrevNextPager($production_employee_fp_list->StartRec, $production_employee_fp_list->DisplayRecs, $production_employee_fp_list->TotalRecs, $production_employee_fp_list->AutoHidePager) ?>
<?php if ($production_employee_fp_list->Pager->RecordCount > 0 && $production_employee_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_fp_list->pageUrl() ?>start=<?php echo $production_employee_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_fp_list->TotalRecs > 0 && (!$production_employee_fp_list->AutoHidePageSizeSelector || $production_employee_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_employee_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_employee_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_employee_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_employee_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_employee_fp_list->TotalRecs == 0 && !$production_employee_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_employee_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_employee_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_employee_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_employee_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_fp_list->terminate();
?>