<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_fp_view = new production_employee_fp_view();

// Run the page
$production_employee_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_employee_fpview = currentForm = new ew.Form("fproduction_employee_fpview", "view");

// Form_CustomValidate event
fproduction_employee_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employee_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employee_fpview.lists["x_grp"] = <?php echo $production_employee_fp_view->grp->Lookup->toClientList() ?>;
fproduction_employee_fpview.lists["x_grp"].options = <?php echo JsonEncode($production_employee_fp_view->grp->options(FALSE, TRUE)) ?>;
fproduction_employee_fpview.lists["x_site"] = <?php echo $production_employee_fp_view->site->Lookup->toClientList() ?>;
fproduction_employee_fpview.lists["x_site"].options = <?php echo JsonEncode($production_employee_fp_view->site->lookupOptions()) ?>;
fproduction_employee_fpview.lists["x_process[]"] = <?php echo $production_employee_fp_view->process->Lookup->toClientList() ?>;
fproduction_employee_fpview.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_fp_view->process->lookupOptions()) ?>;
fproduction_employee_fpview.lists["x_status"] = <?php echo $production_employee_fp_view->status->Lookup->toClientList() ?>;
fproduction_employee_fpview.lists["x_status"].options = <?php echo JsonEncode($production_employee_fp_view->status->options(FALSE, TRUE)) ?>;
fproduction_employee_fpview.lists["x_operator"] = <?php echo $production_employee_fp_view->operator->Lookup->toClientList() ?>;
fproduction_employee_fpview.lists["x_operator"].options = <?php echo JsonEncode($production_employee_fp_view->operator->lookupOptions()) ?>;
fproduction_employee_fpview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_employee_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_employee_fp_view->ExportOptions->render("body") ?>
<?php $production_employee_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_employee_fp_view->showPageHeader(); ?>
<?php
$production_employee_fp_view->showMessage();
?>
<form name="fproduction_employee_fpview" id="fproduction_employee_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee_fp">
<input type="hidden" name="modal" value="<?php echo (int)$production_employee_fp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_employee_fp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_grp"><?php echo $production_employee_fp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_employee_fp->grp->cellAttributes() ?>>
<span id="el_production_employee_fp_grp">
<span<?php echo $production_employee_fp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->grp->getViewValue())) && $production_employee_fp->grp->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->grp->linkAttributes() ?>><?php echo $production_employee_fp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_id"><?php echo $production_employee_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_employee_fp->id->cellAttributes() ?>>
<span id="el_production_employee_fp_id">
<span<?php echo $production_employee_fp->id->viewAttributes() ?>>
<?php echo $production_employee_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->site->Visible) { // site ?>
	<tr id="r_site">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_site"><?php echo $production_employee_fp->site->caption() ?></span></td>
		<td data-name="site"<?php echo $production_employee_fp->site->cellAttributes() ?>>
<span id="el_production_employee_fp_site">
<span<?php echo $production_employee_fp->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->site->getViewValue())) && $production_employee_fp->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->site->linkAttributes() ?>><?php echo $production_employee_fp->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->user_name->Visible) { // user_name ?>
	<tr id="r_user_name">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_user_name"><?php echo $production_employee_fp->user_name->caption() ?></span></td>
		<td data-name="user_name"<?php echo $production_employee_fp->user_name->cellAttributes() ?>>
<span id="el_production_employee_fp_user_name">
<span<?php echo $production_employee_fp->user_name->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->user_name->getViewValue())) && $production_employee_fp->user_name->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->user_name->linkAttributes() ?>><?php echo $production_employee_fp->user_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->user_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_address"><?php echo $production_employee_fp->address->caption() ?></span></td>
		<td data-name="address"<?php echo $production_employee_fp->address->cellAttributes() ?>>
<span id="el_production_employee_fp_address">
<span<?php echo $production_employee_fp->address->viewAttributes() ?>>
<?php echo $production_employee_fp->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_mobile"><?php echo $production_employee_fp->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $production_employee_fp->mobile->cellAttributes() ?>>
<span id="el_production_employee_fp_mobile">
<span<?php echo $production_employee_fp->mobile->viewAttributes() ?>>
<?php echo $production_employee_fp->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_process"><?php echo $production_employee_fp->process->caption() ?></span></td>
		<td data-name="process"<?php echo $production_employee_fp->process->cellAttributes() ?>>
<span id="el_production_employee_fp_process">
<span<?php echo $production_employee_fp->process->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_fp->process->getViewValue())) && $production_employee_fp->process->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_fp->process->linkAttributes() ?>><?php echo $production_employee_fp->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_fp->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_status"><?php echo $production_employee_fp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $production_employee_fp->status->cellAttributes() ?>>
<span id="el_production_employee_fp_status">
<span<?php echo $production_employee_fp->status->viewAttributes() ?>>
<?php echo $production_employee_fp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_operator"><?php echo $production_employee_fp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_employee_fp->operator->cellAttributes() ?>>
<span id="el_production_employee_fp_operator">
<span<?php echo $production_employee_fp->operator->viewAttributes() ?>>
<?php echo $production_employee_fp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee_fp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_employee_fp_view->TableLeftColumnClass ?>"><span id="elh_production_employee_fp_datetime"><?php echo $production_employee_fp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_employee_fp->datetime->cellAttributes() ?>>
<span id="el_production_employee_fp_datetime">
<span<?php echo $production_employee_fp->datetime->viewAttributes() ?>>
<?php echo $production_employee_fp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$production_employee_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_fp_view->terminate();
?>