<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_hs_edit = new production_employee_hs_edit();

// Run the page
$production_employee_hs_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_hs_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproduction_employee_hsedit = currentForm = new ew.Form("fproduction_employee_hsedit", "edit");

// Validate form
fproduction_employee_hsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_employee_hs_edit->uid->Required) { ?>
			elm = this.getElements("x" + infix + "_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->uid->caption(), $production_employee_hs->uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->id->caption(), $production_employee_hs->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->id->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->grp->caption(), $production_employee_hs->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->site->caption(), $production_employee_hs->site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->user_name->caption(), $production_employee_hs->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->address->caption(), $production_employee_hs->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->mobile->caption(), $production_employee_hs->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->mobile->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->process->caption(), $production_employee_hs->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->employee_name->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->employee_name->caption(), $production_employee_hs->employee_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->gender->caption(), $production_employee_hs->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->father_name->caption(), $production_employee_hs->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->designation->Required) { ?>
			elm = this.getElements("x" + infix + "_designation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->designation->caption(), $production_employee_hs->designation->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_designation");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->designation->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->permanent_address->caption(), $production_employee_hs->permanent_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->city->caption(), $production_employee_hs->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->dob->caption(), $production_employee_hs->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->dob->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->dom->caption(), $production_employee_hs->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->dom->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->mobile_other->caption(), $production_employee_hs->mobile_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->mobile_family->caption(), $production_employee_hs->mobile_family->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->marital_status->caption(), $production_employee_hs->marital_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->spouse_details->caption(), $production_employee_hs->spouse_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->emergency_details->caption(), $production_employee_hs->emergency_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->aadhaar_no->caption(), $production_employee_hs->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->id_proof->Required) { ?>
			elm = this.getElements("x" + infix + "_id_proof");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->id_proof->caption(), $production_employee_hs->id_proof->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->reference_details->caption(), $production_employee_hs->reference_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->other_details->caption(), $production_employee_hs->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->doj->Required) { ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->doj->caption(), $production_employee_hs->doj->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->doj->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->doc->Required) { ?>
			elm = this.getElements("x" + infix + "_doc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->doc->caption(), $production_employee_hs->doc->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_doc");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->doc->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->dol->Required) { ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->dol->caption(), $production_employee_hs->dol->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee_hs->dol->errorMessage()) ?>");
		<?php if ($production_employee_hs_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->image->caption(), $production_employee_hs->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->payment_details->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->payment_details->caption(), $production_employee_hs->payment_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->bank_name->caption(), $production_employee_hs->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->bank_ifsc_code->caption(), $production_employee_hs->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->bank_account_no->caption(), $production_employee_hs->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->status->caption(), $production_employee_hs->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->d_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_d_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->d_operator->caption(), $production_employee_hs->d_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_hs_edit->d_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_d_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee_hs->d_datetime->caption(), $production_employee_hs->d_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_employee_hsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employee_hsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employee_hsedit.lists["x_grp"] = <?php echo $production_employee_hs_edit->grp->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_grp"].options = <?php echo JsonEncode($production_employee_hs_edit->grp->options(FALSE, TRUE)) ?>;
fproduction_employee_hsedit.lists["x_site"] = <?php echo $production_employee_hs_edit->site->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_site"].options = <?php echo JsonEncode($production_employee_hs_edit->site->lookupOptions()) ?>;
fproduction_employee_hsedit.lists["x_process[]"] = <?php echo $production_employee_hs_edit->process->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_hs_edit->process->lookupOptions()) ?>;
fproduction_employee_hsedit.lists["x_gender"] = <?php echo $production_employee_hs_edit->gender->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_gender"].options = <?php echo JsonEncode($production_employee_hs_edit->gender->options(FALSE, TRUE)) ?>;
fproduction_employee_hsedit.lists["x_marital_status"] = <?php echo $production_employee_hs_edit->marital_status->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_hs_edit->marital_status->options(FALSE, TRUE)) ?>;
fproduction_employee_hsedit.lists["x_status"] = <?php echo $production_employee_hs_edit->status->Lookup->toClientList() ?>;
fproduction_employee_hsedit.lists["x_status"].options = <?php echo JsonEncode($production_employee_hs_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_employee_hs_edit->showPageHeader(); ?>
<?php
$production_employee_hs_edit->showMessage();
?>
<form name="fproduction_employee_hsedit" id="fproduction_employee_hsedit" class="<?php echo $production_employee_hs_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_hs_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_hs_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee_hs">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$production_employee_hs_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($production_employee_hs->uid->Visible) { // uid ?>
	<div id="r_uid" class="form-group row">
		<label id="elh_production_employee_hs_uid" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->uid->caption() ?><?php echo ($production_employee_hs->uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->uid->cellAttributes() ?>>
<span id="el_production_employee_hs_uid">
<span<?php echo $production_employee_hs->uid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_employee_hs->uid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="production_employee_hs" data-field="x_uid" name="x_uid" id="x_uid" value="<?php echo HtmlEncode($production_employee_hs->uid->CurrentValue) ?>">
<?php echo $production_employee_hs->uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_production_employee_hs_id" for="x_id" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->id->caption() ?><?php echo ($production_employee_hs->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->id->cellAttributes() ?>>
<span id="el_production_employee_hs_id">
<input type="text" data-table="production_employee_hs" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($production_employee_hs->id->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->id->EditValue ?>"<?php echo $production_employee_hs->id->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_production_employee_hs_grp" for="x_grp" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->grp->caption() ?><?php echo ($production_employee_hs->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->grp->cellAttributes() ?>>
<span id="el_production_employee_hs_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee_hs" data-field="x_grp" data-value-separator="<?php echo $production_employee_hs->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $production_employee_hs->grp->editAttributes() ?>>
		<?php echo $production_employee_hs->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $production_employee_hs->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label id="elh_production_employee_hs_site" for="x_site" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->site->caption() ?><?php echo ($production_employee_hs->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->site->cellAttributes() ?>>
<span id="el_production_employee_hs_site">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee_hs" data-field="x_site" data-value-separator="<?php echo $production_employee_hs->site->displayValueSeparatorAttribute() ?>" id="x_site" name="x_site"<?php echo $production_employee_hs->site->editAttributes() ?>>
		<?php echo $production_employee_hs->site->selectOptionListHtml("x_site") ?>
	</select>
</div>
<?php echo $production_employee_hs->site->Lookup->getParamTag("p_x_site") ?>
</span>
<?php echo $production_employee_hs->site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_production_employee_hs_user_name" for="x_user_name" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->user_name->caption() ?><?php echo ($production_employee_hs->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->user_name->cellAttributes() ?>>
<span id="el_production_employee_hs_user_name">
<input type="text" data-table="production_employee_hs" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee_hs->user_name->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->user_name->EditValue ?>"<?php echo $production_employee_hs->user_name->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_production_employee_hs_address" for="x_address" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->address->caption() ?><?php echo ($production_employee_hs->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->address->cellAttributes() ?>>
<span id="el_production_employee_hs_address">
<textarea data-table="production_employee_hs" data-field="x_address" name="x_address" id="x_address" cols="2" rows="3" placeholder="<?php echo HtmlEncode($production_employee_hs->address->getPlaceHolder()) ?>"<?php echo $production_employee_hs->address->editAttributes() ?>><?php echo $production_employee_hs->address->EditValue ?></textarea>
</span>
<?php echo $production_employee_hs->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_production_employee_hs_mobile" for="x_mobile" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->mobile->caption() ?><?php echo ($production_employee_hs->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->mobile->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile">
<input type="text" data-table="production_employee_hs" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($production_employee_hs->mobile->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->mobile->EditValue ?>"<?php echo $production_employee_hs->mobile->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_production_employee_hs_process" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->process->caption() ?><?php echo ($production_employee_hs->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->process->cellAttributes() ?>>
<span id="el_production_employee_hs_process">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee_hs" data-field="x_process" data-value-separator="<?php echo $production_employee_hs->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $production_employee_hs->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_employee_hs->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $production_employee_hs->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $production_employee_hs->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->employee_name->Visible) { // employee_name ?>
	<div id="r_employee_name" class="form-group row">
		<label id="elh_production_employee_hs_employee_name" for="x_employee_name" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->employee_name->caption() ?><?php echo ($production_employee_hs->employee_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->employee_name->cellAttributes() ?>>
<span id="el_production_employee_hs_employee_name">
<input type="text" data-table="production_employee_hs" data-field="x_employee_name" name="x_employee_name" id="x_employee_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee_hs->employee_name->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->employee_name->EditValue ?>"<?php echo $production_employee_hs->employee_name->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->employee_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_production_employee_hs_gender" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->gender->caption() ?><?php echo ($production_employee_hs->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->gender->cellAttributes() ?>>
<span id="el_production_employee_hs_gender">
<div id="tp_x_gender" class="ew-template"><input type="radio" class="form-check-input" data-table="production_employee_hs" data-field="x_gender" data-value-separator="<?php echo $production_employee_hs->gender->displayValueSeparatorAttribute() ?>" name="x_gender" id="x_gender" value="{value}"<?php echo $production_employee_hs->gender->editAttributes() ?>></div>
<div id="dsl_x_gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_employee_hs->gender->radioButtonListHtml(FALSE, "x_gender") ?>
</div></div>
</span>
<?php echo $production_employee_hs->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label id="elh_production_employee_hs_father_name" for="x_father_name" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->father_name->caption() ?><?php echo ($production_employee_hs->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->father_name->cellAttributes() ?>>
<span id="el_production_employee_hs_father_name">
<input type="text" data-table="production_employee_hs" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee_hs->father_name->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->father_name->EditValue ?>"<?php echo $production_employee_hs->father_name->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->designation->Visible) { // designation ?>
	<div id="r_designation" class="form-group row">
		<label id="elh_production_employee_hs_designation" for="x_designation" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->designation->caption() ?><?php echo ($production_employee_hs->designation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->designation->cellAttributes() ?>>
<span id="el_production_employee_hs_designation">
<input type="text" data-table="production_employee_hs" data-field="x_designation" name="x_designation" id="x_designation" size="30" placeholder="<?php echo HtmlEncode($production_employee_hs->designation->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->designation->EditValue ?>"<?php echo $production_employee_hs->designation->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->designation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->permanent_address->Visible) { // permanent_address ?>
	<div id="r_permanent_address" class="form-group row">
		<label id="elh_production_employee_hs_permanent_address" for="x_permanent_address" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->permanent_address->caption() ?><?php echo ($production_employee_hs->permanent_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->permanent_address->cellAttributes() ?>>
<span id="el_production_employee_hs_permanent_address">
<textarea data-table="production_employee_hs" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" cols="3" rows="3" placeholder="<?php echo HtmlEncode($production_employee_hs->permanent_address->getPlaceHolder()) ?>"<?php echo $production_employee_hs->permanent_address->editAttributes() ?>><?php echo $production_employee_hs->permanent_address->EditValue ?></textarea>
</span>
<?php echo $production_employee_hs->permanent_address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_production_employee_hs_city" for="x_city" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->city->caption() ?><?php echo ($production_employee_hs->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->city->cellAttributes() ?>>
<span id="el_production_employee_hs_city">
<input type="text" data-table="production_employee_hs" data-field="x_city" name="x_city" id="x_city" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee_hs->city->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->city->EditValue ?>"<?php echo $production_employee_hs->city->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_production_employee_hs_dob" for="x_dob" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->dob->caption() ?><?php echo ($production_employee_hs->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->dob->cellAttributes() ?>>
<span id="el_production_employee_hs_dob">
<input type="text" data-table="production_employee_hs" data-field="x_dob" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($production_employee_hs->dob->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->dob->EditValue ?>"<?php echo $production_employee_hs->dob->editAttributes() ?>>
<?php if (!$production_employee_hs->dob->ReadOnly && !$production_employee_hs->dob->Disabled && !isset($production_employee_hs->dob->EditAttrs["readonly"]) && !isset($production_employee_hs->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employee_hsedit", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee_hs->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label id="elh_production_employee_hs_dom" for="x_dom" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->dom->caption() ?><?php echo ($production_employee_hs->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->dom->cellAttributes() ?>>
<span id="el_production_employee_hs_dom">
<input type="text" data-table="production_employee_hs" data-field="x_dom" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($production_employee_hs->dom->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->dom->EditValue ?>"<?php echo $production_employee_hs->dom->editAttributes() ?>>
<?php if (!$production_employee_hs->dom->ReadOnly && !$production_employee_hs->dom->Disabled && !isset($production_employee_hs->dom->EditAttrs["readonly"]) && !isset($production_employee_hs->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employee_hsedit", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee_hs->dom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->mobile_other->Visible) { // mobile_other ?>
	<div id="r_mobile_other" class="form-group row">
		<label id="elh_production_employee_hs_mobile_other" for="x_mobile_other" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->mobile_other->caption() ?><?php echo ($production_employee_hs->mobile_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->mobile_other->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile_other">
<input type="text" data-table="production_employee_hs" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($production_employee_hs->mobile_other->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->mobile_other->EditValue ?>"<?php echo $production_employee_hs->mobile_other->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->mobile_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->mobile_family->Visible) { // mobile_family ?>
	<div id="r_mobile_family" class="form-group row">
		<label id="elh_production_employee_hs_mobile_family" for="x_mobile_family" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->mobile_family->caption() ?><?php echo ($production_employee_hs->mobile_family->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->mobile_family->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile_family">
<input type="text" data-table="production_employee_hs" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->mobile_family->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->mobile_family->EditValue ?>"<?php echo $production_employee_hs->mobile_family->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->mobile_family->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->marital_status->Visible) { // marital_status ?>
	<div id="r_marital_status" class="form-group row">
		<label id="elh_production_employee_hs_marital_status" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->marital_status->caption() ?><?php echo ($production_employee_hs->marital_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->marital_status->cellAttributes() ?>>
<span id="el_production_employee_hs_marital_status">
<div id="tp_x_marital_status" class="ew-template"><input type="radio" class="form-check-input" data-table="production_employee_hs" data-field="x_marital_status" data-value-separator="<?php echo $production_employee_hs->marital_status->displayValueSeparatorAttribute() ?>" name="x_marital_status" id="x_marital_status" value="{value}"<?php echo $production_employee_hs->marital_status->editAttributes() ?>></div>
<div id="dsl_x_marital_status" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_employee_hs->marital_status->radioButtonListHtml(FALSE, "x_marital_status") ?>
</div></div>
</span>
<?php echo $production_employee_hs->marital_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->spouse_details->Visible) { // spouse_details ?>
	<div id="r_spouse_details" class="form-group row">
		<label id="elh_production_employee_hs_spouse_details" for="x_spouse_details" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->spouse_details->caption() ?><?php echo ($production_employee_hs->spouse_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->spouse_details->cellAttributes() ?>>
<span id="el_production_employee_hs_spouse_details">
<input type="text" data-table="production_employee_hs" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->spouse_details->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->spouse_details->EditValue ?>"<?php echo $production_employee_hs->spouse_details->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->spouse_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->emergency_details->Visible) { // emergency_details ?>
	<div id="r_emergency_details" class="form-group row">
		<label id="elh_production_employee_hs_emergency_details" for="x_emergency_details" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->emergency_details->caption() ?><?php echo ($production_employee_hs->emergency_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->emergency_details->cellAttributes() ?>>
<span id="el_production_employee_hs_emergency_details">
<input type="text" data-table="production_employee_hs" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->emergency_details->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->emergency_details->EditValue ?>"<?php echo $production_employee_hs->emergency_details->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->emergency_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_production_employee_hs_aadhaar_no" for="x_aadhaar_no" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->aadhaar_no->caption() ?><?php echo ($production_employee_hs->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->aadhaar_no->cellAttributes() ?>>
<span id="el_production_employee_hs_aadhaar_no">
<input type="text" data-table="production_employee_hs" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($production_employee_hs->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->aadhaar_no->EditValue ?>"<?php echo $production_employee_hs->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label id="elh_production_employee_hs_id_proof" for="x_id_proof" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->id_proof->caption() ?><?php echo ($production_employee_hs->id_proof->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->id_proof->cellAttributes() ?>>
<span id="el_production_employee_hs_id_proof">
<input type="text" data-table="production_employee_hs" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->id_proof->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->id_proof->EditValue ?>"<?php echo $production_employee_hs->id_proof->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->reference_details->Visible) { // reference_details ?>
	<div id="r_reference_details" class="form-group row">
		<label id="elh_production_employee_hs_reference_details" for="x_reference_details" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->reference_details->caption() ?><?php echo ($production_employee_hs->reference_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->reference_details->cellAttributes() ?>>
<span id="el_production_employee_hs_reference_details">
<input type="text" data-table="production_employee_hs" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->reference_details->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->reference_details->EditValue ?>"<?php echo $production_employee_hs->reference_details->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->reference_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label id="elh_production_employee_hs_other_details" for="x_other_details" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->other_details->caption() ?><?php echo ($production_employee_hs->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->other_details->cellAttributes() ?>>
<span id="el_production_employee_hs_other_details">
<textarea data-table="production_employee_hs" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee_hs->other_details->getPlaceHolder()) ?>"<?php echo $production_employee_hs->other_details->editAttributes() ?>><?php echo $production_employee_hs->other_details->EditValue ?></textarea>
</span>
<?php echo $production_employee_hs->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->doj->Visible) { // doj ?>
	<div id="r_doj" class="form-group row">
		<label id="elh_production_employee_hs_doj" for="x_doj" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->doj->caption() ?><?php echo ($production_employee_hs->doj->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->doj->cellAttributes() ?>>
<span id="el_production_employee_hs_doj">
<input type="text" data-table="production_employee_hs" data-field="x_doj" name="x_doj" id="x_doj" placeholder="<?php echo HtmlEncode($production_employee_hs->doj->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->doj->EditValue ?>"<?php echo $production_employee_hs->doj->editAttributes() ?>>
<?php if (!$production_employee_hs->doj->ReadOnly && !$production_employee_hs->doj->Disabled && !isset($production_employee_hs->doj->EditAttrs["readonly"]) && !isset($production_employee_hs->doj->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employee_hsedit", "x_doj", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee_hs->doj->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->doc->Visible) { // doc ?>
	<div id="r_doc" class="form-group row">
		<label id="elh_production_employee_hs_doc" for="x_doc" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->doc->caption() ?><?php echo ($production_employee_hs->doc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->doc->cellAttributes() ?>>
<span id="el_production_employee_hs_doc">
<input type="text" data-table="production_employee_hs" data-field="x_doc" name="x_doc" id="x_doc" placeholder="<?php echo HtmlEncode($production_employee_hs->doc->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->doc->EditValue ?>"<?php echo $production_employee_hs->doc->editAttributes() ?>>
<?php if (!$production_employee_hs->doc->ReadOnly && !$production_employee_hs->doc->Disabled && !isset($production_employee_hs->doc->EditAttrs["readonly"]) && !isset($production_employee_hs->doc->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employee_hsedit", "x_doc", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee_hs->doc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->dol->Visible) { // dol ?>
	<div id="r_dol" class="form-group row">
		<label id="elh_production_employee_hs_dol" for="x_dol" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->dol->caption() ?><?php echo ($production_employee_hs->dol->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->dol->cellAttributes() ?>>
<span id="el_production_employee_hs_dol">
<input type="text" data-table="production_employee_hs" data-field="x_dol" name="x_dol" id="x_dol" placeholder="<?php echo HtmlEncode($production_employee_hs->dol->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->dol->EditValue ?>"<?php echo $production_employee_hs->dol->editAttributes() ?>>
<?php if (!$production_employee_hs->dol->ReadOnly && !$production_employee_hs->dol->Disabled && !isset($production_employee_hs->dol->EditAttrs["readonly"]) && !isset($production_employee_hs->dol->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employee_hsedit", "x_dol", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee_hs->dol->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_production_employee_hs_image" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->image->caption() ?><?php echo ($production_employee_hs->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->image->cellAttributes() ?>>
<span id="el_production_employee_hs_image">
<div id="fd_x_image">
<span title="<?php echo $production_employee_hs->image->title() ? $production_employee_hs->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($production_employee_hs->image->ReadOnly || $production_employee_hs->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="production_employee_hs" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $production_employee_hs->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $production_employee_hs->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $production_employee_hs->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $production_employee_hs->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $production_employee_hs->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $production_employee_hs->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->payment_details->Visible) { // payment_details ?>
	<div id="r_payment_details" class="form-group row">
		<label id="elh_production_employee_hs_payment_details" for="x_payment_details" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->payment_details->caption() ?><?php echo ($production_employee_hs->payment_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->payment_details->cellAttributes() ?>>
<span id="el_production_employee_hs_payment_details">
<textarea data-table="production_employee_hs" data-field="x_payment_details" name="x_payment_details" id="x_payment_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee_hs->payment_details->getPlaceHolder()) ?>"<?php echo $production_employee_hs->payment_details->editAttributes() ?>><?php echo $production_employee_hs->payment_details->EditValue ?></textarea>
</span>
<?php echo $production_employee_hs->payment_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label id="elh_production_employee_hs_bank_name" for="x_bank_name" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->bank_name->caption() ?><?php echo ($production_employee_hs->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->bank_name->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_name">
<input type="text" data-table="production_employee_hs" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee_hs->bank_name->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->bank_name->EditValue ?>"<?php echo $production_employee_hs->bank_name->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label id="elh_production_employee_hs_bank_ifsc_code" for="x_bank_ifsc_code" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->bank_ifsc_code->caption() ?><?php echo ($production_employee_hs->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->bank_ifsc_code->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_ifsc_code">
<input type="text" data-table="production_employee_hs" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee_hs->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->bank_ifsc_code->EditValue ?>"<?php echo $production_employee_hs->bank_ifsc_code->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label id="elh_production_employee_hs_bank_account_no" for="x_bank_account_no" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->bank_account_no->caption() ?><?php echo ($production_employee_hs->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->bank_account_no->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_account_no">
<input type="text" data-table="production_employee_hs" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee_hs->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $production_employee_hs->bank_account_no->EditValue ?>"<?php echo $production_employee_hs->bank_account_no->editAttributes() ?>>
</span>
<?php echo $production_employee_hs->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee_hs->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_production_employee_hs_status" for="x_status" class="<?php echo $production_employee_hs_edit->LeftColumnClass ?>"><?php echo $production_employee_hs->status->caption() ?><?php echo ($production_employee_hs->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_hs_edit->RightColumnClass ?>"><div<?php echo $production_employee_hs->status->cellAttributes() ?>>
<span id="el_production_employee_hs_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee_hs" data-field="x_status" data-value-separator="<?php echo $production_employee_hs->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_employee_hs->status->editAttributes() ?>>
		<?php echo $production_employee_hs->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $production_employee_hs->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_employee_hs_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_employee_hs_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_employee_hs_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_employee_hs_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_employee_hs_edit->terminate();
?>