<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_hs_list = new production_employee_hs_list();

// Run the page
$production_employee_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_employee_hslist = currentForm = new ew.Form("fproduction_employee_hslist", "list");
fproduction_employee_hslist.formKeyCountName = '<?php echo $production_employee_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_employee_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employee_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employee_hslist.lists["x_grp"] = <?php echo $production_employee_hs_list->grp->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_grp"].options = <?php echo JsonEncode($production_employee_hs_list->grp->options(FALSE, TRUE)) ?>;
fproduction_employee_hslist.lists["x_site"] = <?php echo $production_employee_hs_list->site->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_site"].options = <?php echo JsonEncode($production_employee_hs_list->site->lookupOptions()) ?>;
fproduction_employee_hslist.lists["x_process[]"] = <?php echo $production_employee_hs_list->process->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_hs_list->process->lookupOptions()) ?>;
fproduction_employee_hslist.lists["x_gender"] = <?php echo $production_employee_hs_list->gender->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_gender"].options = <?php echo JsonEncode($production_employee_hs_list->gender->options(FALSE, TRUE)) ?>;
fproduction_employee_hslist.lists["x_marital_status"] = <?php echo $production_employee_hs_list->marital_status->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_hs_list->marital_status->options(FALSE, TRUE)) ?>;
fproduction_employee_hslist.lists["x_status"] = <?php echo $production_employee_hs_list->status->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_status"].options = <?php echo JsonEncode($production_employee_hs_list->status->options(FALSE, TRUE)) ?>;
fproduction_employee_hslist.lists["x_operator"] = <?php echo $production_employee_hs_list->operator->Lookup->toClientList() ?>;
fproduction_employee_hslist.lists["x_operator"].options = <?php echo JsonEncode($production_employee_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduction_employee_hslistsrch = currentSearchForm = new ew.Form("fproduction_employee_hslistsrch");

// Filters
fproduction_employee_hslistsrch.filterList = <?php echo $production_employee_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_employee_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_employee_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_employee_hs_list->TotalRecs > 0 && $production_employee_hs_list->ExportOptions->visible()) { ?>
<?php $production_employee_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_hs_list->ImportOptions->visible()) { ?>
<?php $production_employee_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_hs_list->SearchOptions->visible()) { ?>
<?php $production_employee_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_hs_list->FilterOptions->visible()) { ?>
<?php $production_employee_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_employee_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_employee_hs->isExport() && !$production_employee_hs->CurrentAction) { ?>
<form name="fproduction_employee_hslistsrch" id="fproduction_employee_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_employee_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_employee_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_employee_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_employee_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_employee_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_employee_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_employee_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_employee_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_employee_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_employee_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_employee_hs_list->showPageHeader(); ?>
<?php
$production_employee_hs_list->showMessage();
?>
<?php if ($production_employee_hs_list->TotalRecs > 0 || $production_employee_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_employee_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_employee_hs">
<?php if (!$production_employee_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_employee_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_hs_list->Pager)) $production_employee_hs_list->Pager = new PrevNextPager($production_employee_hs_list->StartRec, $production_employee_hs_list->DisplayRecs, $production_employee_hs_list->TotalRecs, $production_employee_hs_list->AutoHidePager) ?>
<?php if ($production_employee_hs_list->Pager->RecordCount > 0 && $production_employee_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_hs_list->TotalRecs > 0 && (!$production_employee_hs_list->AutoHidePageSizeSelector || $production_employee_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_employee_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_employee_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_employee_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_employee_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_employee_hslist" id="fproduction_employee_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee_hs">
<div id="gmp_production_employee_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_employee_hs_list->TotalRecs > 0 || $production_employee_hs->isGridEdit()) { ?>
<table id="tbl_production_employee_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_employee_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_employee_hs_list->renderListOptions();

// Render list options (header, left)
$production_employee_hs_list->ListOptions->render("header", "left");
?>
<?php if ($production_employee_hs->uid->Visible) { // uid ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->uid) == "") { ?>
		<th data-name="uid" class="<?php echo $production_employee_hs->uid->headerCellClass() ?>"><div id="elh_production_employee_hs_uid" class="production_employee_hs_uid"><div class="ew-table-header-caption"><?php echo $production_employee_hs->uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uid" class="<?php echo $production_employee_hs->uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->uid) ?>',2);"><div id="elh_production_employee_hs_uid" class="production_employee_hs_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->uid->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->id->Visible) { // id ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_employee_hs->id->headerCellClass() ?>"><div id="elh_production_employee_hs_id" class="production_employee_hs_id"><div class="ew-table-header-caption"><?php echo $production_employee_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_employee_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->id) ?>',2);"><div id="elh_production_employee_hs_id" class="production_employee_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->grp->Visible) { // grp ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $production_employee_hs->grp->headerCellClass() ?>"><div id="elh_production_employee_hs_grp" class="production_employee_hs_grp"><div class="ew-table-header-caption"><?php echo $production_employee_hs->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $production_employee_hs->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->grp) ?>',2);"><div id="elh_production_employee_hs_grp" class="production_employee_hs_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->site->Visible) { // site ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->site) == "") { ?>
		<th data-name="site" class="<?php echo $production_employee_hs->site->headerCellClass() ?>"><div id="elh_production_employee_hs_site" class="production_employee_hs_site"><div class="ew-table-header-caption"><?php echo $production_employee_hs->site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="site" class="<?php echo $production_employee_hs->site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->site) ?>',2);"><div id="elh_production_employee_hs_site" class="production_employee_hs_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->site->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->user_name->Visible) { // user_name ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->user_name) == "") { ?>
		<th data-name="user_name" class="<?php echo $production_employee_hs->user_name->headerCellClass() ?>"><div id="elh_production_employee_hs_user_name" class="production_employee_hs_user_name"><div class="ew-table-header-caption"><?php echo $production_employee_hs->user_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_name" class="<?php echo $production_employee_hs->user_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->user_name) ?>',2);"><div id="elh_production_employee_hs_user_name" class="production_employee_hs_user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->user_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->user_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->user_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->address->Visible) { // address ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->address) == "") { ?>
		<th data-name="address" class="<?php echo $production_employee_hs->address->headerCellClass() ?>"><div id="elh_production_employee_hs_address" class="production_employee_hs_address"><div class="ew-table-header-caption"><?php echo $production_employee_hs->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $production_employee_hs->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->address) ?>',2);"><div id="elh_production_employee_hs_address" class="production_employee_hs_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->mobile->Visible) { // mobile ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $production_employee_hs->mobile->headerCellClass() ?>"><div id="elh_production_employee_hs_mobile" class="production_employee_hs_mobile"><div class="ew-table-header-caption"><?php echo $production_employee_hs->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $production_employee_hs->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->mobile) ?>',2);"><div id="elh_production_employee_hs_mobile" class="production_employee_hs_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->process->Visible) { // process ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->process) == "") { ?>
		<th data-name="process" class="<?php echo $production_employee_hs->process->headerCellClass() ?>"><div id="elh_production_employee_hs_process" class="production_employee_hs_process"><div class="ew-table-header-caption"><?php echo $production_employee_hs->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $production_employee_hs->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->process) ?>',2);"><div id="elh_production_employee_hs_process" class="production_employee_hs_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->employee_name->Visible) { // employee_name ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->employee_name) == "") { ?>
		<th data-name="employee_name" class="<?php echo $production_employee_hs->employee_name->headerCellClass() ?>"><div id="elh_production_employee_hs_employee_name" class="production_employee_hs_employee_name"><div class="ew-table-header-caption"><?php echo $production_employee_hs->employee_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_name" class="<?php echo $production_employee_hs->employee_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->employee_name) ?>',2);"><div id="elh_production_employee_hs_employee_name" class="production_employee_hs_employee_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->employee_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->employee_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->employee_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->gender->Visible) { // gender ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->gender) == "") { ?>
		<th data-name="gender" class="<?php echo $production_employee_hs->gender->headerCellClass() ?>"><div id="elh_production_employee_hs_gender" class="production_employee_hs_gender"><div class="ew-table-header-caption"><?php echo $production_employee_hs->gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gender" class="<?php echo $production_employee_hs->gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->gender) ?>',2);"><div id="elh_production_employee_hs_gender" class="production_employee_hs_gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->father_name->Visible) { // father_name ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->father_name) == "") { ?>
		<th data-name="father_name" class="<?php echo $production_employee_hs->father_name->headerCellClass() ?>"><div id="elh_production_employee_hs_father_name" class="production_employee_hs_father_name"><div class="ew-table-header-caption"><?php echo $production_employee_hs->father_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="father_name" class="<?php echo $production_employee_hs->father_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->father_name) ?>',2);"><div id="elh_production_employee_hs_father_name" class="production_employee_hs_father_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->father_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->father_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->father_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->designation->Visible) { // designation ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->designation) == "") { ?>
		<th data-name="designation" class="<?php echo $production_employee_hs->designation->headerCellClass() ?>"><div id="elh_production_employee_hs_designation" class="production_employee_hs_designation"><div class="ew-table-header-caption"><?php echo $production_employee_hs->designation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="designation" class="<?php echo $production_employee_hs->designation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->designation) ?>',2);"><div id="elh_production_employee_hs_designation" class="production_employee_hs_designation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->designation->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->designation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->designation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->permanent_address->Visible) { // permanent_address ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->permanent_address) == "") { ?>
		<th data-name="permanent_address" class="<?php echo $production_employee_hs->permanent_address->headerCellClass() ?>"><div id="elh_production_employee_hs_permanent_address" class="production_employee_hs_permanent_address"><div class="ew-table-header-caption"><?php echo $production_employee_hs->permanent_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="permanent_address" class="<?php echo $production_employee_hs->permanent_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->permanent_address) ?>',2);"><div id="elh_production_employee_hs_permanent_address" class="production_employee_hs_permanent_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->permanent_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->permanent_address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->permanent_address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->city->Visible) { // city ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->city) == "") { ?>
		<th data-name="city" class="<?php echo $production_employee_hs->city->headerCellClass() ?>"><div id="elh_production_employee_hs_city" class="production_employee_hs_city"><div class="ew-table-header-caption"><?php echo $production_employee_hs->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $production_employee_hs->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->city) ?>',2);"><div id="elh_production_employee_hs_city" class="production_employee_hs_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->city->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->dob->Visible) { // dob ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->dob) == "") { ?>
		<th data-name="dob" class="<?php echo $production_employee_hs->dob->headerCellClass() ?>"><div id="elh_production_employee_hs_dob" class="production_employee_hs_dob"><div class="ew-table-header-caption"><?php echo $production_employee_hs->dob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dob" class="<?php echo $production_employee_hs->dob->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->dob) ?>',2);"><div id="elh_production_employee_hs_dob" class="production_employee_hs_dob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->dob->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->dob->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->dob->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->dom->Visible) { // dom ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->dom) == "") { ?>
		<th data-name="dom" class="<?php echo $production_employee_hs->dom->headerCellClass() ?>"><div id="elh_production_employee_hs_dom" class="production_employee_hs_dom"><div class="ew-table-header-caption"><?php echo $production_employee_hs->dom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dom" class="<?php echo $production_employee_hs->dom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->dom) ?>',2);"><div id="elh_production_employee_hs_dom" class="production_employee_hs_dom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->dom->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->dom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->dom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->mobile_other->Visible) { // mobile_other ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->mobile_other) == "") { ?>
		<th data-name="mobile_other" class="<?php echo $production_employee_hs->mobile_other->headerCellClass() ?>"><div id="elh_production_employee_hs_mobile_other" class="production_employee_hs_mobile_other"><div class="ew-table-header-caption"><?php echo $production_employee_hs->mobile_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_other" class="<?php echo $production_employee_hs->mobile_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->mobile_other) ?>',2);"><div id="elh_production_employee_hs_mobile_other" class="production_employee_hs_mobile_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->mobile_other->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->mobile_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->mobile_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->mobile_family->Visible) { // mobile_family ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->mobile_family) == "") { ?>
		<th data-name="mobile_family" class="<?php echo $production_employee_hs->mobile_family->headerCellClass() ?>"><div id="elh_production_employee_hs_mobile_family" class="production_employee_hs_mobile_family"><div class="ew-table-header-caption"><?php echo $production_employee_hs->mobile_family->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_family" class="<?php echo $production_employee_hs->mobile_family->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->mobile_family) ?>',2);"><div id="elh_production_employee_hs_mobile_family" class="production_employee_hs_mobile_family">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->mobile_family->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->mobile_family->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->mobile_family->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->marital_status->Visible) { // marital_status ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->marital_status) == "") { ?>
		<th data-name="marital_status" class="<?php echo $production_employee_hs->marital_status->headerCellClass() ?>"><div id="elh_production_employee_hs_marital_status" class="production_employee_hs_marital_status"><div class="ew-table-header-caption"><?php echo $production_employee_hs->marital_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marital_status" class="<?php echo $production_employee_hs->marital_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->marital_status) ?>',2);"><div id="elh_production_employee_hs_marital_status" class="production_employee_hs_marital_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->marital_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->marital_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->marital_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->spouse_details->Visible) { // spouse_details ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->spouse_details) == "") { ?>
		<th data-name="spouse_details" class="<?php echo $production_employee_hs->spouse_details->headerCellClass() ?>"><div id="elh_production_employee_hs_spouse_details" class="production_employee_hs_spouse_details"><div class="ew-table-header-caption"><?php echo $production_employee_hs->spouse_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="spouse_details" class="<?php echo $production_employee_hs->spouse_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->spouse_details) ?>',2);"><div id="elh_production_employee_hs_spouse_details" class="production_employee_hs_spouse_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->spouse_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->spouse_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->spouse_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->emergency_details->Visible) { // emergency_details ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->emergency_details) == "") { ?>
		<th data-name="emergency_details" class="<?php echo $production_employee_hs->emergency_details->headerCellClass() ?>"><div id="elh_production_employee_hs_emergency_details" class="production_employee_hs_emergency_details"><div class="ew-table-header-caption"><?php echo $production_employee_hs->emergency_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emergency_details" class="<?php echo $production_employee_hs->emergency_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->emergency_details) ?>',2);"><div id="elh_production_employee_hs_emergency_details" class="production_employee_hs_emergency_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->emergency_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->emergency_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->emergency_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->aadhaar_no->Visible) { // aadhaar_no ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->aadhaar_no) == "") { ?>
		<th data-name="aadhaar_no" class="<?php echo $production_employee_hs->aadhaar_no->headerCellClass() ?>"><div id="elh_production_employee_hs_aadhaar_no" class="production_employee_hs_aadhaar_no"><div class="ew-table-header-caption"><?php echo $production_employee_hs->aadhaar_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="aadhaar_no" class="<?php echo $production_employee_hs->aadhaar_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->aadhaar_no) ?>',2);"><div id="elh_production_employee_hs_aadhaar_no" class="production_employee_hs_aadhaar_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->aadhaar_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->aadhaar_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->aadhaar_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->id_proof->Visible) { // id_proof ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->id_proof) == "") { ?>
		<th data-name="id_proof" class="<?php echo $production_employee_hs->id_proof->headerCellClass() ?>"><div id="elh_production_employee_hs_id_proof" class="production_employee_hs_id_proof"><div class="ew-table-header-caption"><?php echo $production_employee_hs->id_proof->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_proof" class="<?php echo $production_employee_hs->id_proof->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->id_proof) ?>',2);"><div id="elh_production_employee_hs_id_proof" class="production_employee_hs_id_proof">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->id_proof->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->id_proof->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->id_proof->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->reference_details->Visible) { // reference_details ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->reference_details) == "") { ?>
		<th data-name="reference_details" class="<?php echo $production_employee_hs->reference_details->headerCellClass() ?>"><div id="elh_production_employee_hs_reference_details" class="production_employee_hs_reference_details"><div class="ew-table-header-caption"><?php echo $production_employee_hs->reference_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference_details" class="<?php echo $production_employee_hs->reference_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->reference_details) ?>',2);"><div id="elh_production_employee_hs_reference_details" class="production_employee_hs_reference_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->reference_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->reference_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->reference_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->doj->Visible) { // doj ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->doj) == "") { ?>
		<th data-name="doj" class="<?php echo $production_employee_hs->doj->headerCellClass() ?>"><div id="elh_production_employee_hs_doj" class="production_employee_hs_doj"><div class="ew-table-header-caption"><?php echo $production_employee_hs->doj->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="doj" class="<?php echo $production_employee_hs->doj->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->doj) ?>',2);"><div id="elh_production_employee_hs_doj" class="production_employee_hs_doj">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->doj->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->doj->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->doj->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->doc->Visible) { // doc ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->doc) == "") { ?>
		<th data-name="doc" class="<?php echo $production_employee_hs->doc->headerCellClass() ?>"><div id="elh_production_employee_hs_doc" class="production_employee_hs_doc"><div class="ew-table-header-caption"><?php echo $production_employee_hs->doc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="doc" class="<?php echo $production_employee_hs->doc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->doc) ?>',2);"><div id="elh_production_employee_hs_doc" class="production_employee_hs_doc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->doc->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->doc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->doc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->dol->Visible) { // dol ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->dol) == "") { ?>
		<th data-name="dol" class="<?php echo $production_employee_hs->dol->headerCellClass() ?>"><div id="elh_production_employee_hs_dol" class="production_employee_hs_dol"><div class="ew-table-header-caption"><?php echo $production_employee_hs->dol->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dol" class="<?php echo $production_employee_hs->dol->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->dol) ?>',2);"><div id="elh_production_employee_hs_dol" class="production_employee_hs_dol">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->dol->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->dol->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->dol->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->image->Visible) { // image ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->image) == "") { ?>
		<th data-name="image" class="<?php echo $production_employee_hs->image->headerCellClass() ?>"><div id="elh_production_employee_hs_image" class="production_employee_hs_image"><div class="ew-table-header-caption"><?php echo $production_employee_hs->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $production_employee_hs->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->image) ?>',2);"><div id="elh_production_employee_hs_image" class="production_employee_hs_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->bank_name->Visible) { // bank_name ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->bank_name) == "") { ?>
		<th data-name="bank_name" class="<?php echo $production_employee_hs->bank_name->headerCellClass() ?>"><div id="elh_production_employee_hs_bank_name" class="production_employee_hs_bank_name"><div class="ew-table-header-caption"><?php echo $production_employee_hs->bank_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_name" class="<?php echo $production_employee_hs->bank_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->bank_name) ?>',2);"><div id="elh_production_employee_hs_bank_name" class="production_employee_hs_bank_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->bank_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->bank_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->bank_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->bank_ifsc_code) == "") { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $production_employee_hs->bank_ifsc_code->headerCellClass() ?>"><div id="elh_production_employee_hs_bank_ifsc_code" class="production_employee_hs_bank_ifsc_code"><div class="ew-table-header-caption"><?php echo $production_employee_hs->bank_ifsc_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $production_employee_hs->bank_ifsc_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->bank_ifsc_code) ?>',2);"><div id="elh_production_employee_hs_bank_ifsc_code" class="production_employee_hs_bank_ifsc_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->bank_ifsc_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->bank_ifsc_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->bank_ifsc_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->bank_account_no->Visible) { // bank_account_no ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->bank_account_no) == "") { ?>
		<th data-name="bank_account_no" class="<?php echo $production_employee_hs->bank_account_no->headerCellClass() ?>"><div id="elh_production_employee_hs_bank_account_no" class="production_employee_hs_bank_account_no"><div class="ew-table-header-caption"><?php echo $production_employee_hs->bank_account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_account_no" class="<?php echo $production_employee_hs->bank_account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->bank_account_no) ?>',2);"><div id="elh_production_employee_hs_bank_account_no" class="production_employee_hs_bank_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->bank_account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->bank_account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->bank_account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->status->Visible) { // status ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->status) == "") { ?>
		<th data-name="status" class="<?php echo $production_employee_hs->status->headerCellClass() ?>"><div id="elh_production_employee_hs_status" class="production_employee_hs_status"><div class="ew-table-header-caption"><?php echo $production_employee_hs->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $production_employee_hs->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->status) ?>',2);"><div id="elh_production_employee_hs_status" class="production_employee_hs_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->operator->Visible) { // operator ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_employee_hs->operator->headerCellClass() ?>"><div id="elh_production_employee_hs_operator" class="production_employee_hs_operator"><div class="ew-table-header-caption"><?php echo $production_employee_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_employee_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->operator) ?>',2);"><div id="elh_production_employee_hs_operator" class="production_employee_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->datetime->Visible) { // datetime ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_employee_hs->datetime->headerCellClass() ?>"><div id="elh_production_employee_hs_datetime" class="production_employee_hs_datetime"><div class="ew-table-header-caption"><?php echo $production_employee_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_employee_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->datetime) ?>',2);"><div id="elh_production_employee_hs_datetime" class="production_employee_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->d_operator->Visible) { // d_operator ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->d_operator) == "") { ?>
		<th data-name="d_operator" class="<?php echo $production_employee_hs->d_operator->headerCellClass() ?>"><div id="elh_production_employee_hs_d_operator" class="production_employee_hs_d_operator"><div class="ew-table-header-caption"><?php echo $production_employee_hs->d_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_operator" class="<?php echo $production_employee_hs->d_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->d_operator) ?>',2);"><div id="elh_production_employee_hs_d_operator" class="production_employee_hs_d_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->d_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->d_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->d_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee_hs->d_datetime->Visible) { // d_datetime ?>
	<?php if ($production_employee_hs->sortUrl($production_employee_hs->d_datetime) == "") { ?>
		<th data-name="d_datetime" class="<?php echo $production_employee_hs->d_datetime->headerCellClass() ?>"><div id="elh_production_employee_hs_d_datetime" class="production_employee_hs_d_datetime"><div class="ew-table-header-caption"><?php echo $production_employee_hs->d_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_datetime" class="<?php echo $production_employee_hs->d_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee_hs->SortUrl($production_employee_hs->d_datetime) ?>',2);"><div id="elh_production_employee_hs_d_datetime" class="production_employee_hs_d_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee_hs->d_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee_hs->d_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee_hs->d_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_employee_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_employee_hs->ExportAll && $production_employee_hs->isExport()) {
	$production_employee_hs_list->StopRec = $production_employee_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_employee_hs_list->TotalRecs > $production_employee_hs_list->StartRec + $production_employee_hs_list->DisplayRecs - 1)
		$production_employee_hs_list->StopRec = $production_employee_hs_list->StartRec + $production_employee_hs_list->DisplayRecs - 1;
	else
		$production_employee_hs_list->StopRec = $production_employee_hs_list->TotalRecs;
}
$production_employee_hs_list->RecCnt = $production_employee_hs_list->StartRec - 1;
if ($production_employee_hs_list->Recordset && !$production_employee_hs_list->Recordset->EOF) {
	$production_employee_hs_list->Recordset->moveFirst();
	$selectLimit = $production_employee_hs_list->UseSelectLimit;
	if (!$selectLimit && $production_employee_hs_list->StartRec > 1)
		$production_employee_hs_list->Recordset->move($production_employee_hs_list->StartRec - 1);
} elseif (!$production_employee_hs->AllowAddDeleteRow && $production_employee_hs_list->StopRec == 0) {
	$production_employee_hs_list->StopRec = $production_employee_hs->GridAddRowCount;
}

// Initialize aggregate
$production_employee_hs->RowType = ROWTYPE_AGGREGATEINIT;
$production_employee_hs->resetAttributes();
$production_employee_hs_list->renderRow();
while ($production_employee_hs_list->RecCnt < $production_employee_hs_list->StopRec) {
	$production_employee_hs_list->RecCnt++;
	if ($production_employee_hs_list->RecCnt >= $production_employee_hs_list->StartRec) {
		$production_employee_hs_list->RowCnt++;

		// Set up key count
		$production_employee_hs_list->KeyCount = $production_employee_hs_list->RowIndex;

		// Init row class and style
		$production_employee_hs->resetAttributes();
		$production_employee_hs->CssClass = "";
		if ($production_employee_hs->isGridAdd()) {
		} else {
			$production_employee_hs_list->loadRowValues($production_employee_hs_list->Recordset); // Load row values
		}
		$production_employee_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_employee_hs->RowAttrs = array_merge($production_employee_hs->RowAttrs, array('data-rowindex'=>$production_employee_hs_list->RowCnt, 'id'=>'r' . $production_employee_hs_list->RowCnt . '_production_employee_hs', 'data-rowtype'=>$production_employee_hs->RowType));

		// Render row
		$production_employee_hs_list->renderRow();

		// Render list options
		$production_employee_hs_list->renderListOptions();
?>
	<tr<?php echo $production_employee_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_employee_hs_list->ListOptions->render("body", "left", $production_employee_hs_list->RowCnt);
?>
	<?php if ($production_employee_hs->uid->Visible) { // uid ?>
		<td data-name="uid"<?php echo $production_employee_hs->uid->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_uid" class="production_employee_hs_uid">
<span<?php echo $production_employee_hs->uid->viewAttributes() ?>>
<?php echo $production_employee_hs->uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_employee_hs->id->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_id" class="production_employee_hs_id">
<span<?php echo $production_employee_hs->id->viewAttributes() ?>>
<?php echo $production_employee_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $production_employee_hs->grp->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_grp" class="production_employee_hs_grp">
<span<?php echo $production_employee_hs->grp->viewAttributes() ?>>
<?php echo $production_employee_hs->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->site->Visible) { // site ?>
		<td data-name="site"<?php echo $production_employee_hs->site->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_site" class="production_employee_hs_site">
<span<?php echo $production_employee_hs->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->site->getViewValue())) && $production_employee_hs->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->site->linkAttributes() ?>><?php echo $production_employee_hs->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->user_name->Visible) { // user_name ?>
		<td data-name="user_name"<?php echo $production_employee_hs->user_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_user_name" class="production_employee_hs_user_name">
<span<?php echo $production_employee_hs->user_name->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->user_name->getViewValue())) && $production_employee_hs->user_name->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->user_name->linkAttributes() ?>><?php echo $production_employee_hs->user_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->user_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->address->Visible) { // address ?>
		<td data-name="address"<?php echo $production_employee_hs->address->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_address" class="production_employee_hs_address">
<span<?php echo $production_employee_hs->address->viewAttributes() ?>>
<?php echo $production_employee_hs->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $production_employee_hs->mobile->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_mobile" class="production_employee_hs_mobile">
<span<?php echo $production_employee_hs->mobile->viewAttributes() ?>>
<?php echo $production_employee_hs->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->process->Visible) { // process ?>
		<td data-name="process"<?php echo $production_employee_hs->process->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_process" class="production_employee_hs_process">
<span<?php echo $production_employee_hs->process->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->process->getViewValue())) && $production_employee_hs->process->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->process->linkAttributes() ?>><?php echo $production_employee_hs->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->employee_name->Visible) { // employee_name ?>
		<td data-name="employee_name"<?php echo $production_employee_hs->employee_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_employee_name" class="production_employee_hs_employee_name">
<span<?php echo $production_employee_hs->employee_name->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->employee_name->getViewValue())) && $production_employee_hs->employee_name->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->employee_name->linkAttributes() ?>><?php echo $production_employee_hs->employee_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->employee_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->gender->Visible) { // gender ?>
		<td data-name="gender"<?php echo $production_employee_hs->gender->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_gender" class="production_employee_hs_gender">
<span<?php echo $production_employee_hs->gender->viewAttributes() ?>>
<?php echo $production_employee_hs->gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->father_name->Visible) { // father_name ?>
		<td data-name="father_name"<?php echo $production_employee_hs->father_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_father_name" class="production_employee_hs_father_name">
<span<?php echo $production_employee_hs->father_name->viewAttributes() ?>>
<?php echo $production_employee_hs->father_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->designation->Visible) { // designation ?>
		<td data-name="designation"<?php echo $production_employee_hs->designation->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_designation" class="production_employee_hs_designation">
<span<?php echo $production_employee_hs->designation->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->designation->getViewValue())) && $production_employee_hs->designation->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->designation->linkAttributes() ?>><?php echo $production_employee_hs->designation->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->designation->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->permanent_address->Visible) { // permanent_address ?>
		<td data-name="permanent_address"<?php echo $production_employee_hs->permanent_address->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_permanent_address" class="production_employee_hs_permanent_address">
<span<?php echo $production_employee_hs->permanent_address->viewAttributes() ?>>
<?php echo $production_employee_hs->permanent_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->city->Visible) { // city ?>
		<td data-name="city"<?php echo $production_employee_hs->city->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_city" class="production_employee_hs_city">
<span<?php echo $production_employee_hs->city->viewAttributes() ?>>
<?php echo $production_employee_hs->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->dob->Visible) { // dob ?>
		<td data-name="dob"<?php echo $production_employee_hs->dob->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_dob" class="production_employee_hs_dob">
<span<?php echo $production_employee_hs->dob->viewAttributes() ?>>
<?php echo $production_employee_hs->dob->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->dom->Visible) { // dom ?>
		<td data-name="dom"<?php echo $production_employee_hs->dom->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_dom" class="production_employee_hs_dom">
<span<?php echo $production_employee_hs->dom->viewAttributes() ?>>
<?php echo $production_employee_hs->dom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->mobile_other->Visible) { // mobile_other ?>
		<td data-name="mobile_other"<?php echo $production_employee_hs->mobile_other->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_mobile_other" class="production_employee_hs_mobile_other">
<span<?php echo $production_employee_hs->mobile_other->viewAttributes() ?>>
<?php echo $production_employee_hs->mobile_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->mobile_family->Visible) { // mobile_family ?>
		<td data-name="mobile_family"<?php echo $production_employee_hs->mobile_family->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_mobile_family" class="production_employee_hs_mobile_family">
<span<?php echo $production_employee_hs->mobile_family->viewAttributes() ?>>
<?php echo $production_employee_hs->mobile_family->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->marital_status->Visible) { // marital_status ?>
		<td data-name="marital_status"<?php echo $production_employee_hs->marital_status->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_marital_status" class="production_employee_hs_marital_status">
<span<?php echo $production_employee_hs->marital_status->viewAttributes() ?>>
<?php echo $production_employee_hs->marital_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->spouse_details->Visible) { // spouse_details ?>
		<td data-name="spouse_details"<?php echo $production_employee_hs->spouse_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_spouse_details" class="production_employee_hs_spouse_details">
<span<?php echo $production_employee_hs->spouse_details->viewAttributes() ?>>
<?php echo $production_employee_hs->spouse_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->emergency_details->Visible) { // emergency_details ?>
		<td data-name="emergency_details"<?php echo $production_employee_hs->emergency_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_emergency_details" class="production_employee_hs_emergency_details">
<span<?php echo $production_employee_hs->emergency_details->viewAttributes() ?>>
<?php echo $production_employee_hs->emergency_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->aadhaar_no->Visible) { // aadhaar_no ?>
		<td data-name="aadhaar_no"<?php echo $production_employee_hs->aadhaar_no->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_aadhaar_no" class="production_employee_hs_aadhaar_no">
<span<?php echo $production_employee_hs->aadhaar_no->viewAttributes() ?>>
<?php echo $production_employee_hs->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->id_proof->Visible) { // id_proof ?>
		<td data-name="id_proof"<?php echo $production_employee_hs->id_proof->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_id_proof" class="production_employee_hs_id_proof">
<span<?php echo $production_employee_hs->id_proof->viewAttributes() ?>>
<?php echo $production_employee_hs->id_proof->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->reference_details->Visible) { // reference_details ?>
		<td data-name="reference_details"<?php echo $production_employee_hs->reference_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_reference_details" class="production_employee_hs_reference_details">
<span<?php echo $production_employee_hs->reference_details->viewAttributes() ?>>
<?php echo $production_employee_hs->reference_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->doj->Visible) { // doj ?>
		<td data-name="doj"<?php echo $production_employee_hs->doj->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_doj" class="production_employee_hs_doj">
<span<?php echo $production_employee_hs->doj->viewAttributes() ?>>
<?php echo $production_employee_hs->doj->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->doc->Visible) { // doc ?>
		<td data-name="doc"<?php echo $production_employee_hs->doc->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_doc" class="production_employee_hs_doc">
<span<?php echo $production_employee_hs->doc->viewAttributes() ?>>
<?php echo $production_employee_hs->doc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->dol->Visible) { // dol ?>
		<td data-name="dol"<?php echo $production_employee_hs->dol->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_dol" class="production_employee_hs_dol">
<span<?php echo $production_employee_hs->dol->viewAttributes() ?>>
<?php echo $production_employee_hs->dol->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->image->Visible) { // image ?>
		<td data-name="image"<?php echo $production_employee_hs->image->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_image" class="production_employee_hs_image">
<span<?php echo $production_employee_hs->image->viewAttributes() ?>>
<?php echo GetFileViewTag($production_employee_hs->image, $production_employee_hs->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->bank_name->Visible) { // bank_name ?>
		<td data-name="bank_name"<?php echo $production_employee_hs->bank_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_bank_name" class="production_employee_hs_bank_name">
<span<?php echo $production_employee_hs->bank_name->viewAttributes() ?>>
<?php echo $production_employee_hs->bank_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
		<td data-name="bank_ifsc_code"<?php echo $production_employee_hs->bank_ifsc_code->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_bank_ifsc_code" class="production_employee_hs_bank_ifsc_code">
<span<?php echo $production_employee_hs->bank_ifsc_code->viewAttributes() ?>>
<?php echo $production_employee_hs->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->bank_account_no->Visible) { // bank_account_no ?>
		<td data-name="bank_account_no"<?php echo $production_employee_hs->bank_account_no->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_bank_account_no" class="production_employee_hs_bank_account_no">
<span<?php echo $production_employee_hs->bank_account_no->viewAttributes() ?>>
<?php echo $production_employee_hs->bank_account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->status->Visible) { // status ?>
		<td data-name="status"<?php echo $production_employee_hs->status->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_status" class="production_employee_hs_status">
<span<?php echo $production_employee_hs->status->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->status->getViewValue())) && $production_employee_hs->status->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->status->linkAttributes() ?>><?php echo $production_employee_hs->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_employee_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_operator" class="production_employee_hs_operator">
<span<?php echo $production_employee_hs->operator->viewAttributes() ?>>
<?php echo $production_employee_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_employee_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_datetime" class="production_employee_hs_datetime">
<span<?php echo $production_employee_hs->datetime->viewAttributes() ?>>
<?php echo $production_employee_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->d_operator->Visible) { // d_operator ?>
		<td data-name="d_operator"<?php echo $production_employee_hs->d_operator->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_d_operator" class="production_employee_hs_d_operator">
<span<?php echo $production_employee_hs->d_operator->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee_hs->d_operator->getViewValue())) && $production_employee_hs->d_operator->linkAttributes() <> "") { ?>
<a<?php echo $production_employee_hs->d_operator->linkAttributes() ?>><?php echo $production_employee_hs->d_operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee_hs->d_operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee_hs->d_datetime->Visible) { // d_datetime ?>
		<td data-name="d_datetime"<?php echo $production_employee_hs->d_datetime->cellAttributes() ?>>
<span id="el<?php echo $production_employee_hs_list->RowCnt ?>_production_employee_hs_d_datetime" class="production_employee_hs_d_datetime">
<span<?php echo $production_employee_hs->d_datetime->viewAttributes() ?>>
<?php echo $production_employee_hs->d_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_employee_hs_list->ListOptions->render("body", "right", $production_employee_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_employee_hs->isGridAdd())
		$production_employee_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_employee_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_employee_hs_list->Recordset)
	$production_employee_hs_list->Recordset->Close();
?>
<?php if (!$production_employee_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_employee_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_hs_list->Pager)) $production_employee_hs_list->Pager = new PrevNextPager($production_employee_hs_list->StartRec, $production_employee_hs_list->DisplayRecs, $production_employee_hs_list->TotalRecs, $production_employee_hs_list->AutoHidePager) ?>
<?php if ($production_employee_hs_list->Pager->RecordCount > 0 && $production_employee_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_hs_list->pageUrl() ?>start=<?php echo $production_employee_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_hs_list->TotalRecs > 0 && (!$production_employee_hs_list->AutoHidePageSizeSelector || $production_employee_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_employee_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_employee_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_employee_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_employee_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_employee_hs_list->TotalRecs == 0 && !$production_employee_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_employee_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_employee_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_employee_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_employee_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_hs_list->terminate();
?>