<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_add = new production_employee_add();

// Run the page
$production_employee_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduction_employeeadd = currentForm = new ew.Form("fproduction_employeeadd", "add");

// Validate form
fproduction_employeeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_employee_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->grp->caption(), $production_employee->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->site->caption(), $production_employee->site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->id->caption(), $production_employee->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkByRegEx(elm.value, /^[0-9]{1,5}$/))
				return this.onError(elm, "<?php echo JsEncode($production_employee->id->errorMessage()) ?>");
		<?php if ($production_employee_add->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->user_name->caption(), $production_employee->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->salary->Required) { ?>
			elm = this.getElements("x" + infix + "_salary");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->salary->caption(), $production_employee->salary->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_salary");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->salary->errorMessage()) ?>");
		<?php if ($production_employee_add->contractor->Required) { ?>
			elm = this.getElements("x" + infix + "_contractor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->contractor->caption(), $production_employee->contractor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile->caption(), $production_employee->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->mobile->errorMessage()) ?>");
		<?php if ($production_employee_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->category->caption(), $production_employee->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->process->caption(), $production_employee->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->status->caption(), $production_employee->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->employee_name->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->employee_name->caption(), $production_employee->employee_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->gender->caption(), $production_employee->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->father_name->caption(), $production_employee->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->designation->Required) { ?>
			elm = this.getElements("x" + infix + "_designation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->designation->caption(), $production_employee->designation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->permanent_address->caption(), $production_employee->permanent_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->city->caption(), $production_employee->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dob->caption(), $production_employee->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dob->errorMessage()) ?>");
		<?php if ($production_employee_add->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dom->caption(), $production_employee->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dom->errorMessage()) ?>");
		<?php if ($production_employee_add->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile_other->caption(), $production_employee->mobile_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile_family->caption(), $production_employee->mobile_family->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->marital_status->caption(), $production_employee->marital_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->spouse_details->caption(), $production_employee->spouse_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->emergency_details->caption(), $production_employee->emergency_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->pan_no->caption(), $production_employee->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->aadhaar_no->caption(), $production_employee->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($production_employee->aadhaar_no->errorMessage()) ?>");
		<?php if ($production_employee_add->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $production_employee->id_proof->caption(), $production_employee->id_proof->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->reference_details->caption(), $production_employee->reference_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->other_details->caption(), $production_employee->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->doj->Required) { ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->doj->caption(), $production_employee->doj->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->doj->errorMessage()) ?>");
		<?php if ($production_employee_add->dol->Required) { ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dol->caption(), $production_employee->dol->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dol->errorMessage()) ?>");
		<?php if ($production_employee_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $production_employee->image->caption(), $production_employee->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_name->caption(), $production_employee->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_ifsc_code->caption(), $production_employee->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_account_no->caption(), $production_employee->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->d_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_d_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->d_operator->caption(), $production_employee->d_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->d_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_d_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->d_datetime->caption(), $production_employee->d_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_add->am_id->Required) { ?>
			elm = this.getElements("x" + infix + "_am_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->am_id->caption(), $production_employee->am_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_am_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->am_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_employeeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employeeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employeeadd.lists["x_grp[]"] = <?php echo $production_employee_add->grp->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_grp[]"].options = <?php echo JsonEncode($production_employee_add->grp->lookupOptions()) ?>;
fproduction_employeeadd.lists["x_site[]"] = <?php echo $production_employee_add->site->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_site[]"].options = <?php echo JsonEncode($production_employee_add->site->lookupOptions()) ?>;
fproduction_employeeadd.lists["x_contractor"] = <?php echo $production_employee_add->contractor->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_contractor"].options = <?php echo JsonEncode($production_employee_add->contractor->lookupOptions()) ?>;
fproduction_employeeadd.lists["x_category"] = <?php echo $production_employee_add->category->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_category"].options = <?php echo JsonEncode($production_employee_add->category->options(FALSE, TRUE)) ?>;
fproduction_employeeadd.lists["x_process[]"] = <?php echo $production_employee_add->process->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_add->process->lookupOptions()) ?>;
fproduction_employeeadd.lists["x_status"] = <?php echo $production_employee_add->status->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_status"].options = <?php echo JsonEncode($production_employee_add->status->options(FALSE, TRUE)) ?>;
fproduction_employeeadd.lists["x_gender"] = <?php echo $production_employee_add->gender->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_gender"].options = <?php echo JsonEncode($production_employee_add->gender->options(FALSE, TRUE)) ?>;
fproduction_employeeadd.lists["x_marital_status"] = <?php echo $production_employee_add->marital_status->Lookup->toClientList() ?>;
fproduction_employeeadd.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_add->marital_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_employee_add->showPageHeader(); ?>
<?php
$production_employee_add->showMessage();
?>
<form name="fproduction_employeeadd" id="fproduction_employeeadd" class="<?php echo $production_employee_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$production_employee_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($production_employee->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_production_employee_grp" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->grp->caption() ?><?php echo ($production_employee->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->grp->cellAttributes() ?>>
<span id="el_production_employee_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_grp" data-value-separator="<?php echo $production_employee->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $production_employee->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $production_employee->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $production_employee->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $production_employee->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label id="elh_production_employee_site" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->site->caption() ?><?php echo ($production_employee->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->site->cellAttributes() ?>>
<span id="el_production_employee_site">
<div id="tp_x_site" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_site" data-value-separator="<?php echo $production_employee->site->displayValueSeparatorAttribute() ?>" name="x_site[]" id="x_site[]" value="{value}"<?php echo $production_employee->site->editAttributes() ?>></div>
<div id="dsl_x_site" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $production_employee->site->checkBoxListHtml(FALSE, "x_site[]") ?>
</div></div>
<?php echo $production_employee->site->Lookup->getParamTag("p_x_site") ?>
</span>
<?php echo $production_employee->site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_production_employee_id" for="x_id" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->id->caption() ?><?php echo ($production_employee->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->id->cellAttributes() ?>>
<span id="el_production_employee_id">
<input type="text" data-table="production_employee" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($production_employee->id->getPlaceHolder()) ?>" value="<?php echo $production_employee->id->EditValue ?>"<?php echo $production_employee->id->editAttributes() ?>>
</span>
<?php echo $production_employee->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_production_employee_user_name" for="x_user_name" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->user_name->caption() ?><?php echo ($production_employee->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->user_name->cellAttributes() ?>>
<span id="el_production_employee_user_name">
<input type="text" data-table="production_employee" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->user_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->user_name->EditValue ?>"<?php echo $production_employee->user_name->editAttributes() ?>>
</span>
<?php echo $production_employee->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->salary->Visible) { // salary ?>
	<div id="r_salary" class="form-group row">
		<label id="elh_production_employee_salary" for="x_salary" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->salary->caption() ?><?php echo ($production_employee->salary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->salary->cellAttributes() ?>>
<span id="el_production_employee_salary">
<input type="text" data-table="production_employee" data-field="x_salary" name="x_salary" id="x_salary" size="30" placeholder="<?php echo HtmlEncode($production_employee->salary->getPlaceHolder()) ?>" value="<?php echo $production_employee->salary->EditValue ?>"<?php echo $production_employee->salary->editAttributes() ?>>
</span>
<?php echo $production_employee->salary->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->contractor->Visible) { // contractor ?>
	<div id="r_contractor" class="form-group row">
		<label id="elh_production_employee_contractor" for="x_contractor" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->contractor->caption() ?><?php echo ($production_employee->contractor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->contractor->cellAttributes() ?>>
<span id="el_production_employee_contractor">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_contractor" data-value-separator="<?php echo $production_employee->contractor->displayValueSeparatorAttribute() ?>" id="x_contractor" name="x_contractor"<?php echo $production_employee->contractor->editAttributes() ?>>
		<?php echo $production_employee->contractor->selectOptionListHtml("x_contractor") ?>
	</select>
</div>
<?php echo $production_employee->contractor->Lookup->getParamTag("p_x_contractor") ?>
</span>
<?php echo $production_employee->contractor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_production_employee_mobile" for="x_mobile" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->mobile->caption() ?><?php echo ($production_employee->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->mobile->cellAttributes() ?>>
<span id="el_production_employee_mobile">
<input type="text" data-table="production_employee" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($production_employee->mobile->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile->EditValue ?>"<?php echo $production_employee->mobile->editAttributes() ?>>
</span>
<?php echo $production_employee->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_production_employee_category" for="x_category" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->category->caption() ?><?php echo ($production_employee->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->category->cellAttributes() ?>>
<span id="el_production_employee_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_category" data-value-separator="<?php echo $production_employee->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $production_employee->category->editAttributes() ?>>
		<?php echo $production_employee->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
</span>
<?php echo $production_employee->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_production_employee_process" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->process->caption() ?><?php echo ($production_employee->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->process->cellAttributes() ?>>
<span id="el_production_employee_process">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_process" data-value-separator="<?php echo $production_employee->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $production_employee->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_employee->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $production_employee->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $production_employee->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_production_employee_status" for="x_status" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->status->caption() ?><?php echo ($production_employee->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->status->cellAttributes() ?>>
<span id="el_production_employee_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_status" data-value-separator="<?php echo $production_employee->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_employee->status->editAttributes() ?>>
		<?php echo $production_employee->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $production_employee->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->employee_name->Visible) { // employee_name ?>
	<div id="r_employee_name" class="form-group row">
		<label id="elh_production_employee_employee_name" for="x_employee_name" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->employee_name->caption() ?><?php echo ($production_employee->employee_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->employee_name->cellAttributes() ?>>
<span id="el_production_employee_employee_name">
<input type="text" data-table="production_employee" data-field="x_employee_name" name="x_employee_name" id="x_employee_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->employee_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->employee_name->EditValue ?>"<?php echo $production_employee->employee_name->editAttributes() ?>>
</span>
<?php echo $production_employee->employee_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_production_employee_gender" for="x_gender" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->gender->caption() ?><?php echo ($production_employee->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->gender->cellAttributes() ?>>
<span id="el_production_employee_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_gender" data-value-separator="<?php echo $production_employee->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $production_employee->gender->editAttributes() ?>>
		<?php echo $production_employee->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
<?php echo $production_employee->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label id="elh_production_employee_father_name" for="x_father_name" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->father_name->caption() ?><?php echo ($production_employee->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->father_name->cellAttributes() ?>>
<span id="el_production_employee_father_name">
<input type="text" data-table="production_employee" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->father_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->father_name->EditValue ?>"<?php echo $production_employee->father_name->editAttributes() ?>>
</span>
<?php echo $production_employee->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->designation->Visible) { // designation ?>
	<div id="r_designation" class="form-group row">
		<label id="elh_production_employee_designation" for="x_designation" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->designation->caption() ?><?php echo ($production_employee->designation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->designation->cellAttributes() ?>>
<span id="el_production_employee_designation">
<input type="text" data-table="production_employee" data-field="x_designation" name="x_designation" id="x_designation" size="30" placeholder="<?php echo HtmlEncode($production_employee->designation->getPlaceHolder()) ?>" value="<?php echo $production_employee->designation->EditValue ?>"<?php echo $production_employee->designation->editAttributes() ?>>
</span>
<?php echo $production_employee->designation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->permanent_address->Visible) { // permanent_address ?>
	<div id="r_permanent_address" class="form-group row">
		<label id="elh_production_employee_permanent_address" for="x_permanent_address" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->permanent_address->caption() ?><?php echo ($production_employee->permanent_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->permanent_address->cellAttributes() ?>>
<span id="el_production_employee_permanent_address">
<textarea data-table="production_employee" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee->permanent_address->getPlaceHolder()) ?>"<?php echo $production_employee->permanent_address->editAttributes() ?>><?php echo $production_employee->permanent_address->EditValue ?></textarea>
</span>
<?php echo $production_employee->permanent_address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_production_employee_city" for="x_city" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->city->caption() ?><?php echo ($production_employee->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->city->cellAttributes() ?>>
<span id="el_production_employee_city">
<input type="text" data-table="production_employee" data-field="x_city" name="x_city" id="x_city" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->city->getPlaceHolder()) ?>" value="<?php echo $production_employee->city->EditValue ?>"<?php echo $production_employee->city->editAttributes() ?>>
</span>
<?php echo $production_employee->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_production_employee_dob" for="x_dob" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->dob->caption() ?><?php echo ($production_employee->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->dob->cellAttributes() ?>>
<span id="el_production_employee_dob">
<input type="text" data-table="production_employee" data-field="x_dob" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($production_employee->dob->getPlaceHolder()) ?>" value="<?php echo $production_employee->dob->EditValue ?>"<?php echo $production_employee->dob->editAttributes() ?>>
<?php if (!$production_employee->dob->ReadOnly && !$production_employee->dob->Disabled && !isset($production_employee->dob->EditAttrs["readonly"]) && !isset($production_employee->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeadd", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label id="elh_production_employee_dom" for="x_dom" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->dom->caption() ?><?php echo ($production_employee->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->dom->cellAttributes() ?>>
<span id="el_production_employee_dom">
<input type="text" data-table="production_employee" data-field="x_dom" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($production_employee->dom->getPlaceHolder()) ?>" value="<?php echo $production_employee->dom->EditValue ?>"<?php echo $production_employee->dom->editAttributes() ?>>
<?php if (!$production_employee->dom->ReadOnly && !$production_employee->dom->Disabled && !isset($production_employee->dom->EditAttrs["readonly"]) && !isset($production_employee->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeadd", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee->dom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile_other->Visible) { // mobile_other ?>
	<div id="r_mobile_other" class="form-group row">
		<label id="elh_production_employee_mobile_other" for="x_mobile_other" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->mobile_other->caption() ?><?php echo ($production_employee->mobile_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->mobile_other->cellAttributes() ?>>
<span id="el_production_employee_mobile_other">
<input type="text" data-table="production_employee" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($production_employee->mobile_other->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile_other->EditValue ?>"<?php echo $production_employee->mobile_other->editAttributes() ?>>
</span>
<?php echo $production_employee->mobile_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile_family->Visible) { // mobile_family ?>
	<div id="r_mobile_family" class="form-group row">
		<label id="elh_production_employee_mobile_family" for="x_mobile_family" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->mobile_family->caption() ?><?php echo ($production_employee->mobile_family->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->mobile_family->cellAttributes() ?>>
<span id="el_production_employee_mobile_family">
<input type="text" data-table="production_employee" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->mobile_family->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile_family->EditValue ?>"<?php echo $production_employee->mobile_family->editAttributes() ?>>
</span>
<?php echo $production_employee->mobile_family->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->marital_status->Visible) { // marital_status ?>
	<div id="r_marital_status" class="form-group row">
		<label id="elh_production_employee_marital_status" for="x_marital_status" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->marital_status->caption() ?><?php echo ($production_employee->marital_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->marital_status->cellAttributes() ?>>
<span id="el_production_employee_marital_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_marital_status" data-value-separator="<?php echo $production_employee->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $production_employee->marital_status->editAttributes() ?>>
		<?php echo $production_employee->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
</span>
<?php echo $production_employee->marital_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->spouse_details->Visible) { // spouse_details ?>
	<div id="r_spouse_details" class="form-group row">
		<label id="elh_production_employee_spouse_details" for="x_spouse_details" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->spouse_details->caption() ?><?php echo ($production_employee->spouse_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->spouse_details->cellAttributes() ?>>
<span id="el_production_employee_spouse_details">
<input type="text" data-table="production_employee" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->spouse_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->spouse_details->EditValue ?>"<?php echo $production_employee->spouse_details->editAttributes() ?>>
</span>
<?php echo $production_employee->spouse_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->emergency_details->Visible) { // emergency_details ?>
	<div id="r_emergency_details" class="form-group row">
		<label id="elh_production_employee_emergency_details" for="x_emergency_details" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->emergency_details->caption() ?><?php echo ($production_employee->emergency_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->emergency_details->cellAttributes() ?>>
<span id="el_production_employee_emergency_details">
<input type="text" data-table="production_employee" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->emergency_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->emergency_details->EditValue ?>"<?php echo $production_employee->emergency_details->editAttributes() ?>>
</span>
<?php echo $production_employee->emergency_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_production_employee_pan_no" for="x_pan_no" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->pan_no->caption() ?><?php echo ($production_employee->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->pan_no->cellAttributes() ?>>
<span id="el_production_employee_pan_no">
<input type="text" data-table="production_employee" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($production_employee->pan_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->pan_no->EditValue ?>"<?php echo $production_employee->pan_no->editAttributes() ?>>
</span>
<?php echo $production_employee->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_production_employee_aadhaar_no" for="x_aadhaar_no" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->aadhaar_no->caption() ?><?php echo ($production_employee->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->aadhaar_no->cellAttributes() ?>>
<span id="el_production_employee_aadhaar_no">
<input type="text" data-table="production_employee" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($production_employee->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->aadhaar_no->EditValue ?>"<?php echo $production_employee->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $production_employee->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label id="elh_production_employee_id_proof" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->id_proof->caption() ?><?php echo ($production_employee->id_proof->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->id_proof->cellAttributes() ?>>
<span id="el_production_employee_id_proof">
<div id="fd_x_id_proof">
<span title="<?php echo $production_employee->id_proof->title() ? $production_employee->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($production_employee->id_proof->ReadOnly || $production_employee->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="production_employee" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $production_employee->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $production_employee->id_proof->Upload->FileName ?>">
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $production_employee->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $production_employee->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $production_employee->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $production_employee->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->reference_details->Visible) { // reference_details ?>
	<div id="r_reference_details" class="form-group row">
		<label id="elh_production_employee_reference_details" for="x_reference_details" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->reference_details->caption() ?><?php echo ($production_employee->reference_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->reference_details->cellAttributes() ?>>
<span id="el_production_employee_reference_details">
<input type="text" data-table="production_employee" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->reference_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->reference_details->EditValue ?>"<?php echo $production_employee->reference_details->editAttributes() ?>>
</span>
<?php echo $production_employee->reference_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label id="elh_production_employee_other_details" for="x_other_details" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->other_details->caption() ?><?php echo ($production_employee->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->other_details->cellAttributes() ?>>
<span id="el_production_employee_other_details">
<textarea data-table="production_employee" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee->other_details->getPlaceHolder()) ?>"<?php echo $production_employee->other_details->editAttributes() ?>><?php echo $production_employee->other_details->EditValue ?></textarea>
</span>
<?php echo $production_employee->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->doj->Visible) { // doj ?>
	<div id="r_doj" class="form-group row">
		<label id="elh_production_employee_doj" for="x_doj" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->doj->caption() ?><?php echo ($production_employee->doj->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->doj->cellAttributes() ?>>
<span id="el_production_employee_doj">
<input type="text" data-table="production_employee" data-field="x_doj" name="x_doj" id="x_doj" placeholder="<?php echo HtmlEncode($production_employee->doj->getPlaceHolder()) ?>" value="<?php echo $production_employee->doj->EditValue ?>"<?php echo $production_employee->doj->editAttributes() ?>>
<?php if (!$production_employee->doj->ReadOnly && !$production_employee->doj->Disabled && !isset($production_employee->doj->EditAttrs["readonly"]) && !isset($production_employee->doj->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeadd", "x_doj", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee->doj->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->dol->Visible) { // dol ?>
	<div id="r_dol" class="form-group row">
		<label id="elh_production_employee_dol" for="x_dol" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->dol->caption() ?><?php echo ($production_employee->dol->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->dol->cellAttributes() ?>>
<span id="el_production_employee_dol">
<input type="text" data-table="production_employee" data-field="x_dol" name="x_dol" id="x_dol" placeholder="<?php echo HtmlEncode($production_employee->dol->getPlaceHolder()) ?>" value="<?php echo $production_employee->dol->EditValue ?>"<?php echo $production_employee->dol->editAttributes() ?>>
<?php if (!$production_employee->dol->ReadOnly && !$production_employee->dol->Disabled && !isset($production_employee->dol->EditAttrs["readonly"]) && !isset($production_employee->dol->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeadd", "x_dol", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $production_employee->dol->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_production_employee_image" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->image->caption() ?><?php echo ($production_employee->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->image->cellAttributes() ?>>
<span id="el_production_employee_image">
<div id="fd_x_image">
<span title="<?php echo $production_employee->image->title() ? $production_employee->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($production_employee->image->ReadOnly || $production_employee->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="production_employee" data-field="x_image" name="x_image" id="x_image"<?php echo $production_employee->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $production_employee->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $production_employee->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $production_employee->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $production_employee->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label id="elh_production_employee_bank_name" for="x_bank_name" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->bank_name->caption() ?><?php echo ($production_employee->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->bank_name->cellAttributes() ?>>
<span id="el_production_employee_bank_name">
<input type="text" data-table="production_employee" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->bank_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_name->EditValue ?>"<?php echo $production_employee->bank_name->editAttributes() ?>>
</span>
<?php echo $production_employee->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label id="elh_production_employee_bank_ifsc_code" for="x_bank_ifsc_code" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->bank_ifsc_code->caption() ?><?php echo ($production_employee->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->bank_ifsc_code->cellAttributes() ?>>
<span id="el_production_employee_bank_ifsc_code">
<input type="text" data-table="production_employee" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_ifsc_code->EditValue ?>"<?php echo $production_employee->bank_ifsc_code->editAttributes() ?>>
</span>
<?php echo $production_employee->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label id="elh_production_employee_bank_account_no" for="x_bank_account_no" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->bank_account_no->caption() ?><?php echo ($production_employee->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->bank_account_no->cellAttributes() ?>>
<span id="el_production_employee_bank_account_no">
<input type="text" data-table="production_employee" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_account_no->EditValue ?>"<?php echo $production_employee->bank_account_no->editAttributes() ?>>
</span>
<?php echo $production_employee->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_employee->am_id->Visible) { // am_id ?>
	<div id="r_am_id" class="form-group row">
		<label id="elh_production_employee_am_id" for="x_am_id" class="<?php echo $production_employee_add->LeftColumnClass ?>"><?php echo $production_employee->am_id->caption() ?><?php echo ($production_employee->am_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_employee_add->RightColumnClass ?>"><div<?php echo $production_employee->am_id->cellAttributes() ?>>
<span id="el_production_employee_am_id">
<input type="text" data-table="production_employee" data-field="x_am_id" name="x_am_id" id="x_am_id" size="30" placeholder="<?php echo HtmlEncode($production_employee->am_id->getPlaceHolder()) ?>" value="<?php echo $production_employee->am_id->EditValue ?>"<?php echo $production_employee->am_id->editAttributes() ?>>
</span>
<?php echo $production_employee->am_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_employee_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_employee_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_employee_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_employee_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

			$("#r_dol").hide();
</script>
<?php include_once "footer.php" ?>
<?php
$production_employee_add->terminate();
?>