<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_addopt = new production_employee_addopt();

// Run the page
$production_employee_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fproduction_employeeaddopt = currentForm = new ew.Form("fproduction_employeeaddopt", "addopt");

// Validate form
fproduction_employeeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_employee_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->grp->caption(), $production_employee->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->site->caption(), $production_employee->site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->user_name->caption(), $production_employee->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->salary->Required) { ?>
			elm = this.getElements("x" + infix + "_salary");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->salary->caption(), $production_employee->salary->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_salary");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->salary->errorMessage()) ?>");
		<?php if ($production_employee_addopt->contractor->Required) { ?>
			elm = this.getElements("x" + infix + "_contractor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->contractor->caption(), $production_employee->contractor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile->caption(), $production_employee->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->mobile->errorMessage()) ?>");
		<?php if ($production_employee_addopt->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->process->caption(), $production_employee->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->status->caption(), $production_employee->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->employee_name->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->employee_name->caption(), $production_employee->employee_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->gender->caption(), $production_employee->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->father_name->caption(), $production_employee->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->designation->Required) { ?>
			elm = this.getElements("x" + infix + "_designation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->designation->caption(), $production_employee->designation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->permanent_address->caption(), $production_employee->permanent_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->city->caption(), $production_employee->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dob->caption(), $production_employee->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dob->errorMessage()) ?>");
		<?php if ($production_employee_addopt->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dom->caption(), $production_employee->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dom->errorMessage()) ?>");
		<?php if ($production_employee_addopt->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile_other->caption(), $production_employee->mobile_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->mobile_family->caption(), $production_employee->mobile_family->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->marital_status->caption(), $production_employee->marital_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->spouse_details->caption(), $production_employee->spouse_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->emergency_details->caption(), $production_employee->emergency_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->pan_no->caption(), $production_employee->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->aadhaar_no->caption(), $production_employee->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($production_employee->aadhaar_no->errorMessage()) ?>");
		<?php if ($production_employee_addopt->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $production_employee->id_proof->caption(), $production_employee->id_proof->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->reference_details->caption(), $production_employee->reference_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->other_details->caption(), $production_employee->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->doj->Required) { ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->doj->caption(), $production_employee->doj->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_doj");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->doj->errorMessage()) ?>");
		<?php if ($production_employee_addopt->doc->Required) { ?>
			elm = this.getElements("x" + infix + "_doc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->doc->caption(), $production_employee->doc->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_doc");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->doc->errorMessage()) ?>");
		<?php if ($production_employee_addopt->dol->Required) { ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->dol->caption(), $production_employee->dol->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dol");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->dol->errorMessage()) ?>");
		<?php if ($production_employee_addopt->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $production_employee->image->caption(), $production_employee->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->payment_details->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->payment_details->caption(), $production_employee->payment_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_name->caption(), $production_employee->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_ifsc_code->caption(), $production_employee->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->bank_account_no->caption(), $production_employee->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->operator->caption(), $production_employee->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->operator->errorMessage()) ?>");
		<?php if ($production_employee_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->datetime->caption(), $production_employee->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->datetime->errorMessage()) ?>");
		<?php if ($production_employee_addopt->d_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_d_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->d_operator->caption(), $production_employee->d_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->d_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_d_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->d_datetime->caption(), $production_employee->d_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_employee_addopt->am_id->Required) { ?>
			elm = this.getElements("x" + infix + "_am_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_employee->am_id->caption(), $production_employee->am_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_am_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_employee->am_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_employeeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employeeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employeeaddopt.lists["x_grp[]"] = <?php echo $production_employee_addopt->grp->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_grp[]"].options = <?php echo JsonEncode($production_employee_addopt->grp->lookupOptions()) ?>;
fproduction_employeeaddopt.lists["x_site[]"] = <?php echo $production_employee_addopt->site->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_site[]"].options = <?php echo JsonEncode($production_employee_addopt->site->lookupOptions()) ?>;
fproduction_employeeaddopt.lists["x_contractor"] = <?php echo $production_employee_addopt->contractor->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_contractor"].options = <?php echo JsonEncode($production_employee_addopt->contractor->lookupOptions()) ?>;
fproduction_employeeaddopt.lists["x_process[]"] = <?php echo $production_employee_addopt->process->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_addopt->process->lookupOptions()) ?>;
fproduction_employeeaddopt.lists["x_status"] = <?php echo $production_employee_addopt->status->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_status"].options = <?php echo JsonEncode($production_employee_addopt->status->options(FALSE, TRUE)) ?>;
fproduction_employeeaddopt.lists["x_gender"] = <?php echo $production_employee_addopt->gender->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_gender"].options = <?php echo JsonEncode($production_employee_addopt->gender->options(FALSE, TRUE)) ?>;
fproduction_employeeaddopt.lists["x_marital_status"] = <?php echo $production_employee_addopt->marital_status->Lookup->toClientList() ?>;
fproduction_employeeaddopt.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_addopt->marital_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_employee_addopt->showPageHeader(); ?>
<?php
$production_employee_addopt->showMessage();
?>
<form name="fproduction_employeeaddopt" id="fproduction_employeeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($production_employee_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $production_employee_addopt->TableVar ?>">
<?php if ($production_employee->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_employee->grp->caption() ?><?php echo ($production_employee->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_grp" data-value-separator="<?php echo $production_employee->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $production_employee->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $production_employee->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $production_employee->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $production_employee->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->site->Visible) { // site ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_employee->site->caption() ?><?php echo ($production_employee->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_site" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_site" data-value-separator="<?php echo $production_employee->site->displayValueSeparatorAttribute() ?>" name="x_site[]" id="x_site[]" value="{value}"<?php echo $production_employee->site->editAttributes() ?>></div>
<div id="dsl_x_site" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $production_employee->site->checkBoxListHtml(FALSE, "x_site[]") ?>
</div></div>
<?php echo $production_employee->site->Lookup->getParamTag("p_x_site") ?>
<?php echo $production_employee->site->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->user_name->Visible) { // user_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_user_name"><?php echo $production_employee->user_name->caption() ?><?php echo ($production_employee->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->user_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->user_name->EditValue ?>"<?php echo $production_employee->user_name->editAttributes() ?>>
<?php echo $production_employee->user_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->salary->Visible) { // salary ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_salary"><?php echo $production_employee->salary->caption() ?><?php echo ($production_employee->salary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_salary" name="x_salary" id="x_salary" size="30" placeholder="<?php echo HtmlEncode($production_employee->salary->getPlaceHolder()) ?>" value="<?php echo $production_employee->salary->EditValue ?>"<?php echo $production_employee->salary->editAttributes() ?>>
<?php echo $production_employee->salary->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->contractor->Visible) { // contractor ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_contractor"><?php echo $production_employee->contractor->caption() ?><?php echo ($production_employee->contractor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_contractor" data-value-separator="<?php echo $production_employee->contractor->displayValueSeparatorAttribute() ?>" id="x_contractor" name="x_contractor"<?php echo $production_employee->contractor->editAttributes() ?>>
		<?php echo $production_employee->contractor->selectOptionListHtml("x_contractor") ?>
	</select>
</div>
<?php echo $production_employee->contractor->Lookup->getParamTag("p_x_contractor") ?>
<?php echo $production_employee->contractor->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile->Visible) { // mobile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?php echo $production_employee->mobile->caption() ?><?php echo ($production_employee->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($production_employee->mobile->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile->EditValue ?>"<?php echo $production_employee->mobile->editAttributes() ?>>
<?php echo $production_employee->mobile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->process->Visible) { // process ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_employee->process->caption() ?><?php echo ($production_employee->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_process" data-value-separator="<?php echo $production_employee->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $production_employee->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_employee->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $production_employee->process->Lookup->getParamTag("p_x_process") ?>
<?php echo $production_employee->process->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $production_employee->status->caption() ?><?php echo ($production_employee->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_status" data-value-separator="<?php echo $production_employee->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_employee->status->editAttributes() ?>>
		<?php echo $production_employee->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $production_employee->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->employee_name->Visible) { // employee_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_employee_name"><?php echo $production_employee->employee_name->caption() ?><?php echo ($production_employee->employee_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_employee_name" name="x_employee_name" id="x_employee_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->employee_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->employee_name->EditValue ?>"<?php echo $production_employee->employee_name->editAttributes() ?>>
<?php echo $production_employee->employee_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->gender->Visible) { // gender ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_gender"><?php echo $production_employee->gender->caption() ?><?php echo ($production_employee->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_gender" data-value-separator="<?php echo $production_employee->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $production_employee->gender->editAttributes() ?>>
		<?php echo $production_employee->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
<?php echo $production_employee->gender->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->father_name->Visible) { // father_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_father_name"><?php echo $production_employee->father_name->caption() ?><?php echo ($production_employee->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($production_employee->father_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->father_name->EditValue ?>"<?php echo $production_employee->father_name->editAttributes() ?>>
<?php echo $production_employee->father_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->designation->Visible) { // designation ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_designation"><?php echo $production_employee->designation->caption() ?><?php echo ($production_employee->designation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_designation" name="x_designation" id="x_designation" size="30" placeholder="<?php echo HtmlEncode($production_employee->designation->getPlaceHolder()) ?>" value="<?php echo $production_employee->designation->EditValue ?>"<?php echo $production_employee->designation->editAttributes() ?>>
<?php echo $production_employee->designation->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->permanent_address->Visible) { // permanent_address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_permanent_address"><?php echo $production_employee->permanent_address->caption() ?><?php echo ($production_employee->permanent_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_employee" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee->permanent_address->getPlaceHolder()) ?>"<?php echo $production_employee->permanent_address->editAttributes() ?>><?php echo $production_employee->permanent_address->EditValue ?></textarea>
<?php echo $production_employee->permanent_address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->city->Visible) { // city ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_city"><?php echo $production_employee->city->caption() ?><?php echo ($production_employee->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_city" name="x_city" id="x_city" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->city->getPlaceHolder()) ?>" value="<?php echo $production_employee->city->EditValue ?>"<?php echo $production_employee->city->editAttributes() ?>>
<?php echo $production_employee->city->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->dob->Visible) { // dob ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_dob"><?php echo $production_employee->dob->caption() ?><?php echo ($production_employee->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_dob" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($production_employee->dob->getPlaceHolder()) ?>" value="<?php echo $production_employee->dob->EditValue ?>"<?php echo $production_employee->dob->editAttributes() ?>>
<?php if (!$production_employee->dob->ReadOnly && !$production_employee->dob->Disabled && !isset($production_employee->dob->EditAttrs["readonly"]) && !isset($production_employee->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->dob->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->dom->Visible) { // dom ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_dom"><?php echo $production_employee->dom->caption() ?><?php echo ($production_employee->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_dom" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($production_employee->dom->getPlaceHolder()) ?>" value="<?php echo $production_employee->dom->EditValue ?>"<?php echo $production_employee->dom->editAttributes() ?>>
<?php if (!$production_employee->dom->ReadOnly && !$production_employee->dom->Disabled && !isset($production_employee->dom->EditAttrs["readonly"]) && !isset($production_employee->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->dom->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile_other->Visible) { // mobile_other ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_other"><?php echo $production_employee->mobile_other->caption() ?><?php echo ($production_employee->mobile_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($production_employee->mobile_other->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile_other->EditValue ?>"<?php echo $production_employee->mobile_other->editAttributes() ?>>
<?php echo $production_employee->mobile_other->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->mobile_family->Visible) { // mobile_family ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_family"><?php echo $production_employee->mobile_family->caption() ?><?php echo ($production_employee->mobile_family->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->mobile_family->getPlaceHolder()) ?>" value="<?php echo $production_employee->mobile_family->EditValue ?>"<?php echo $production_employee->mobile_family->editAttributes() ?>>
<?php echo $production_employee->mobile_family->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->marital_status->Visible) { // marital_status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_marital_status"><?php echo $production_employee->marital_status->caption() ?><?php echo ($production_employee->marital_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_employee" data-field="x_marital_status" data-value-separator="<?php echo $production_employee->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $production_employee->marital_status->editAttributes() ?>>
		<?php echo $production_employee->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
<?php echo $production_employee->marital_status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->spouse_details->Visible) { // spouse_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_spouse_details"><?php echo $production_employee->spouse_details->caption() ?><?php echo ($production_employee->spouse_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->spouse_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->spouse_details->EditValue ?>"<?php echo $production_employee->spouse_details->editAttributes() ?>>
<?php echo $production_employee->spouse_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->emergency_details->Visible) { // emergency_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_emergency_details"><?php echo $production_employee->emergency_details->caption() ?><?php echo ($production_employee->emergency_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->emergency_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->emergency_details->EditValue ?>"<?php echo $production_employee->emergency_details->editAttributes() ?>>
<?php echo $production_employee->emergency_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->pan_no->Visible) { // pan_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_pan_no"><?php echo $production_employee->pan_no->caption() ?><?php echo ($production_employee->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($production_employee->pan_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->pan_no->EditValue ?>"<?php echo $production_employee->pan_no->editAttributes() ?>>
<?php echo $production_employee->pan_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->aadhaar_no->Visible) { // aadhaar_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_aadhaar_no"><?php echo $production_employee->aadhaar_no->caption() ?><?php echo ($production_employee->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($production_employee->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->aadhaar_no->EditValue ?>"<?php echo $production_employee->aadhaar_no->editAttributes() ?>>
<?php echo $production_employee->aadhaar_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->id_proof->Visible) { // id_proof ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_employee->id_proof->caption() ?><?php echo ($production_employee->id_proof->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_id_proof">
<span title="<?php echo $production_employee->id_proof->title() ? $production_employee->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($production_employee->id_proof->ReadOnly || $production_employee->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="production_employee" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $production_employee->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $production_employee->id_proof->Upload->FileName ?>">
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $production_employee->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $production_employee->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $production_employee->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $production_employee->id_proof->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->reference_details->Visible) { // reference_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reference_details"><?php echo $production_employee->reference_details->caption() ?><?php echo ($production_employee->reference_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->reference_details->getPlaceHolder()) ?>" value="<?php echo $production_employee->reference_details->EditValue ?>"<?php echo $production_employee->reference_details->editAttributes() ?>>
<?php echo $production_employee->reference_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->other_details->Visible) { // other_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_other_details"><?php echo $production_employee->other_details->caption() ?><?php echo ($production_employee->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_employee" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee->other_details->getPlaceHolder()) ?>"<?php echo $production_employee->other_details->editAttributes() ?>><?php echo $production_employee->other_details->EditValue ?></textarea>
<?php echo $production_employee->other_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->doj->Visible) { // doj ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_doj"><?php echo $production_employee->doj->caption() ?><?php echo ($production_employee->doj->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_doj" name="x_doj" id="x_doj" placeholder="<?php echo HtmlEncode($production_employee->doj->getPlaceHolder()) ?>" value="<?php echo $production_employee->doj->EditValue ?>"<?php echo $production_employee->doj->editAttributes() ?>>
<?php if (!$production_employee->doj->ReadOnly && !$production_employee->doj->Disabled && !isset($production_employee->doj->EditAttrs["readonly"]) && !isset($production_employee->doj->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_doj", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->doj->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->doc->Visible) { // doc ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_doc"><?php echo $production_employee->doc->caption() ?><?php echo ($production_employee->doc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_doc" name="x_doc" id="x_doc" placeholder="<?php echo HtmlEncode($production_employee->doc->getPlaceHolder()) ?>" value="<?php echo $production_employee->doc->EditValue ?>"<?php echo $production_employee->doc->editAttributes() ?>>
<?php if (!$production_employee->doc->ReadOnly && !$production_employee->doc->Disabled && !isset($production_employee->doc->EditAttrs["readonly"]) && !isset($production_employee->doc->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_doc", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->doc->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->dol->Visible) { // dol ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_dol"><?php echo $production_employee->dol->caption() ?><?php echo ($production_employee->dol->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_dol" name="x_dol" id="x_dol" placeholder="<?php echo HtmlEncode($production_employee->dol->getPlaceHolder()) ?>" value="<?php echo $production_employee->dol->EditValue ?>"<?php echo $production_employee->dol->editAttributes() ?>>
<?php if (!$production_employee->dol->ReadOnly && !$production_employee->dol->Disabled && !isset($production_employee->dol->EditAttrs["readonly"]) && !isset($production_employee->dol->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_dol", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->dol->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->image->Visible) { // image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_employee->image->caption() ?><?php echo ($production_employee->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_image">
<span title="<?php echo $production_employee->image->title() ? $production_employee->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($production_employee->image->ReadOnly || $production_employee->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="production_employee" data-field="x_image" name="x_image" id="x_image"<?php echo $production_employee->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $production_employee->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $production_employee->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $production_employee->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $production_employee->image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->payment_details->Visible) { // payment_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_payment_details"><?php echo $production_employee->payment_details->caption() ?><?php echo ($production_employee->payment_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_employee" data-field="x_payment_details" name="x_payment_details" id="x_payment_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_employee->payment_details->getPlaceHolder()) ?>"<?php echo $production_employee->payment_details->editAttributes() ?>><?php echo $production_employee->payment_details->EditValue ?></textarea>
<?php echo $production_employee->payment_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_name->Visible) { // bank_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_name"><?php echo $production_employee->bank_name->caption() ?><?php echo ($production_employee->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_employee->bank_name->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_name->EditValue ?>"<?php echo $production_employee->bank_name->editAttributes() ?>>
<?php echo $production_employee->bank_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_ifsc_code"><?php echo $production_employee->bank_ifsc_code->caption() ?><?php echo ($production_employee->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_ifsc_code->EditValue ?>"<?php echo $production_employee->bank_ifsc_code->editAttributes() ?>>
<?php echo $production_employee->bank_ifsc_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->bank_account_no->Visible) { // bank_account_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_account_no"><?php echo $production_employee->bank_account_no->caption() ?><?php echo ($production_employee->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($production_employee->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $production_employee->bank_account_no->EditValue ?>"<?php echo $production_employee->bank_account_no->editAttributes() ?>>
<?php echo $production_employee->bank_account_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->operator->Visible) { // operator ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_operator"><?php echo $production_employee->operator->caption() ?><?php echo ($production_employee->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($production_employee->operator->getPlaceHolder()) ?>" value="<?php echo $production_employee->operator->EditValue ?>"<?php echo $production_employee->operator->editAttributes() ?>>
<?php echo $production_employee->operator->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->datetime->Visible) { // datetime ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_datetime"><?php echo $production_employee->datetime->caption() ?><?php echo ($production_employee->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($production_employee->datetime->getPlaceHolder()) ?>" value="<?php echo $production_employee->datetime->EditValue ?>"<?php echo $production_employee->datetime->editAttributes() ?>>
<?php if (!$production_employee->datetime->ReadOnly && !$production_employee->datetime->Disabled && !isset($production_employee->datetime->EditAttrs["readonly"]) && !isset($production_employee->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_employeeaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $production_employee->datetime->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_employee->d_operator->Visible) { // d_operator ?>
	<input type="hidden" data-table="production_employee" data-field="x_d_operator" name="x_d_operator" id="x_d_operator" value="<?php echo HtmlEncode($production_employee->d_operator->CurrentValue) ?>">
<?php } ?>
<?php if ($production_employee->d_datetime->Visible) { // d_datetime ?>
	<input type="hidden" data-table="production_employee" data-field="x_d_datetime" name="x_d_datetime" id="x_d_datetime" value="<?php echo HtmlEncode($production_employee->d_datetime->CurrentValue) ?>">
	<?php if (!$production_employee->d_datetime->ReadOnly && !$production_employee->d_datetime->Disabled && !isset($production_employee->d_datetime->EditAttrs["readonly"]) && !isset($production_employee->d_datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fproduction_employeeaddopt", "x_d_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->am_id->Visible) { // am_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_am_id"><?php echo $production_employee->am_id->caption() ?><?php echo ($production_employee->am_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_employee" data-field="x_am_id" name="x_am_id" id="x_am_id" size="30" placeholder="<?php echo HtmlEncode($production_employee->am_id->getPlaceHolder()) ?>" value="<?php echo $production_employee->am_id->EditValue ?>"<?php echo $production_employee->am_id->editAttributes() ?>>
<?php echo $production_employee->am_id->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$production_employee_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var status = $("#x_status").val();
		if (status == 1)
		{
			$("#x_dol").val('');
			$("#r_dol").hide();
		}
		else
		{
			$("#r_dol").show();
		}
</script>
<?php
$production_employee_addopt->terminate();
?>