<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_list = new production_employee_list();

// Run the page
$production_employee_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_employeelist = currentForm = new ew.Form("fproduction_employeelist", "list");
fproduction_employeelist.formKeyCountName = '<?php echo $production_employee_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_employeelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employeelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employeelist.lists["x_grp[]"] = <?php echo $production_employee_list->grp->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_grp[]"].options = <?php echo JsonEncode($production_employee_list->grp->lookupOptions()) ?>;
fproduction_employeelist.lists["x_site[]"] = <?php echo $production_employee_list->site->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_site[]"].options = <?php echo JsonEncode($production_employee_list->site->lookupOptions()) ?>;
fproduction_employeelist.lists["x_contractor"] = <?php echo $production_employee_list->contractor->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_contractor"].options = <?php echo JsonEncode($production_employee_list->contractor->lookupOptions()) ?>;
fproduction_employeelist.lists["x_process[]"] = <?php echo $production_employee_list->process->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_list->process->lookupOptions()) ?>;
fproduction_employeelist.lists["x_status"] = <?php echo $production_employee_list->status->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_status"].options = <?php echo JsonEncode($production_employee_list->status->options(FALSE, TRUE)) ?>;
fproduction_employeelist.lists["x_gender"] = <?php echo $production_employee_list->gender->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_gender"].options = <?php echo JsonEncode($production_employee_list->gender->options(FALSE, TRUE)) ?>;
fproduction_employeelist.lists["x_marital_status"] = <?php echo $production_employee_list->marital_status->Lookup->toClientList() ?>;
fproduction_employeelist.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_list->marital_status->options(FALSE, TRUE)) ?>;

// Form object for search
var fproduction_employeelistsrch = currentSearchForm = new ew.Form("fproduction_employeelistsrch");

// Filters
fproduction_employeelistsrch.filterList = <?php echo $production_employee_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_employeelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var PrintECard = function(CID)
{
	  var CAID =[];
	  $("#tbl_production_employeelist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });
	  if(CAID.length>0)
	  {

	  	//location.href='employee_card.php?id=' + CAID.toString();
	  	window.open('employee_card.php?id=' + CAID.toString(), '_blank');
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
</script>
<?php } ?>
<?php if (!$production_employee->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_employee_list->TotalRecs > 0 && $production_employee_list->ExportOptions->visible()) { ?>
<?php $production_employee_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_list->ImportOptions->visible()) { ?>
<?php $production_employee_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_list->SearchOptions->visible()) { ?>
<?php $production_employee_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_employee_list->FilterOptions->visible()) { ?>
<?php $production_employee_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_employee_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_employee->isExport() && !$production_employee->CurrentAction) { ?>
<form name="fproduction_employeelistsrch" id="fproduction_employeelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_employee_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_employeelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_employee">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_employee_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_employee_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_employee_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_employee_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_employee_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_employee_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_employee_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_employee_list->showPageHeader(); ?>
<?php
$production_employee_list->showMessage();
?>
<?php if ($production_employee_list->TotalRecs > 0 || $production_employee->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_employee_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_employee">
<?php if (!$production_employee->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_employee->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_list->Pager)) $production_employee_list->Pager = new PrevNextPager($production_employee_list->StartRec, $production_employee_list->DisplayRecs, $production_employee_list->TotalRecs, $production_employee_list->AutoHidePager) ?>
<?php if ($production_employee_list->Pager->RecordCount > 0 && $production_employee_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_list->TotalRecs > 0 && (!$production_employee_list->AutoHidePageSizeSelector || $production_employee_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($production_employee_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($production_employee->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_employeelist" id="fproduction_employeelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_production_employee" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_employee_list->TotalRecs > 0 || $production_employee->isGridEdit()) { ?>
<table id="tbl_production_employeelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_employee_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_employee_list->renderListOptions();

// Render list options (header, left)
$production_employee_list->ListOptions->render("header", "left");
?>
<?php if ($production_employee->grp->Visible) { // grp ?>
	<?php if ($production_employee->sortUrl($production_employee->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $production_employee->grp->headerCellClass() ?>"><div id="elh_production_employee_grp" class="production_employee_grp"><div class="ew-table-header-caption"><?php echo $production_employee->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $production_employee->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->grp) ?>',1);"><div id="elh_production_employee_grp" class="production_employee_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->site->Visible) { // site ?>
	<?php if ($production_employee->sortUrl($production_employee->site) == "") { ?>
		<th data-name="site" class="<?php echo $production_employee->site->headerCellClass() ?>"><div id="elh_production_employee_site" class="production_employee_site"><div class="ew-table-header-caption"><?php echo $production_employee->site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="site" class="<?php echo $production_employee->site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->site) ?>',1);"><div id="elh_production_employee_site" class="production_employee_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->site->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->id->Visible) { // id ?>
	<?php if ($production_employee->sortUrl($production_employee->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_employee->id->headerCellClass() ?>"><div id="elh_production_employee_id" class="production_employee_id"><div class="ew-table-header-caption"><?php echo $production_employee->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_employee->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->id) ?>',1);"><div id="elh_production_employee_id" class="production_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->user_name->Visible) { // user_name ?>
	<?php if ($production_employee->sortUrl($production_employee->user_name) == "") { ?>
		<th data-name="user_name" class="<?php echo $production_employee->user_name->headerCellClass() ?>"><div id="elh_production_employee_user_name" class="production_employee_user_name"><div class="ew-table-header-caption"><?php echo $production_employee->user_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_name" class="<?php echo $production_employee->user_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->user_name) ?>',1);"><div id="elh_production_employee_user_name" class="production_employee_user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->user_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->user_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->user_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->salary->Visible) { // salary ?>
	<?php if ($production_employee->sortUrl($production_employee->salary) == "") { ?>
		<th data-name="salary" class="<?php echo $production_employee->salary->headerCellClass() ?>"><div id="elh_production_employee_salary" class="production_employee_salary"><div class="ew-table-header-caption"><?php echo $production_employee->salary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salary" class="<?php echo $production_employee->salary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->salary) ?>',1);"><div id="elh_production_employee_salary" class="production_employee_salary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->salary->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->salary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->salary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->contractor->Visible) { // contractor ?>
	<?php if ($production_employee->sortUrl($production_employee->contractor) == "") { ?>
		<th data-name="contractor" class="<?php echo $production_employee->contractor->headerCellClass() ?>"><div id="elh_production_employee_contractor" class="production_employee_contractor"><div class="ew-table-header-caption"><?php echo $production_employee->contractor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contractor" class="<?php echo $production_employee->contractor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->contractor) ?>',1);"><div id="elh_production_employee_contractor" class="production_employee_contractor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->contractor->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->contractor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->contractor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->mobile->Visible) { // mobile ?>
	<?php if ($production_employee->sortUrl($production_employee->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $production_employee->mobile->headerCellClass() ?>"><div id="elh_production_employee_mobile" class="production_employee_mobile"><div class="ew-table-header-caption"><?php echo $production_employee->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $production_employee->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->mobile) ?>',1);"><div id="elh_production_employee_mobile" class="production_employee_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->process->Visible) { // process ?>
	<?php if ($production_employee->sortUrl($production_employee->process) == "") { ?>
		<th data-name="process" class="<?php echo $production_employee->process->headerCellClass() ?>"><div id="elh_production_employee_process" class="production_employee_process"><div class="ew-table-header-caption"><?php echo $production_employee->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $production_employee->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->process) ?>',1);"><div id="elh_production_employee_process" class="production_employee_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->status->Visible) { // status ?>
	<?php if ($production_employee->sortUrl($production_employee->status) == "") { ?>
		<th data-name="status" class="<?php echo $production_employee->status->headerCellClass() ?>"><div id="elh_production_employee_status" class="production_employee_status"><div class="ew-table-header-caption"><?php echo $production_employee->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $production_employee->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->status) ?>',1);"><div id="elh_production_employee_status" class="production_employee_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->employee_name->Visible) { // employee_name ?>
	<?php if ($production_employee->sortUrl($production_employee->employee_name) == "") { ?>
		<th data-name="employee_name" class="<?php echo $production_employee->employee_name->headerCellClass() ?>"><div id="elh_production_employee_employee_name" class="production_employee_employee_name"><div class="ew-table-header-caption"><?php echo $production_employee->employee_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_name" class="<?php echo $production_employee->employee_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->employee_name) ?>',1);"><div id="elh_production_employee_employee_name" class="production_employee_employee_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->employee_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->employee_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->employee_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->gender->Visible) { // gender ?>
	<?php if ($production_employee->sortUrl($production_employee->gender) == "") { ?>
		<th data-name="gender" class="<?php echo $production_employee->gender->headerCellClass() ?>"><div id="elh_production_employee_gender" class="production_employee_gender"><div class="ew-table-header-caption"><?php echo $production_employee->gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gender" class="<?php echo $production_employee->gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->gender) ?>',1);"><div id="elh_production_employee_gender" class="production_employee_gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->father_name->Visible) { // father_name ?>
	<?php if ($production_employee->sortUrl($production_employee->father_name) == "") { ?>
		<th data-name="father_name" class="<?php echo $production_employee->father_name->headerCellClass() ?>"><div id="elh_production_employee_father_name" class="production_employee_father_name"><div class="ew-table-header-caption"><?php echo $production_employee->father_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="father_name" class="<?php echo $production_employee->father_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->father_name) ?>',1);"><div id="elh_production_employee_father_name" class="production_employee_father_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->father_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->father_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->father_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->designation->Visible) { // designation ?>
	<?php if ($production_employee->sortUrl($production_employee->designation) == "") { ?>
		<th data-name="designation" class="<?php echo $production_employee->designation->headerCellClass() ?>"><div id="elh_production_employee_designation" class="production_employee_designation"><div class="ew-table-header-caption"><?php echo $production_employee->designation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="designation" class="<?php echo $production_employee->designation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->designation) ?>',1);"><div id="elh_production_employee_designation" class="production_employee_designation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->designation->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->designation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->designation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->permanent_address->Visible) { // permanent_address ?>
	<?php if ($production_employee->sortUrl($production_employee->permanent_address) == "") { ?>
		<th data-name="permanent_address" class="<?php echo $production_employee->permanent_address->headerCellClass() ?>"><div id="elh_production_employee_permanent_address" class="production_employee_permanent_address"><div class="ew-table-header-caption"><?php echo $production_employee->permanent_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="permanent_address" class="<?php echo $production_employee->permanent_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->permanent_address) ?>',1);"><div id="elh_production_employee_permanent_address" class="production_employee_permanent_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->permanent_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->permanent_address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->permanent_address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->city->Visible) { // city ?>
	<?php if ($production_employee->sortUrl($production_employee->city) == "") { ?>
		<th data-name="city" class="<?php echo $production_employee->city->headerCellClass() ?>"><div id="elh_production_employee_city" class="production_employee_city"><div class="ew-table-header-caption"><?php echo $production_employee->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $production_employee->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->city) ?>',1);"><div id="elh_production_employee_city" class="production_employee_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->city->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->dob->Visible) { // dob ?>
	<?php if ($production_employee->sortUrl($production_employee->dob) == "") { ?>
		<th data-name="dob" class="<?php echo $production_employee->dob->headerCellClass() ?>"><div id="elh_production_employee_dob" class="production_employee_dob"><div class="ew-table-header-caption"><?php echo $production_employee->dob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dob" class="<?php echo $production_employee->dob->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->dob) ?>',1);"><div id="elh_production_employee_dob" class="production_employee_dob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->dob->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->dob->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->dob->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->dom->Visible) { // dom ?>
	<?php if ($production_employee->sortUrl($production_employee->dom) == "") { ?>
		<th data-name="dom" class="<?php echo $production_employee->dom->headerCellClass() ?>"><div id="elh_production_employee_dom" class="production_employee_dom"><div class="ew-table-header-caption"><?php echo $production_employee->dom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dom" class="<?php echo $production_employee->dom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->dom) ?>',1);"><div id="elh_production_employee_dom" class="production_employee_dom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->dom->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->dom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->dom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->mobile_other->Visible) { // mobile_other ?>
	<?php if ($production_employee->sortUrl($production_employee->mobile_other) == "") { ?>
		<th data-name="mobile_other" class="<?php echo $production_employee->mobile_other->headerCellClass() ?>"><div id="elh_production_employee_mobile_other" class="production_employee_mobile_other"><div class="ew-table-header-caption"><?php echo $production_employee->mobile_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_other" class="<?php echo $production_employee->mobile_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->mobile_other) ?>',1);"><div id="elh_production_employee_mobile_other" class="production_employee_mobile_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->mobile_other->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->mobile_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->mobile_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->mobile_family->Visible) { // mobile_family ?>
	<?php if ($production_employee->sortUrl($production_employee->mobile_family) == "") { ?>
		<th data-name="mobile_family" class="<?php echo $production_employee->mobile_family->headerCellClass() ?>"><div id="elh_production_employee_mobile_family" class="production_employee_mobile_family"><div class="ew-table-header-caption"><?php echo $production_employee->mobile_family->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_family" class="<?php echo $production_employee->mobile_family->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->mobile_family) ?>',1);"><div id="elh_production_employee_mobile_family" class="production_employee_mobile_family">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->mobile_family->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->mobile_family->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->mobile_family->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->marital_status->Visible) { // marital_status ?>
	<?php if ($production_employee->sortUrl($production_employee->marital_status) == "") { ?>
		<th data-name="marital_status" class="<?php echo $production_employee->marital_status->headerCellClass() ?>"><div id="elh_production_employee_marital_status" class="production_employee_marital_status"><div class="ew-table-header-caption"><?php echo $production_employee->marital_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marital_status" class="<?php echo $production_employee->marital_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->marital_status) ?>',1);"><div id="elh_production_employee_marital_status" class="production_employee_marital_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->marital_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->marital_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->marital_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->spouse_details->Visible) { // spouse_details ?>
	<?php if ($production_employee->sortUrl($production_employee->spouse_details) == "") { ?>
		<th data-name="spouse_details" class="<?php echo $production_employee->spouse_details->headerCellClass() ?>"><div id="elh_production_employee_spouse_details" class="production_employee_spouse_details"><div class="ew-table-header-caption"><?php echo $production_employee->spouse_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="spouse_details" class="<?php echo $production_employee->spouse_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->spouse_details) ?>',1);"><div id="elh_production_employee_spouse_details" class="production_employee_spouse_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->spouse_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->spouse_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->spouse_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->emergency_details->Visible) { // emergency_details ?>
	<?php if ($production_employee->sortUrl($production_employee->emergency_details) == "") { ?>
		<th data-name="emergency_details" class="<?php echo $production_employee->emergency_details->headerCellClass() ?>"><div id="elh_production_employee_emergency_details" class="production_employee_emergency_details"><div class="ew-table-header-caption"><?php echo $production_employee->emergency_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emergency_details" class="<?php echo $production_employee->emergency_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->emergency_details) ?>',1);"><div id="elh_production_employee_emergency_details" class="production_employee_emergency_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->emergency_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->emergency_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->emergency_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->pan_no->Visible) { // pan_no ?>
	<?php if ($production_employee->sortUrl($production_employee->pan_no) == "") { ?>
		<th data-name="pan_no" class="<?php echo $production_employee->pan_no->headerCellClass() ?>"><div id="elh_production_employee_pan_no" class="production_employee_pan_no"><div class="ew-table-header-caption"><?php echo $production_employee->pan_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pan_no" class="<?php echo $production_employee->pan_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->pan_no) ?>',1);"><div id="elh_production_employee_pan_no" class="production_employee_pan_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->pan_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->pan_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->pan_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->aadhaar_no->Visible) { // aadhaar_no ?>
	<?php if ($production_employee->sortUrl($production_employee->aadhaar_no) == "") { ?>
		<th data-name="aadhaar_no" class="<?php echo $production_employee->aadhaar_no->headerCellClass() ?>"><div id="elh_production_employee_aadhaar_no" class="production_employee_aadhaar_no"><div class="ew-table-header-caption"><?php echo $production_employee->aadhaar_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="aadhaar_no" class="<?php echo $production_employee->aadhaar_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->aadhaar_no) ?>',1);"><div id="elh_production_employee_aadhaar_no" class="production_employee_aadhaar_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->aadhaar_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->aadhaar_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->aadhaar_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->id_proof->Visible) { // id_proof ?>
	<?php if ($production_employee->sortUrl($production_employee->id_proof) == "") { ?>
		<th data-name="id_proof" class="<?php echo $production_employee->id_proof->headerCellClass() ?>"><div id="elh_production_employee_id_proof" class="production_employee_id_proof"><div class="ew-table-header-caption"><?php echo $production_employee->id_proof->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_proof" class="<?php echo $production_employee->id_proof->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->id_proof) ?>',1);"><div id="elh_production_employee_id_proof" class="production_employee_id_proof">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->id_proof->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->id_proof->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->id_proof->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->reference_details->Visible) { // reference_details ?>
	<?php if ($production_employee->sortUrl($production_employee->reference_details) == "") { ?>
		<th data-name="reference_details" class="<?php echo $production_employee->reference_details->headerCellClass() ?>"><div id="elh_production_employee_reference_details" class="production_employee_reference_details"><div class="ew-table-header-caption"><?php echo $production_employee->reference_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference_details" class="<?php echo $production_employee->reference_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->reference_details) ?>',1);"><div id="elh_production_employee_reference_details" class="production_employee_reference_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->reference_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->reference_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->reference_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->doj->Visible) { // doj ?>
	<?php if ($production_employee->sortUrl($production_employee->doj) == "") { ?>
		<th data-name="doj" class="<?php echo $production_employee->doj->headerCellClass() ?>"><div id="elh_production_employee_doj" class="production_employee_doj"><div class="ew-table-header-caption"><?php echo $production_employee->doj->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="doj" class="<?php echo $production_employee->doj->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->doj) ?>',1);"><div id="elh_production_employee_doj" class="production_employee_doj">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->doj->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->doj->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->doj->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->dol->Visible) { // dol ?>
	<?php if ($production_employee->sortUrl($production_employee->dol) == "") { ?>
		<th data-name="dol" class="<?php echo $production_employee->dol->headerCellClass() ?>"><div id="elh_production_employee_dol" class="production_employee_dol"><div class="ew-table-header-caption"><?php echo $production_employee->dol->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dol" class="<?php echo $production_employee->dol->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->dol) ?>',1);"><div id="elh_production_employee_dol" class="production_employee_dol">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->dol->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->dol->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->dol->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->image->Visible) { // image ?>
	<?php if ($production_employee->sortUrl($production_employee->image) == "") { ?>
		<th data-name="image" class="<?php echo $production_employee->image->headerCellClass() ?>"><div id="elh_production_employee_image" class="production_employee_image"><div class="ew-table-header-caption"><?php echo $production_employee->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $production_employee->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->image) ?>',1);"><div id="elh_production_employee_image" class="production_employee_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->bank_name->Visible) { // bank_name ?>
	<?php if ($production_employee->sortUrl($production_employee->bank_name) == "") { ?>
		<th data-name="bank_name" class="<?php echo $production_employee->bank_name->headerCellClass() ?>"><div id="elh_production_employee_bank_name" class="production_employee_bank_name"><div class="ew-table-header-caption"><?php echo $production_employee->bank_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_name" class="<?php echo $production_employee->bank_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->bank_name) ?>',1);"><div id="elh_production_employee_bank_name" class="production_employee_bank_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->bank_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->bank_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->bank_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<?php if ($production_employee->sortUrl($production_employee->bank_ifsc_code) == "") { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $production_employee->bank_ifsc_code->headerCellClass() ?>"><div id="elh_production_employee_bank_ifsc_code" class="production_employee_bank_ifsc_code"><div class="ew-table-header-caption"><?php echo $production_employee->bank_ifsc_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $production_employee->bank_ifsc_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->bank_ifsc_code) ?>',1);"><div id="elh_production_employee_bank_ifsc_code" class="production_employee_bank_ifsc_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->bank_ifsc_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->bank_ifsc_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->bank_ifsc_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->bank_account_no->Visible) { // bank_account_no ?>
	<?php if ($production_employee->sortUrl($production_employee->bank_account_no) == "") { ?>
		<th data-name="bank_account_no" class="<?php echo $production_employee->bank_account_no->headerCellClass() ?>"><div id="elh_production_employee_bank_account_no" class="production_employee_bank_account_no"><div class="ew-table-header-caption"><?php echo $production_employee->bank_account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_account_no" class="<?php echo $production_employee->bank_account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->bank_account_no) ?>',1);"><div id="elh_production_employee_bank_account_no" class="production_employee_bank_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->bank_account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_employee->bank_account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->bank_account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->d_operator->Visible) { // d_operator ?>
	<?php if ($production_employee->sortUrl($production_employee->d_operator) == "") { ?>
		<th data-name="d_operator" class="<?php echo $production_employee->d_operator->headerCellClass() ?>"><div id="elh_production_employee_d_operator" class="production_employee_d_operator"><div class="ew-table-header-caption"><?php echo $production_employee->d_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_operator" class="<?php echo $production_employee->d_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->d_operator) ?>',1);"><div id="elh_production_employee_d_operator" class="production_employee_d_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->d_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->d_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->d_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->d_datetime->Visible) { // d_datetime ?>
	<?php if ($production_employee->sortUrl($production_employee->d_datetime) == "") { ?>
		<th data-name="d_datetime" class="<?php echo $production_employee->d_datetime->headerCellClass() ?>"><div id="elh_production_employee_d_datetime" class="production_employee_d_datetime"><div class="ew-table-header-caption"><?php echo $production_employee->d_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_datetime" class="<?php echo $production_employee->d_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->d_datetime) ?>',1);"><div id="elh_production_employee_d_datetime" class="production_employee_d_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->d_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->d_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->d_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_employee->am_id->Visible) { // am_id ?>
	<?php if ($production_employee->sortUrl($production_employee->am_id) == "") { ?>
		<th data-name="am_id" class="<?php echo $production_employee->am_id->headerCellClass() ?>"><div id="elh_production_employee_am_id" class="production_employee_am_id"><div class="ew-table-header-caption"><?php echo $production_employee->am_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="am_id" class="<?php echo $production_employee->am_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_employee->SortUrl($production_employee->am_id) ?>',1);"><div id="elh_production_employee_am_id" class="production_employee_am_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_employee->am_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_employee->am_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_employee->am_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_employee_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_employee->ExportAll && $production_employee->isExport()) {
	$production_employee_list->StopRec = $production_employee_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_employee_list->TotalRecs > $production_employee_list->StartRec + $production_employee_list->DisplayRecs - 1)
		$production_employee_list->StopRec = $production_employee_list->StartRec + $production_employee_list->DisplayRecs - 1;
	else
		$production_employee_list->StopRec = $production_employee_list->TotalRecs;
}
$production_employee_list->RecCnt = $production_employee_list->StartRec - 1;
if ($production_employee_list->Recordset && !$production_employee_list->Recordset->EOF) {
	$production_employee_list->Recordset->moveFirst();
	$selectLimit = $production_employee_list->UseSelectLimit;
	if (!$selectLimit && $production_employee_list->StartRec > 1)
		$production_employee_list->Recordset->move($production_employee_list->StartRec - 1);
} elseif (!$production_employee->AllowAddDeleteRow && $production_employee_list->StopRec == 0) {
	$production_employee_list->StopRec = $production_employee->GridAddRowCount;
}

// Initialize aggregate
$production_employee->RowType = ROWTYPE_AGGREGATEINIT;
$production_employee->resetAttributes();
$production_employee_list->renderRow();
while ($production_employee_list->RecCnt < $production_employee_list->StopRec) {
	$production_employee_list->RecCnt++;
	if ($production_employee_list->RecCnt >= $production_employee_list->StartRec) {
		$production_employee_list->RowCnt++;

		// Set up key count
		$production_employee_list->KeyCount = $production_employee_list->RowIndex;

		// Init row class and style
		$production_employee->resetAttributes();
		$production_employee->CssClass = "";
		if ($production_employee->isGridAdd()) {
		} else {
			$production_employee_list->loadRowValues($production_employee_list->Recordset); // Load row values
		}
		$production_employee->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_employee->RowAttrs = array_merge($production_employee->RowAttrs, array('data-rowindex'=>$production_employee_list->RowCnt, 'id'=>'r' . $production_employee_list->RowCnt . '_production_employee', 'data-rowtype'=>$production_employee->RowType));

		// Render row
		$production_employee_list->renderRow();

		// Render list options
		$production_employee_list->renderListOptions();
?>
	<tr<?php echo $production_employee->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_employee_list->ListOptions->render("body", "left", $production_employee_list->RowCnt);
?>
	<?php if ($production_employee->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $production_employee->grp->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_grp" class="production_employee_grp">
<span<?php echo $production_employee->grp->viewAttributes() ?>>
<?php echo $production_employee->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->site->Visible) { // site ?>
		<td data-name="site"<?php echo $production_employee->site->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_site" class="production_employee_site">
<span<?php echo $production_employee->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee->site->getViewValue())) && $production_employee->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee->site->linkAttributes() ?>><?php echo $production_employee->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_employee->id->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_id" class="production_employee_id">
<span<?php echo $production_employee->id->viewAttributes() ?>>
<?php echo $production_employee->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->user_name->Visible) { // user_name ?>
		<td data-name="user_name"<?php echo $production_employee->user_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_user_name" class="production_employee_user_name">
<span<?php echo $production_employee->user_name->viewAttributes() ?>>
<?php echo $production_employee->user_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->salary->Visible) { // salary ?>
		<td data-name="salary"<?php echo $production_employee->salary->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_salary" class="production_employee_salary">
<span<?php echo $production_employee->salary->viewAttributes() ?>>
<?php echo $production_employee->salary->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->contractor->Visible) { // contractor ?>
		<td data-name="contractor"<?php echo $production_employee->contractor->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_contractor" class="production_employee_contractor">
<span<?php echo $production_employee->contractor->viewAttributes() ?>>
<?php echo $production_employee->contractor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $production_employee->mobile->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_mobile" class="production_employee_mobile">
<span<?php echo $production_employee->mobile->viewAttributes() ?>>
<?php echo $production_employee->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->process->Visible) { // process ?>
		<td data-name="process"<?php echo $production_employee->process->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_process" class="production_employee_process">
<span<?php echo $production_employee->process->viewAttributes() ?>>
<?php echo $production_employee->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->status->Visible) { // status ?>
		<td data-name="status"<?php echo $production_employee->status->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_status" class="production_employee_status">
<span<?php echo $production_employee->status->viewAttributes() ?>>
<?php echo $production_employee->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->employee_name->Visible) { // employee_name ?>
		<td data-name="employee_name"<?php echo $production_employee->employee_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_employee_name" class="production_employee_employee_name">
<span<?php echo $production_employee->employee_name->viewAttributes() ?>>
<?php echo $production_employee->employee_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->gender->Visible) { // gender ?>
		<td data-name="gender"<?php echo $production_employee->gender->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_gender" class="production_employee_gender">
<span<?php echo $production_employee->gender->viewAttributes() ?>>
<?php echo $production_employee->gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->father_name->Visible) { // father_name ?>
		<td data-name="father_name"<?php echo $production_employee->father_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_father_name" class="production_employee_father_name">
<span<?php echo $production_employee->father_name->viewAttributes() ?>>
<?php echo $production_employee->father_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->designation->Visible) { // designation ?>
		<td data-name="designation"<?php echo $production_employee->designation->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_designation" class="production_employee_designation">
<span<?php echo $production_employee->designation->viewAttributes() ?>>
<?php echo $production_employee->designation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->permanent_address->Visible) { // permanent_address ?>
		<td data-name="permanent_address"<?php echo $production_employee->permanent_address->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_permanent_address" class="production_employee_permanent_address">
<span<?php echo $production_employee->permanent_address->viewAttributes() ?>>
<?php echo $production_employee->permanent_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->city->Visible) { // city ?>
		<td data-name="city"<?php echo $production_employee->city->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_city" class="production_employee_city">
<span<?php echo $production_employee->city->viewAttributes() ?>>
<?php echo $production_employee->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->dob->Visible) { // dob ?>
		<td data-name="dob"<?php echo $production_employee->dob->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_dob" class="production_employee_dob">
<span<?php echo $production_employee->dob->viewAttributes() ?>>
<?php echo $production_employee->dob->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->dom->Visible) { // dom ?>
		<td data-name="dom"<?php echo $production_employee->dom->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_dom" class="production_employee_dom">
<span<?php echo $production_employee->dom->viewAttributes() ?>>
<?php echo $production_employee->dom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->mobile_other->Visible) { // mobile_other ?>
		<td data-name="mobile_other"<?php echo $production_employee->mobile_other->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_mobile_other" class="production_employee_mobile_other">
<span<?php echo $production_employee->mobile_other->viewAttributes() ?>>
<?php echo $production_employee->mobile_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->mobile_family->Visible) { // mobile_family ?>
		<td data-name="mobile_family"<?php echo $production_employee->mobile_family->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_mobile_family" class="production_employee_mobile_family">
<span<?php echo $production_employee->mobile_family->viewAttributes() ?>>
<?php echo $production_employee->mobile_family->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->marital_status->Visible) { // marital_status ?>
		<td data-name="marital_status"<?php echo $production_employee->marital_status->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_marital_status" class="production_employee_marital_status">
<span<?php echo $production_employee->marital_status->viewAttributes() ?>>
<?php echo $production_employee->marital_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->spouse_details->Visible) { // spouse_details ?>
		<td data-name="spouse_details"<?php echo $production_employee->spouse_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_spouse_details" class="production_employee_spouse_details">
<span<?php echo $production_employee->spouse_details->viewAttributes() ?>>
<?php echo $production_employee->spouse_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->emergency_details->Visible) { // emergency_details ?>
		<td data-name="emergency_details"<?php echo $production_employee->emergency_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_emergency_details" class="production_employee_emergency_details">
<span<?php echo $production_employee->emergency_details->viewAttributes() ?>>
<?php echo $production_employee->emergency_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->pan_no->Visible) { // pan_no ?>
		<td data-name="pan_no"<?php echo $production_employee->pan_no->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_pan_no" class="production_employee_pan_no">
<span<?php echo $production_employee->pan_no->viewAttributes() ?>>
<?php echo $production_employee->pan_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->aadhaar_no->Visible) { // aadhaar_no ?>
		<td data-name="aadhaar_no"<?php echo $production_employee->aadhaar_no->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_aadhaar_no" class="production_employee_aadhaar_no">
<span<?php echo $production_employee->aadhaar_no->viewAttributes() ?>>
<?php echo $production_employee->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->id_proof->Visible) { // id_proof ?>
		<td data-name="id_proof"<?php echo $production_employee->id_proof->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_id_proof" class="production_employee_id_proof">
<span<?php echo $production_employee->id_proof->viewAttributes() ?>>
<?php echo GetFileViewTag($production_employee->id_proof, $production_employee->id_proof->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->reference_details->Visible) { // reference_details ?>
		<td data-name="reference_details"<?php echo $production_employee->reference_details->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_reference_details" class="production_employee_reference_details">
<span<?php echo $production_employee->reference_details->viewAttributes() ?>>
<?php echo $production_employee->reference_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->doj->Visible) { // doj ?>
		<td data-name="doj"<?php echo $production_employee->doj->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_doj" class="production_employee_doj">
<span<?php echo $production_employee->doj->viewAttributes() ?>>
<?php echo $production_employee->doj->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->dol->Visible) { // dol ?>
		<td data-name="dol"<?php echo $production_employee->dol->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_dol" class="production_employee_dol">
<span<?php echo $production_employee->dol->viewAttributes() ?>>
<?php echo $production_employee->dol->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->image->Visible) { // image ?>
		<td data-name="image"<?php echo $production_employee->image->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_image" class="production_employee_image">
<span<?php echo $production_employee->image->viewAttributes() ?>>
<?php echo GetFileViewTag($production_employee->image, $production_employee->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->bank_name->Visible) { // bank_name ?>
		<td data-name="bank_name"<?php echo $production_employee->bank_name->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_bank_name" class="production_employee_bank_name">
<span<?php echo $production_employee->bank_name->viewAttributes() ?>>
<?php echo $production_employee->bank_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
		<td data-name="bank_ifsc_code"<?php echo $production_employee->bank_ifsc_code->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_bank_ifsc_code" class="production_employee_bank_ifsc_code">
<span<?php echo $production_employee->bank_ifsc_code->viewAttributes() ?>>
<?php echo $production_employee->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->bank_account_no->Visible) { // bank_account_no ?>
		<td data-name="bank_account_no"<?php echo $production_employee->bank_account_no->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_bank_account_no" class="production_employee_bank_account_no">
<span<?php echo $production_employee->bank_account_no->viewAttributes() ?>>
<?php echo $production_employee->bank_account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->d_operator->Visible) { // d_operator ?>
		<td data-name="d_operator"<?php echo $production_employee->d_operator->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_d_operator" class="production_employee_d_operator">
<span<?php echo $production_employee->d_operator->viewAttributes() ?>>
<?php echo $production_employee->d_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->d_datetime->Visible) { // d_datetime ?>
		<td data-name="d_datetime"<?php echo $production_employee->d_datetime->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_d_datetime" class="production_employee_d_datetime">
<span<?php echo $production_employee->d_datetime->viewAttributes() ?>>
<?php echo $production_employee->d_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_employee->am_id->Visible) { // am_id ?>
		<td data-name="am_id"<?php echo $production_employee->am_id->cellAttributes() ?>>
<span id="el<?php echo $production_employee_list->RowCnt ?>_production_employee_am_id" class="production_employee_am_id">
<span<?php echo $production_employee->am_id->viewAttributes() ?>>
<?php echo $production_employee->am_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_employee_list->ListOptions->render("body", "right", $production_employee_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_employee->isGridAdd())
		$production_employee_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_employee->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_employee_list->Recordset)
	$production_employee_list->Recordset->Close();
?>
<?php if (!$production_employee->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_employee->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_employee_list->Pager)) $production_employee_list->Pager = new PrevNextPager($production_employee_list->StartRec, $production_employee_list->DisplayRecs, $production_employee_list->TotalRecs, $production_employee_list->AutoHidePager) ?>
<?php if ($production_employee_list->Pager->RecordCount > 0 && $production_employee_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_employee_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_employee_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_employee_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_employee_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_employee_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_employee_list->pageUrl() ?>start=<?php echo $production_employee_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_employee_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_employee_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_employee_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_employee_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_employee_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_employee_list->TotalRecs > 0 && (!$production_employee_list->AutoHidePageSizeSelector || $production_employee_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_employee">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($production_employee_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_employee_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_employee_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($production_employee->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_employee_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_employee_list->TotalRecs == 0 && !$production_employee->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_employee_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_employee_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_employee->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_employee", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_list->terminate();
?>