<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_employee_view = new production_employee_view();

// Run the page
$production_employee_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_employee_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_employee->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_employeeview = currentForm = new ew.Form("fproduction_employeeview", "view");

// Form_CustomValidate event
fproduction_employeeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_employeeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_employeeview.lists["x_grp[]"] = <?php echo $production_employee_view->grp->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_grp[]"].options = <?php echo JsonEncode($production_employee_view->grp->lookupOptions()) ?>;
fproduction_employeeview.lists["x_site[]"] = <?php echo $production_employee_view->site->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_site[]"].options = <?php echo JsonEncode($production_employee_view->site->lookupOptions()) ?>;
fproduction_employeeview.lists["x_contractor"] = <?php echo $production_employee_view->contractor->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_contractor"].options = <?php echo JsonEncode($production_employee_view->contractor->lookupOptions()) ?>;
fproduction_employeeview.lists["x_category"] = <?php echo $production_employee_view->category->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_category"].options = <?php echo JsonEncode($production_employee_view->category->options(FALSE, TRUE)) ?>;
fproduction_employeeview.lists["x_process[]"] = <?php echo $production_employee_view->process->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_process[]"].options = <?php echo JsonEncode($production_employee_view->process->lookupOptions()) ?>;
fproduction_employeeview.lists["x_status"] = <?php echo $production_employee_view->status->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_status"].options = <?php echo JsonEncode($production_employee_view->status->options(FALSE, TRUE)) ?>;
fproduction_employeeview.lists["x_gender"] = <?php echo $production_employee_view->gender->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_gender"].options = <?php echo JsonEncode($production_employee_view->gender->options(FALSE, TRUE)) ?>;
fproduction_employeeview.lists["x_marital_status"] = <?php echo $production_employee_view->marital_status->Lookup->toClientList() ?>;
fproduction_employeeview.lists["x_marital_status"].options = <?php echo JsonEncode($production_employee_view->marital_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_employee->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_employee_view->ExportOptions->render("body") ?>
<?php $production_employee_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_employee_view->showPageHeader(); ?>
<?php
$production_employee_view->showMessage();
?>
<form name="fproduction_employeeview" id="fproduction_employeeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_employee_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_employee_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_employee">
<input type="hidden" name="modal" value="<?php echo (int)$production_employee_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_employee->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_grp"><?php echo $production_employee->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_employee->grp->cellAttributes() ?>>
<span id="el_production_employee_grp">
<span<?php echo $production_employee->grp->viewAttributes() ?>>
<?php echo $production_employee->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->site->Visible) { // site ?>
	<tr id="r_site">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_site"><?php echo $production_employee->site->caption() ?></span></td>
		<td data-name="site"<?php echo $production_employee->site->cellAttributes() ?>>
<span id="el_production_employee_site">
<span<?php echo $production_employee->site->viewAttributes() ?>>
<?php if ((!EmptyString($production_employee->site->getViewValue())) && $production_employee->site->linkAttributes() <> "") { ?>
<a<?php echo $production_employee->site->linkAttributes() ?>><?php echo $production_employee->site->getViewValue() ?></a>
<?php } else { ?>
<?php echo $production_employee->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_id"><?php echo $production_employee->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_employee->id->cellAttributes() ?>>
<span id="el_production_employee_id">
<span<?php echo $production_employee->id->viewAttributes() ?>>
<?php echo $production_employee->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->user_name->Visible) { // user_name ?>
	<tr id="r_user_name">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_user_name"><?php echo $production_employee->user_name->caption() ?></span></td>
		<td data-name="user_name"<?php echo $production_employee->user_name->cellAttributes() ?>>
<span id="el_production_employee_user_name">
<span<?php echo $production_employee->user_name->viewAttributes() ?>>
<?php echo $production_employee->user_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->salary->Visible) { // salary ?>
	<tr id="r_salary">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_salary"><?php echo $production_employee->salary->caption() ?></span></td>
		<td data-name="salary"<?php echo $production_employee->salary->cellAttributes() ?>>
<span id="el_production_employee_salary">
<span<?php echo $production_employee->salary->viewAttributes() ?>>
<?php echo $production_employee->salary->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->contractor->Visible) { // contractor ?>
	<tr id="r_contractor">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_contractor"><?php echo $production_employee->contractor->caption() ?></span></td>
		<td data-name="contractor"<?php echo $production_employee->contractor->cellAttributes() ?>>
<span id="el_production_employee_contractor">
<span<?php echo $production_employee->contractor->viewAttributes() ?>>
<?php echo $production_employee->contractor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_address"><?php echo $production_employee->address->caption() ?></span></td>
		<td data-name="address"<?php echo $production_employee->address->cellAttributes() ?>>
<span id="el_production_employee_address">
<span<?php echo $production_employee->address->viewAttributes() ?>>
<?php echo $production_employee->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_mobile"><?php echo $production_employee->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $production_employee->mobile->cellAttributes() ?>>
<span id="el_production_employee_mobile">
<span<?php echo $production_employee->mobile->viewAttributes() ?>>
<?php echo $production_employee->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_category"><?php echo $production_employee->category->caption() ?></span></td>
		<td data-name="category"<?php echo $production_employee->category->cellAttributes() ?>>
<span id="el_production_employee_category">
<span<?php echo $production_employee->category->viewAttributes() ?>>
<?php echo $production_employee->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_process"><?php echo $production_employee->process->caption() ?></span></td>
		<td data-name="process"<?php echo $production_employee->process->cellAttributes() ?>>
<span id="el_production_employee_process">
<span<?php echo $production_employee->process->viewAttributes() ?>>
<?php echo $production_employee->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_status"><?php echo $production_employee->status->caption() ?></span></td>
		<td data-name="status"<?php echo $production_employee->status->cellAttributes() ?>>
<span id="el_production_employee_status">
<span<?php echo $production_employee->status->viewAttributes() ?>>
<?php echo $production_employee->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->employee_name->Visible) { // employee_name ?>
	<tr id="r_employee_name">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_employee_name"><?php echo $production_employee->employee_name->caption() ?></span></td>
		<td data-name="employee_name"<?php echo $production_employee->employee_name->cellAttributes() ?>>
<span id="el_production_employee_employee_name">
<span<?php echo $production_employee->employee_name->viewAttributes() ?>>
<?php echo $production_employee->employee_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->gender->Visible) { // gender ?>
	<tr id="r_gender">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_gender"><?php echo $production_employee->gender->caption() ?></span></td>
		<td data-name="gender"<?php echo $production_employee->gender->cellAttributes() ?>>
<span id="el_production_employee_gender">
<span<?php echo $production_employee->gender->viewAttributes() ?>>
<?php echo $production_employee->gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->father_name->Visible) { // father_name ?>
	<tr id="r_father_name">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_father_name"><?php echo $production_employee->father_name->caption() ?></span></td>
		<td data-name="father_name"<?php echo $production_employee->father_name->cellAttributes() ?>>
<span id="el_production_employee_father_name">
<span<?php echo $production_employee->father_name->viewAttributes() ?>>
<?php echo $production_employee->father_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->designation->Visible) { // designation ?>
	<tr id="r_designation">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_designation"><?php echo $production_employee->designation->caption() ?></span></td>
		<td data-name="designation"<?php echo $production_employee->designation->cellAttributes() ?>>
<span id="el_production_employee_designation">
<span<?php echo $production_employee->designation->viewAttributes() ?>>
<?php echo $production_employee->designation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->permanent_address->Visible) { // permanent_address ?>
	<tr id="r_permanent_address">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_permanent_address"><?php echo $production_employee->permanent_address->caption() ?></span></td>
		<td data-name="permanent_address"<?php echo $production_employee->permanent_address->cellAttributes() ?>>
<span id="el_production_employee_permanent_address">
<span<?php echo $production_employee->permanent_address->viewAttributes() ?>>
<?php echo $production_employee->permanent_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->city->Visible) { // city ?>
	<tr id="r_city">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_city"><?php echo $production_employee->city->caption() ?></span></td>
		<td data-name="city"<?php echo $production_employee->city->cellAttributes() ?>>
<span id="el_production_employee_city">
<span<?php echo $production_employee->city->viewAttributes() ?>>
<?php echo $production_employee->city->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->dob->Visible) { // dob ?>
	<tr id="r_dob">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_dob"><?php echo $production_employee->dob->caption() ?></span></td>
		<td data-name="dob"<?php echo $production_employee->dob->cellAttributes() ?>>
<span id="el_production_employee_dob">
<span<?php echo $production_employee->dob->viewAttributes() ?>>
<?php echo $production_employee->dob->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->dom->Visible) { // dom ?>
	<tr id="r_dom">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_dom"><?php echo $production_employee->dom->caption() ?></span></td>
		<td data-name="dom"<?php echo $production_employee->dom->cellAttributes() ?>>
<span id="el_production_employee_dom">
<span<?php echo $production_employee->dom->viewAttributes() ?>>
<?php echo $production_employee->dom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->mobile_other->Visible) { // mobile_other ?>
	<tr id="r_mobile_other">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_mobile_other"><?php echo $production_employee->mobile_other->caption() ?></span></td>
		<td data-name="mobile_other"<?php echo $production_employee->mobile_other->cellAttributes() ?>>
<span id="el_production_employee_mobile_other">
<span<?php echo $production_employee->mobile_other->viewAttributes() ?>>
<?php echo $production_employee->mobile_other->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->mobile_family->Visible) { // mobile_family ?>
	<tr id="r_mobile_family">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_mobile_family"><?php echo $production_employee->mobile_family->caption() ?></span></td>
		<td data-name="mobile_family"<?php echo $production_employee->mobile_family->cellAttributes() ?>>
<span id="el_production_employee_mobile_family">
<span<?php echo $production_employee->mobile_family->viewAttributes() ?>>
<?php echo $production_employee->mobile_family->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->marital_status->Visible) { // marital_status ?>
	<tr id="r_marital_status">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_marital_status"><?php echo $production_employee->marital_status->caption() ?></span></td>
		<td data-name="marital_status"<?php echo $production_employee->marital_status->cellAttributes() ?>>
<span id="el_production_employee_marital_status">
<span<?php echo $production_employee->marital_status->viewAttributes() ?>>
<?php echo $production_employee->marital_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->spouse_details->Visible) { // spouse_details ?>
	<tr id="r_spouse_details">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_spouse_details"><?php echo $production_employee->spouse_details->caption() ?></span></td>
		<td data-name="spouse_details"<?php echo $production_employee->spouse_details->cellAttributes() ?>>
<span id="el_production_employee_spouse_details">
<span<?php echo $production_employee->spouse_details->viewAttributes() ?>>
<?php echo $production_employee->spouse_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->emergency_details->Visible) { // emergency_details ?>
	<tr id="r_emergency_details">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_emergency_details"><?php echo $production_employee->emergency_details->caption() ?></span></td>
		<td data-name="emergency_details"<?php echo $production_employee->emergency_details->cellAttributes() ?>>
<span id="el_production_employee_emergency_details">
<span<?php echo $production_employee->emergency_details->viewAttributes() ?>>
<?php echo $production_employee->emergency_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->pan_no->Visible) { // pan_no ?>
	<tr id="r_pan_no">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_pan_no"><?php echo $production_employee->pan_no->caption() ?></span></td>
		<td data-name="pan_no"<?php echo $production_employee->pan_no->cellAttributes() ?>>
<span id="el_production_employee_pan_no">
<span<?php echo $production_employee->pan_no->viewAttributes() ?>>
<?php echo $production_employee->pan_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->aadhaar_no->Visible) { // aadhaar_no ?>
	<tr id="r_aadhaar_no">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_aadhaar_no"><?php echo $production_employee->aadhaar_no->caption() ?></span></td>
		<td data-name="aadhaar_no"<?php echo $production_employee->aadhaar_no->cellAttributes() ?>>
<span id="el_production_employee_aadhaar_no">
<span<?php echo $production_employee->aadhaar_no->viewAttributes() ?>>
<?php echo $production_employee->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->id_proof->Visible) { // id_proof ?>
	<tr id="r_id_proof">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_id_proof"><?php echo $production_employee->id_proof->caption() ?></span></td>
		<td data-name="id_proof"<?php echo $production_employee->id_proof->cellAttributes() ?>>
<span id="el_production_employee_id_proof">
<span<?php echo $production_employee->id_proof->viewAttributes() ?>>
<?php echo GetFileViewTag($production_employee->id_proof, $production_employee->id_proof->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->reference_details->Visible) { // reference_details ?>
	<tr id="r_reference_details">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_reference_details"><?php echo $production_employee->reference_details->caption() ?></span></td>
		<td data-name="reference_details"<?php echo $production_employee->reference_details->cellAttributes() ?>>
<span id="el_production_employee_reference_details">
<span<?php echo $production_employee->reference_details->viewAttributes() ?>>
<?php echo $production_employee->reference_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->other_details->Visible) { // other_details ?>
	<tr id="r_other_details">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_other_details"><?php echo $production_employee->other_details->caption() ?></span></td>
		<td data-name="other_details"<?php echo $production_employee->other_details->cellAttributes() ?>>
<span id="el_production_employee_other_details">
<span<?php echo $production_employee->other_details->viewAttributes() ?>>
<?php echo $production_employee->other_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->doj->Visible) { // doj ?>
	<tr id="r_doj">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_doj"><?php echo $production_employee->doj->caption() ?></span></td>
		<td data-name="doj"<?php echo $production_employee->doj->cellAttributes() ?>>
<span id="el_production_employee_doj">
<span<?php echo $production_employee->doj->viewAttributes() ?>>
<?php echo $production_employee->doj->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->dol->Visible) { // dol ?>
	<tr id="r_dol">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_dol"><?php echo $production_employee->dol->caption() ?></span></td>
		<td data-name="dol"<?php echo $production_employee->dol->cellAttributes() ?>>
<span id="el_production_employee_dol">
<span<?php echo $production_employee->dol->viewAttributes() ?>>
<?php echo $production_employee->dol->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_image"><?php echo $production_employee->image->caption() ?></span></td>
		<td data-name="image"<?php echo $production_employee->image->cellAttributes() ?>>
<span id="el_production_employee_image">
<span<?php echo $production_employee->image->viewAttributes() ?>>
<?php echo GetFileViewTag($production_employee->image, $production_employee->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->payment_details->Visible) { // payment_details ?>
	<tr id="r_payment_details">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_payment_details"><?php echo $production_employee->payment_details->caption() ?></span></td>
		<td data-name="payment_details"<?php echo $production_employee->payment_details->cellAttributes() ?>>
<span id="el_production_employee_payment_details">
<span<?php echo $production_employee->payment_details->viewAttributes() ?>>
<?php echo $production_employee->payment_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->bank_name->Visible) { // bank_name ?>
	<tr id="r_bank_name">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_bank_name"><?php echo $production_employee->bank_name->caption() ?></span></td>
		<td data-name="bank_name"<?php echo $production_employee->bank_name->cellAttributes() ?>>
<span id="el_production_employee_bank_name">
<span<?php echo $production_employee->bank_name->viewAttributes() ?>>
<?php echo $production_employee->bank_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<tr id="r_bank_ifsc_code">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_bank_ifsc_code"><?php echo $production_employee->bank_ifsc_code->caption() ?></span></td>
		<td data-name="bank_ifsc_code"<?php echo $production_employee->bank_ifsc_code->cellAttributes() ?>>
<span id="el_production_employee_bank_ifsc_code">
<span<?php echo $production_employee->bank_ifsc_code->viewAttributes() ?>>
<?php echo $production_employee->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->bank_account_no->Visible) { // bank_account_no ?>
	<tr id="r_bank_account_no">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_bank_account_no"><?php echo $production_employee->bank_account_no->caption() ?></span></td>
		<td data-name="bank_account_no"<?php echo $production_employee->bank_account_no->cellAttributes() ?>>
<span id="el_production_employee_bank_account_no">
<span<?php echo $production_employee->bank_account_no->viewAttributes() ?>>
<?php echo $production_employee->bank_account_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_operator"><?php echo $production_employee->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_employee->operator->cellAttributes() ?>>
<span id="el_production_employee_operator">
<span<?php echo $production_employee->operator->viewAttributes() ?>>
<?php echo $production_employee->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_datetime"><?php echo $production_employee->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_employee->datetime->cellAttributes() ?>>
<span id="el_production_employee_datetime">
<span<?php echo $production_employee->datetime->viewAttributes() ?>>
<?php echo $production_employee->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->d_operator->Visible) { // d_operator ?>
	<tr id="r_d_operator">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_d_operator"><?php echo $production_employee->d_operator->caption() ?></span></td>
		<td data-name="d_operator"<?php echo $production_employee->d_operator->cellAttributes() ?>>
<span id="el_production_employee_d_operator">
<span<?php echo $production_employee->d_operator->viewAttributes() ?>>
<?php echo $production_employee->d_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->d_datetime->Visible) { // d_datetime ?>
	<tr id="r_d_datetime">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_d_datetime"><?php echo $production_employee->d_datetime->caption() ?></span></td>
		<td data-name="d_datetime"<?php echo $production_employee->d_datetime->cellAttributes() ?>>
<span id="el_production_employee_d_datetime">
<span<?php echo $production_employee->d_datetime->viewAttributes() ?>>
<?php echo $production_employee->d_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_employee->am_id->Visible) { // am_id ?>
	<tr id="r_am_id">
		<td class="<?php echo $production_employee_view->TableLeftColumnClass ?>"><span id="elh_production_employee_am_id"><?php echo $production_employee->am_id->caption() ?></span></td>
		<td data-name="am_id"<?php echo $production_employee->am_id->cellAttributes() ?>>
<span id="el_production_employee_am_id">
<span<?php echo $production_employee->am_id->viewAttributes() ?>>
<?php echo $production_employee->am_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$production_employee_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_employee->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_employee_view->terminate();
?>