<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_partner_add = new production_partner_add();

// Run the page
$production_partner_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_partner_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduction_partneradd = currentForm = new ew.Form("fproduction_partneradd", "add");

// Validate form
fproduction_partneradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_partner_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->name->caption(), $production_partner->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->code->caption(), $production_partner->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,8}$/))
				return this.onError(elm, "<?php echo JsEncode($production_partner->code->errorMessage()) ?>");
		<?php if ($production_partner_add->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->country->caption(), $production_partner->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->region->Required) { ?>
			elm = this.getElements("x" + infix + "_region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->region->caption(), $production_partner->region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->city->caption(), $production_partner->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->address->caption(), $production_partner->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->mobile->caption(), $production_partner->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->_email->caption(), $production_partner->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->url->caption(), $production_partner->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->grp->caption(), $production_partner->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->category->caption(), $production_partner->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->reports_to->caption(), $production_partner->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->status->caption(), $production_partner->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->operator->caption(), $production_partner->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->datetime->caption(), $production_partner->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->type->caption(), $production_partner->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->tax_registration->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_registration");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->tax_registration->caption(), $production_partner->tax_registration->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->cin->Required) { ?>
			elm = this.getElements("x" + infix + "_cin");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cin->caption(), $production_partner->cin->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->pan->Required) { ?>
			elm = this.getElements("x" + infix + "_pan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->pan->caption(), $production_partner->pan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->tan->Required) { ?>
			elm = this.getElements("x" + infix + "_tan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->tan->caption(), $production_partner->tan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->msme->Required) { ?>
			elm = this.getElements("x" + infix + "_msme");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->msme->caption(), $production_partner->msme->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->port_air->Required) { ?>
			elm = this.getElements("x" + infix + "_port_air");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->port_air->caption(), $production_partner->port_air->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->port_sea->Required) { ?>
			elm = this.getElements("x" + infix + "_port_sea");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->port_sea->caption(), $production_partner->port_sea->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->iec->Required) { ?>
			elm = this.getElements("x" + infix + "_iec");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->iec->caption(), $production_partner->iec->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->rex->Required) { ?>
			elm = this.getElements("x" + infix + "_rex");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->rex->caption(), $production_partner->rex->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->rcmc->Required) { ?>
			elm = this.getElements("x" + infix + "_rcmc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->rcmc->caption(), $production_partner->rcmc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->delivery_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->delivery_terms->caption(), $production_partner->delivery_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->shipping_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_terms->caption(), $production_partner->shipping_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->payment_terms->caption(), $production_partner->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->export_type->Required) { ?>
			elm = this.getElements("x" + infix + "_export_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->export_type->caption(), $production_partner->export_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->lead_time_ss->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_time_ss");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->lead_time_ss->caption(), $production_partner->lead_time_ss->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lead_time_ss");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_ss->errorMessage()) ?>");
		<?php if ($production_partner_add->lead_time_cs->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_time_cs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->lead_time_cs->caption(), $production_partner->lead_time_cs->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lead_time_cs");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_cs->errorMessage()) ?>");
		<?php if ($production_partner_add->cha->Required) { ?>
			elm = this.getElements("x" + infix + "_cha");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha->caption(), $production_partner->cha->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->cha_email->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha_email->caption(), $production_partner->cha_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->cha_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha_phone->caption(), $production_partner->cha_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->forwarder->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder->caption(), $production_partner->forwarder->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->forwarder_email->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder_email->caption(), $production_partner->forwarder_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->forwarder_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder_phone->caption(), $production_partner->forwarder_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->merchant->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant->caption(), $production_partner->merchant->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->merchant_email->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant_email->caption(), $production_partner->merchant_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->merchant_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant_phone->caption(), $production_partner->merchant_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->shipping_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_incharge->caption(), $production_partner->shipping_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->shipping_email->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_email->caption(), $production_partner->shipping_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->shipping_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_phone->caption(), $production_partner->shipping_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->account_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_account_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->account_incharge->caption(), $production_partner->account_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->accounts_email->Required) { ?>
			elm = this.getElements("x" + infix + "_accounts_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->accounts_email->caption(), $production_partner->accounts_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->accounts_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_accounts_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->accounts_phone->caption(), $production_partner->accounts_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->warehouse_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_incharge->caption(), $production_partner->warehouse_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->warehouse_email->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_email->caption(), $production_partner->warehouse_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->warehouse_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_phone->caption(), $production_partner->warehouse_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->production_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_production_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_incharge->caption(), $production_partner->production_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->production_email->Required) { ?>
			elm = this.getElements("x" + infix + "_production_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_email->caption(), $production_partner->production_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->production_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_production_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_phone->caption(), $production_partner->production_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->qc_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_incharge->caption(), $production_partner->qc_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->qc_email->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_email->caption(), $production_partner->qc_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_add->qc_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_phone->caption(), $production_partner->qc_phone->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_partneradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_partneradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fproduction_partneradd.multiPage = new ew.MultiPage("fproduction_partneradd");

// Dynamic selection lists
fproduction_partneradd.lists["x_country"] = <?php echo $production_partner_add->country->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_country"].options = <?php echo JsonEncode($production_partner_add->country->lookupOptions()) ?>;
fproduction_partneradd.lists["x_region"] = <?php echo $production_partner_add->region->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_region"].options = <?php echo JsonEncode($production_partner_add->region->lookupOptions()) ?>;
fproduction_partneradd.lists["x_city"] = <?php echo $production_partner_add->city->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_city"].options = <?php echo JsonEncode($production_partner_add->city->lookupOptions()) ?>;
fproduction_partneradd.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduction_partneradd.lists["x_grp[]"] = <?php echo $production_partner_add->grp->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_grp[]"].options = <?php echo JsonEncode($production_partner_add->grp->lookupOptions()) ?>;
fproduction_partneradd.lists["x_category"] = <?php echo $production_partner_add->category->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_category"].options = <?php echo JsonEncode($production_partner_add->category->lookupOptions()) ?>;
fproduction_partneradd.lists["x_reports_to"] = <?php echo $production_partner_add->reports_to->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_reports_to"].options = <?php echo JsonEncode($production_partner_add->reports_to->lookupOptions()) ?>;
fproduction_partneradd.lists["x_status"] = <?php echo $production_partner_add->status->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_status"].options = <?php echo JsonEncode($production_partner_add->status->options(FALSE, TRUE)) ?>;
fproduction_partneradd.lists["x_operator"] = <?php echo $production_partner_add->operator->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_operator"].options = <?php echo JsonEncode($production_partner_add->operator->lookupOptions()) ?>;
fproduction_partneradd.lists["x_type"] = <?php echo $production_partner_add->type->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_type"].options = <?php echo JsonEncode($production_partner_add->type->options(FALSE, TRUE)) ?>;
fproduction_partneradd.lists["x_port_air"] = <?php echo $production_partner_add->port_air->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_port_air"].options = <?php echo JsonEncode($production_partner_add->port_air->lookupOptions()) ?>;
fproduction_partneradd.lists["x_port_sea"] = <?php echo $production_partner_add->port_sea->Lookup->toClientList() ?>;
fproduction_partneradd.lists["x_port_sea"].options = <?php echo JsonEncode($production_partner_add->port_sea->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_partner_add->showPageHeader(); ?>
<?php
$production_partner_add->showMessage();
?>
<form name="fproduction_partneradd" id="fproduction_partneradd" class="<?php echo $production_partner_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_partner_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_partner_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$production_partner_add->IsModal ?>">
<?php if ($production_partner_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($production_partner->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_production_partner_name" for="x_name" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->name->caption() ?><?php echo ($production_partner->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->name->cellAttributes() ?>>
<span id="el_production_partner_name">
<input type="text" data-table="production_partner" data-field="x_name" data-page="0" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($production_partner->name->getPlaceHolder()) ?>" value="<?php echo $production_partner->name->EditValue ?>"<?php echo $production_partner->name->editAttributes() ?>>
</span>
<?php echo $production_partner->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_production_partner_code" for="x_code" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->code->caption() ?><?php echo ($production_partner->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->code->cellAttributes() ?>>
<span id="el_production_partner_code">
<input type="text" data-table="production_partner" data-field="x_code" data-page="0" name="x_code" id="x_code" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($production_partner->code->getPlaceHolder()) ?>" value="<?php echo $production_partner->code->EditValue ?>"<?php echo $production_partner->code->editAttributes() ?>>
</span>
<?php echo $production_partner->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="production_partner_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("1")) ?>" href="#tab_production_partner1"><?php echo $production_partner->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label id="elh_production_partner_country" for="x_country" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->country->caption() ?><?php echo ($production_partner->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->country->cellAttributes() ?>>
<span id="el_production_partner_country">
<?php $production_partner->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_country" data-page="1" data-value-separator="<?php echo $production_partner->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $production_partner->country->editAttributes() ?>>
		<?php echo $production_partner->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $production_partner->country->Lookup->getParamTag("p_x_country") ?>
</span>
<?php echo $production_partner->country->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->region->Visible) { // region ?>
	<div id="r_region" class="form-group row">
		<label id="elh_production_partner_region" for="x_region" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->region->caption() ?><?php echo ($production_partner->region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->region->cellAttributes() ?>>
<span id="el_production_partner_region">
<?php $production_partner->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_region" data-page="1" data-value-separator="<?php echo $production_partner->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $production_partner->region->editAttributes() ?>>
		<?php echo $production_partner->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $production_partner->region->Lookup->getParamTag("p_x_region") ?>
</span>
<?php echo $production_partner->region->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_production_partner_city" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->city->caption() ?><?php echo ($production_partner->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->city->cellAttributes() ?>>
<span id="el_production_partner_city">
<?php
$wrkonchange = "" . trim(@$production_partner->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$production_partner->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($production_partner->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>"<?php echo $production_partner->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_partner->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($production_partner->city->ReadOnly || $production_partner->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="production_partner" data-field="x_city" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_partner->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($production_partner->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduction_partneradd.createAutoSuggest({"id":"x_city","forceSelect":true});
</script>
<?php echo $production_partner->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php echo $production_partner->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_production_partner_address" for="x_address" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->address->caption() ?><?php echo ($production_partner->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->address->cellAttributes() ?>>
<span id="el_production_partner_address">
<textarea data-table="production_partner" data-field="x_address" data-page="1" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?php echo HtmlEncode($production_partner->address->getPlaceHolder()) ?>"<?php echo $production_partner->address->editAttributes() ?>><?php echo $production_partner->address->EditValue ?></textarea>
</span>
<?php echo $production_partner->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_production_partner_mobile" for="x_mobile" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->mobile->caption() ?><?php echo ($production_partner->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->mobile->cellAttributes() ?>>
<span id="el_production_partner_mobile">
<input type="text" data-table="production_partner" data-field="x_mobile" data-page="1" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_partner->mobile->getPlaceHolder()) ?>" value="<?php echo $production_partner->mobile->EditValue ?>"<?php echo $production_partner->mobile->editAttributes() ?>>
</span>
<?php echo $production_partner->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_production_partner__email" for="x__email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->_email->caption() ?><?php echo ($production_partner->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->_email->cellAttributes() ?>>
<span id="el_production_partner__email">
<input type="text" data-table="production_partner" data-field="x__email" data-page="1" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_partner->_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->_email->EditValue ?>"<?php echo $production_partner->_email->editAttributes() ?>>
</span>
<?php echo $production_partner->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_production_partner_url" for="x_url" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->url->caption() ?><?php echo ($production_partner->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->url->cellAttributes() ?>>
<span id="el_production_partner_url">
<input type="text" data-table="production_partner" data-field="x_url" data-page="1" name="x_url" id="x_url" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->url->getPlaceHolder()) ?>" value="<?php echo $production_partner->url->EditValue ?>"<?php echo $production_partner->url->editAttributes() ?>>
</span>
<?php echo $production_partner->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("2")) ?>" href="#tab_production_partner2"><?php echo $production_partner->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_production_partner_grp" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->grp->caption() ?><?php echo ($production_partner->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->grp->cellAttributes() ?>>
<span id="el_production_partner_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_partner" data-field="x_grp" data-page="2" data-value-separator="<?php echo $production_partner->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $production_partner->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_partner->grp->checkBoxListHtml(FALSE, "x_grp[]", 2) ?>
</div></div>
<?php echo $production_partner->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $production_partner->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_production_partner_category" for="x_category" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->category->caption() ?><?php echo ($production_partner->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->category->cellAttributes() ?>>
<span id="el_production_partner_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_category" data-page="2" data-value-separator="<?php echo $production_partner->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $production_partner->category->editAttributes() ?>>
		<?php echo $production_partner->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $production_partner->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $production_partner->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_production_partner_reports_to" for="x_reports_to" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->reports_to->caption() ?><?php echo ($production_partner->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->reports_to->cellAttributes() ?>>
<span id="el_production_partner_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_reports_to" data-page="2" data-value-separator="<?php echo $production_partner->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $production_partner->reports_to->editAttributes() ?>>
		<?php echo $production_partner->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $production_partner->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $production_partner->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_production_partner_status" for="x_status" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->status->caption() ?><?php echo ($production_partner->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->status->cellAttributes() ?>>
<span id="el_production_partner_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_status" data-page="2" data-value-separator="<?php echo $production_partner->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_partner->status->editAttributes() ?>>
		<?php echo $production_partner->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $production_partner->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_production_partner_type" for="x_type" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->type->caption() ?><?php echo ($production_partner->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->type->cellAttributes() ?>>
<span id="el_production_partner_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_type" data-page="2" data-value-separator="<?php echo $production_partner->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $production_partner->type->editAttributes() ?>>
		<?php echo $production_partner->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $production_partner->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("3")) ?>" href="#tab_production_partner3"><?php echo $production_partner->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
	<div id="r_tax_registration" class="form-group row">
		<label id="elh_production_partner_tax_registration" for="x_tax_registration" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->tax_registration->caption() ?><?php echo ($production_partner->tax_registration->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->tax_registration->cellAttributes() ?>>
<span id="el_production_partner_tax_registration">
<input type="text" data-table="production_partner" data-field="x_tax_registration" data-page="3" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_partner->tax_registration->getPlaceHolder()) ?>" value="<?php echo $production_partner->tax_registration->EditValue ?>"<?php echo $production_partner->tax_registration->editAttributes() ?>>
</span>
<?php echo $production_partner->tax_registration->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cin->Visible) { // cin ?>
	<div id="r_cin" class="form-group row">
		<label id="elh_production_partner_cin" for="x_cin" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->cin->caption() ?><?php echo ($production_partner->cin->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->cin->cellAttributes() ?>>
<span id="el_production_partner_cin">
<input type="text" data-table="production_partner" data-field="x_cin" data-page="3" name="x_cin" id="x_cin" size="30" placeholder="<?php echo HtmlEncode($production_partner->cin->getPlaceHolder()) ?>" value="<?php echo $production_partner->cin->EditValue ?>"<?php echo $production_partner->cin->editAttributes() ?>>
</span>
<?php echo $production_partner->cin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->pan->Visible) { // pan ?>
	<div id="r_pan" class="form-group row">
		<label id="elh_production_partner_pan" for="x_pan" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->pan->caption() ?><?php echo ($production_partner->pan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->pan->cellAttributes() ?>>
<span id="el_production_partner_pan">
<input type="text" data-table="production_partner" data-field="x_pan" data-page="3" name="x_pan" id="x_pan" size="30" placeholder="<?php echo HtmlEncode($production_partner->pan->getPlaceHolder()) ?>" value="<?php echo $production_partner->pan->EditValue ?>"<?php echo $production_partner->pan->editAttributes() ?>>
</span>
<?php echo $production_partner->pan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->tan->Visible) { // tan ?>
	<div id="r_tan" class="form-group row">
		<label id="elh_production_partner_tan" for="x_tan" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->tan->caption() ?><?php echo ($production_partner->tan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->tan->cellAttributes() ?>>
<span id="el_production_partner_tan">
<input type="text" data-table="production_partner" data-field="x_tan" data-page="3" name="x_tan" id="x_tan" size="30" placeholder="<?php echo HtmlEncode($production_partner->tan->getPlaceHolder()) ?>" value="<?php echo $production_partner->tan->EditValue ?>"<?php echo $production_partner->tan->editAttributes() ?>>
</span>
<?php echo $production_partner->tan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->msme->Visible) { // msme ?>
	<div id="r_msme" class="form-group row">
		<label id="elh_production_partner_msme" for="x_msme" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->msme->caption() ?><?php echo ($production_partner->msme->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->msme->cellAttributes() ?>>
<span id="el_production_partner_msme">
<input type="text" data-table="production_partner" data-field="x_msme" data-page="3" name="x_msme" id="x_msme" size="30" placeholder="<?php echo HtmlEncode($production_partner->msme->getPlaceHolder()) ?>" value="<?php echo $production_partner->msme->EditValue ?>"<?php echo $production_partner->msme->editAttributes() ?>>
</span>
<?php echo $production_partner->msme->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("4") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("4")) ?>" href="#tab_production_partner4"><?php echo $production_partner->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->port_air->Visible) { // port_air ?>
	<div id="r_port_air" class="form-group row">
		<label id="elh_production_partner_port_air" for="x_port_air" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->port_air->caption() ?><?php echo ($production_partner->port_air->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->port_air->cellAttributes() ?>>
<span id="el_production_partner_port_air">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_port_air" data-page="4" data-value-separator="<?php echo $production_partner->port_air->displayValueSeparatorAttribute() ?>" id="x_port_air" name="x_port_air"<?php echo $production_partner->port_air->editAttributes() ?>>
		<?php echo $production_partner->port_air->selectOptionListHtml("x_port_air") ?>
	</select>
</div>
<?php echo $production_partner->port_air->Lookup->getParamTag("p_x_port_air") ?>
</span>
<?php echo $production_partner->port_air->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->port_sea->Visible) { // port_sea ?>
	<div id="r_port_sea" class="form-group row">
		<label id="elh_production_partner_port_sea" for="x_port_sea" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->port_sea->caption() ?><?php echo ($production_partner->port_sea->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->port_sea->cellAttributes() ?>>
<span id="el_production_partner_port_sea">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_port_sea" data-page="4" data-value-separator="<?php echo $production_partner->port_sea->displayValueSeparatorAttribute() ?>" id="x_port_sea" name="x_port_sea"<?php echo $production_partner->port_sea->editAttributes() ?>>
		<?php echo $production_partner->port_sea->selectOptionListHtml("x_port_sea") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "port") && !$production_partner->port_sea->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_sea" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $production_partner->port_sea->caption() ?>" data-title="<?php echo $production_partner->port_sea->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_port_sea',url:'portaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $production_partner->port_sea->Lookup->getParamTag("p_x_port_sea") ?>
</span>
<?php echo $production_partner->port_sea->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->iec->Visible) { // iec ?>
	<div id="r_iec" class="form-group row">
		<label id="elh_production_partner_iec" for="x_iec" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->iec->caption() ?><?php echo ($production_partner->iec->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->iec->cellAttributes() ?>>
<span id="el_production_partner_iec">
<input type="text" data-table="production_partner" data-field="x_iec" data-page="4" name="x_iec" id="x_iec" size="30" placeholder="<?php echo HtmlEncode($production_partner->iec->getPlaceHolder()) ?>" value="<?php echo $production_partner->iec->EditValue ?>"<?php echo $production_partner->iec->editAttributes() ?>>
</span>
<?php echo $production_partner->iec->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->rex->Visible) { // rex ?>
	<div id="r_rex" class="form-group row">
		<label id="elh_production_partner_rex" for="x_rex" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->rex->caption() ?><?php echo ($production_partner->rex->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->rex->cellAttributes() ?>>
<span id="el_production_partner_rex">
<input type="text" data-table="production_partner" data-field="x_rex" data-page="4" name="x_rex" id="x_rex" size="30" placeholder="<?php echo HtmlEncode($production_partner->rex->getPlaceHolder()) ?>" value="<?php echo $production_partner->rex->EditValue ?>"<?php echo $production_partner->rex->editAttributes() ?>>
</span>
<?php echo $production_partner->rex->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
	<div id="r_rcmc" class="form-group row">
		<label id="elh_production_partner_rcmc" for="x_rcmc" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->rcmc->caption() ?><?php echo ($production_partner->rcmc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->rcmc->cellAttributes() ?>>
<span id="el_production_partner_rcmc">
<input type="text" data-table="production_partner" data-field="x_rcmc" data-page="4" name="x_rcmc" id="x_rcmc" size="30" placeholder="<?php echo HtmlEncode($production_partner->rcmc->getPlaceHolder()) ?>" value="<?php echo $production_partner->rcmc->EditValue ?>"<?php echo $production_partner->rcmc->editAttributes() ?>>
</span>
<?php echo $production_partner->rcmc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
	<div id="r_delivery_terms" class="form-group row">
		<label id="elh_production_partner_delivery_terms" for="x_delivery_terms" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->delivery_terms->caption() ?><?php echo ($production_partner->delivery_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->delivery_terms->cellAttributes() ?>>
<span id="el_production_partner_delivery_terms">
<input type="text" data-table="production_partner" data-field="x_delivery_terms" data-page="4" name="x_delivery_terms" id="x_delivery_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->delivery_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->delivery_terms->EditValue ?>"<?php echo $production_partner->delivery_terms->editAttributes() ?>>
</span>
<?php echo $production_partner->delivery_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
	<div id="r_shipping_terms" class="form-group row">
		<label id="elh_production_partner_shipping_terms" for="x_shipping_terms" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->shipping_terms->caption() ?><?php echo ($production_partner->shipping_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->shipping_terms->cellAttributes() ?>>
<span id="el_production_partner_shipping_terms">
<input type="text" data-table="production_partner" data-field="x_shipping_terms" data-page="4" name="x_shipping_terms" id="x_shipping_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->shipping_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_terms->EditValue ?>"<?php echo $production_partner->shipping_terms->editAttributes() ?>>
</span>
<?php echo $production_partner->shipping_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_production_partner_payment_terms" for="x_payment_terms" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->payment_terms->caption() ?><?php echo ($production_partner->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->payment_terms->cellAttributes() ?>>
<span id="el_production_partner_payment_terms">
<input type="text" data-table="production_partner" data-field="x_payment_terms" data-page="4" name="x_payment_terms" id="x_payment_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->payment_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->payment_terms->EditValue ?>"<?php echo $production_partner->payment_terms->editAttributes() ?>>
</span>
<?php echo $production_partner->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->export_type->Visible) { // export_type ?>
	<div id="r_export_type" class="form-group row">
		<label id="elh_production_partner_export_type" for="x_export_type" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->export_type->caption() ?><?php echo ($production_partner->export_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->export_type->cellAttributes() ?>>
<span id="el_production_partner_export_type">
<input type="text" data-table="production_partner" data-field="x_export_type" data-page="4" name="x_export_type" id="x_export_type" size="30" placeholder="<?php echo HtmlEncode($production_partner->export_type->getPlaceHolder()) ?>" value="<?php echo $production_partner->export_type->EditValue ?>"<?php echo $production_partner->export_type->editAttributes() ?>>
</span>
<?php echo $production_partner->export_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
	<div id="r_lead_time_ss" class="form-group row">
		<label id="elh_production_partner_lead_time_ss" for="x_lead_time_ss" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->lead_time_ss->caption() ?><?php echo ($production_partner->lead_time_ss->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->lead_time_ss->cellAttributes() ?>>
<span id="el_production_partner_lead_time_ss">
<input type="text" data-table="production_partner" data-field="x_lead_time_ss" data-page="4" name="x_lead_time_ss" id="x_lead_time_ss" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_ss->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_ss->EditValue ?>"<?php echo $production_partner->lead_time_ss->editAttributes() ?>>
</span>
<?php echo $production_partner->lead_time_ss->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
	<div id="r_lead_time_cs" class="form-group row">
		<label id="elh_production_partner_lead_time_cs" for="x_lead_time_cs" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->lead_time_cs->caption() ?><?php echo ($production_partner->lead_time_cs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->lead_time_cs->cellAttributes() ?>>
<span id="el_production_partner_lead_time_cs">
<input type="text" data-table="production_partner" data-field="x_lead_time_cs" data-page="4" name="x_lead_time_cs" id="x_lead_time_cs" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_cs->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_cs->EditValue ?>"<?php echo $production_partner->lead_time_cs->editAttributes() ?>>
</span>
<?php echo $production_partner->lead_time_cs->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("5") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("5")) ?>" href="#tab_production_partner5"><?php echo $production_partner->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->cha->Visible) { // cha ?>
	<div id="r_cha" class="form-group row">
		<label id="elh_production_partner_cha" for="x_cha" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->cha->caption() ?><?php echo ($production_partner->cha->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->cha->cellAttributes() ?>>
<span id="el_production_partner_cha">
<textarea data-table="production_partner" data-field="x_cha" data-page="5" name="x_cha" id="x_cha" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha->getPlaceHolder()) ?>"<?php echo $production_partner->cha->editAttributes() ?>><?php echo $production_partner->cha->EditValue ?></textarea>
</span>
<?php echo $production_partner->cha->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
	<div id="r_cha_email" class="form-group row">
		<label id="elh_production_partner_cha_email" for="x_cha_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->cha_email->caption() ?><?php echo ($production_partner->cha_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->cha_email->cellAttributes() ?>>
<span id="el_production_partner_cha_email">
<textarea data-table="production_partner" data-field="x_cha_email" data-page="5" name="x_cha_email" id="x_cha_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha_email->getPlaceHolder()) ?>"<?php echo $production_partner->cha_email->editAttributes() ?>><?php echo $production_partner->cha_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->cha_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
	<div id="r_cha_phone" class="form-group row">
		<label id="elh_production_partner_cha_phone" for="x_cha_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->cha_phone->caption() ?><?php echo ($production_partner->cha_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->cha_phone->cellAttributes() ?>>
<span id="el_production_partner_cha_phone">
<textarea data-table="production_partner" data-field="x_cha_phone" data-page="5" name="x_cha_phone" id="x_cha_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha_phone->getPlaceHolder()) ?>"<?php echo $production_partner->cha_phone->editAttributes() ?>><?php echo $production_partner->cha_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->cha_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("6") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("6")) ?>" href="#tab_production_partner6"><?php echo $production_partner->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
	<div id="r_forwarder" class="form-group row">
		<label id="elh_production_partner_forwarder" for="x_forwarder" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->forwarder->caption() ?><?php echo ($production_partner->forwarder->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->forwarder->cellAttributes() ?>>
<span id="el_production_partner_forwarder">
<textarea data-table="production_partner" data-field="x_forwarder" data-page="6" name="x_forwarder" id="x_forwarder" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder->editAttributes() ?>><?php echo $production_partner->forwarder->EditValue ?></textarea>
</span>
<?php echo $production_partner->forwarder->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
	<div id="r_forwarder_email" class="form-group row">
		<label id="elh_production_partner_forwarder_email" for="x_forwarder_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->forwarder_email->caption() ?><?php echo ($production_partner->forwarder_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->forwarder_email->cellAttributes() ?>>
<span id="el_production_partner_forwarder_email">
<textarea data-table="production_partner" data-field="x_forwarder_email" data-page="6" name="x_forwarder_email" id="x_forwarder_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder_email->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder_email->editAttributes() ?>><?php echo $production_partner->forwarder_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->forwarder_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
	<div id="r_forwarder_phone" class="form-group row">
		<label id="elh_production_partner_forwarder_phone" for="x_forwarder_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->forwarder_phone->caption() ?><?php echo ($production_partner->forwarder_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->forwarder_phone->cellAttributes() ?>>
<span id="el_production_partner_forwarder_phone">
<textarea data-table="production_partner" data-field="x_forwarder_phone" data-page="6" name="x_forwarder_phone" id="x_forwarder_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder_phone->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder_phone->editAttributes() ?>><?php echo $production_partner->forwarder_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->forwarder_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("7") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("7")) ?>" href="#tab_production_partner7"><?php echo $production_partner->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->merchant->Visible) { // merchant ?>
	<div id="r_merchant" class="form-group row">
		<label id="elh_production_partner_merchant" for="x_merchant" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->merchant->caption() ?><?php echo ($production_partner->merchant->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->merchant->cellAttributes() ?>>
<span id="el_production_partner_merchant">
<textarea data-table="production_partner" data-field="x_merchant" data-page="7" name="x_merchant" id="x_merchant" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant->getPlaceHolder()) ?>"<?php echo $production_partner->merchant->editAttributes() ?>><?php echo $production_partner->merchant->EditValue ?></textarea>
</span>
<?php echo $production_partner->merchant->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
	<div id="r_merchant_email" class="form-group row">
		<label id="elh_production_partner_merchant_email" for="x_merchant_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->merchant_email->caption() ?><?php echo ($production_partner->merchant_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->merchant_email->cellAttributes() ?>>
<span id="el_production_partner_merchant_email">
<textarea data-table="production_partner" data-field="x_merchant_email" data-page="7" name="x_merchant_email" id="x_merchant_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant_email->getPlaceHolder()) ?>"<?php echo $production_partner->merchant_email->editAttributes() ?>><?php echo $production_partner->merchant_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->merchant_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
	<div id="r_merchant_phone" class="form-group row">
		<label id="elh_production_partner_merchant_phone" for="x_merchant_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->merchant_phone->caption() ?><?php echo ($production_partner->merchant_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->merchant_phone->cellAttributes() ?>>
<span id="el_production_partner_merchant_phone">
<textarea data-table="production_partner" data-field="x_merchant_phone" data-page="7" name="x_merchant_phone" id="x_merchant_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant_phone->getPlaceHolder()) ?>"<?php echo $production_partner->merchant_phone->editAttributes() ?>><?php echo $production_partner->merchant_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->merchant_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("8") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("8")) ?>" href="#tab_production_partner8"><?php echo $production_partner->pageCaption(8) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("8") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner8"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
	<div id="r_shipping_incharge" class="form-group row">
		<label id="elh_production_partner_shipping_incharge" for="x_shipping_incharge" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->shipping_incharge->caption() ?><?php echo ($production_partner->shipping_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->shipping_incharge->cellAttributes() ?>>
<span id="el_production_partner_shipping_incharge">
<textarea data-table="production_partner" data-field="x_shipping_incharge" data-page="8" name="x_shipping_incharge" id="x_shipping_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_incharge->editAttributes() ?>><?php echo $production_partner->shipping_incharge->EditValue ?></textarea>
</span>
<?php echo $production_partner->shipping_incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
	<div id="r_shipping_email" class="form-group row">
		<label id="elh_production_partner_shipping_email" for="x_shipping_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->shipping_email->caption() ?><?php echo ($production_partner->shipping_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->shipping_email->cellAttributes() ?>>
<span id="el_production_partner_shipping_email">
<textarea data-table="production_partner" data-field="x_shipping_email" data-page="8" name="x_shipping_email" id="x_shipping_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_email->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_email->editAttributes() ?>><?php echo $production_partner->shipping_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->shipping_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
	<div id="r_shipping_phone" class="form-group row">
		<label id="elh_production_partner_shipping_phone" for="x_shipping_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->shipping_phone->caption() ?><?php echo ($production_partner->shipping_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->shipping_phone->cellAttributes() ?>>
<span id="el_production_partner_shipping_phone">
<textarea data-table="production_partner" data-field="x_shipping_phone" data-page="8" name="x_shipping_phone" id="x_shipping_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_phone->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_phone->editAttributes() ?>><?php echo $production_partner->shipping_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->shipping_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("9") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("9")) ?>" href="#tab_production_partner9"><?php echo $production_partner->pageCaption(9) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("9") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner9"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
	<div id="r_account_incharge" class="form-group row">
		<label id="elh_production_partner_account_incharge" for="x_account_incharge" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->account_incharge->caption() ?><?php echo ($production_partner->account_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->account_incharge->cellAttributes() ?>>
<span id="el_production_partner_account_incharge">
<textarea data-table="production_partner" data-field="x_account_incharge" data-page="9" name="x_account_incharge" id="x_account_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->account_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->account_incharge->editAttributes() ?>><?php echo $production_partner->account_incharge->EditValue ?></textarea>
</span>
<?php echo $production_partner->account_incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
	<div id="r_accounts_email" class="form-group row">
		<label id="elh_production_partner_accounts_email" for="x_accounts_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->accounts_email->caption() ?><?php echo ($production_partner->accounts_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->accounts_email->cellAttributes() ?>>
<span id="el_production_partner_accounts_email">
<textarea data-table="production_partner" data-field="x_accounts_email" data-page="9" name="x_accounts_email" id="x_accounts_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->accounts_email->getPlaceHolder()) ?>"<?php echo $production_partner->accounts_email->editAttributes() ?>><?php echo $production_partner->accounts_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->accounts_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
	<div id="r_accounts_phone" class="form-group row">
		<label id="elh_production_partner_accounts_phone" for="x_accounts_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->accounts_phone->caption() ?><?php echo ($production_partner->accounts_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->accounts_phone->cellAttributes() ?>>
<span id="el_production_partner_accounts_phone">
<textarea data-table="production_partner" data-field="x_accounts_phone" data-page="9" name="x_accounts_phone" id="x_accounts_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->accounts_phone->getPlaceHolder()) ?>"<?php echo $production_partner->accounts_phone->editAttributes() ?>><?php echo $production_partner->accounts_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->accounts_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("10") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("10")) ?>" href="#tab_production_partner10"><?php echo $production_partner->pageCaption(10) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("10") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner10"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
	<div id="r_warehouse_incharge" class="form-group row">
		<label id="elh_production_partner_warehouse_incharge" for="x_warehouse_incharge" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->warehouse_incharge->caption() ?><?php echo ($production_partner->warehouse_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_incharge->cellAttributes() ?>>
<span id="el_production_partner_warehouse_incharge">
<textarea data-table="production_partner" data-field="x_warehouse_incharge" data-page="10" name="x_warehouse_incharge" id="x_warehouse_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_incharge->editAttributes() ?>><?php echo $production_partner->warehouse_incharge->EditValue ?></textarea>
</span>
<?php echo $production_partner->warehouse_incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
	<div id="r_warehouse_email" class="form-group row">
		<label id="elh_production_partner_warehouse_email" for="x_warehouse_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->warehouse_email->caption() ?><?php echo ($production_partner->warehouse_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_email->cellAttributes() ?>>
<span id="el_production_partner_warehouse_email">
<textarea data-table="production_partner" data-field="x_warehouse_email" data-page="10" name="x_warehouse_email" id="x_warehouse_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_email->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_email->editAttributes() ?>><?php echo $production_partner->warehouse_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->warehouse_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
	<div id="r_warehouse_phone" class="form-group row">
		<label id="elh_production_partner_warehouse_phone" for="x_warehouse_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->warehouse_phone->caption() ?><?php echo ($production_partner->warehouse_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_phone->cellAttributes() ?>>
<span id="el_production_partner_warehouse_phone">
<textarea data-table="production_partner" data-field="x_warehouse_phone" data-page="10" name="x_warehouse_phone" id="x_warehouse_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_phone->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_phone->editAttributes() ?>><?php echo $production_partner->warehouse_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->warehouse_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("11") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("11")) ?>" href="#tab_production_partner11"><?php echo $production_partner->pageCaption(11) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("11") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner11"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
	<div id="r_production_incharge" class="form-group row">
		<label id="elh_production_partner_production_incharge" for="x_production_incharge" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->production_incharge->caption() ?><?php echo ($production_partner->production_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->production_incharge->cellAttributes() ?>>
<span id="el_production_partner_production_incharge">
<textarea data-table="production_partner" data-field="x_production_incharge" data-page="11" name="x_production_incharge" id="x_production_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->production_incharge->editAttributes() ?>><?php echo $production_partner->production_incharge->EditValue ?></textarea>
</span>
<?php echo $production_partner->production_incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_email->Visible) { // production_email ?>
	<div id="r_production_email" class="form-group row">
		<label id="elh_production_partner_production_email" for="x_production_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->production_email->caption() ?><?php echo ($production_partner->production_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->production_email->cellAttributes() ?>>
<span id="el_production_partner_production_email">
<textarea data-table="production_partner" data-field="x_production_email" data-page="11" name="x_production_email" id="x_production_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_email->getPlaceHolder()) ?>"<?php echo $production_partner->production_email->editAttributes() ?>><?php echo $production_partner->production_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->production_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
	<div id="r_production_phone" class="form-group row">
		<label id="elh_production_partner_production_phone" for="x_production_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->production_phone->caption() ?><?php echo ($production_partner->production_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->production_phone->cellAttributes() ?>>
<span id="el_production_partner_production_phone">
<textarea data-table="production_partner" data-field="x_production_phone" data-page="11" name="x_production_phone" id="x_production_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_phone->getPlaceHolder()) ?>"<?php echo $production_partner->production_phone->editAttributes() ?>><?php echo $production_partner->production_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->production_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $production_partner_add->MultiPages->pageStyle("12") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_add->MultiPages->isActive("12")) ?>" href="#tab_production_partner12"><?php echo $production_partner->pageCaption(12) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_add->MultiPages->pageStyle("12") ?>" data-parent="<?php echo $production_partner_add->MultiPages->Parent ?>" id="tab_production_partner12"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
	<div id="r_qc_incharge" class="form-group row">
		<label id="elh_production_partner_qc_incharge" for="x_qc_incharge" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->qc_incharge->caption() ?><?php echo ($production_partner->qc_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->qc_incharge->cellAttributes() ?>>
<span id="el_production_partner_qc_incharge">
<textarea data-table="production_partner" data-field="x_qc_incharge" data-page="12" name="x_qc_incharge" id="x_qc_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->qc_incharge->editAttributes() ?>><?php echo $production_partner->qc_incharge->EditValue ?></textarea>
</span>
<?php echo $production_partner->qc_incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
	<div id="r_qc_email" class="form-group row">
		<label id="elh_production_partner_qc_email" for="x_qc_email" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->qc_email->caption() ?><?php echo ($production_partner->qc_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->qc_email->cellAttributes() ?>>
<span id="el_production_partner_qc_email">
<textarea data-table="production_partner" data-field="x_qc_email" data-page="12" name="x_qc_email" id="x_qc_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_email->getPlaceHolder()) ?>"<?php echo $production_partner->qc_email->editAttributes() ?>><?php echo $production_partner->qc_email->EditValue ?></textarea>
</span>
<?php echo $production_partner->qc_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
	<div id="r_qc_phone" class="form-group row">
		<label id="elh_production_partner_qc_phone" for="x_qc_phone" class="<?php echo $production_partner_add->LeftColumnClass ?>"><?php echo $production_partner->qc_phone->caption() ?><?php echo ($production_partner->qc_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_partner_add->RightColumnClass ?>"><div<?php echo $production_partner->qc_phone->cellAttributes() ?>>
<span id="el_production_partner_qc_phone">
<textarea data-table="production_partner" data-field="x_qc_phone" data-page="12" name="x_qc_phone" id="x_qc_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_phone->getPlaceHolder()) ?>"<?php echo $production_partner->qc_phone->editAttributes() ?>><?php echo $production_partner->qc_phone->EditValue ?></textarea>
</span>
<?php echo $production_partner->qc_phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
	if (in_array("shipping_address", explode(",", $production_partner->getCurrentDetailTable())) && $shipping_address->DetailAdd) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("shipping_address", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "shipping_addressgrid.php" ?>
<?php } ?>
<?php
	if (in_array("_bank_info", explode(",", $production_partner->getCurrentDetailTable())) && $_bank_info->DetailAdd) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("_bank_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "_bank_infogrid.php" ?>
<?php } ?>
<?php
	if (in_array("capacity_plan", explode(",", $production_partner->getCurrentDetailTable())) && $capacity_plan->DetailAdd) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("capacity_plan", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "capacity_plangrid.php" ?>
<?php } ?>
<?php if (!$production_partner_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_partner_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_partner_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_partner_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_partner_add->terminate();
?>