<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_partner_addopt = new production_partner_addopt();

// Run the page
$production_partner_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_partner_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fproduction_partneraddopt = currentForm = new ew.Form("fproduction_partneraddopt", "addopt");

// Validate form
fproduction_partneraddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_partner_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->name->caption(), $production_partner->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->code->caption(), $production_partner->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,8}$/))
				return this.onError(elm, "<?php echo JsEncode($production_partner->code->errorMessage()) ?>");
		<?php if ($production_partner_addopt->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->country->caption(), $production_partner->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->region->Required) { ?>
			elm = this.getElements("x" + infix + "_region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->region->caption(), $production_partner->region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->city->caption(), $production_partner->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->address->caption(), $production_partner->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->mobile->caption(), $production_partner->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->_email->caption(), $production_partner->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->url->caption(), $production_partner->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->grp->caption(), $production_partner->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->category->caption(), $production_partner->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->reports_to->caption(), $production_partner->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->status->caption(), $production_partner->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->performance->Required) { ?>
			elm = this.getElements("x" + infix + "_performance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->performance->caption(), $production_partner->performance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_performance");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_partner->performance->errorMessage()) ?>");
		<?php if ($production_partner_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->operator->caption(), $production_partner->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->datetime->caption(), $production_partner->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->type->caption(), $production_partner->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->tax_registration->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_registration");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->tax_registration->caption(), $production_partner->tax_registration->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->cin->Required) { ?>
			elm = this.getElements("x" + infix + "_cin");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cin->caption(), $production_partner->cin->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->pan->Required) { ?>
			elm = this.getElements("x" + infix + "_pan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->pan->caption(), $production_partner->pan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->tan->Required) { ?>
			elm = this.getElements("x" + infix + "_tan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->tan->caption(), $production_partner->tan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->msme->Required) { ?>
			elm = this.getElements("x" + infix + "_msme");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->msme->caption(), $production_partner->msme->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->incoterm->Required) { ?>
			elm = this.getElements("x" + infix + "_incoterm[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->incoterm->caption(), $production_partner->incoterm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->port_air->Required) { ?>
			elm = this.getElements("x" + infix + "_port_air");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->port_air->caption(), $production_partner->port_air->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->port_sea->Required) { ?>
			elm = this.getElements("x" + infix + "_port_sea");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->port_sea->caption(), $production_partner->port_sea->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->iec->Required) { ?>
			elm = this.getElements("x" + infix + "_iec");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->iec->caption(), $production_partner->iec->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->rex->Required) { ?>
			elm = this.getElements("x" + infix + "_rex");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->rex->caption(), $production_partner->rex->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->rcmc->Required) { ?>
			elm = this.getElements("x" + infix + "_rcmc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->rcmc->caption(), $production_partner->rcmc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->delivery_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->delivery_terms->caption(), $production_partner->delivery_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->shipping_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_terms->caption(), $production_partner->shipping_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->payment_terms->caption(), $production_partner->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->export_type->Required) { ?>
			elm = this.getElements("x" + infix + "_export_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->export_type->caption(), $production_partner->export_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->lead_time_ss->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_time_ss");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->lead_time_ss->caption(), $production_partner->lead_time_ss->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lead_time_ss");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_ss->errorMessage()) ?>");
		<?php if ($production_partner_addopt->lead_time_cs->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_time_cs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->lead_time_cs->caption(), $production_partner->lead_time_cs->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lead_time_cs");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_cs->errorMessage()) ?>");
		<?php if ($production_partner_addopt->cha->Required) { ?>
			elm = this.getElements("x" + infix + "_cha");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha->caption(), $production_partner->cha->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->cha_email->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha_email->caption(), $production_partner->cha_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->cha_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->cha_phone->caption(), $production_partner->cha_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->forwarder->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder->caption(), $production_partner->forwarder->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->forwarder_email->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder_email->caption(), $production_partner->forwarder_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->forwarder_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_forwarder_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->forwarder_phone->caption(), $production_partner->forwarder_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->merchant->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant->caption(), $production_partner->merchant->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->merchant_email->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant_email->caption(), $production_partner->merchant_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->merchant_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_merchant_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->merchant_phone->caption(), $production_partner->merchant_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->shipping_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_incharge->caption(), $production_partner->shipping_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->shipping_email->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_email->caption(), $production_partner->shipping_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->shipping_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->shipping_phone->caption(), $production_partner->shipping_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->account_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_account_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->account_incharge->caption(), $production_partner->account_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->accounts_email->Required) { ?>
			elm = this.getElements("x" + infix + "_accounts_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->accounts_email->caption(), $production_partner->accounts_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->accounts_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_accounts_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->accounts_phone->caption(), $production_partner->accounts_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->warehouse_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_incharge->caption(), $production_partner->warehouse_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->warehouse_email->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_email->caption(), $production_partner->warehouse_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->warehouse_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_warehouse_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->warehouse_phone->caption(), $production_partner->warehouse_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->production_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_production_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_incharge->caption(), $production_partner->production_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->production_email->Required) { ?>
			elm = this.getElements("x" + infix + "_production_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_email->caption(), $production_partner->production_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->production_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_production_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->production_phone->caption(), $production_partner->production_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->qc_incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_incharge->caption(), $production_partner->qc_incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->qc_email->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_email->caption(), $production_partner->qc_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->qc_phone->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_phone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->qc_phone->caption(), $production_partner->qc_phone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_partner_addopt->r_text->Required) { ?>
			elm = this.getElements("x" + infix + "_r_text");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_partner->r_text->caption(), $production_partner->r_text->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_partneraddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_partneraddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_partneraddopt.lists["x_country"] = <?php echo $production_partner_addopt->country->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_country"].options = <?php echo JsonEncode($production_partner_addopt->country->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_region"] = <?php echo $production_partner_addopt->region->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_region"].options = <?php echo JsonEncode($production_partner_addopt->region->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_city"] = <?php echo $production_partner_addopt->city->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_city"].options = <?php echo JsonEncode($production_partner_addopt->city->lookupOptions()) ?>;
fproduction_partneraddopt.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduction_partneraddopt.lists["x_grp[]"] = <?php echo $production_partner_addopt->grp->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_grp[]"].options = <?php echo JsonEncode($production_partner_addopt->grp->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_category"] = <?php echo $production_partner_addopt->category->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_category"].options = <?php echo JsonEncode($production_partner_addopt->category->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_reports_to"] = <?php echo $production_partner_addopt->reports_to->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_reports_to"].options = <?php echo JsonEncode($production_partner_addopt->reports_to->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_status"] = <?php echo $production_partner_addopt->status->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_status"].options = <?php echo JsonEncode($production_partner_addopt->status->options(FALSE, TRUE)) ?>;
fproduction_partneraddopt.lists["x_operator"] = <?php echo $production_partner_addopt->operator->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_operator"].options = <?php echo JsonEncode($production_partner_addopt->operator->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_type"] = <?php echo $production_partner_addopt->type->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_type"].options = <?php echo JsonEncode($production_partner_addopt->type->options(FALSE, TRUE)) ?>;
fproduction_partneraddopt.lists["x_incoterm[]"] = <?php echo $production_partner_addopt->incoterm->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_incoterm[]"].options = <?php echo JsonEncode($production_partner_addopt->incoterm->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_port_air"] = <?php echo $production_partner_addopt->port_air->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_port_air"].options = <?php echo JsonEncode($production_partner_addopt->port_air->lookupOptions()) ?>;
fproduction_partneraddopt.lists["x_port_sea"] = <?php echo $production_partner_addopt->port_sea->Lookup->toClientList() ?>;
fproduction_partneraddopt.lists["x_port_sea"].options = <?php echo JsonEncode($production_partner_addopt->port_sea->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_partner_addopt->showPageHeader(); ?>
<?php
$production_partner_addopt->showMessage();
?>
<form name="fproduction_partneraddopt" id="fproduction_partneraddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($production_partner_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_partner_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $production_partner_addopt->TableVar ?>">
<?php if ($production_partner->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $production_partner->name->caption() ?><?php echo ($production_partner->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($production_partner->name->getPlaceHolder()) ?>" value="<?php echo $production_partner->name->EditValue ?>"<?php echo $production_partner->name->editAttributes() ?>>
<?php echo $production_partner->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $production_partner->code->caption() ?><?php echo ($production_partner->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($production_partner->code->getPlaceHolder()) ?>" value="<?php echo $production_partner->code->EditValue ?>"<?php echo $production_partner->code->editAttributes() ?>>
<?php echo $production_partner->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->country->Visible) { // country ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_country"><?php echo $production_partner->country->caption() ?><?php echo ($production_partner->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $production_partner->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_country" data-value-separator="<?php echo $production_partner->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $production_partner->country->editAttributes() ?>>
		<?php echo $production_partner->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $production_partner->country->Lookup->getParamTag("p_x_country") ?>
<?php echo $production_partner->country->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->region->Visible) { // region ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_region"><?php echo $production_partner->region->caption() ?><?php echo ($production_partner->region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $production_partner->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_region" data-value-separator="<?php echo $production_partner->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $production_partner->region->editAttributes() ?>>
		<?php echo $production_partner->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $production_partner->region->Lookup->getParamTag("p_x_region") ?>
<?php echo $production_partner->region->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->city->Visible) { // city ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_partner->city->caption() ?><?php echo ($production_partner->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$production_partner->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$production_partner->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($production_partner->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>"<?php echo $production_partner->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_partner->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($production_partner->city->ReadOnly || $production_partner->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="production_partner" data-field="x_city" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_partner->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($production_partner->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduction_partneraddopt.createAutoSuggest({"id":"x_city","forceSelect":true});
</script>
<?php echo $production_partner->city->Lookup->getParamTag("p_x_city") ?>
<?php echo $production_partner->city->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->address->Visible) { // address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_address"><?php echo $production_partner->address->caption() ?><?php echo ($production_partner->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_address" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?php echo HtmlEncode($production_partner->address->getPlaceHolder()) ?>"<?php echo $production_partner->address->editAttributes() ?>><?php echo $production_partner->address->EditValue ?></textarea>
<?php echo $production_partner->address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->mobile->Visible) { // mobile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?php echo $production_partner->mobile->caption() ?><?php echo ($production_partner->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_partner->mobile->getPlaceHolder()) ?>" value="<?php echo $production_partner->mobile->EditValue ?>"<?php echo $production_partner->mobile->editAttributes() ?>>
<?php echo $production_partner->mobile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->_email->Visible) { // email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__email"><?php echo $production_partner->_email->caption() ?><?php echo ($production_partner->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_partner->_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->_email->EditValue ?>"<?php echo $production_partner->_email->editAttributes() ?>>
<?php echo $production_partner->_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->url->Visible) { // url ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_url"><?php echo $production_partner->url->caption() ?><?php echo ($production_partner->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->url->getPlaceHolder()) ?>" value="<?php echo $production_partner->url->EditValue ?>"<?php echo $production_partner->url->editAttributes() ?>>
<?php echo $production_partner->url->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $production_partner->grp->caption() ?><?php echo ($production_partner->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_partner" data-field="x_grp" data-value-separator="<?php echo $production_partner->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $production_partner->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_partner->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $production_partner->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $production_partner->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->category->Visible) { // category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_category"><?php echo $production_partner->category->caption() ?><?php echo ($production_partner->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_category" data-value-separator="<?php echo $production_partner->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $production_partner->category->editAttributes() ?>>
		<?php echo $production_partner->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $production_partner->category->Lookup->getParamTag("p_x_category") ?>
<?php echo $production_partner->category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reports_to"><?php echo $production_partner->reports_to->caption() ?><?php echo ($production_partner->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_reports_to" data-value-separator="<?php echo $production_partner->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $production_partner->reports_to->editAttributes() ?>>
		<?php echo $production_partner->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $production_partner->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
<?php echo $production_partner->reports_to->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $production_partner->status->caption() ?><?php echo ($production_partner->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_status" data-value-separator="<?php echo $production_partner->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_partner->status->editAttributes() ?>>
		<?php echo $production_partner->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $production_partner->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->performance->Visible) { // performance ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_performance"><?php echo $production_partner->performance->caption() ?><?php echo ($production_partner->performance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_performance" name="x_performance" id="x_performance" size="30" placeholder="<?php echo HtmlEncode($production_partner->performance->getPlaceHolder()) ?>" value="<?php echo $production_partner->performance->EditValue ?>"<?php echo $production_partner->performance->editAttributes() ?>>
<?php echo $production_partner->performance->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->operator->Visible) { // operator ?>
	<input type="hidden" data-table="production_partner" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($production_partner->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($production_partner->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="production_partner" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($production_partner->datetime->CurrentValue) ?>">
	<?php if (!$production_partner->datetime->ReadOnly && !$production_partner->datetime->Disabled && !isset($production_partner->datetime->EditAttrs["readonly"]) && !isset($production_partner->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fproduction_partneraddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->type->Visible) { // type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_type"><?php echo $production_partner->type->caption() ?><?php echo ($production_partner->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_type" data-value-separator="<?php echo $production_partner->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $production_partner->type->editAttributes() ?>>
		<?php echo $production_partner->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $production_partner->type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_tax_registration"><?php echo $production_partner->tax_registration->caption() ?><?php echo ($production_partner->tax_registration->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_tax_registration" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_partner->tax_registration->getPlaceHolder()) ?>" value="<?php echo $production_partner->tax_registration->EditValue ?>"<?php echo $production_partner->tax_registration->editAttributes() ?>>
<?php echo $production_partner->tax_registration->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->cin->Visible) { // cin ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cin"><?php echo $production_partner->cin->caption() ?><?php echo ($production_partner->cin->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_cin" name="x_cin" id="x_cin" size="30" placeholder="<?php echo HtmlEncode($production_partner->cin->getPlaceHolder()) ?>" value="<?php echo $production_partner->cin->EditValue ?>"<?php echo $production_partner->cin->editAttributes() ?>>
<?php echo $production_partner->cin->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->pan->Visible) { // pan ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_pan"><?php echo $production_partner->pan->caption() ?><?php echo ($production_partner->pan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_pan" name="x_pan" id="x_pan" size="30" placeholder="<?php echo HtmlEncode($production_partner->pan->getPlaceHolder()) ?>" value="<?php echo $production_partner->pan->EditValue ?>"<?php echo $production_partner->pan->editAttributes() ?>>
<?php echo $production_partner->pan->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->tan->Visible) { // tan ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_tan"><?php echo $production_partner->tan->caption() ?><?php echo ($production_partner->tan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_tan" name="x_tan" id="x_tan" size="30" placeholder="<?php echo HtmlEncode($production_partner->tan->getPlaceHolder()) ?>" value="<?php echo $production_partner->tan->EditValue ?>"<?php echo $production_partner->tan->editAttributes() ?>>
<?php echo $production_partner->tan->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->msme->Visible) { // msme ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_msme"><?php echo $production_partner->msme->caption() ?><?php echo ($production_partner->msme->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_msme" name="x_msme" id="x_msme" size="30" placeholder="<?php echo HtmlEncode($production_partner->msme->getPlaceHolder()) ?>" value="<?php echo $production_partner->msme->EditValue ?>"<?php echo $production_partner->msme->editAttributes() ?>>
<?php echo $production_partner->msme->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->incoterm->Visible) { // incoterm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_incoterm"><?php echo $production_partner->incoterm->caption() ?><?php echo ($production_partner->incoterm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_incoterm" data-value-separator="<?php echo $production_partner->incoterm->displayValueSeparatorAttribute() ?>" id="x_incoterm[]" name="x_incoterm[]" size=5 multiple="multiple"<?php echo $production_partner->incoterm->editAttributes() ?>>
		<?php echo $production_partner->incoterm->selectOptionListHtml("x_incoterm[]") ?>
	</select>
</div>
<?php echo $production_partner->incoterm->Lookup->getParamTag("p_x_incoterm") ?>
<?php echo $production_partner->incoterm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->port_air->Visible) { // port_air ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_port_air"><?php echo $production_partner->port_air->caption() ?><?php echo ($production_partner->port_air->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_port_air" data-value-separator="<?php echo $production_partner->port_air->displayValueSeparatorAttribute() ?>" id="x_port_air" name="x_port_air"<?php echo $production_partner->port_air->editAttributes() ?>>
		<?php echo $production_partner->port_air->selectOptionListHtml("x_port_air") ?>
	</select>
</div>
<?php echo $production_partner->port_air->Lookup->getParamTag("p_x_port_air") ?>
<?php echo $production_partner->port_air->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->port_sea->Visible) { // port_sea ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_port_sea"><?php echo $production_partner->port_sea->caption() ?><?php echo ($production_partner->port_sea->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_port_sea" data-value-separator="<?php echo $production_partner->port_sea->displayValueSeparatorAttribute() ?>" id="x_port_sea" name="x_port_sea"<?php echo $production_partner->port_sea->editAttributes() ?>>
		<?php echo $production_partner->port_sea->selectOptionListHtml("x_port_sea") ?>
	</select>
</div>
<?php echo $production_partner->port_sea->Lookup->getParamTag("p_x_port_sea") ?>
<?php echo $production_partner->port_sea->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->iec->Visible) { // iec ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_iec"><?php echo $production_partner->iec->caption() ?><?php echo ($production_partner->iec->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_iec" name="x_iec" id="x_iec" size="30" placeholder="<?php echo HtmlEncode($production_partner->iec->getPlaceHolder()) ?>" value="<?php echo $production_partner->iec->EditValue ?>"<?php echo $production_partner->iec->editAttributes() ?>>
<?php echo $production_partner->iec->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->rex->Visible) { // rex ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_rex"><?php echo $production_partner->rex->caption() ?><?php echo ($production_partner->rex->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_rex" name="x_rex" id="x_rex" size="30" placeholder="<?php echo HtmlEncode($production_partner->rex->getPlaceHolder()) ?>" value="<?php echo $production_partner->rex->EditValue ?>"<?php echo $production_partner->rex->editAttributes() ?>>
<?php echo $production_partner->rex->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_rcmc"><?php echo $production_partner->rcmc->caption() ?><?php echo ($production_partner->rcmc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_rcmc" name="x_rcmc" id="x_rcmc" size="30" placeholder="<?php echo HtmlEncode($production_partner->rcmc->getPlaceHolder()) ?>" value="<?php echo $production_partner->rcmc->EditValue ?>"<?php echo $production_partner->rcmc->editAttributes() ?>>
<?php echo $production_partner->rcmc->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_delivery_terms"><?php echo $production_partner->delivery_terms->caption() ?><?php echo ($production_partner->delivery_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_delivery_terms" name="x_delivery_terms" id="x_delivery_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->delivery_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->delivery_terms->EditValue ?>"<?php echo $production_partner->delivery_terms->editAttributes() ?>>
<?php echo $production_partner->delivery_terms->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shipping_terms"><?php echo $production_partner->shipping_terms->caption() ?><?php echo ($production_partner->shipping_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_shipping_terms" name="x_shipping_terms" id="x_shipping_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->shipping_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_terms->EditValue ?>"<?php echo $production_partner->shipping_terms->editAttributes() ?>>
<?php echo $production_partner->shipping_terms->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_payment_terms"><?php echo $production_partner->payment_terms->caption() ?><?php echo ($production_partner->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_payment_terms" name="x_payment_terms" id="x_payment_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->payment_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->payment_terms->EditValue ?>"<?php echo $production_partner->payment_terms->editAttributes() ?>>
<?php echo $production_partner->payment_terms->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->export_type->Visible) { // export_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_export_type"><?php echo $production_partner->export_type->caption() ?><?php echo ($production_partner->export_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_export_type" name="x_export_type" id="x_export_type" size="30" placeholder="<?php echo HtmlEncode($production_partner->export_type->getPlaceHolder()) ?>" value="<?php echo $production_partner->export_type->EditValue ?>"<?php echo $production_partner->export_type->editAttributes() ?>>
<?php echo $production_partner->export_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_lead_time_ss"><?php echo $production_partner->lead_time_ss->caption() ?><?php echo ($production_partner->lead_time_ss->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_lead_time_ss" name="x_lead_time_ss" id="x_lead_time_ss" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_ss->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_ss->EditValue ?>"<?php echo $production_partner->lead_time_ss->editAttributes() ?>>
<?php echo $production_partner->lead_time_ss->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_lead_time_cs"><?php echo $production_partner->lead_time_cs->caption() ?><?php echo ($production_partner->lead_time_cs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="production_partner" data-field="x_lead_time_cs" name="x_lead_time_cs" id="x_lead_time_cs" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_cs->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_cs->EditValue ?>"<?php echo $production_partner->lead_time_cs->editAttributes() ?>>
<?php echo $production_partner->lead_time_cs->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha->Visible) { // cha ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cha"><?php echo $production_partner->cha->caption() ?><?php echo ($production_partner->cha->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_cha" name="x_cha" id="x_cha" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha->getPlaceHolder()) ?>"<?php echo $production_partner->cha->editAttributes() ?>><?php echo $production_partner->cha->EditValue ?></textarea>
<?php echo $production_partner->cha->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cha_email"><?php echo $production_partner->cha_email->caption() ?><?php echo ($production_partner->cha_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_cha_email" name="x_cha_email" id="x_cha_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha_email->getPlaceHolder()) ?>"<?php echo $production_partner->cha_email->editAttributes() ?>><?php echo $production_partner->cha_email->EditValue ?></textarea>
<?php echo $production_partner->cha_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cha_phone"><?php echo $production_partner->cha_phone->caption() ?><?php echo ($production_partner->cha_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_cha_phone" name="x_cha_phone" id="x_cha_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->cha_phone->getPlaceHolder()) ?>"<?php echo $production_partner->cha_phone->editAttributes() ?>><?php echo $production_partner->cha_phone->EditValue ?></textarea>
<?php echo $production_partner->cha_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_forwarder"><?php echo $production_partner->forwarder->caption() ?><?php echo ($production_partner->forwarder->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_forwarder" name="x_forwarder" id="x_forwarder" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder->editAttributes() ?>><?php echo $production_partner->forwarder->EditValue ?></textarea>
<?php echo $production_partner->forwarder->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_forwarder_email"><?php echo $production_partner->forwarder_email->caption() ?><?php echo ($production_partner->forwarder_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_forwarder_email" name="x_forwarder_email" id="x_forwarder_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder_email->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder_email->editAttributes() ?>><?php echo $production_partner->forwarder_email->EditValue ?></textarea>
<?php echo $production_partner->forwarder_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_forwarder_phone"><?php echo $production_partner->forwarder_phone->caption() ?><?php echo ($production_partner->forwarder_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_forwarder_phone" name="x_forwarder_phone" id="x_forwarder_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->forwarder_phone->getPlaceHolder()) ?>"<?php echo $production_partner->forwarder_phone->editAttributes() ?>><?php echo $production_partner->forwarder_phone->EditValue ?></textarea>
<?php echo $production_partner->forwarder_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant->Visible) { // merchant ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_merchant"><?php echo $production_partner->merchant->caption() ?><?php echo ($production_partner->merchant->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_merchant" name="x_merchant" id="x_merchant" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant->getPlaceHolder()) ?>"<?php echo $production_partner->merchant->editAttributes() ?>><?php echo $production_partner->merchant->EditValue ?></textarea>
<?php echo $production_partner->merchant->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_merchant_email"><?php echo $production_partner->merchant_email->caption() ?><?php echo ($production_partner->merchant_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_merchant_email" name="x_merchant_email" id="x_merchant_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant_email->getPlaceHolder()) ?>"<?php echo $production_partner->merchant_email->editAttributes() ?>><?php echo $production_partner->merchant_email->EditValue ?></textarea>
<?php echo $production_partner->merchant_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_merchant_phone"><?php echo $production_partner->merchant_phone->caption() ?><?php echo ($production_partner->merchant_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_merchant_phone" name="x_merchant_phone" id="x_merchant_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->merchant_phone->getPlaceHolder()) ?>"<?php echo $production_partner->merchant_phone->editAttributes() ?>><?php echo $production_partner->merchant_phone->EditValue ?></textarea>
<?php echo $production_partner->merchant_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shipping_incharge"><?php echo $production_partner->shipping_incharge->caption() ?><?php echo ($production_partner->shipping_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_shipping_incharge" name="x_shipping_incharge" id="x_shipping_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_incharge->editAttributes() ?>><?php echo $production_partner->shipping_incharge->EditValue ?></textarea>
<?php echo $production_partner->shipping_incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shipping_email"><?php echo $production_partner->shipping_email->caption() ?><?php echo ($production_partner->shipping_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_shipping_email" name="x_shipping_email" id="x_shipping_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_email->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_email->editAttributes() ?>><?php echo $production_partner->shipping_email->EditValue ?></textarea>
<?php echo $production_partner->shipping_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shipping_phone"><?php echo $production_partner->shipping_phone->caption() ?><?php echo ($production_partner->shipping_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_shipping_phone" name="x_shipping_phone" id="x_shipping_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->shipping_phone->getPlaceHolder()) ?>"<?php echo $production_partner->shipping_phone->editAttributes() ?>><?php echo $production_partner->shipping_phone->EditValue ?></textarea>
<?php echo $production_partner->shipping_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_account_incharge"><?php echo $production_partner->account_incharge->caption() ?><?php echo ($production_partner->account_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_account_incharge" name="x_account_incharge" id="x_account_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->account_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->account_incharge->editAttributes() ?>><?php echo $production_partner->account_incharge->EditValue ?></textarea>
<?php echo $production_partner->account_incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_accounts_email"><?php echo $production_partner->accounts_email->caption() ?><?php echo ($production_partner->accounts_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_accounts_email" name="x_accounts_email" id="x_accounts_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->accounts_email->getPlaceHolder()) ?>"<?php echo $production_partner->accounts_email->editAttributes() ?>><?php echo $production_partner->accounts_email->EditValue ?></textarea>
<?php echo $production_partner->accounts_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_accounts_phone"><?php echo $production_partner->accounts_phone->caption() ?><?php echo ($production_partner->accounts_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_accounts_phone" name="x_accounts_phone" id="x_accounts_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->accounts_phone->getPlaceHolder()) ?>"<?php echo $production_partner->accounts_phone->editAttributes() ?>><?php echo $production_partner->accounts_phone->EditValue ?></textarea>
<?php echo $production_partner->accounts_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_warehouse_incharge"><?php echo $production_partner->warehouse_incharge->caption() ?><?php echo ($production_partner->warehouse_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_warehouse_incharge" name="x_warehouse_incharge" id="x_warehouse_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_incharge->editAttributes() ?>><?php echo $production_partner->warehouse_incharge->EditValue ?></textarea>
<?php echo $production_partner->warehouse_incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_warehouse_email"><?php echo $production_partner->warehouse_email->caption() ?><?php echo ($production_partner->warehouse_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_warehouse_email" name="x_warehouse_email" id="x_warehouse_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_email->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_email->editAttributes() ?>><?php echo $production_partner->warehouse_email->EditValue ?></textarea>
<?php echo $production_partner->warehouse_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_warehouse_phone"><?php echo $production_partner->warehouse_phone->caption() ?><?php echo ($production_partner->warehouse_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_warehouse_phone" name="x_warehouse_phone" id="x_warehouse_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->warehouse_phone->getPlaceHolder()) ?>"<?php echo $production_partner->warehouse_phone->editAttributes() ?>><?php echo $production_partner->warehouse_phone->EditValue ?></textarea>
<?php echo $production_partner->warehouse_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_production_incharge"><?php echo $production_partner->production_incharge->caption() ?><?php echo ($production_partner->production_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_production_incharge" name="x_production_incharge" id="x_production_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->production_incharge->editAttributes() ?>><?php echo $production_partner->production_incharge->EditValue ?></textarea>
<?php echo $production_partner->production_incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_email->Visible) { // production_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_production_email"><?php echo $production_partner->production_email->caption() ?><?php echo ($production_partner->production_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_production_email" name="x_production_email" id="x_production_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_email->getPlaceHolder()) ?>"<?php echo $production_partner->production_email->editAttributes() ?>><?php echo $production_partner->production_email->EditValue ?></textarea>
<?php echo $production_partner->production_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_production_phone"><?php echo $production_partner->production_phone->caption() ?><?php echo ($production_partner->production_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_production_phone" name="x_production_phone" id="x_production_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->production_phone->getPlaceHolder()) ?>"<?php echo $production_partner->production_phone->editAttributes() ?>><?php echo $production_partner->production_phone->EditValue ?></textarea>
<?php echo $production_partner->production_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_qc_incharge"><?php echo $production_partner->qc_incharge->caption() ?><?php echo ($production_partner->qc_incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_qc_incharge" name="x_qc_incharge" id="x_qc_incharge" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_incharge->getPlaceHolder()) ?>"<?php echo $production_partner->qc_incharge->editAttributes() ?>><?php echo $production_partner->qc_incharge->EditValue ?></textarea>
<?php echo $production_partner->qc_incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_qc_email"><?php echo $production_partner->qc_email->caption() ?><?php echo ($production_partner->qc_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_qc_email" name="x_qc_email" id="x_qc_email" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_email->getPlaceHolder()) ?>"<?php echo $production_partner->qc_email->editAttributes() ?>><?php echo $production_partner->qc_email->EditValue ?></textarea>
<?php echo $production_partner->qc_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_qc_phone"><?php echo $production_partner->qc_phone->caption() ?><?php echo ($production_partner->qc_phone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_qc_phone" name="x_qc_phone" id="x_qc_phone" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->qc_phone->getPlaceHolder()) ?>"<?php echo $production_partner->qc_phone->editAttributes() ?>><?php echo $production_partner->qc_phone->EditValue ?></textarea>
<?php echo $production_partner->qc_phone->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($production_partner->r_text->Visible) { // r_text ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_r_text"><?php echo $production_partner->r_text->caption() ?><?php echo ($production_partner->r_text->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="production_partner" data-field="x_r_text" name="x_r_text" id="x_r_text" cols="35" rows="4" placeholder="<?php echo HtmlEncode($production_partner->r_text->getPlaceHolder()) ?>"<?php echo $production_partner->r_text->editAttributes() ?>><?php echo $production_partner->r_text->EditValue ?></textarea>
<?php echo $production_partner->r_text->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$production_partner_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$production_partner_addopt->terminate();
?>