<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_partner_list = new production_partner_list();

// Run the page
$production_partner_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_partner_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_partner->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_partnerlist = currentForm = new ew.Form("fproduction_partnerlist", "list");
fproduction_partnerlist.formKeyCountName = '<?php echo $production_partner_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_partnerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_partnerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_partnerlist.lists["x_country"] = <?php echo $production_partner_list->country->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_country"].options = <?php echo JsonEncode($production_partner_list->country->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_region"] = <?php echo $production_partner_list->region->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_region"].options = <?php echo JsonEncode($production_partner_list->region->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_city"] = <?php echo $production_partner_list->city->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_city"].options = <?php echo JsonEncode($production_partner_list->city->lookupOptions()) ?>;
fproduction_partnerlist.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduction_partnerlist.lists["x_grp[]"] = <?php echo $production_partner_list->grp->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_grp[]"].options = <?php echo JsonEncode($production_partner_list->grp->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_category"] = <?php echo $production_partner_list->category->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_category"].options = <?php echo JsonEncode($production_partner_list->category->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_reports_to"] = <?php echo $production_partner_list->reports_to->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_reports_to"].options = <?php echo JsonEncode($production_partner_list->reports_to->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_status"] = <?php echo $production_partner_list->status->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_status"].options = <?php echo JsonEncode($production_partner_list->status->options(FALSE, TRUE)) ?>;
fproduction_partnerlist.lists["x_operator"] = <?php echo $production_partner_list->operator->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_operator"].options = <?php echo JsonEncode($production_partner_list->operator->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_type"] = <?php echo $production_partner_list->type->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_type"].options = <?php echo JsonEncode($production_partner_list->type->options(FALSE, TRUE)) ?>;
fproduction_partnerlist.lists["x_port_air"] = <?php echo $production_partner_list->port_air->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_port_air"].options = <?php echo JsonEncode($production_partner_list->port_air->lookupOptions()) ?>;
fproduction_partnerlist.lists["x_port_sea"] = <?php echo $production_partner_list->port_sea->Lookup->toClientList() ?>;
fproduction_partnerlist.lists["x_port_sea"].options = <?php echo JsonEncode($production_partner_list->port_sea->lookupOptions()) ?>;

// Form object for search
var fproduction_partnerlistsrch = currentSearchForm = new ew.Form("fproduction_partnerlistsrch");

// Filters
fproduction_partnerlistsrch.filterList = <?php echo $production_partner_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_partnerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_partner_list->TotalRecs > 0 && $production_partner_list->ExportOptions->visible()) { ?>
<?php $production_partner_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_partner_list->ImportOptions->visible()) { ?>
<?php $production_partner_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_partner_list->SearchOptions->visible()) { ?>
<?php $production_partner_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_partner_list->FilterOptions->visible()) { ?>
<?php $production_partner_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_partner_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_partner->isExport() && !$production_partner->CurrentAction) { ?>
<form name="fproduction_partnerlistsrch" id="fproduction_partnerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_partner_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_partnerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_partner">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_partner_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_partner_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_partner_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_partner_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_partner_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_partner_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_partner_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_partner_list->showPageHeader(); ?>
<?php
$production_partner_list->showMessage();
?>
<?php if ($production_partner_list->TotalRecs > 0 || $production_partner->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_partner_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_partner">
<?php if (!$production_partner->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_partner->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_partner_list->Pager)) $production_partner_list->Pager = new PrevNextPager($production_partner_list->StartRec, $production_partner_list->DisplayRecs, $production_partner_list->TotalRecs, $production_partner_list->AutoHidePager) ?>
<?php if ($production_partner_list->Pager->RecordCount > 0 && $production_partner_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_partner_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_partner_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_partner_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_partner_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_partner_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_partner_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_partner_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_partner_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_partner_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_partner_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_partner_list->TotalRecs > 0 && (!$production_partner_list->AutoHidePageSizeSelector || $production_partner_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_partner">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_partner_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_partner_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_partner_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_partner_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_partner_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_partner->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_partner_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_partnerlist" id="fproduction_partnerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_partner_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_partner_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<div id="gmp_production_partner" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_partner_list->TotalRecs > 0 || $production_partner->isGridEdit()) { ?>
<table id="tbl_production_partnerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_partner_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_partner_list->renderListOptions();

// Render list options (header, left)
$production_partner_list->ListOptions->render("header", "left");
?>
<?php if ($production_partner->id->Visible) { // id ?>
	<?php if ($production_partner->sortUrl($production_partner->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_partner->id->headerCellClass() ?>"><div id="elh_production_partner_id" class="production_partner_id"><div class="ew-table-header-caption"><?php echo $production_partner->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_partner->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->id) ?>',2);"><div id="elh_production_partner_id" class="production_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->name->Visible) { // name ?>
	<?php if ($production_partner->sortUrl($production_partner->name) == "") { ?>
		<th data-name="name" class="<?php echo $production_partner->name->headerCellClass() ?>"><div id="elh_production_partner_name" class="production_partner_name"><div class="ew-table-header-caption"><?php echo $production_partner->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $production_partner->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->name) ?>',2);"><div id="elh_production_partner_name" class="production_partner_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->code->Visible) { // code ?>
	<?php if ($production_partner->sortUrl($production_partner->code) == "") { ?>
		<th data-name="code" class="<?php echo $production_partner->code->headerCellClass() ?>"><div id="elh_production_partner_code" class="production_partner_code"><div class="ew-table-header-caption"><?php echo $production_partner->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $production_partner->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->code) ?>',2);"><div id="elh_production_partner_code" class="production_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->country->Visible) { // country ?>
	<?php if ($production_partner->sortUrl($production_partner->country) == "") { ?>
		<th data-name="country" class="<?php echo $production_partner->country->headerCellClass() ?>"><div id="elh_production_partner_country" class="production_partner_country"><div class="ew-table-header-caption"><?php echo $production_partner->country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country" class="<?php echo $production_partner->country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->country) ?>',2);"><div id="elh_production_partner_country" class="production_partner_country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->country->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->region->Visible) { // region ?>
	<?php if ($production_partner->sortUrl($production_partner->region) == "") { ?>
		<th data-name="region" class="<?php echo $production_partner->region->headerCellClass() ?>"><div id="elh_production_partner_region" class="production_partner_region"><div class="ew-table-header-caption"><?php echo $production_partner->region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="region" class="<?php echo $production_partner->region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->region) ?>',2);"><div id="elh_production_partner_region" class="production_partner_region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->region->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->city->Visible) { // city ?>
	<?php if ($production_partner->sortUrl($production_partner->city) == "") { ?>
		<th data-name="city" class="<?php echo $production_partner->city->headerCellClass() ?>"><div id="elh_production_partner_city" class="production_partner_city"><div class="ew-table-header-caption"><?php echo $production_partner->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $production_partner->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->city) ?>',2);"><div id="elh_production_partner_city" class="production_partner_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->city->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->address->Visible) { // address ?>
	<?php if ($production_partner->sortUrl($production_partner->address) == "") { ?>
		<th data-name="address" class="<?php echo $production_partner->address->headerCellClass() ?>"><div id="elh_production_partner_address" class="production_partner_address"><div class="ew-table-header-caption"><?php echo $production_partner->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $production_partner->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->address) ?>',2);"><div id="elh_production_partner_address" class="production_partner_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->mobile->Visible) { // mobile ?>
	<?php if ($production_partner->sortUrl($production_partner->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $production_partner->mobile->headerCellClass() ?>"><div id="elh_production_partner_mobile" class="production_partner_mobile"><div class="ew-table-header-caption"><?php echo $production_partner->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $production_partner->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->mobile) ?>',2);"><div id="elh_production_partner_mobile" class="production_partner_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->_email->Visible) { // email ?>
	<?php if ($production_partner->sortUrl($production_partner->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $production_partner->_email->headerCellClass() ?>"><div id="elh_production_partner__email" class="production_partner__email"><div class="ew-table-header-caption"><?php echo $production_partner->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $production_partner->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->_email) ?>',2);"><div id="elh_production_partner__email" class="production_partner__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->url->Visible) { // url ?>
	<?php if ($production_partner->sortUrl($production_partner->url) == "") { ?>
		<th data-name="url" class="<?php echo $production_partner->url->headerCellClass() ?>"><div id="elh_production_partner_url" class="production_partner_url"><div class="ew-table-header-caption"><?php echo $production_partner->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $production_partner->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->url) ?>',2);"><div id="elh_production_partner_url" class="production_partner_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->grp->Visible) { // grp ?>
	<?php if ($production_partner->sortUrl($production_partner->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $production_partner->grp->headerCellClass() ?>"><div id="elh_production_partner_grp" class="production_partner_grp"><div class="ew-table-header-caption"><?php echo $production_partner->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $production_partner->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->grp) ?>',2);"><div id="elh_production_partner_grp" class="production_partner_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->category->Visible) { // category ?>
	<?php if ($production_partner->sortUrl($production_partner->category) == "") { ?>
		<th data-name="category" class="<?php echo $production_partner->category->headerCellClass() ?>"><div id="elh_production_partner_category" class="production_partner_category"><div class="ew-table-header-caption"><?php echo $production_partner->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $production_partner->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->category) ?>',2);"><div id="elh_production_partner_category" class="production_partner_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
	<?php if ($production_partner->sortUrl($production_partner->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $production_partner->reports_to->headerCellClass() ?>"><div id="elh_production_partner_reports_to" class="production_partner_reports_to"><div class="ew-table-header-caption"><?php echo $production_partner->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $production_partner->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->reports_to) ?>',2);"><div id="elh_production_partner_reports_to" class="production_partner_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->status->Visible) { // status ?>
	<?php if ($production_partner->sortUrl($production_partner->status) == "") { ?>
		<th data-name="status" class="<?php echo $production_partner->status->headerCellClass() ?>"><div id="elh_production_partner_status" class="production_partner_status"><div class="ew-table-header-caption"><?php echo $production_partner->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $production_partner->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->status) ?>',2);"><div id="elh_production_partner_status" class="production_partner_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->performance->Visible) { // performance ?>
	<?php if ($production_partner->sortUrl($production_partner->performance) == "") { ?>
		<th data-name="performance" class="<?php echo $production_partner->performance->headerCellClass() ?>"><div id="elh_production_partner_performance" class="production_partner_performance"><div class="ew-table-header-caption"><?php echo $production_partner->performance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="performance" class="<?php echo $production_partner->performance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->performance) ?>',2);"><div id="elh_production_partner_performance" class="production_partner_performance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->performance->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->performance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->performance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->operator->Visible) { // operator ?>
	<?php if ($production_partner->sortUrl($production_partner->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_partner->operator->headerCellClass() ?>"><div id="elh_production_partner_operator" class="production_partner_operator"><div class="ew-table-header-caption"><?php echo $production_partner->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_partner->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->operator) ?>',2);"><div id="elh_production_partner_operator" class="production_partner_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->datetime->Visible) { // datetime ?>
	<?php if ($production_partner->sortUrl($production_partner->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_partner->datetime->headerCellClass() ?>"><div id="elh_production_partner_datetime" class="production_partner_datetime"><div class="ew-table-header-caption"><?php echo $production_partner->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_partner->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->datetime) ?>',2);"><div id="elh_production_partner_datetime" class="production_partner_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->type->Visible) { // type ?>
	<?php if ($production_partner->sortUrl($production_partner->type) == "") { ?>
		<th data-name="type" class="<?php echo $production_partner->type->headerCellClass() ?>"><div id="elh_production_partner_type" class="production_partner_type"><div class="ew-table-header-caption"><?php echo $production_partner->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $production_partner->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->type) ?>',2);"><div id="elh_production_partner_type" class="production_partner_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
	<?php if ($production_partner->sortUrl($production_partner->tax_registration) == "") { ?>
		<th data-name="tax_registration" class="<?php echo $production_partner->tax_registration->headerCellClass() ?>"><div id="elh_production_partner_tax_registration" class="production_partner_tax_registration"><div class="ew-table-header-caption"><?php echo $production_partner->tax_registration->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tax_registration" class="<?php echo $production_partner->tax_registration->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->tax_registration) ?>',2);"><div id="elh_production_partner_tax_registration" class="production_partner_tax_registration">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->tax_registration->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->tax_registration->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->tax_registration->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->cin->Visible) { // cin ?>
	<?php if ($production_partner->sortUrl($production_partner->cin) == "") { ?>
		<th data-name="cin" class="<?php echo $production_partner->cin->headerCellClass() ?>"><div id="elh_production_partner_cin" class="production_partner_cin"><div class="ew-table-header-caption"><?php echo $production_partner->cin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cin" class="<?php echo $production_partner->cin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->cin) ?>',2);"><div id="elh_production_partner_cin" class="production_partner_cin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->cin->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->cin->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->cin->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->pan->Visible) { // pan ?>
	<?php if ($production_partner->sortUrl($production_partner->pan) == "") { ?>
		<th data-name="pan" class="<?php echo $production_partner->pan->headerCellClass() ?>"><div id="elh_production_partner_pan" class="production_partner_pan"><div class="ew-table-header-caption"><?php echo $production_partner->pan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pan" class="<?php echo $production_partner->pan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->pan) ?>',2);"><div id="elh_production_partner_pan" class="production_partner_pan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->pan->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->pan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->pan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->tan->Visible) { // tan ?>
	<?php if ($production_partner->sortUrl($production_partner->tan) == "") { ?>
		<th data-name="tan" class="<?php echo $production_partner->tan->headerCellClass() ?>"><div id="elh_production_partner_tan" class="production_partner_tan"><div class="ew-table-header-caption"><?php echo $production_partner->tan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tan" class="<?php echo $production_partner->tan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->tan) ?>',2);"><div id="elh_production_partner_tan" class="production_partner_tan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->tan->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->tan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->tan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->msme->Visible) { // msme ?>
	<?php if ($production_partner->sortUrl($production_partner->msme) == "") { ?>
		<th data-name="msme" class="<?php echo $production_partner->msme->headerCellClass() ?>"><div id="elh_production_partner_msme" class="production_partner_msme"><div class="ew-table-header-caption"><?php echo $production_partner->msme->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="msme" class="<?php echo $production_partner->msme->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->msme) ?>',2);"><div id="elh_production_partner_msme" class="production_partner_msme">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->msme->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->msme->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->msme->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->port_air->Visible) { // port_air ?>
	<?php if ($production_partner->sortUrl($production_partner->port_air) == "") { ?>
		<th data-name="port_air" class="<?php echo $production_partner->port_air->headerCellClass() ?>"><div id="elh_production_partner_port_air" class="production_partner_port_air"><div class="ew-table-header-caption"><?php echo $production_partner->port_air->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_air" class="<?php echo $production_partner->port_air->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->port_air) ?>',2);"><div id="elh_production_partner_port_air" class="production_partner_port_air">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->port_air->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->port_air->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->port_air->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->port_sea->Visible) { // port_sea ?>
	<?php if ($production_partner->sortUrl($production_partner->port_sea) == "") { ?>
		<th data-name="port_sea" class="<?php echo $production_partner->port_sea->headerCellClass() ?>"><div id="elh_production_partner_port_sea" class="production_partner_port_sea"><div class="ew-table-header-caption"><?php echo $production_partner->port_sea->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_sea" class="<?php echo $production_partner->port_sea->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->port_sea) ?>',2);"><div id="elh_production_partner_port_sea" class="production_partner_port_sea">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->port_sea->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->port_sea->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->port_sea->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->iec->Visible) { // iec ?>
	<?php if ($production_partner->sortUrl($production_partner->iec) == "") { ?>
		<th data-name="iec" class="<?php echo $production_partner->iec->headerCellClass() ?>"><div id="elh_production_partner_iec" class="production_partner_iec"><div class="ew-table-header-caption"><?php echo $production_partner->iec->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iec" class="<?php echo $production_partner->iec->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->iec) ?>',2);"><div id="elh_production_partner_iec" class="production_partner_iec">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->iec->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->iec->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->iec->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->rex->Visible) { // rex ?>
	<?php if ($production_partner->sortUrl($production_partner->rex) == "") { ?>
		<th data-name="rex" class="<?php echo $production_partner->rex->headerCellClass() ?>"><div id="elh_production_partner_rex" class="production_partner_rex"><div class="ew-table-header-caption"><?php echo $production_partner->rex->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rex" class="<?php echo $production_partner->rex->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->rex) ?>',2);"><div id="elh_production_partner_rex" class="production_partner_rex">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->rex->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->rex->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->rex->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
	<?php if ($production_partner->sortUrl($production_partner->rcmc) == "") { ?>
		<th data-name="rcmc" class="<?php echo $production_partner->rcmc->headerCellClass() ?>"><div id="elh_production_partner_rcmc" class="production_partner_rcmc"><div class="ew-table-header-caption"><?php echo $production_partner->rcmc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rcmc" class="<?php echo $production_partner->rcmc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->rcmc) ?>',2);"><div id="elh_production_partner_rcmc" class="production_partner_rcmc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->rcmc->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->rcmc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->rcmc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
	<?php if ($production_partner->sortUrl($production_partner->delivery_terms) == "") { ?>
		<th data-name="delivery_terms" class="<?php echo $production_partner->delivery_terms->headerCellClass() ?>"><div id="elh_production_partner_delivery_terms" class="production_partner_delivery_terms"><div class="ew-table-header-caption"><?php echo $production_partner->delivery_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_terms" class="<?php echo $production_partner->delivery_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->delivery_terms) ?>',2);"><div id="elh_production_partner_delivery_terms" class="production_partner_delivery_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->delivery_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->delivery_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->delivery_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
	<?php if ($production_partner->sortUrl($production_partner->shipping_terms) == "") { ?>
		<th data-name="shipping_terms" class="<?php echo $production_partner->shipping_terms->headerCellClass() ?>"><div id="elh_production_partner_shipping_terms" class="production_partner_shipping_terms"><div class="ew-table-header-caption"><?php echo $production_partner->shipping_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_terms" class="<?php echo $production_partner->shipping_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->shipping_terms) ?>',2);"><div id="elh_production_partner_shipping_terms" class="production_partner_shipping_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->shipping_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->shipping_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->shipping_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
	<?php if ($production_partner->sortUrl($production_partner->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $production_partner->payment_terms->headerCellClass() ?>"><div id="elh_production_partner_payment_terms" class="production_partner_payment_terms"><div class="ew-table-header-caption"><?php echo $production_partner->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $production_partner->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->payment_terms) ?>',2);"><div id="elh_production_partner_payment_terms" class="production_partner_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->export_type->Visible) { // export_type ?>
	<?php if ($production_partner->sortUrl($production_partner->export_type) == "") { ?>
		<th data-name="export_type" class="<?php echo $production_partner->export_type->headerCellClass() ?>"><div id="elh_production_partner_export_type" class="production_partner_export_type"><div class="ew-table-header-caption"><?php echo $production_partner->export_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="export_type" class="<?php echo $production_partner->export_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->export_type) ?>',2);"><div id="elh_production_partner_export_type" class="production_partner_export_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->export_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->export_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->export_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
	<?php if ($production_partner->sortUrl($production_partner->lead_time_ss) == "") { ?>
		<th data-name="lead_time_ss" class="<?php echo $production_partner->lead_time_ss->headerCellClass() ?>"><div id="elh_production_partner_lead_time_ss" class="production_partner_lead_time_ss"><div class="ew-table-header-caption"><?php echo $production_partner->lead_time_ss->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_time_ss" class="<?php echo $production_partner->lead_time_ss->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->lead_time_ss) ?>',2);"><div id="elh_production_partner_lead_time_ss" class="production_partner_lead_time_ss">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->lead_time_ss->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->lead_time_ss->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->lead_time_ss->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
	<?php if ($production_partner->sortUrl($production_partner->lead_time_cs) == "") { ?>
		<th data-name="lead_time_cs" class="<?php echo $production_partner->lead_time_cs->headerCellClass() ?>"><div id="elh_production_partner_lead_time_cs" class="production_partner_lead_time_cs"><div class="ew-table-header-caption"><?php echo $production_partner->lead_time_cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_time_cs" class="<?php echo $production_partner->lead_time_cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->lead_time_cs) ?>',2);"><div id="elh_production_partner_lead_time_cs" class="production_partner_lead_time_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->lead_time_cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->lead_time_cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->lead_time_cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->cha->Visible) { // cha ?>
	<?php if ($production_partner->sortUrl($production_partner->cha) == "") { ?>
		<th data-name="cha" class="<?php echo $production_partner->cha->headerCellClass() ?>"><div id="elh_production_partner_cha" class="production_partner_cha"><div class="ew-table-header-caption"><?php echo $production_partner->cha->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cha" class="<?php echo $production_partner->cha->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->cha) ?>',2);"><div id="elh_production_partner_cha" class="production_partner_cha">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->cha->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->cha->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->cha->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
	<?php if ($production_partner->sortUrl($production_partner->cha_email) == "") { ?>
		<th data-name="cha_email" class="<?php echo $production_partner->cha_email->headerCellClass() ?>"><div id="elh_production_partner_cha_email" class="production_partner_cha_email"><div class="ew-table-header-caption"><?php echo $production_partner->cha_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cha_email" class="<?php echo $production_partner->cha_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->cha_email) ?>',2);"><div id="elh_production_partner_cha_email" class="production_partner_cha_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->cha_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->cha_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->cha_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->cha_phone) == "") { ?>
		<th data-name="cha_phone" class="<?php echo $production_partner->cha_phone->headerCellClass() ?>"><div id="elh_production_partner_cha_phone" class="production_partner_cha_phone"><div class="ew-table-header-caption"><?php echo $production_partner->cha_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cha_phone" class="<?php echo $production_partner->cha_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->cha_phone) ?>',2);"><div id="elh_production_partner_cha_phone" class="production_partner_cha_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->cha_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->cha_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->cha_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
	<?php if ($production_partner->sortUrl($production_partner->forwarder) == "") { ?>
		<th data-name="forwarder" class="<?php echo $production_partner->forwarder->headerCellClass() ?>"><div id="elh_production_partner_forwarder" class="production_partner_forwarder"><div class="ew-table-header-caption"><?php echo $production_partner->forwarder->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="forwarder" class="<?php echo $production_partner->forwarder->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->forwarder) ?>',2);"><div id="elh_production_partner_forwarder" class="production_partner_forwarder">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->forwarder->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_partner->forwarder->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->forwarder->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
	<?php if ($production_partner->sortUrl($production_partner->forwarder_email) == "") { ?>
		<th data-name="forwarder_email" class="<?php echo $production_partner->forwarder_email->headerCellClass() ?>"><div id="elh_production_partner_forwarder_email" class="production_partner_forwarder_email"><div class="ew-table-header-caption"><?php echo $production_partner->forwarder_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="forwarder_email" class="<?php echo $production_partner->forwarder_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->forwarder_email) ?>',2);"><div id="elh_production_partner_forwarder_email" class="production_partner_forwarder_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->forwarder_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->forwarder_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->forwarder_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->forwarder_phone) == "") { ?>
		<th data-name="forwarder_phone" class="<?php echo $production_partner->forwarder_phone->headerCellClass() ?>"><div id="elh_production_partner_forwarder_phone" class="production_partner_forwarder_phone"><div class="ew-table-header-caption"><?php echo $production_partner->forwarder_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="forwarder_phone" class="<?php echo $production_partner->forwarder_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->forwarder_phone) ?>',2);"><div id="elh_production_partner_forwarder_phone" class="production_partner_forwarder_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->forwarder_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->forwarder_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->forwarder_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->merchant->Visible) { // merchant ?>
	<?php if ($production_partner->sortUrl($production_partner->merchant) == "") { ?>
		<th data-name="merchant" class="<?php echo $production_partner->merchant->headerCellClass() ?>"><div id="elh_production_partner_merchant" class="production_partner_merchant"><div class="ew-table-header-caption"><?php echo $production_partner->merchant->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="merchant" class="<?php echo $production_partner->merchant->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->merchant) ?>',2);"><div id="elh_production_partner_merchant" class="production_partner_merchant">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->merchant->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->merchant->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->merchant->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
	<?php if ($production_partner->sortUrl($production_partner->merchant_email) == "") { ?>
		<th data-name="merchant_email" class="<?php echo $production_partner->merchant_email->headerCellClass() ?>"><div id="elh_production_partner_merchant_email" class="production_partner_merchant_email"><div class="ew-table-header-caption"><?php echo $production_partner->merchant_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="merchant_email" class="<?php echo $production_partner->merchant_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->merchant_email) ?>',2);"><div id="elh_production_partner_merchant_email" class="production_partner_merchant_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->merchant_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->merchant_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->merchant_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->merchant_phone) == "") { ?>
		<th data-name="merchant_phone" class="<?php echo $production_partner->merchant_phone->headerCellClass() ?>"><div id="elh_production_partner_merchant_phone" class="production_partner_merchant_phone"><div class="ew-table-header-caption"><?php echo $production_partner->merchant_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="merchant_phone" class="<?php echo $production_partner->merchant_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->merchant_phone) ?>',2);"><div id="elh_production_partner_merchant_phone" class="production_partner_merchant_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->merchant_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->merchant_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->merchant_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
	<?php if ($production_partner->sortUrl($production_partner->shipping_incharge) == "") { ?>
		<th data-name="shipping_incharge" class="<?php echo $production_partner->shipping_incharge->headerCellClass() ?>"><div id="elh_production_partner_shipping_incharge" class="production_partner_shipping_incharge"><div class="ew-table-header-caption"><?php echo $production_partner->shipping_incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_incharge" class="<?php echo $production_partner->shipping_incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->shipping_incharge) ?>',2);"><div id="elh_production_partner_shipping_incharge" class="production_partner_shipping_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->shipping_incharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->shipping_incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->shipping_incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
	<?php if ($production_partner->sortUrl($production_partner->shipping_email) == "") { ?>
		<th data-name="shipping_email" class="<?php echo $production_partner->shipping_email->headerCellClass() ?>"><div id="elh_production_partner_shipping_email" class="production_partner_shipping_email"><div class="ew-table-header-caption"><?php echo $production_partner->shipping_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_email" class="<?php echo $production_partner->shipping_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->shipping_email) ?>',2);"><div id="elh_production_partner_shipping_email" class="production_partner_shipping_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->shipping_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->shipping_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->shipping_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->shipping_phone) == "") { ?>
		<th data-name="shipping_phone" class="<?php echo $production_partner->shipping_phone->headerCellClass() ?>"><div id="elh_production_partner_shipping_phone" class="production_partner_shipping_phone"><div class="ew-table-header-caption"><?php echo $production_partner->shipping_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_phone" class="<?php echo $production_partner->shipping_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->shipping_phone) ?>',2);"><div id="elh_production_partner_shipping_phone" class="production_partner_shipping_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->shipping_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->shipping_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->shipping_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
	<?php if ($production_partner->sortUrl($production_partner->account_incharge) == "") { ?>
		<th data-name="account_incharge" class="<?php echo $production_partner->account_incharge->headerCellClass() ?>"><div id="elh_production_partner_account_incharge" class="production_partner_account_incharge"><div class="ew-table-header-caption"><?php echo $production_partner->account_incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_incharge" class="<?php echo $production_partner->account_incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->account_incharge) ?>',2);"><div id="elh_production_partner_account_incharge" class="production_partner_account_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->account_incharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->account_incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->account_incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
	<?php if ($production_partner->sortUrl($production_partner->accounts_email) == "") { ?>
		<th data-name="accounts_email" class="<?php echo $production_partner->accounts_email->headerCellClass() ?>"><div id="elh_production_partner_accounts_email" class="production_partner_accounts_email"><div class="ew-table-header-caption"><?php echo $production_partner->accounts_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="accounts_email" class="<?php echo $production_partner->accounts_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->accounts_email) ?>',2);"><div id="elh_production_partner_accounts_email" class="production_partner_accounts_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->accounts_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->accounts_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->accounts_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->accounts_phone) == "") { ?>
		<th data-name="accounts_phone" class="<?php echo $production_partner->accounts_phone->headerCellClass() ?>"><div id="elh_production_partner_accounts_phone" class="production_partner_accounts_phone"><div class="ew-table-header-caption"><?php echo $production_partner->accounts_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="accounts_phone" class="<?php echo $production_partner->accounts_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->accounts_phone) ?>',2);"><div id="elh_production_partner_accounts_phone" class="production_partner_accounts_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->accounts_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->accounts_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->accounts_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
	<?php if ($production_partner->sortUrl($production_partner->warehouse_incharge) == "") { ?>
		<th data-name="warehouse_incharge" class="<?php echo $production_partner->warehouse_incharge->headerCellClass() ?>"><div id="elh_production_partner_warehouse_incharge" class="production_partner_warehouse_incharge"><div class="ew-table-header-caption"><?php echo $production_partner->warehouse_incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="warehouse_incharge" class="<?php echo $production_partner->warehouse_incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->warehouse_incharge) ?>',2);"><div id="elh_production_partner_warehouse_incharge" class="production_partner_warehouse_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->warehouse_incharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->warehouse_incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->warehouse_incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
	<?php if ($production_partner->sortUrl($production_partner->warehouse_email) == "") { ?>
		<th data-name="warehouse_email" class="<?php echo $production_partner->warehouse_email->headerCellClass() ?>"><div id="elh_production_partner_warehouse_email" class="production_partner_warehouse_email"><div class="ew-table-header-caption"><?php echo $production_partner->warehouse_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="warehouse_email" class="<?php echo $production_partner->warehouse_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->warehouse_email) ?>',2);"><div id="elh_production_partner_warehouse_email" class="production_partner_warehouse_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->warehouse_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->warehouse_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->warehouse_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->warehouse_phone) == "") { ?>
		<th data-name="warehouse_phone" class="<?php echo $production_partner->warehouse_phone->headerCellClass() ?>"><div id="elh_production_partner_warehouse_phone" class="production_partner_warehouse_phone"><div class="ew-table-header-caption"><?php echo $production_partner->warehouse_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="warehouse_phone" class="<?php echo $production_partner->warehouse_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->warehouse_phone) ?>',2);"><div id="elh_production_partner_warehouse_phone" class="production_partner_warehouse_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->warehouse_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->warehouse_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->warehouse_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
	<?php if ($production_partner->sortUrl($production_partner->production_incharge) == "") { ?>
		<th data-name="production_incharge" class="<?php echo $production_partner->production_incharge->headerCellClass() ?>"><div id="elh_production_partner_production_incharge" class="production_partner_production_incharge"><div class="ew-table-header-caption"><?php echo $production_partner->production_incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_incharge" class="<?php echo $production_partner->production_incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->production_incharge) ?>',2);"><div id="elh_production_partner_production_incharge" class="production_partner_production_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->production_incharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->production_incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->production_incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->production_email->Visible) { // production_email ?>
	<?php if ($production_partner->sortUrl($production_partner->production_email) == "") { ?>
		<th data-name="production_email" class="<?php echo $production_partner->production_email->headerCellClass() ?>"><div id="elh_production_partner_production_email" class="production_partner_production_email"><div class="ew-table-header-caption"><?php echo $production_partner->production_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_email" class="<?php echo $production_partner->production_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->production_email) ?>',2);"><div id="elh_production_partner_production_email" class="production_partner_production_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->production_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->production_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->production_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->production_phone) == "") { ?>
		<th data-name="production_phone" class="<?php echo $production_partner->production_phone->headerCellClass() ?>"><div id="elh_production_partner_production_phone" class="production_partner_production_phone"><div class="ew-table-header-caption"><?php echo $production_partner->production_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_phone" class="<?php echo $production_partner->production_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->production_phone) ?>',2);"><div id="elh_production_partner_production_phone" class="production_partner_production_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->production_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->production_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->production_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
	<?php if ($production_partner->sortUrl($production_partner->qc_incharge) == "") { ?>
		<th data-name="qc_incharge" class="<?php echo $production_partner->qc_incharge->headerCellClass() ?>"><div id="elh_production_partner_qc_incharge" class="production_partner_qc_incharge"><div class="ew-table-header-caption"><?php echo $production_partner->qc_incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_incharge" class="<?php echo $production_partner->qc_incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->qc_incharge) ?>',2);"><div id="elh_production_partner_qc_incharge" class="production_partner_qc_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->qc_incharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->qc_incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->qc_incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
	<?php if ($production_partner->sortUrl($production_partner->qc_email) == "") { ?>
		<th data-name="qc_email" class="<?php echo $production_partner->qc_email->headerCellClass() ?>"><div id="elh_production_partner_qc_email" class="production_partner_qc_email"><div class="ew-table-header-caption"><?php echo $production_partner->qc_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_email" class="<?php echo $production_partner->qc_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->qc_email) ?>',2);"><div id="elh_production_partner_qc_email" class="production_partner_qc_email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->qc_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->qc_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->qc_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
	<?php if ($production_partner->sortUrl($production_partner->qc_phone) == "") { ?>
		<th data-name="qc_phone" class="<?php echo $production_partner->qc_phone->headerCellClass() ?>"><div id="elh_production_partner_qc_phone" class="production_partner_qc_phone"><div class="ew-table-header-caption"><?php echo $production_partner->qc_phone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_phone" class="<?php echo $production_partner->qc_phone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_partner->SortUrl($production_partner->qc_phone) ?>',2);"><div id="elh_production_partner_qc_phone" class="production_partner_qc_phone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_partner->qc_phone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_partner->qc_phone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_partner->qc_phone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_partner_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_partner->ExportAll && $production_partner->isExport()) {
	$production_partner_list->StopRec = $production_partner_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_partner_list->TotalRecs > $production_partner_list->StartRec + $production_partner_list->DisplayRecs - 1)
		$production_partner_list->StopRec = $production_partner_list->StartRec + $production_partner_list->DisplayRecs - 1;
	else
		$production_partner_list->StopRec = $production_partner_list->TotalRecs;
}
$production_partner_list->RecCnt = $production_partner_list->StartRec - 1;
if ($production_partner_list->Recordset && !$production_partner_list->Recordset->EOF) {
	$production_partner_list->Recordset->moveFirst();
	$selectLimit = $production_partner_list->UseSelectLimit;
	if (!$selectLimit && $production_partner_list->StartRec > 1)
		$production_partner_list->Recordset->move($production_partner_list->StartRec - 1);
} elseif (!$production_partner->AllowAddDeleteRow && $production_partner_list->StopRec == 0) {
	$production_partner_list->StopRec = $production_partner->GridAddRowCount;
}

// Initialize aggregate
$production_partner->RowType = ROWTYPE_AGGREGATEINIT;
$production_partner->resetAttributes();
$production_partner_list->renderRow();
while ($production_partner_list->RecCnt < $production_partner_list->StopRec) {
	$production_partner_list->RecCnt++;
	if ($production_partner_list->RecCnt >= $production_partner_list->StartRec) {
		$production_partner_list->RowCnt++;

		// Set up key count
		$production_partner_list->KeyCount = $production_partner_list->RowIndex;

		// Init row class and style
		$production_partner->resetAttributes();
		$production_partner->CssClass = "";
		if ($production_partner->isGridAdd()) {
		} else {
			$production_partner_list->loadRowValues($production_partner_list->Recordset); // Load row values
		}
		$production_partner->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_partner->RowAttrs = array_merge($production_partner->RowAttrs, array('data-rowindex'=>$production_partner_list->RowCnt, 'id'=>'r' . $production_partner_list->RowCnt . '_production_partner', 'data-rowtype'=>$production_partner->RowType));

		// Render row
		$production_partner_list->renderRow();

		// Render list options
		$production_partner_list->renderListOptions();
?>
	<tr<?php echo $production_partner->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_partner_list->ListOptions->render("body", "left", $production_partner_list->RowCnt);
?>
	<?php if ($production_partner->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_partner->id->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_id" class="production_partner_id">
<span<?php echo $production_partner->id->viewAttributes() ?>>
<?php echo $production_partner->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->name->Visible) { // name ?>
		<td data-name="name"<?php echo $production_partner->name->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_name" class="production_partner_name">
<span<?php echo $production_partner->name->viewAttributes() ?>>
<?php echo $production_partner->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->code->Visible) { // code ?>
		<td data-name="code"<?php echo $production_partner->code->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_code" class="production_partner_code">
<span<?php echo $production_partner->code->viewAttributes() ?>>
<?php echo $production_partner->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->country->Visible) { // country ?>
		<td data-name="country"<?php echo $production_partner->country->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_country" class="production_partner_country">
<span<?php echo $production_partner->country->viewAttributes() ?>>
<?php echo $production_partner->country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->region->Visible) { // region ?>
		<td data-name="region"<?php echo $production_partner->region->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_region" class="production_partner_region">
<span<?php echo $production_partner->region->viewAttributes() ?>>
<?php echo $production_partner->region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->city->Visible) { // city ?>
		<td data-name="city"<?php echo $production_partner->city->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_city" class="production_partner_city">
<span<?php echo $production_partner->city->viewAttributes() ?>>
<?php echo $production_partner->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->address->Visible) { // address ?>
		<td data-name="address"<?php echo $production_partner->address->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_address" class="production_partner_address">
<span<?php echo $production_partner->address->viewAttributes() ?>>
<?php echo $production_partner->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $production_partner->mobile->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_mobile" class="production_partner_mobile">
<span<?php echo $production_partner->mobile->viewAttributes() ?>>
<?php echo $production_partner->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $production_partner->_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner__email" class="production_partner__email">
<span<?php echo $production_partner->_email->viewAttributes() ?>>
<?php echo $production_partner->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->url->Visible) { // url ?>
		<td data-name="url"<?php echo $production_partner->url->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_url" class="production_partner_url">
<span<?php echo $production_partner->url->viewAttributes() ?>>
<?php echo $production_partner->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $production_partner->grp->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_grp" class="production_partner_grp">
<span<?php echo $production_partner->grp->viewAttributes() ?>>
<?php echo $production_partner->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->category->Visible) { // category ?>
		<td data-name="category"<?php echo $production_partner->category->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_category" class="production_partner_category">
<span<?php echo $production_partner->category->viewAttributes() ?>>
<?php echo $production_partner->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $production_partner->reports_to->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_reports_to" class="production_partner_reports_to">
<span<?php echo $production_partner->reports_to->viewAttributes() ?>>
<?php echo $production_partner->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->status->Visible) { // status ?>
		<td data-name="status"<?php echo $production_partner->status->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_status" class="production_partner_status">
<span<?php echo $production_partner->status->viewAttributes() ?>>
<?php echo $production_partner->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->performance->Visible) { // performance ?>
		<td data-name="performance"<?php echo $production_partner->performance->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_performance" class="production_partner_performance">
<span<?php echo $production_partner->performance->viewAttributes() ?>>
<?php echo $production_partner->performance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_partner->operator->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_operator" class="production_partner_operator">
<span<?php echo $production_partner->operator->viewAttributes() ?>>
<?php echo $production_partner->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_partner->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_datetime" class="production_partner_datetime">
<span<?php echo $production_partner->datetime->viewAttributes() ?>>
<?php echo $production_partner->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->type->Visible) { // type ?>
		<td data-name="type"<?php echo $production_partner->type->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_type" class="production_partner_type">
<span<?php echo $production_partner->type->viewAttributes() ?>>
<?php echo $production_partner->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
		<td data-name="tax_registration"<?php echo $production_partner->tax_registration->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_tax_registration" class="production_partner_tax_registration">
<span<?php echo $production_partner->tax_registration->viewAttributes() ?>>
<?php echo $production_partner->tax_registration->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->cin->Visible) { // cin ?>
		<td data-name="cin"<?php echo $production_partner->cin->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_cin" class="production_partner_cin">
<span<?php echo $production_partner->cin->viewAttributes() ?>>
<?php echo $production_partner->cin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->pan->Visible) { // pan ?>
		<td data-name="pan"<?php echo $production_partner->pan->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_pan" class="production_partner_pan">
<span<?php echo $production_partner->pan->viewAttributes() ?>>
<?php echo $production_partner->pan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->tan->Visible) { // tan ?>
		<td data-name="tan"<?php echo $production_partner->tan->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_tan" class="production_partner_tan">
<span<?php echo $production_partner->tan->viewAttributes() ?>>
<?php echo $production_partner->tan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->msme->Visible) { // msme ?>
		<td data-name="msme"<?php echo $production_partner->msme->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_msme" class="production_partner_msme">
<span<?php echo $production_partner->msme->viewAttributes() ?>>
<?php echo $production_partner->msme->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->port_air->Visible) { // port_air ?>
		<td data-name="port_air"<?php echo $production_partner->port_air->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_port_air" class="production_partner_port_air">
<span<?php echo $production_partner->port_air->viewAttributes() ?>>
<?php echo $production_partner->port_air->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->port_sea->Visible) { // port_sea ?>
		<td data-name="port_sea"<?php echo $production_partner->port_sea->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_port_sea" class="production_partner_port_sea">
<span<?php echo $production_partner->port_sea->viewAttributes() ?>>
<?php echo $production_partner->port_sea->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->iec->Visible) { // iec ?>
		<td data-name="iec"<?php echo $production_partner->iec->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_iec" class="production_partner_iec">
<span<?php echo $production_partner->iec->viewAttributes() ?>>
<?php echo $production_partner->iec->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->rex->Visible) { // rex ?>
		<td data-name="rex"<?php echo $production_partner->rex->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_rex" class="production_partner_rex">
<span<?php echo $production_partner->rex->viewAttributes() ?>>
<?php echo $production_partner->rex->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
		<td data-name="rcmc"<?php echo $production_partner->rcmc->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_rcmc" class="production_partner_rcmc">
<span<?php echo $production_partner->rcmc->viewAttributes() ?>>
<?php echo $production_partner->rcmc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
		<td data-name="delivery_terms"<?php echo $production_partner->delivery_terms->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_delivery_terms" class="production_partner_delivery_terms">
<span<?php echo $production_partner->delivery_terms->viewAttributes() ?>>
<?php echo $production_partner->delivery_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
		<td data-name="shipping_terms"<?php echo $production_partner->shipping_terms->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_shipping_terms" class="production_partner_shipping_terms">
<span<?php echo $production_partner->shipping_terms->viewAttributes() ?>>
<?php echo $production_partner->shipping_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $production_partner->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_payment_terms" class="production_partner_payment_terms">
<span<?php echo $production_partner->payment_terms->viewAttributes() ?>>
<?php echo $production_partner->payment_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->export_type->Visible) { // export_type ?>
		<td data-name="export_type"<?php echo $production_partner->export_type->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_export_type" class="production_partner_export_type">
<span<?php echo $production_partner->export_type->viewAttributes() ?>>
<?php echo $production_partner->export_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
		<td data-name="lead_time_ss"<?php echo $production_partner->lead_time_ss->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_lead_time_ss" class="production_partner_lead_time_ss">
<span<?php echo $production_partner->lead_time_ss->viewAttributes() ?>>
<?php echo $production_partner->lead_time_ss->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
		<td data-name="lead_time_cs"<?php echo $production_partner->lead_time_cs->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_lead_time_cs" class="production_partner_lead_time_cs">
<span<?php echo $production_partner->lead_time_cs->viewAttributes() ?>>
<?php echo $production_partner->lead_time_cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->cha->Visible) { // cha ?>
		<td data-name="cha"<?php echo $production_partner->cha->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_cha" class="production_partner_cha">
<span<?php echo $production_partner->cha->viewAttributes() ?>>
<?php echo $production_partner->cha->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
		<td data-name="cha_email"<?php echo $production_partner->cha_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_cha_email" class="production_partner_cha_email">
<span<?php echo $production_partner->cha_email->viewAttributes() ?>>
<?php echo $production_partner->cha_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
		<td data-name="cha_phone"<?php echo $production_partner->cha_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_cha_phone" class="production_partner_cha_phone">
<span<?php echo $production_partner->cha_phone->viewAttributes() ?>>
<?php echo $production_partner->cha_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
		<td data-name="forwarder"<?php echo $production_partner->forwarder->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_forwarder" class="production_partner_forwarder">
<span<?php echo $production_partner->forwarder->viewAttributes() ?>>
<?php echo $production_partner->forwarder->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
		<td data-name="forwarder_email"<?php echo $production_partner->forwarder_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_forwarder_email" class="production_partner_forwarder_email">
<span<?php echo $production_partner->forwarder_email->viewAttributes() ?>>
<?php echo $production_partner->forwarder_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
		<td data-name="forwarder_phone"<?php echo $production_partner->forwarder_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_forwarder_phone" class="production_partner_forwarder_phone">
<span<?php echo $production_partner->forwarder_phone->viewAttributes() ?>>
<?php echo $production_partner->forwarder_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->merchant->Visible) { // merchant ?>
		<td data-name="merchant"<?php echo $production_partner->merchant->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_merchant" class="production_partner_merchant">
<span<?php echo $production_partner->merchant->viewAttributes() ?>>
<?php echo $production_partner->merchant->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
		<td data-name="merchant_email"<?php echo $production_partner->merchant_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_merchant_email" class="production_partner_merchant_email">
<span<?php echo $production_partner->merchant_email->viewAttributes() ?>>
<?php echo $production_partner->merchant_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
		<td data-name="merchant_phone"<?php echo $production_partner->merchant_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_merchant_phone" class="production_partner_merchant_phone">
<span<?php echo $production_partner->merchant_phone->viewAttributes() ?>>
<?php echo $production_partner->merchant_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
		<td data-name="shipping_incharge"<?php echo $production_partner->shipping_incharge->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_shipping_incharge" class="production_partner_shipping_incharge">
<span<?php echo $production_partner->shipping_incharge->viewAttributes() ?>>
<?php echo $production_partner->shipping_incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
		<td data-name="shipping_email"<?php echo $production_partner->shipping_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_shipping_email" class="production_partner_shipping_email">
<span<?php echo $production_partner->shipping_email->viewAttributes() ?>>
<?php echo $production_partner->shipping_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
		<td data-name="shipping_phone"<?php echo $production_partner->shipping_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_shipping_phone" class="production_partner_shipping_phone">
<span<?php echo $production_partner->shipping_phone->viewAttributes() ?>>
<?php echo $production_partner->shipping_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
		<td data-name="account_incharge"<?php echo $production_partner->account_incharge->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_account_incharge" class="production_partner_account_incharge">
<span<?php echo $production_partner->account_incharge->viewAttributes() ?>>
<?php echo $production_partner->account_incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
		<td data-name="accounts_email"<?php echo $production_partner->accounts_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_accounts_email" class="production_partner_accounts_email">
<span<?php echo $production_partner->accounts_email->viewAttributes() ?>>
<?php echo $production_partner->accounts_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
		<td data-name="accounts_phone"<?php echo $production_partner->accounts_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_accounts_phone" class="production_partner_accounts_phone">
<span<?php echo $production_partner->accounts_phone->viewAttributes() ?>>
<?php echo $production_partner->accounts_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
		<td data-name="warehouse_incharge"<?php echo $production_partner->warehouse_incharge->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_warehouse_incharge" class="production_partner_warehouse_incharge">
<span<?php echo $production_partner->warehouse_incharge->viewAttributes() ?>>
<?php echo $production_partner->warehouse_incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
		<td data-name="warehouse_email"<?php echo $production_partner->warehouse_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_warehouse_email" class="production_partner_warehouse_email">
<span<?php echo $production_partner->warehouse_email->viewAttributes() ?>>
<?php echo $production_partner->warehouse_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
		<td data-name="warehouse_phone"<?php echo $production_partner->warehouse_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_warehouse_phone" class="production_partner_warehouse_phone">
<span<?php echo $production_partner->warehouse_phone->viewAttributes() ?>>
<?php echo $production_partner->warehouse_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
		<td data-name="production_incharge"<?php echo $production_partner->production_incharge->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_production_incharge" class="production_partner_production_incharge">
<span<?php echo $production_partner->production_incharge->viewAttributes() ?>>
<?php echo $production_partner->production_incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->production_email->Visible) { // production_email ?>
		<td data-name="production_email"<?php echo $production_partner->production_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_production_email" class="production_partner_production_email">
<span<?php echo $production_partner->production_email->viewAttributes() ?>>
<?php echo $production_partner->production_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
		<td data-name="production_phone"<?php echo $production_partner->production_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_production_phone" class="production_partner_production_phone">
<span<?php echo $production_partner->production_phone->viewAttributes() ?>>
<?php echo $production_partner->production_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
		<td data-name="qc_incharge"<?php echo $production_partner->qc_incharge->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_qc_incharge" class="production_partner_qc_incharge">
<span<?php echo $production_partner->qc_incharge->viewAttributes() ?>>
<?php echo $production_partner->qc_incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
		<td data-name="qc_email"<?php echo $production_partner->qc_email->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_qc_email" class="production_partner_qc_email">
<span<?php echo $production_partner->qc_email->viewAttributes() ?>>
<?php echo $production_partner->qc_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
		<td data-name="qc_phone"<?php echo $production_partner->qc_phone->cellAttributes() ?>>
<span id="el<?php echo $production_partner_list->RowCnt ?>_production_partner_qc_phone" class="production_partner_qc_phone">
<span<?php echo $production_partner->qc_phone->viewAttributes() ?>>
<?php echo $production_partner->qc_phone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_partner_list->ListOptions->render("body", "right", $production_partner_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_partner->isGridAdd())
		$production_partner_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_partner->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_partner_list->Recordset)
	$production_partner_list->Recordset->Close();
?>
<?php if (!$production_partner->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_partner->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_partner_list->Pager)) $production_partner_list->Pager = new PrevNextPager($production_partner_list->StartRec, $production_partner_list->DisplayRecs, $production_partner_list->TotalRecs, $production_partner_list->AutoHidePager) ?>
<?php if ($production_partner_list->Pager->RecordCount > 0 && $production_partner_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_partner_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_partner_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_partner_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_partner_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_partner_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_partner_list->pageUrl() ?>start=<?php echo $production_partner_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_partner_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_partner_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_partner_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_partner_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_partner_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_partner_list->TotalRecs > 0 && (!$production_partner_list->AutoHidePageSizeSelector || $production_partner_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_partner">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_partner_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_partner_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_partner_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_partner_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_partner_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_partner->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_partner_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_partner_list->TotalRecs == 0 && !$production_partner->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_partner_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_partner_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_partner->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_partner->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_partner", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_partner_list->terminate();
?>