<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_partner_search = new production_partner_search();

// Run the page
$production_partner_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_partner_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($production_partner_search->IsModal) { ?>
var fproduction_partnersearch = currentAdvancedSearchForm = new ew.Form("fproduction_partnersearch", "search");
<?php } else { ?>
var fproduction_partnersearch = currentForm = new ew.Form("fproduction_partnersearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduction_partnersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_partnersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fproduction_partnersearch.multiPage = new ew.MultiPage("fproduction_partnersearch");

// Dynamic selection lists
fproduction_partnersearch.lists["x_country"] = <?php echo $production_partner_search->country->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_country"].options = <?php echo JsonEncode($production_partner_search->country->lookupOptions()) ?>;
fproduction_partnersearch.lists["x_region"] = <?php echo $production_partner_search->region->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_region"].options = <?php echo JsonEncode($production_partner_search->region->lookupOptions()) ?>;
fproduction_partnersearch.lists["x_city"] = <?php echo $production_partner_search->city->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_city"].options = <?php echo JsonEncode($production_partner_search->city->lookupOptions()) ?>;
fproduction_partnersearch.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduction_partnersearch.lists["x_grp[]"] = <?php echo $production_partner_search->grp->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_grp[]"].options = <?php echo JsonEncode($production_partner_search->grp->lookupOptions()) ?>;
fproduction_partnersearch.lists["x_category"] = <?php echo $production_partner_search->category->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_category"].options = <?php echo JsonEncode($production_partner_search->category->lookupOptions()) ?>;
fproduction_partnersearch.lists["x_reports_to"] = <?php echo $production_partner_search->reports_to->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_reports_to"].options = <?php echo JsonEncode($production_partner_search->reports_to->lookupOptions()) ?>;
fproduction_partnersearch.lists["x_status"] = <?php echo $production_partner_search->status->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_status"].options = <?php echo JsonEncode($production_partner_search->status->options(FALSE, TRUE)) ?>;
fproduction_partnersearch.lists["x_operator"] = <?php echo $production_partner_search->operator->Lookup->toClientList() ?>;
fproduction_partnersearch.lists["x_operator"].options = <?php echo JsonEncode($production_partner_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduction_partnersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_partner->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,8}$/))
		return this.onError(elm, "<?php echo JsEncode($production_partner->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_performance");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_partner->performance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lead_time_ss");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_ss->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lead_time_cs");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_partner->lead_time_cs->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_partner_search->showPageHeader(); ?>
<?php
$production_partner_search->showMessage();
?>
<form name="fproduction_partnersearch" id="fproduction_partnersearch" class="<?php echo $production_partner_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_partner_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_partner_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$production_partner_search->IsModal ?>">
<?php if ($production_partner_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($production_partner->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_id"><?php echo $production_partner->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->id->cellAttributes() ?>>
			<span id="el_production_partner_id">
<input type="text" data-table="production_partner" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($production_partner->id->getPlaceHolder()) ?>" value="<?php echo $production_partner->id->EditValue ?>"<?php echo $production_partner->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_name"><?php echo $production_partner->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->name->cellAttributes() ?>>
			<span id="el_production_partner_name">
<input type="text" data-table="production_partner" data-field="x_name" data-page="0" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($production_partner->name->getPlaceHolder()) ?>" value="<?php echo $production_partner->name->EditValue ?>"<?php echo $production_partner->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_code"><?php echo $production_partner->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->code->cellAttributes() ?>>
			<span id="el_production_partner_code">
<input type="text" data-table="production_partner" data-field="x_code" data-page="0" name="x_code" id="x_code" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($production_partner->code->getPlaceHolder()) ?>" value="<?php echo $production_partner->code->EditValue ?>"<?php echo $production_partner->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="production_partner_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("1")) ?>" href="#tab_production_partner1"><?php echo $production_partner->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label for="x_country" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_country"><?php echo $production_partner->country->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country" id="z_country" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->country->cellAttributes() ?>>
			<span id="el_production_partner_country">
<?php $production_partner->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_country" data-page="1" data-value-separator="<?php echo $production_partner->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $production_partner->country->editAttributes() ?>>
		<?php echo $production_partner->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $production_partner->country->Lookup->getParamTag("p_x_country") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->region->Visible) { // region ?>
	<div id="r_region" class="form-group row">
		<label for="x_region" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_region"><?php echo $production_partner->region->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_region" id="z_region" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->region->cellAttributes() ?>>
			<span id="el_production_partner_region">
<?php $production_partner->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_partner->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_region" data-page="1" data-value-separator="<?php echo $production_partner->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $production_partner->region->editAttributes() ?>>
		<?php echo $production_partner->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $production_partner->region->Lookup->getParamTag("p_x_region") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_city"><?php echo $production_partner->city->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_city" id="z_city" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->city->cellAttributes() ?>>
			<span id="el_production_partner_city">
<?php
$wrkonchange = "" . trim(@$production_partner->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$production_partner->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($production_partner->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($production_partner->city->getPlaceHolder()) ?>"<?php echo $production_partner->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_partner->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($production_partner->city->ReadOnly || $production_partner->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="production_partner" data-field="x_city" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_partner->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($production_partner->city->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduction_partnersearch.createAutoSuggest({"id":"x_city","forceSelect":false});
</script>
<?php echo $production_partner->city->Lookup->getParamTag("p_x_city") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_address"><?php echo $production_partner->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->address->cellAttributes() ?>>
			<span id="el_production_partner_address">
<input type="text" data-table="production_partner" data-field="x_address" data-page="1" name="x_address" id="x_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_partner->address->getPlaceHolder()) ?>" value="<?php echo $production_partner->address->EditValue ?>"<?php echo $production_partner->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_mobile"><?php echo $production_partner->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->mobile->cellAttributes() ?>>
			<span id="el_production_partner_mobile">
<input type="text" data-table="production_partner" data-field="x_mobile" data-page="1" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_partner->mobile->getPlaceHolder()) ?>" value="<?php echo $production_partner->mobile->EditValue ?>"<?php echo $production_partner->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner__email"><?php echo $production_partner->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->_email->cellAttributes() ?>>
			<span id="el_production_partner__email">
<input type="text" data-table="production_partner" data-field="x__email" data-page="1" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($production_partner->_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->_email->EditValue ?>"<?php echo $production_partner->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_url"><?php echo $production_partner->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->url->cellAttributes() ?>>
			<span id="el_production_partner_url">
<input type="text" data-table="production_partner" data-field="x_url" data-page="1" name="x_url" id="x_url" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->url->getPlaceHolder()) ?>" value="<?php echo $production_partner->url->EditValue ?>"<?php echo $production_partner->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("2")) ?>" href="#tab_production_partner2"><?php echo $production_partner->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_grp"><?php echo $production_partner->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->grp->cellAttributes() ?>>
			<span id="el_production_partner_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_partner" data-field="x_grp" data-page="2" data-value-separator="<?php echo $production_partner->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $production_partner->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $production_partner->grp->checkBoxListHtml(FALSE, "x_grp[]", 2) ?>
</div></div>
<?php echo $production_partner->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_category"><?php echo $production_partner->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->category->cellAttributes() ?>>
			<span id="el_production_partner_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_category" data-page="2" data-value-separator="<?php echo $production_partner->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $production_partner->category->editAttributes() ?>>
		<?php echo $production_partner->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $production_partner->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_reports_to"><?php echo $production_partner->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->reports_to->cellAttributes() ?>>
			<span id="el_production_partner_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_reports_to" data-page="2" data-value-separator="<?php echo $production_partner->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $production_partner->reports_to->editAttributes() ?>>
		<?php echo $production_partner->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $production_partner->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_status"><?php echo $production_partner->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->status->cellAttributes() ?>>
			<span id="el_production_partner_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_status" data-page="2" data-value-separator="<?php echo $production_partner->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $production_partner->status->editAttributes() ?>>
		<?php echo $production_partner->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->performance->Visible) { // performance ?>
	<div id="r_performance" class="form-group row">
		<label for="x_performance" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_performance"><?php echo $production_partner->performance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_performance" id="z_performance" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->performance->cellAttributes() ?>>
			<span id="el_production_partner_performance">
<input type="text" data-table="production_partner" data-field="x_performance" data-page="2" name="x_performance" id="x_performance" size="30" placeholder="<?php echo HtmlEncode($production_partner->performance->getPlaceHolder()) ?>" value="<?php echo $production_partner->performance->EditValue ?>"<?php echo $production_partner->performance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_operator"><?php echo $production_partner->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->operator->cellAttributes() ?>>
			<span id="el_production_partner_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_partner" data-field="x_operator" data-page="2" data-value-separator="<?php echo $production_partner->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $production_partner->operator->editAttributes() ?>>
		<?php echo $production_partner->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $production_partner->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_datetime"><?php echo $production_partner->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->datetime->cellAttributes() ?>>
			<span id="el_production_partner_datetime">
<input type="text" data-table="production_partner" data-field="x_datetime" data-page="2" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($production_partner->datetime->getPlaceHolder()) ?>" value="<?php echo $production_partner->datetime->EditValue ?>"<?php echo $production_partner->datetime->editAttributes() ?>>
<?php if (!$production_partner->datetime->ReadOnly && !$production_partner->datetime->Disabled && !isset($production_partner->datetime->EditAttrs["readonly"]) && !isset($production_partner->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_partnersearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("3")) ?>" href="#tab_production_partner3"><?php echo $production_partner->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
	<div id="r_tax_registration" class="form-group row">
		<label for="x_tax_registration" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_tax_registration"><?php echo $production_partner->tax_registration->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tax_registration" id="z_tax_registration" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->tax_registration->cellAttributes() ?>>
			<span id="el_production_partner_tax_registration">
<input type="text" data-table="production_partner" data-field="x_tax_registration" data-page="3" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_partner->tax_registration->getPlaceHolder()) ?>" value="<?php echo $production_partner->tax_registration->EditValue ?>"<?php echo $production_partner->tax_registration->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cin->Visible) { // cin ?>
	<div id="r_cin" class="form-group row">
		<label for="x_cin" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_cin"><?php echo $production_partner->cin->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cin" id="z_cin" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->cin->cellAttributes() ?>>
			<span id="el_production_partner_cin">
<input type="text" data-table="production_partner" data-field="x_cin" data-page="3" name="x_cin" id="x_cin" size="30" placeholder="<?php echo HtmlEncode($production_partner->cin->getPlaceHolder()) ?>" value="<?php echo $production_partner->cin->EditValue ?>"<?php echo $production_partner->cin->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->pan->Visible) { // pan ?>
	<div id="r_pan" class="form-group row">
		<label for="x_pan" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_pan"><?php echo $production_partner->pan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pan" id="z_pan" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->pan->cellAttributes() ?>>
			<span id="el_production_partner_pan">
<input type="text" data-table="production_partner" data-field="x_pan" data-page="3" name="x_pan" id="x_pan" size="30" placeholder="<?php echo HtmlEncode($production_partner->pan->getPlaceHolder()) ?>" value="<?php echo $production_partner->pan->EditValue ?>"<?php echo $production_partner->pan->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->tan->Visible) { // tan ?>
	<div id="r_tan" class="form-group row">
		<label for="x_tan" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_tan"><?php echo $production_partner->tan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tan" id="z_tan" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->tan->cellAttributes() ?>>
			<span id="el_production_partner_tan">
<input type="text" data-table="production_partner" data-field="x_tan" data-page="3" name="x_tan" id="x_tan" size="30" placeholder="<?php echo HtmlEncode($production_partner->tan->getPlaceHolder()) ?>" value="<?php echo $production_partner->tan->EditValue ?>"<?php echo $production_partner->tan->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->msme->Visible) { // msme ?>
	<div id="r_msme" class="form-group row">
		<label for="x_msme" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_msme"><?php echo $production_partner->msme->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_msme" id="z_msme" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->msme->cellAttributes() ?>>
			<span id="el_production_partner_msme">
<input type="text" data-table="production_partner" data-field="x_msme" data-page="3" name="x_msme" id="x_msme" size="30" placeholder="<?php echo HtmlEncode($production_partner->msme->getPlaceHolder()) ?>" value="<?php echo $production_partner->msme->EditValue ?>"<?php echo $production_partner->msme->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("4")) ?>" href="#tab_production_partner4"><?php echo $production_partner->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->iec->Visible) { // iec ?>
	<div id="r_iec" class="form-group row">
		<label for="x_iec" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_iec"><?php echo $production_partner->iec->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_iec" id="z_iec" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->iec->cellAttributes() ?>>
			<span id="el_production_partner_iec">
<input type="text" data-table="production_partner" data-field="x_iec" data-page="4" name="x_iec" id="x_iec" size="30" placeholder="<?php echo HtmlEncode($production_partner->iec->getPlaceHolder()) ?>" value="<?php echo $production_partner->iec->EditValue ?>"<?php echo $production_partner->iec->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->rex->Visible) { // rex ?>
	<div id="r_rex" class="form-group row">
		<label for="x_rex" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_rex"><?php echo $production_partner->rex->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rex" id="z_rex" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->rex->cellAttributes() ?>>
			<span id="el_production_partner_rex">
<input type="text" data-table="production_partner" data-field="x_rex" data-page="4" name="x_rex" id="x_rex" size="30" placeholder="<?php echo HtmlEncode($production_partner->rex->getPlaceHolder()) ?>" value="<?php echo $production_partner->rex->EditValue ?>"<?php echo $production_partner->rex->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
	<div id="r_rcmc" class="form-group row">
		<label for="x_rcmc" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_rcmc"><?php echo $production_partner->rcmc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rcmc" id="z_rcmc" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->rcmc->cellAttributes() ?>>
			<span id="el_production_partner_rcmc">
<input type="text" data-table="production_partner" data-field="x_rcmc" data-page="4" name="x_rcmc" id="x_rcmc" size="30" placeholder="<?php echo HtmlEncode($production_partner->rcmc->getPlaceHolder()) ?>" value="<?php echo $production_partner->rcmc->EditValue ?>"<?php echo $production_partner->rcmc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
	<div id="r_delivery_terms" class="form-group row">
		<label for="x_delivery_terms" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_delivery_terms"><?php echo $production_partner->delivery_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_terms" id="z_delivery_terms" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->delivery_terms->cellAttributes() ?>>
			<span id="el_production_partner_delivery_terms">
<input type="text" data-table="production_partner" data-field="x_delivery_terms" data-page="4" name="x_delivery_terms" id="x_delivery_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->delivery_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->delivery_terms->EditValue ?>"<?php echo $production_partner->delivery_terms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
	<div id="r_shipping_terms" class="form-group row">
		<label for="x_shipping_terms" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_shipping_terms"><?php echo $production_partner->shipping_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shipping_terms" id="z_shipping_terms" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->shipping_terms->cellAttributes() ?>>
			<span id="el_production_partner_shipping_terms">
<input type="text" data-table="production_partner" data-field="x_shipping_terms" data-page="4" name="x_shipping_terms" id="x_shipping_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->shipping_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_terms->EditValue ?>"<?php echo $production_partner->shipping_terms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_payment_terms"><?php echo $production_partner->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->payment_terms->cellAttributes() ?>>
			<span id="el_production_partner_payment_terms">
<input type="text" data-table="production_partner" data-field="x_payment_terms" data-page="4" name="x_payment_terms" id="x_payment_terms" size="30" placeholder="<?php echo HtmlEncode($production_partner->payment_terms->getPlaceHolder()) ?>" value="<?php echo $production_partner->payment_terms->EditValue ?>"<?php echo $production_partner->payment_terms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->export_type->Visible) { // export_type ?>
	<div id="r_export_type" class="form-group row">
		<label for="x_export_type" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_export_type"><?php echo $production_partner->export_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_export_type" id="z_export_type" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->export_type->cellAttributes() ?>>
			<span id="el_production_partner_export_type">
<input type="text" data-table="production_partner" data-field="x_export_type" data-page="4" name="x_export_type" id="x_export_type" size="30" placeholder="<?php echo HtmlEncode($production_partner->export_type->getPlaceHolder()) ?>" value="<?php echo $production_partner->export_type->EditValue ?>"<?php echo $production_partner->export_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
	<div id="r_lead_time_ss" class="form-group row">
		<label for="x_lead_time_ss" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_lead_time_ss"><?php echo $production_partner->lead_time_ss->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lead_time_ss" id="z_lead_time_ss" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->lead_time_ss->cellAttributes() ?>>
			<span id="el_production_partner_lead_time_ss">
<input type="text" data-table="production_partner" data-field="x_lead_time_ss" data-page="4" name="x_lead_time_ss" id="x_lead_time_ss" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_ss->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_ss->EditValue ?>"<?php echo $production_partner->lead_time_ss->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
	<div id="r_lead_time_cs" class="form-group row">
		<label for="x_lead_time_cs" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_lead_time_cs"><?php echo $production_partner->lead_time_cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lead_time_cs" id="z_lead_time_cs" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->lead_time_cs->cellAttributes() ?>>
			<span id="el_production_partner_lead_time_cs">
<input type="text" data-table="production_partner" data-field="x_lead_time_cs" data-page="4" name="x_lead_time_cs" id="x_lead_time_cs" size="30" placeholder="<?php echo HtmlEncode($production_partner->lead_time_cs->getPlaceHolder()) ?>" value="<?php echo $production_partner->lead_time_cs->EditValue ?>"<?php echo $production_partner->lead_time_cs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("5")) ?>" href="#tab_production_partner5"><?php echo $production_partner->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->cha->Visible) { // cha ?>
	<div id="r_cha" class="form-group row">
		<label for="x_cha" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_cha"><?php echo $production_partner->cha->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cha" id="z_cha" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->cha->cellAttributes() ?>>
			<span id="el_production_partner_cha">
<input type="text" data-table="production_partner" data-field="x_cha" data-page="5" name="x_cha" id="x_cha" placeholder="<?php echo HtmlEncode($production_partner->cha->getPlaceHolder()) ?>" value="<?php echo $production_partner->cha->EditValue ?>"<?php echo $production_partner->cha->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
	<div id="r_cha_email" class="form-group row">
		<label for="x_cha_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_cha_email"><?php echo $production_partner->cha_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cha_email" id="z_cha_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->cha_email->cellAttributes() ?>>
			<span id="el_production_partner_cha_email">
<input type="text" data-table="production_partner" data-field="x_cha_email" data-page="5" name="x_cha_email" id="x_cha_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->cha_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->cha_email->EditValue ?>"<?php echo $production_partner->cha_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
	<div id="r_cha_phone" class="form-group row">
		<label for="x_cha_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_cha_phone"><?php echo $production_partner->cha_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cha_phone" id="z_cha_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->cha_phone->cellAttributes() ?>>
			<span id="el_production_partner_cha_phone">
<input type="text" data-table="production_partner" data-field="x_cha_phone" data-page="5" name="x_cha_phone" id="x_cha_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->cha_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->cha_phone->EditValue ?>"<?php echo $production_partner->cha_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("6")) ?>" href="#tab_production_partner6"><?php echo $production_partner->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
	<div id="r_forwarder" class="form-group row">
		<label for="x_forwarder" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_forwarder"><?php echo $production_partner->forwarder->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_forwarder" id="z_forwarder" value="="></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->forwarder->cellAttributes() ?>>
			<span id="el_production_partner_forwarder">
<input type="text" data-table="production_partner" data-field="x_forwarder" data-page="6" name="x_forwarder" id="x_forwarder" placeholder="<?php echo HtmlEncode($production_partner->forwarder->getPlaceHolder()) ?>" value="<?php echo $production_partner->forwarder->EditValue ?>"<?php echo $production_partner->forwarder->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
	<div id="r_forwarder_email" class="form-group row">
		<label for="x_forwarder_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_forwarder_email"><?php echo $production_partner->forwarder_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_forwarder_email" id="z_forwarder_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->forwarder_email->cellAttributes() ?>>
			<span id="el_production_partner_forwarder_email">
<input type="text" data-table="production_partner" data-field="x_forwarder_email" data-page="6" name="x_forwarder_email" id="x_forwarder_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->forwarder_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->forwarder_email->EditValue ?>"<?php echo $production_partner->forwarder_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
	<div id="r_forwarder_phone" class="form-group row">
		<label for="x_forwarder_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_forwarder_phone"><?php echo $production_partner->forwarder_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_forwarder_phone" id="z_forwarder_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->forwarder_phone->cellAttributes() ?>>
			<span id="el_production_partner_forwarder_phone">
<input type="text" data-table="production_partner" data-field="x_forwarder_phone" data-page="6" name="x_forwarder_phone" id="x_forwarder_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->forwarder_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->forwarder_phone->EditValue ?>"<?php echo $production_partner->forwarder_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("7") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("7")) ?>" href="#tab_production_partner7"><?php echo $production_partner->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->merchant->Visible) { // merchant ?>
	<div id="r_merchant" class="form-group row">
		<label for="x_merchant" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_merchant"><?php echo $production_partner->merchant->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_merchant" id="z_merchant" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->merchant->cellAttributes() ?>>
			<span id="el_production_partner_merchant">
<input type="text" data-table="production_partner" data-field="x_merchant" data-page="7" name="x_merchant" id="x_merchant" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->merchant->getPlaceHolder()) ?>" value="<?php echo $production_partner->merchant->EditValue ?>"<?php echo $production_partner->merchant->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
	<div id="r_merchant_email" class="form-group row">
		<label for="x_merchant_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_merchant_email"><?php echo $production_partner->merchant_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_merchant_email" id="z_merchant_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->merchant_email->cellAttributes() ?>>
			<span id="el_production_partner_merchant_email">
<input type="text" data-table="production_partner" data-field="x_merchant_email" data-page="7" name="x_merchant_email" id="x_merchant_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->merchant_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->merchant_email->EditValue ?>"<?php echo $production_partner->merchant_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
	<div id="r_merchant_phone" class="form-group row">
		<label for="x_merchant_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_merchant_phone"><?php echo $production_partner->merchant_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_merchant_phone" id="z_merchant_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->merchant_phone->cellAttributes() ?>>
			<span id="el_production_partner_merchant_phone">
<input type="text" data-table="production_partner" data-field="x_merchant_phone" data-page="7" name="x_merchant_phone" id="x_merchant_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->merchant_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->merchant_phone->EditValue ?>"<?php echo $production_partner->merchant_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("8") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("8")) ?>" href="#tab_production_partner8"><?php echo $production_partner->pageCaption(8) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("8") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner8"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
	<div id="r_shipping_incharge" class="form-group row">
		<label for="x_shipping_incharge" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_shipping_incharge"><?php echo $production_partner->shipping_incharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_incharge" id="z_shipping_incharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->shipping_incharge->cellAttributes() ?>>
			<span id="el_production_partner_shipping_incharge">
<input type="text" data-table="production_partner" data-field="x_shipping_incharge" data-page="8" name="x_shipping_incharge" id="x_shipping_incharge" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->shipping_incharge->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_incharge->EditValue ?>"<?php echo $production_partner->shipping_incharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
	<div id="r_shipping_email" class="form-group row">
		<label for="x_shipping_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_shipping_email"><?php echo $production_partner->shipping_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_email" id="z_shipping_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->shipping_email->cellAttributes() ?>>
			<span id="el_production_partner_shipping_email">
<input type="text" data-table="production_partner" data-field="x_shipping_email" data-page="8" name="x_shipping_email" id="x_shipping_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->shipping_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_email->EditValue ?>"<?php echo $production_partner->shipping_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
	<div id="r_shipping_phone" class="form-group row">
		<label for="x_shipping_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_shipping_phone"><?php echo $production_partner->shipping_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_phone" id="z_shipping_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->shipping_phone->cellAttributes() ?>>
			<span id="el_production_partner_shipping_phone">
<input type="text" data-table="production_partner" data-field="x_shipping_phone" data-page="8" name="x_shipping_phone" id="x_shipping_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->shipping_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->shipping_phone->EditValue ?>"<?php echo $production_partner->shipping_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("9") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("9")) ?>" href="#tab_production_partner9"><?php echo $production_partner->pageCaption(9) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("9") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner9"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
	<div id="r_account_incharge" class="form-group row">
		<label for="x_account_incharge" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_account_incharge"><?php echo $production_partner->account_incharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_account_incharge" id="z_account_incharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->account_incharge->cellAttributes() ?>>
			<span id="el_production_partner_account_incharge">
<input type="text" data-table="production_partner" data-field="x_account_incharge" data-page="9" name="x_account_incharge" id="x_account_incharge" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->account_incharge->getPlaceHolder()) ?>" value="<?php echo $production_partner->account_incharge->EditValue ?>"<?php echo $production_partner->account_incharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
	<div id="r_accounts_email" class="form-group row">
		<label for="x_accounts_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_accounts_email"><?php echo $production_partner->accounts_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_accounts_email" id="z_accounts_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->accounts_email->cellAttributes() ?>>
			<span id="el_production_partner_accounts_email">
<input type="text" data-table="production_partner" data-field="x_accounts_email" data-page="9" name="x_accounts_email" id="x_accounts_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->accounts_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->accounts_email->EditValue ?>"<?php echo $production_partner->accounts_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
	<div id="r_accounts_phone" class="form-group row">
		<label for="x_accounts_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_accounts_phone"><?php echo $production_partner->accounts_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_accounts_phone" id="z_accounts_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->accounts_phone->cellAttributes() ?>>
			<span id="el_production_partner_accounts_phone">
<input type="text" data-table="production_partner" data-field="x_accounts_phone" data-page="9" name="x_accounts_phone" id="x_accounts_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->accounts_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->accounts_phone->EditValue ?>"<?php echo $production_partner->accounts_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("10") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("10")) ?>" href="#tab_production_partner10"><?php echo $production_partner->pageCaption(10) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("10") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner10"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
	<div id="r_warehouse_incharge" class="form-group row">
		<label for="x_warehouse_incharge" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_incharge"><?php echo $production_partner->warehouse_incharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_warehouse_incharge" id="z_warehouse_incharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_incharge->cellAttributes() ?>>
			<span id="el_production_partner_warehouse_incharge">
<input type="text" data-table="production_partner" data-field="x_warehouse_incharge" data-page="10" name="x_warehouse_incharge" id="x_warehouse_incharge" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->warehouse_incharge->getPlaceHolder()) ?>" value="<?php echo $production_partner->warehouse_incharge->EditValue ?>"<?php echo $production_partner->warehouse_incharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
	<div id="r_warehouse_email" class="form-group row">
		<label for="x_warehouse_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_email"><?php echo $production_partner->warehouse_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_warehouse_email" id="z_warehouse_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_email->cellAttributes() ?>>
			<span id="el_production_partner_warehouse_email">
<input type="text" data-table="production_partner" data-field="x_warehouse_email" data-page="10" name="x_warehouse_email" id="x_warehouse_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->warehouse_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->warehouse_email->EditValue ?>"<?php echo $production_partner->warehouse_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
	<div id="r_warehouse_phone" class="form-group row">
		<label for="x_warehouse_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_phone"><?php echo $production_partner->warehouse_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_warehouse_phone" id="z_warehouse_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->warehouse_phone->cellAttributes() ?>>
			<span id="el_production_partner_warehouse_phone">
<input type="text" data-table="production_partner" data-field="x_warehouse_phone" data-page="10" name="x_warehouse_phone" id="x_warehouse_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->warehouse_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->warehouse_phone->EditValue ?>"<?php echo $production_partner->warehouse_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("11") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("11")) ?>" href="#tab_production_partner11"><?php echo $production_partner->pageCaption(11) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("11") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner11"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
	<div id="r_production_incharge" class="form-group row">
		<label for="x_production_incharge" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_production_incharge"><?php echo $production_partner->production_incharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_production_incharge" id="z_production_incharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->production_incharge->cellAttributes() ?>>
			<span id="el_production_partner_production_incharge">
<input type="text" data-table="production_partner" data-field="x_production_incharge" data-page="11" name="x_production_incharge" id="x_production_incharge" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->production_incharge->getPlaceHolder()) ?>" value="<?php echo $production_partner->production_incharge->EditValue ?>"<?php echo $production_partner->production_incharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_email->Visible) { // production_email ?>
	<div id="r_production_email" class="form-group row">
		<label for="x_production_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_production_email"><?php echo $production_partner->production_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_production_email" id="z_production_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->production_email->cellAttributes() ?>>
			<span id="el_production_partner_production_email">
<input type="text" data-table="production_partner" data-field="x_production_email" data-page="11" name="x_production_email" id="x_production_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->production_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->production_email->EditValue ?>"<?php echo $production_partner->production_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
	<div id="r_production_phone" class="form-group row">
		<label for="x_production_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_production_phone"><?php echo $production_partner->production_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_production_phone" id="z_production_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->production_phone->cellAttributes() ?>>
			<span id="el_production_partner_production_phone">
<input type="text" data-table="production_partner" data-field="x_production_phone" data-page="11" name="x_production_phone" id="x_production_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->production_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->production_phone->EditValue ?>"<?php echo $production_partner->production_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $production_partner_search->MultiPages->pageStyle("12") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_search->MultiPages->isActive("12")) ?>" href="#tab_production_partner12"><?php echo $production_partner->pageCaption(12) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_search->MultiPages->pageStyle("12") ?>" data-parent="<?php echo $production_partner_search->MultiPages->Parent ?>" id="tab_production_partner12"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
	<div id="r_qc_incharge" class="form-group row">
		<label for="x_qc_incharge" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_qc_incharge"><?php echo $production_partner->qc_incharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_qc_incharge" id="z_qc_incharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->qc_incharge->cellAttributes() ?>>
			<span id="el_production_partner_qc_incharge">
<input type="text" data-table="production_partner" data-field="x_qc_incharge" data-page="12" name="x_qc_incharge" id="x_qc_incharge" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->qc_incharge->getPlaceHolder()) ?>" value="<?php echo $production_partner->qc_incharge->EditValue ?>"<?php echo $production_partner->qc_incharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
	<div id="r_qc_email" class="form-group row">
		<label for="x_qc_email" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_qc_email"><?php echo $production_partner->qc_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_qc_email" id="z_qc_email" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->qc_email->cellAttributes() ?>>
			<span id="el_production_partner_qc_email">
<input type="text" data-table="production_partner" data-field="x_qc_email" data-page="12" name="x_qc_email" id="x_qc_email" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->qc_email->getPlaceHolder()) ?>" value="<?php echo $production_partner->qc_email->EditValue ?>"<?php echo $production_partner->qc_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
	<div id="r_qc_phone" class="form-group row">
		<label for="x_qc_phone" class="<?php echo $production_partner_search->LeftColumnClass ?>"><span id="elh_production_partner_qc_phone"><?php echo $production_partner->qc_phone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_qc_phone" id="z_qc_phone" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_partner_search->RightColumnClass ?>"><div<?php echo $production_partner->qc_phone->cellAttributes() ?>>
			<span id="el_production_partner_qc_phone">
<input type="text" data-table="production_partner" data-field="x_qc_phone" data-page="12" name="x_qc_phone" id="x_qc_phone" maxlength="192" placeholder="<?php echo HtmlEncode($production_partner->qc_phone->getPlaceHolder()) ?>" value="<?php echo $production_partner->qc_phone->EditValue ?>"<?php echo $production_partner->qc_phone->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$production_partner_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_partner_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_partner_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_partner_search->terminate();
?>