<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_partner_view = new production_partner_view();

// Run the page
$production_partner_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_partner_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_partner->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_partnerview = currentForm = new ew.Form("fproduction_partnerview", "view");

// Form_CustomValidate event
fproduction_partnerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_partnerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fproduction_partnerview.multiPage = new ew.MultiPage("fproduction_partnerview");

// Dynamic selection lists
fproduction_partnerview.lists["x_country"] = <?php echo $production_partner_view->country->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_country"].options = <?php echo JsonEncode($production_partner_view->country->lookupOptions()) ?>;
fproduction_partnerview.lists["x_region"] = <?php echo $production_partner_view->region->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_region"].options = <?php echo JsonEncode($production_partner_view->region->lookupOptions()) ?>;
fproduction_partnerview.lists["x_city"] = <?php echo $production_partner_view->city->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_city"].options = <?php echo JsonEncode($production_partner_view->city->lookupOptions()) ?>;
fproduction_partnerview.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduction_partnerview.lists["x_grp[]"] = <?php echo $production_partner_view->grp->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_grp[]"].options = <?php echo JsonEncode($production_partner_view->grp->lookupOptions()) ?>;
fproduction_partnerview.lists["x_category"] = <?php echo $production_partner_view->category->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_category"].options = <?php echo JsonEncode($production_partner_view->category->lookupOptions()) ?>;
fproduction_partnerview.lists["x_reports_to"] = <?php echo $production_partner_view->reports_to->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_reports_to"].options = <?php echo JsonEncode($production_partner_view->reports_to->lookupOptions()) ?>;
fproduction_partnerview.lists["x_status"] = <?php echo $production_partner_view->status->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_status"].options = <?php echo JsonEncode($production_partner_view->status->options(FALSE, TRUE)) ?>;
fproduction_partnerview.lists["x_operator"] = <?php echo $production_partner_view->operator->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_operator"].options = <?php echo JsonEncode($production_partner_view->operator->lookupOptions()) ?>;
fproduction_partnerview.lists["x_type"] = <?php echo $production_partner_view->type->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_type"].options = <?php echo JsonEncode($production_partner_view->type->options(FALSE, TRUE)) ?>;
fproduction_partnerview.lists["x_port_air"] = <?php echo $production_partner_view->port_air->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_port_air"].options = <?php echo JsonEncode($production_partner_view->port_air->lookupOptions()) ?>;
fproduction_partnerview.lists["x_port_sea"] = <?php echo $production_partner_view->port_sea->Lookup->toClientList() ?>;
fproduction_partnerview.lists["x_port_sea"].options = <?php echo JsonEncode($production_partner_view->port_sea->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_partner_view->ExportOptions->render("body") ?>
<?php $production_partner_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_partner_view->showPageHeader(); ?>
<?php
$production_partner_view->showMessage();
?>
<form name="fproduction_partnerview" id="fproduction_partnerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_partner_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_partner_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<input type="hidden" name="modal" value="<?php echo (int)$production_partner_view->IsModal ?>">
<?php if ($production_partner_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_id"><?php echo $production_partner->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_partner->id->cellAttributes() ?>>
<span id="el_production_partner_id" data-page="0">
<span<?php echo $production_partner->id->viewAttributes() ?>>
<?php echo $production_partner->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_name"><?php echo $production_partner->name->caption() ?></span></td>
		<td data-name="name"<?php echo $production_partner->name->cellAttributes() ?>>
<span id="el_production_partner_name" data-page="0">
<span<?php echo $production_partner->name->viewAttributes() ?>>
<?php echo $production_partner->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_code"><?php echo $production_partner->code->caption() ?></span></td>
		<td data-name="code"<?php echo $production_partner->code->cellAttributes() ?>>
<span id="el_production_partner_code" data-page="0">
<span<?php echo $production_partner->code->viewAttributes() ?>>
<?php echo $production_partner->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
<div class="ew-multi-page">
<div class="accordion ew-accordion" id="production_partner_view"><!-- multi-page accordion -->
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("1")) ?>" href="#tab_production_partner1"><?php echo $production_partner->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner1">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->country->Visible) { // country ?>
	<tr id="r_country">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_country"><?php echo $production_partner->country->caption() ?></span></td>
		<td data-name="country"<?php echo $production_partner->country->cellAttributes() ?>>
<span id="el_production_partner_country" data-page="1">
<span<?php echo $production_partner->country->viewAttributes() ?>>
<?php echo $production_partner->country->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->region->Visible) { // region ?>
	<tr id="r_region">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_region"><?php echo $production_partner->region->caption() ?></span></td>
		<td data-name="region"<?php echo $production_partner->region->cellAttributes() ?>>
<span id="el_production_partner_region" data-page="1">
<span<?php echo $production_partner->region->viewAttributes() ?>>
<?php echo $production_partner->region->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->city->Visible) { // city ?>
	<tr id="r_city">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_city"><?php echo $production_partner->city->caption() ?></span></td>
		<td data-name="city"<?php echo $production_partner->city->cellAttributes() ?>>
<span id="el_production_partner_city" data-page="1">
<span<?php echo $production_partner->city->viewAttributes() ?>>
<?php echo $production_partner->city->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_address"><?php echo $production_partner->address->caption() ?></span></td>
		<td data-name="address"<?php echo $production_partner->address->cellAttributes() ?>>
<span id="el_production_partner_address" data-page="1">
<span<?php echo $production_partner->address->viewAttributes() ?>>
<?php echo $production_partner->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_mobile"><?php echo $production_partner->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $production_partner->mobile->cellAttributes() ?>>
<span id="el_production_partner_mobile" data-page="1">
<span<?php echo $production_partner->mobile->viewAttributes() ?>>
<?php echo $production_partner->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner__email"><?php echo $production_partner->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $production_partner->_email->cellAttributes() ?>>
<span id="el_production_partner__email" data-page="1">
<span<?php echo $production_partner->_email->viewAttributes() ?>>
<?php echo $production_partner->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_url"><?php echo $production_partner->url->caption() ?></span></td>
		<td data-name="url"<?php echo $production_partner->url->cellAttributes() ?>>
<span id="el_production_partner_url" data-page="1">
<span<?php echo $production_partner->url->viewAttributes() ?>>
<?php echo $production_partner->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("2")) ?>" href="#tab_production_partner2"><?php echo $production_partner->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner2">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_grp"><?php echo $production_partner->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_partner->grp->cellAttributes() ?>>
<span id="el_production_partner_grp" data-page="2">
<span<?php echo $production_partner->grp->viewAttributes() ?>>
<?php echo $production_partner->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_category"><?php echo $production_partner->category->caption() ?></span></td>
		<td data-name="category"<?php echo $production_partner->category->cellAttributes() ?>>
<span id="el_production_partner_category" data-page="2">
<span<?php echo $production_partner->category->viewAttributes() ?>>
<?php echo $production_partner->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->reports_to->Visible) { // reports_to ?>
	<tr id="r_reports_to">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_reports_to"><?php echo $production_partner->reports_to->caption() ?></span></td>
		<td data-name="reports_to"<?php echo $production_partner->reports_to->cellAttributes() ?>>
<span id="el_production_partner_reports_to" data-page="2">
<span<?php echo $production_partner->reports_to->viewAttributes() ?>>
<?php echo $production_partner->reports_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_status"><?php echo $production_partner->status->caption() ?></span></td>
		<td data-name="status"<?php echo $production_partner->status->cellAttributes() ?>>
<span id="el_production_partner_status" data-page="2">
<span<?php echo $production_partner->status->viewAttributes() ?>>
<?php echo $production_partner->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->performance->Visible) { // performance ?>
	<tr id="r_performance">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_performance"><?php echo $production_partner->performance->caption() ?></span></td>
		<td data-name="performance"<?php echo $production_partner->performance->cellAttributes() ?>>
<span id="el_production_partner_performance" data-page="2">
<span<?php echo $production_partner->performance->viewAttributes() ?>>
<?php echo $production_partner->performance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_operator"><?php echo $production_partner->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_partner->operator->cellAttributes() ?>>
<span id="el_production_partner_operator" data-page="2">
<span<?php echo $production_partner->operator->viewAttributes() ?>>
<?php echo $production_partner->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_datetime"><?php echo $production_partner->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_partner->datetime->cellAttributes() ?>>
<span id="el_production_partner_datetime" data-page="2">
<span<?php echo $production_partner->datetime->viewAttributes() ?>>
<?php echo $production_partner->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_type"><?php echo $production_partner->type->caption() ?></span></td>
		<td data-name="type"<?php echo $production_partner->type->cellAttributes() ?>>
<span id="el_production_partner_type" data-page="2">
<span<?php echo $production_partner->type->viewAttributes() ?>>
<?php echo $production_partner->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("3")) ?>" href="#tab_production_partner3"><?php echo $production_partner->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner3">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->tax_registration->Visible) { // tax_registration ?>
	<tr id="r_tax_registration">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_tax_registration"><?php echo $production_partner->tax_registration->caption() ?></span></td>
		<td data-name="tax_registration"<?php echo $production_partner->tax_registration->cellAttributes() ?>>
<span id="el_production_partner_tax_registration" data-page="3">
<span<?php echo $production_partner->tax_registration->viewAttributes() ?>>
<?php echo $production_partner->tax_registration->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->cin->Visible) { // cin ?>
	<tr id="r_cin">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_cin"><?php echo $production_partner->cin->caption() ?></span></td>
		<td data-name="cin"<?php echo $production_partner->cin->cellAttributes() ?>>
<span id="el_production_partner_cin" data-page="3">
<span<?php echo $production_partner->cin->viewAttributes() ?>>
<?php echo $production_partner->cin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->pan->Visible) { // pan ?>
	<tr id="r_pan">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_pan"><?php echo $production_partner->pan->caption() ?></span></td>
		<td data-name="pan"<?php echo $production_partner->pan->cellAttributes() ?>>
<span id="el_production_partner_pan" data-page="3">
<span<?php echo $production_partner->pan->viewAttributes() ?>>
<?php echo $production_partner->pan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->tan->Visible) { // tan ?>
	<tr id="r_tan">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_tan"><?php echo $production_partner->tan->caption() ?></span></td>
		<td data-name="tan"<?php echo $production_partner->tan->cellAttributes() ?>>
<span id="el_production_partner_tan" data-page="3">
<span<?php echo $production_partner->tan->viewAttributes() ?>>
<?php echo $production_partner->tan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->msme->Visible) { // msme ?>
	<tr id="r_msme">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_msme"><?php echo $production_partner->msme->caption() ?></span></td>
		<td data-name="msme"<?php echo $production_partner->msme->cellAttributes() ?>>
<span id="el_production_partner_msme" data-page="3">
<span<?php echo $production_partner->msme->viewAttributes() ?>>
<?php echo $production_partner->msme->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("4")) ?>" href="#tab_production_partner4"><?php echo $production_partner->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner4">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->port_air->Visible) { // port_air ?>
	<tr id="r_port_air">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_port_air"><?php echo $production_partner->port_air->caption() ?></span></td>
		<td data-name="port_air"<?php echo $production_partner->port_air->cellAttributes() ?>>
<span id="el_production_partner_port_air" data-page="4">
<span<?php echo $production_partner->port_air->viewAttributes() ?>>
<?php echo $production_partner->port_air->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->port_sea->Visible) { // port_sea ?>
	<tr id="r_port_sea">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_port_sea"><?php echo $production_partner->port_sea->caption() ?></span></td>
		<td data-name="port_sea"<?php echo $production_partner->port_sea->cellAttributes() ?>>
<span id="el_production_partner_port_sea" data-page="4">
<span<?php echo $production_partner->port_sea->viewAttributes() ?>>
<?php echo $production_partner->port_sea->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->iec->Visible) { // iec ?>
	<tr id="r_iec">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_iec"><?php echo $production_partner->iec->caption() ?></span></td>
		<td data-name="iec"<?php echo $production_partner->iec->cellAttributes() ?>>
<span id="el_production_partner_iec" data-page="4">
<span<?php echo $production_partner->iec->viewAttributes() ?>>
<?php echo $production_partner->iec->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->rex->Visible) { // rex ?>
	<tr id="r_rex">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_rex"><?php echo $production_partner->rex->caption() ?></span></td>
		<td data-name="rex"<?php echo $production_partner->rex->cellAttributes() ?>>
<span id="el_production_partner_rex" data-page="4">
<span<?php echo $production_partner->rex->viewAttributes() ?>>
<?php echo $production_partner->rex->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->rcmc->Visible) { // rcmc ?>
	<tr id="r_rcmc">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_rcmc"><?php echo $production_partner->rcmc->caption() ?></span></td>
		<td data-name="rcmc"<?php echo $production_partner->rcmc->cellAttributes() ?>>
<span id="el_production_partner_rcmc" data-page="4">
<span<?php echo $production_partner->rcmc->viewAttributes() ?>>
<?php echo $production_partner->rcmc->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->delivery_terms->Visible) { // delivery_terms ?>
	<tr id="r_delivery_terms">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_delivery_terms"><?php echo $production_partner->delivery_terms->caption() ?></span></td>
		<td data-name="delivery_terms"<?php echo $production_partner->delivery_terms->cellAttributes() ?>>
<span id="el_production_partner_delivery_terms" data-page="4">
<span<?php echo $production_partner->delivery_terms->viewAttributes() ?>>
<?php echo $production_partner->delivery_terms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->shipping_terms->Visible) { // shipping_terms ?>
	<tr id="r_shipping_terms">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_shipping_terms"><?php echo $production_partner->shipping_terms->caption() ?></span></td>
		<td data-name="shipping_terms"<?php echo $production_partner->shipping_terms->cellAttributes() ?>>
<span id="el_production_partner_shipping_terms" data-page="4">
<span<?php echo $production_partner->shipping_terms->viewAttributes() ?>>
<?php echo $production_partner->shipping_terms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->payment_terms->Visible) { // payment_terms ?>
	<tr id="r_payment_terms">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_payment_terms"><?php echo $production_partner->payment_terms->caption() ?></span></td>
		<td data-name="payment_terms"<?php echo $production_partner->payment_terms->cellAttributes() ?>>
<span id="el_production_partner_payment_terms" data-page="4">
<span<?php echo $production_partner->payment_terms->viewAttributes() ?>>
<?php echo $production_partner->payment_terms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->export_type->Visible) { // export_type ?>
	<tr id="r_export_type">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_export_type"><?php echo $production_partner->export_type->caption() ?></span></td>
		<td data-name="export_type"<?php echo $production_partner->export_type->cellAttributes() ?>>
<span id="el_production_partner_export_type" data-page="4">
<span<?php echo $production_partner->export_type->viewAttributes() ?>>
<?php echo $production_partner->export_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->lead_time_ss->Visible) { // lead_time_ss ?>
	<tr id="r_lead_time_ss">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_lead_time_ss"><?php echo $production_partner->lead_time_ss->caption() ?></span></td>
		<td data-name="lead_time_ss"<?php echo $production_partner->lead_time_ss->cellAttributes() ?>>
<span id="el_production_partner_lead_time_ss" data-page="4">
<span<?php echo $production_partner->lead_time_ss->viewAttributes() ?>>
<?php echo $production_partner->lead_time_ss->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->lead_time_cs->Visible) { // lead_time_cs ?>
	<tr id="r_lead_time_cs">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_lead_time_cs"><?php echo $production_partner->lead_time_cs->caption() ?></span></td>
		<td data-name="lead_time_cs"<?php echo $production_partner->lead_time_cs->cellAttributes() ?>>
<span id="el_production_partner_lead_time_cs" data-page="4">
<span<?php echo $production_partner->lead_time_cs->viewAttributes() ?>>
<?php echo $production_partner->lead_time_cs->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("5")) ?>" href="#tab_production_partner5"><?php echo $production_partner->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner5">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->cha->Visible) { // cha ?>
	<tr id="r_cha">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_cha"><?php echo $production_partner->cha->caption() ?></span></td>
		<td data-name="cha"<?php echo $production_partner->cha->cellAttributes() ?>>
<span id="el_production_partner_cha" data-page="5">
<span<?php echo $production_partner->cha->viewAttributes() ?>>
<?php echo $production_partner->cha->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->cha_email->Visible) { // cha_email ?>
	<tr id="r_cha_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_cha_email"><?php echo $production_partner->cha_email->caption() ?></span></td>
		<td data-name="cha_email"<?php echo $production_partner->cha_email->cellAttributes() ?>>
<span id="el_production_partner_cha_email" data-page="5">
<span<?php echo $production_partner->cha_email->viewAttributes() ?>>
<?php echo $production_partner->cha_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->cha_phone->Visible) { // cha_phone ?>
	<tr id="r_cha_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_cha_phone"><?php echo $production_partner->cha_phone->caption() ?></span></td>
		<td data-name="cha_phone"<?php echo $production_partner->cha_phone->cellAttributes() ?>>
<span id="el_production_partner_cha_phone" data-page="5">
<span<?php echo $production_partner->cha_phone->viewAttributes() ?>>
<?php echo $production_partner->cha_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("6")) ?>" href="#tab_production_partner6"><?php echo $production_partner->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner6">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->forwarder->Visible) { // forwarder ?>
	<tr id="r_forwarder">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_forwarder"><?php echo $production_partner->forwarder->caption() ?></span></td>
		<td data-name="forwarder"<?php echo $production_partner->forwarder->cellAttributes() ?>>
<span id="el_production_partner_forwarder" data-page="6">
<span<?php echo $production_partner->forwarder->viewAttributes() ?>>
<?php echo $production_partner->forwarder->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->forwarder_email->Visible) { // forwarder_email ?>
	<tr id="r_forwarder_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_forwarder_email"><?php echo $production_partner->forwarder_email->caption() ?></span></td>
		<td data-name="forwarder_email"<?php echo $production_partner->forwarder_email->cellAttributes() ?>>
<span id="el_production_partner_forwarder_email" data-page="6">
<span<?php echo $production_partner->forwarder_email->viewAttributes() ?>>
<?php echo $production_partner->forwarder_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->forwarder_phone->Visible) { // forwarder_phone ?>
	<tr id="r_forwarder_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_forwarder_phone"><?php echo $production_partner->forwarder_phone->caption() ?></span></td>
		<td data-name="forwarder_phone"<?php echo $production_partner->forwarder_phone->cellAttributes() ?>>
<span id="el_production_partner_forwarder_phone" data-page="6">
<span<?php echo $production_partner->forwarder_phone->viewAttributes() ?>>
<?php echo $production_partner->forwarder_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("7") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("7")) ?>" href="#tab_production_partner7"><?php echo $production_partner->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner7">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->merchant->Visible) { // merchant ?>
	<tr id="r_merchant">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_merchant"><?php echo $production_partner->merchant->caption() ?></span></td>
		<td data-name="merchant"<?php echo $production_partner->merchant->cellAttributes() ?>>
<span id="el_production_partner_merchant" data-page="7">
<span<?php echo $production_partner->merchant->viewAttributes() ?>>
<?php echo $production_partner->merchant->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->merchant_email->Visible) { // merchant_email ?>
	<tr id="r_merchant_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_merchant_email"><?php echo $production_partner->merchant_email->caption() ?></span></td>
		<td data-name="merchant_email"<?php echo $production_partner->merchant_email->cellAttributes() ?>>
<span id="el_production_partner_merchant_email" data-page="7">
<span<?php echo $production_partner->merchant_email->viewAttributes() ?>>
<?php echo $production_partner->merchant_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->merchant_phone->Visible) { // merchant_phone ?>
	<tr id="r_merchant_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_merchant_phone"><?php echo $production_partner->merchant_phone->caption() ?></span></td>
		<td data-name="merchant_phone"<?php echo $production_partner->merchant_phone->cellAttributes() ?>>
<span id="el_production_partner_merchant_phone" data-page="7">
<span<?php echo $production_partner->merchant_phone->viewAttributes() ?>>
<?php echo $production_partner->merchant_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("8") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("8")) ?>" href="#tab_production_partner8"><?php echo $production_partner->pageCaption(8) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("8") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner8">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->shipping_incharge->Visible) { // shipping_incharge ?>
	<tr id="r_shipping_incharge">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_shipping_incharge"><?php echo $production_partner->shipping_incharge->caption() ?></span></td>
		<td data-name="shipping_incharge"<?php echo $production_partner->shipping_incharge->cellAttributes() ?>>
<span id="el_production_partner_shipping_incharge" data-page="8">
<span<?php echo $production_partner->shipping_incharge->viewAttributes() ?>>
<?php echo $production_partner->shipping_incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->shipping_email->Visible) { // shipping_email ?>
	<tr id="r_shipping_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_shipping_email"><?php echo $production_partner->shipping_email->caption() ?></span></td>
		<td data-name="shipping_email"<?php echo $production_partner->shipping_email->cellAttributes() ?>>
<span id="el_production_partner_shipping_email" data-page="8">
<span<?php echo $production_partner->shipping_email->viewAttributes() ?>>
<?php echo $production_partner->shipping_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->shipping_phone->Visible) { // shipping_phone ?>
	<tr id="r_shipping_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_shipping_phone"><?php echo $production_partner->shipping_phone->caption() ?></span></td>
		<td data-name="shipping_phone"<?php echo $production_partner->shipping_phone->cellAttributes() ?>>
<span id="el_production_partner_shipping_phone" data-page="8">
<span<?php echo $production_partner->shipping_phone->viewAttributes() ?>>
<?php echo $production_partner->shipping_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("9") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("9")) ?>" href="#tab_production_partner9"><?php echo $production_partner->pageCaption(9) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("9") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner9">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->account_incharge->Visible) { // account_incharge ?>
	<tr id="r_account_incharge">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_account_incharge"><?php echo $production_partner->account_incharge->caption() ?></span></td>
		<td data-name="account_incharge"<?php echo $production_partner->account_incharge->cellAttributes() ?>>
<span id="el_production_partner_account_incharge" data-page="9">
<span<?php echo $production_partner->account_incharge->viewAttributes() ?>>
<?php echo $production_partner->account_incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->accounts_email->Visible) { // accounts_email ?>
	<tr id="r_accounts_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_accounts_email"><?php echo $production_partner->accounts_email->caption() ?></span></td>
		<td data-name="accounts_email"<?php echo $production_partner->accounts_email->cellAttributes() ?>>
<span id="el_production_partner_accounts_email" data-page="9">
<span<?php echo $production_partner->accounts_email->viewAttributes() ?>>
<?php echo $production_partner->accounts_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->accounts_phone->Visible) { // accounts_phone ?>
	<tr id="r_accounts_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_accounts_phone"><?php echo $production_partner->accounts_phone->caption() ?></span></td>
		<td data-name="accounts_phone"<?php echo $production_partner->accounts_phone->cellAttributes() ?>>
<span id="el_production_partner_accounts_phone" data-page="9">
<span<?php echo $production_partner->accounts_phone->viewAttributes() ?>>
<?php echo $production_partner->accounts_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("10") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("10")) ?>" href="#tab_production_partner10"><?php echo $production_partner->pageCaption(10) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("10") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner10">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->warehouse_incharge->Visible) { // warehouse_incharge ?>
	<tr id="r_warehouse_incharge">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_warehouse_incharge"><?php echo $production_partner->warehouse_incharge->caption() ?></span></td>
		<td data-name="warehouse_incharge"<?php echo $production_partner->warehouse_incharge->cellAttributes() ?>>
<span id="el_production_partner_warehouse_incharge" data-page="10">
<span<?php echo $production_partner->warehouse_incharge->viewAttributes() ?>>
<?php echo $production_partner->warehouse_incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->warehouse_email->Visible) { // warehouse_email ?>
	<tr id="r_warehouse_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_warehouse_email"><?php echo $production_partner->warehouse_email->caption() ?></span></td>
		<td data-name="warehouse_email"<?php echo $production_partner->warehouse_email->cellAttributes() ?>>
<span id="el_production_partner_warehouse_email" data-page="10">
<span<?php echo $production_partner->warehouse_email->viewAttributes() ?>>
<?php echo $production_partner->warehouse_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->warehouse_phone->Visible) { // warehouse_phone ?>
	<tr id="r_warehouse_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_warehouse_phone"><?php echo $production_partner->warehouse_phone->caption() ?></span></td>
		<td data-name="warehouse_phone"<?php echo $production_partner->warehouse_phone->cellAttributes() ?>>
<span id="el_production_partner_warehouse_phone" data-page="10">
<span<?php echo $production_partner->warehouse_phone->viewAttributes() ?>>
<?php echo $production_partner->warehouse_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("11") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("11")) ?>" href="#tab_production_partner11"><?php echo $production_partner->pageCaption(11) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("11") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner11">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->production_incharge->Visible) { // production_incharge ?>
	<tr id="r_production_incharge">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_production_incharge"><?php echo $production_partner->production_incharge->caption() ?></span></td>
		<td data-name="production_incharge"<?php echo $production_partner->production_incharge->cellAttributes() ?>>
<span id="el_production_partner_production_incharge" data-page="11">
<span<?php echo $production_partner->production_incharge->viewAttributes() ?>>
<?php echo $production_partner->production_incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->production_email->Visible) { // production_email ?>
	<tr id="r_production_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_production_email"><?php echo $production_partner->production_email->caption() ?></span></td>
		<td data-name="production_email"<?php echo $production_partner->production_email->cellAttributes() ?>>
<span id="el_production_partner_production_email" data-page="11">
<span<?php echo $production_partner->production_email->viewAttributes() ?>>
<?php echo $production_partner->production_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->production_phone->Visible) { // production_phone ?>
	<tr id="r_production_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_production_phone"><?php echo $production_partner->production_phone->caption() ?></span></td>
		<td data-name="production_phone"<?php echo $production_partner->production_phone->cellAttributes() ?>>
<span id="el_production_partner_production_phone" data-page="11">
<span<?php echo $production_partner->production_phone->viewAttributes() ?>>
<?php echo $production_partner->production_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $production_partner_view->MultiPages->pageStyle("12") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($production_partner_view->MultiPages->isActive("12")) ?>" href="#tab_production_partner12"><?php echo $production_partner->pageCaption(12) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $production_partner_view->MultiPages->pageStyle("12") ?>" data-parent="<?php echo $production_partner_view->MultiPages->Parent ?>" id="tab_production_partner12">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_partner->qc_incharge->Visible) { // qc_incharge ?>
	<tr id="r_qc_incharge">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_qc_incharge"><?php echo $production_partner->qc_incharge->caption() ?></span></td>
		<td data-name="qc_incharge"<?php echo $production_partner->qc_incharge->cellAttributes() ?>>
<span id="el_production_partner_qc_incharge" data-page="12">
<span<?php echo $production_partner->qc_incharge->viewAttributes() ?>>
<?php echo $production_partner->qc_incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->qc_email->Visible) { // qc_email ?>
	<tr id="r_qc_email">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_qc_email"><?php echo $production_partner->qc_email->caption() ?></span></td>
		<td data-name="qc_email"<?php echo $production_partner->qc_email->cellAttributes() ?>>
<span id="el_production_partner_qc_email" data-page="12">
<span<?php echo $production_partner->qc_email->viewAttributes() ?>>
<?php echo $production_partner->qc_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_partner->qc_phone->Visible) { // qc_phone ?>
	<tr id="r_qc_phone">
		<td class="<?php echo $production_partner_view->TableLeftColumnClass ?>"><span id="elh_production_partner_qc_phone"><?php echo $production_partner->qc_phone->caption() ?></span></td>
		<td data-name="qc_phone"<?php echo $production_partner->qc_phone->cellAttributes() ?>>
<span id="el_production_partner_qc_phone" data-page="12">
<span<?php echo $production_partner->qc_phone->viewAttributes() ?>>
<?php echo $production_partner->qc_phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_partner->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$production_partner->isExport()) { ?>
</div>
</div>
<?php } ?>
<?php
	if (in_array("shipping_address", explode(",", $production_partner->getCurrentDetailTable())) && $shipping_address->DetailView) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("shipping_address", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "shipping_addressgrid.php" ?>
<?php } ?>
<?php
	if (in_array("_bank_info", explode(",", $production_partner->getCurrentDetailTable())) && $_bank_info->DetailView) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("_bank_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "_bank_infogrid.php" ?>
<?php } ?>
<?php
	if (in_array("capacity_plan", explode(",", $production_partner->getCurrentDetailTable())) && $capacity_plan->DetailView) {
?>
<?php if ($production_partner->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("capacity_plan", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "capacity_plangrid.php" ?>
<?php } ?>
</form>
<?php
$production_partner_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_partner->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_partner_view->terminate();
?>