<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_plan_head_view = new production_plan_head_view();

// Run the page
$production_plan_head_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_plan_head_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_plan_head->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_plan_headview = currentForm = new ew.Form("fproduction_plan_headview", "view");

// Form_CustomValidate event
fproduction_plan_headview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_plan_headview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_plan_headview.lists["x_grp"] = <?php echo $production_plan_head_view->grp->Lookup->toClientList() ?>;
fproduction_plan_headview.lists["x_grp"].options = <?php echo JsonEncode($production_plan_head_view->grp->lookupOptions()) ?>;
fproduction_plan_headview.lists["x_status"] = <?php echo $production_plan_head_view->status->Lookup->toClientList() ?>;
fproduction_plan_headview.lists["x_status"].options = <?php echo JsonEncode($production_plan_head_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_plan_head->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_plan_head_view->ExportOptions->render("body") ?>
<?php $production_plan_head_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_plan_head_view->showPageHeader(); ?>
<?php
$production_plan_head_view->showMessage();
?>
<form name="fproduction_plan_headview" id="fproduction_plan_headview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_plan_head_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_plan_head_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_plan_head">
<input type="hidden" name="modal" value="<?php echo (int)$production_plan_head_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_plan_head->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_id"><?php echo $production_plan_head->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_plan_head->id->cellAttributes() ?>>
<span id="el_production_plan_head_id">
<span<?php echo $production_plan_head->id->viewAttributes() ?>>
<?php echo $production_plan_head->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan_head->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_grp"><?php echo $production_plan_head->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_plan_head->grp->cellAttributes() ?>>
<span id="el_production_plan_head_grp">
<span<?php echo $production_plan_head->grp->viewAttributes() ?>>
<?php echo $production_plan_head->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan_head->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_item"><?php echo $production_plan_head->item->caption() ?></span></td>
		<td data-name="item"<?php echo $production_plan_head->item->cellAttributes() ?>>
<span id="el_production_plan_head_item">
<span<?php echo $production_plan_head->item->viewAttributes() ?>>
<?php echo $production_plan_head->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan_head->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_status"><?php echo $production_plan_head->status->caption() ?></span></td>
		<td data-name="status"<?php echo $production_plan_head->status->cellAttributes() ?>>
<span id="el_production_plan_head_status">
<span<?php echo $production_plan_head->status->viewAttributes() ?>>
<?php echo $production_plan_head->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan_head->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_operator"><?php echo $production_plan_head->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_plan_head->operator->cellAttributes() ?>>
<span id="el_production_plan_head_operator">
<span<?php echo $production_plan_head->operator->viewAttributes() ?>>
<?php echo $production_plan_head->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan_head->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_plan_head_view->TableLeftColumnClass ?>"><span id="elh_production_plan_head_datetime"><?php echo $production_plan_head->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_plan_head->datetime->cellAttributes() ?>>
<span id="el_production_plan_head_datetime">
<span<?php echo $production_plan_head->datetime->viewAttributes() ?>>
<?php echo $production_plan_head->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$production_plan_head_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_plan_head->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_plan_head_view->terminate();
?>