<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_plan_delete = new production_plan_delete();

// Run the page
$production_plan_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_plan_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fproduction_plandelete = currentForm = new ew.Form("fproduction_plandelete", "delete");

// Form_CustomValidate event
fproduction_plandelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_plandelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_plandelete.lists["x_grp"] = <?php echo $production_plan_delete->grp->Lookup->toClientList() ?>;
fproduction_plandelete.lists["x_grp"].options = <?php echo JsonEncode($production_plan_delete->grp->lookupOptions()) ?>;
fproduction_plandelete.lists["x_plan_type"] = <?php echo $production_plan_delete->plan_type->Lookup->toClientList() ?>;
fproduction_plandelete.lists["x_plan_type"].options = <?php echo JsonEncode($production_plan_delete->plan_type->lookupOptions()) ?>;
fproduction_plandelete.lists["x_plan_for"] = <?php echo $production_plan_delete->plan_for->Lookup->toClientList() ?>;
fproduction_plandelete.lists["x_plan_for"].options = <?php echo JsonEncode($production_plan_delete->plan_for->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_plan_delete->showPageHeader(); ?>
<?php
$production_plan_delete->showMessage();
?>
<form name="fproduction_plandelete" id="fproduction_plandelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_plan_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_plan_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_plan">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($production_plan_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($production_plan->id->Visible) { // id ?>
		<th class="<?php echo $production_plan->id->headerCellClass() ?>"><span id="elh_production_plan_id" class="production_plan_id"><?php echo $production_plan->id->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->grp->Visible) { // grp ?>
		<th class="<?php echo $production_plan->grp->headerCellClass() ?>"><span id="elh_production_plan_grp" class="production_plan_grp"><?php echo $production_plan->grp->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
		<th class="<?php echo $production_plan->plan_type->headerCellClass() ?>"><span id="elh_production_plan_plan_type" class="production_plan_plan_type"><?php echo $production_plan->plan_type->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
		<th class="<?php echo $production_plan->plan_for->headerCellClass() ?>"><span id="elh_production_plan_plan_for" class="production_plan_plan_for"><?php echo $production_plan->plan_for->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
		<th class="<?php echo $production_plan->to_start_days_before->headerCellClass() ?>"><span id="elh_production_plan_to_start_days_before" class="production_plan_to_start_days_before"><?php echo $production_plan->to_start_days_before->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
		<th class="<?php echo $production_plan->to_finish_in_days->headerCellClass() ?>"><span id="elh_production_plan_to_finish_in_days" class="production_plan_to_finish_in_days"><?php echo $production_plan->to_finish_in_days->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->operator->Visible) { // operator ?>
		<th class="<?php echo $production_plan->operator->headerCellClass() ?>"><span id="elh_production_plan_operator" class="production_plan_operator"><?php echo $production_plan->operator->caption() ?></span></th>
<?php } ?>
<?php if ($production_plan->datetime->Visible) { // datetime ?>
		<th class="<?php echo $production_plan->datetime->headerCellClass() ?>"><span id="elh_production_plan_datetime" class="production_plan_datetime"><?php echo $production_plan->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$production_plan_delete->RecCnt = 0;
$i = 0;
while (!$production_plan_delete->Recordset->EOF) {
	$production_plan_delete->RecCnt++;
	$production_plan_delete->RowCnt++;

	// Set row properties
	$production_plan->resetAttributes();
	$production_plan->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$production_plan_delete->loadRowValues($production_plan_delete->Recordset);

	// Render row
	$production_plan_delete->renderRow();
?>
	<tr<?php echo $production_plan->rowAttributes() ?>>
<?php if ($production_plan->id->Visible) { // id ?>
		<td<?php echo $production_plan->id->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_id" class="production_plan_id">
<span<?php echo $production_plan->id->viewAttributes() ?>>
<?php echo $production_plan->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->grp->Visible) { // grp ?>
		<td<?php echo $production_plan->grp->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_grp" class="production_plan_grp">
<span<?php echo $production_plan->grp->viewAttributes() ?>>
<?php echo $production_plan->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
		<td<?php echo $production_plan->plan_type->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_plan_type" class="production_plan_plan_type">
<span<?php echo $production_plan->plan_type->viewAttributes() ?>>
<?php echo $production_plan->plan_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
		<td<?php echo $production_plan->plan_for->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_plan_for" class="production_plan_plan_for">
<span<?php echo $production_plan->plan_for->viewAttributes() ?>>
<?php echo $production_plan->plan_for->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
		<td<?php echo $production_plan->to_start_days_before->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_to_start_days_before" class="production_plan_to_start_days_before">
<span<?php echo $production_plan->to_start_days_before->viewAttributes() ?>>
<?php echo $production_plan->to_start_days_before->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
		<td<?php echo $production_plan->to_finish_in_days->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_to_finish_in_days" class="production_plan_to_finish_in_days">
<span<?php echo $production_plan->to_finish_in_days->viewAttributes() ?>>
<?php echo $production_plan->to_finish_in_days->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->operator->Visible) { // operator ?>
		<td<?php echo $production_plan->operator->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_operator" class="production_plan_operator">
<span<?php echo $production_plan->operator->viewAttributes() ?>>
<?php echo $production_plan->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_plan->datetime->Visible) { // datetime ?>
		<td<?php echo $production_plan->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_plan_delete->RowCnt ?>_production_plan_datetime" class="production_plan_datetime">
<span<?php echo $production_plan->datetime->viewAttributes() ?>>
<?php echo $production_plan->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$production_plan_delete->Recordset->moveNext();
}
$production_plan_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_plan_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$production_plan_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_plan_delete->terminate();
?>