<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_plan_edit = new production_plan_edit();

// Run the page
$production_plan_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_plan_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproduction_planedit = currentForm = new ew.Form("fproduction_planedit", "edit");

// Validate form
fproduction_planedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_plan_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->id->caption(), $production_plan->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_plan_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->grp->caption(), $production_plan->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_plan_edit->plan_type->Required) { ?>
			elm = this.getElements("x" + infix + "_plan_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->plan_type->caption(), $production_plan->plan_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_plan_edit->plan_for->Required) { ?>
			elm = this.getElements("x" + infix + "_plan_for");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->plan_for->caption(), $production_plan->plan_for->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_plan_edit->to_start_days_before->Required) { ?>
			elm = this.getElements("x" + infix + "_to_start_days_before");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->to_start_days_before->caption(), $production_plan->to_start_days_before->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_start_days_before");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_plan->to_start_days_before->errorMessage()) ?>");
		<?php if ($production_plan_edit->to_finish_in_days->Required) { ?>
			elm = this.getElements("x" + infix + "_to_finish_in_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->to_finish_in_days->caption(), $production_plan->to_finish_in_days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_finish_in_days");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_plan->to_finish_in_days->errorMessage()) ?>");
		<?php if ($production_plan_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->operator->caption(), $production_plan->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_plan_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_plan->datetime->caption(), $production_plan->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_planedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_planedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_planedit.lists["x_grp"] = <?php echo $production_plan_edit->grp->Lookup->toClientList() ?>;
fproduction_planedit.lists["x_grp"].options = <?php echo JsonEncode($production_plan_edit->grp->lookupOptions()) ?>;
fproduction_planedit.lists["x_plan_type"] = <?php echo $production_plan_edit->plan_type->Lookup->toClientList() ?>;
fproduction_planedit.lists["x_plan_type"].options = <?php echo JsonEncode($production_plan_edit->plan_type->lookupOptions()) ?>;
fproduction_planedit.lists["x_plan_for"] = <?php echo $production_plan_edit->plan_for->Lookup->toClientList() ?>;
fproduction_planedit.lists["x_plan_for"].options = <?php echo JsonEncode($production_plan_edit->plan_for->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_plan_edit->showPageHeader(); ?>
<?php
$production_plan_edit->showMessage();
?>
<form name="fproduction_planedit" id="fproduction_planedit" class="<?php echo $production_plan_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_plan_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_plan_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_plan">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$production_plan_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($production_plan->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_production_plan_id" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->id->caption() ?><?php echo ($production_plan->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->id->cellAttributes() ?>>
<span id="el_production_plan_id">
<span<?php echo $production_plan->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_plan->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="production_plan" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($production_plan->id->CurrentValue) ?>">
<?php echo $production_plan->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_plan->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_production_plan_grp" for="x_grp" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->grp->caption() ?><?php echo ($production_plan->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->grp->cellAttributes() ?>>
<span id="el_production_plan_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_plan" data-field="x_grp" data-value-separator="<?php echo $production_plan->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $production_plan->grp->editAttributes() ?>>
		<?php echo $production_plan->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $production_plan->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $production_plan->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
	<div id="r_plan_type" class="form-group row">
		<label id="elh_production_plan_plan_type" for="x_plan_type" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->plan_type->caption() ?><?php echo ($production_plan->plan_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->plan_type->cellAttributes() ?>>
<span id="el_production_plan_plan_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_plan" data-field="x_plan_type" data-value-separator="<?php echo $production_plan->plan_type->displayValueSeparatorAttribute() ?>" id="x_plan_type" name="x_plan_type"<?php echo $production_plan->plan_type->editAttributes() ?>>
		<?php echo $production_plan->plan_type->selectOptionListHtml("x_plan_type") ?>
	</select>
</div>
<?php echo $production_plan->plan_type->Lookup->getParamTag("p_x_plan_type") ?>
</span>
<?php echo $production_plan->plan_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
	<div id="r_plan_for" class="form-group row">
		<label id="elh_production_plan_plan_for" for="x_plan_for" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->plan_for->caption() ?><?php echo ($production_plan->plan_for->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->plan_for->cellAttributes() ?>>
<span id="el_production_plan_plan_for">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_plan" data-field="x_plan_for" data-value-separator="<?php echo $production_plan->plan_for->displayValueSeparatorAttribute() ?>" id="x_plan_for" name="x_plan_for"<?php echo $production_plan->plan_for->editAttributes() ?>>
		<?php echo $production_plan->plan_for->selectOptionListHtml("x_plan_for") ?>
	</select>
</div>
<?php echo $production_plan->plan_for->Lookup->getParamTag("p_x_plan_for") ?>
</span>
<?php echo $production_plan->plan_for->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
	<div id="r_to_start_days_before" class="form-group row">
		<label id="elh_production_plan_to_start_days_before" for="x_to_start_days_before" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->to_start_days_before->caption() ?><?php echo ($production_plan->to_start_days_before->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->to_start_days_before->cellAttributes() ?>>
<span id="el_production_plan_to_start_days_before">
<input type="text" data-table="production_plan" data-field="x_to_start_days_before" name="x_to_start_days_before" id="x_to_start_days_before" size="30" placeholder="<?php echo HtmlEncode($production_plan->to_start_days_before->getPlaceHolder()) ?>" value="<?php echo $production_plan->to_start_days_before->EditValue ?>"<?php echo $production_plan->to_start_days_before->editAttributes() ?>>
</span>
<?php echo $production_plan->to_start_days_before->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
	<div id="r_to_finish_in_days" class="form-group row">
		<label id="elh_production_plan_to_finish_in_days" for="x_to_finish_in_days" class="<?php echo $production_plan_edit->LeftColumnClass ?>"><?php echo $production_plan->to_finish_in_days->caption() ?><?php echo ($production_plan->to_finish_in_days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_plan_edit->RightColumnClass ?>"><div<?php echo $production_plan->to_finish_in_days->cellAttributes() ?>>
<span id="el_production_plan_to_finish_in_days">
<input type="text" data-table="production_plan" data-field="x_to_finish_in_days" name="x_to_finish_in_days" id="x_to_finish_in_days" size="30" placeholder="<?php echo HtmlEncode($production_plan->to_finish_in_days->getPlaceHolder()) ?>" value="<?php echo $production_plan->to_finish_in_days->EditValue ?>"<?php echo $production_plan->to_finish_in_days->editAttributes() ?>>
</span>
<?php echo $production_plan->to_finish_in_days->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_plan_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_plan_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_plan_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_plan_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_plan_edit->terminate();
?>