<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_plan_list = new production_plan_list();

// Run the page
$production_plan_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_plan_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_planlist = currentForm = new ew.Form("fproduction_planlist", "list");
fproduction_planlist.formKeyCountName = '<?php echo $production_plan_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_planlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_planlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_planlist.lists["x_grp"] = <?php echo $production_plan_list->grp->Lookup->toClientList() ?>;
fproduction_planlist.lists["x_grp"].options = <?php echo JsonEncode($production_plan_list->grp->lookupOptions()) ?>;
fproduction_planlist.lists["x_plan_type"] = <?php echo $production_plan_list->plan_type->Lookup->toClientList() ?>;
fproduction_planlist.lists["x_plan_type"].options = <?php echo JsonEncode($production_plan_list->plan_type->lookupOptions()) ?>;
fproduction_planlist.lists["x_plan_for"] = <?php echo $production_plan_list->plan_for->Lookup->toClientList() ?>;
fproduction_planlist.lists["x_plan_for"].options = <?php echo JsonEncode($production_plan_list->plan_for->lookupOptions()) ?>;

// Form object for search
var fproduction_planlistsrch = currentSearchForm = new ew.Form("fproduction_planlistsrch");

// Filters
fproduction_planlistsrch.filterList = <?php echo $production_plan_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_planlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_plan_list->TotalRecs > 0 && $production_plan_list->ExportOptions->visible()) { ?>
<?php $production_plan_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_plan_list->ImportOptions->visible()) { ?>
<?php $production_plan_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_plan_list->SearchOptions->visible()) { ?>
<?php $production_plan_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_plan_list->FilterOptions->visible()) { ?>
<?php $production_plan_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_plan_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_plan->isExport() && !$production_plan->CurrentAction) { ?>
<form name="fproduction_planlistsrch" id="fproduction_planlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_plan_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_planlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_plan">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_plan_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_plan_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_plan_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_plan_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_plan_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_plan_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_plan_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_plan_list->showPageHeader(); ?>
<?php
$production_plan_list->showMessage();
?>
<?php if ($production_plan_list->TotalRecs > 0 || $production_plan->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_plan_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_plan">
<?php if (!$production_plan->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_plan_list->Pager)) $production_plan_list->Pager = new PrevNextPager($production_plan_list->StartRec, $production_plan_list->DisplayRecs, $production_plan_list->TotalRecs, $production_plan_list->AutoHidePager) ?>
<?php if ($production_plan_list->Pager->RecordCount > 0 && $production_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_plan_list->TotalRecs > 0 && (!$production_plan_list->AutoHidePageSizeSelector || $production_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_planlist" id="fproduction_planlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_plan_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_plan_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_plan">
<div id="gmp_production_plan" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_plan_list->TotalRecs > 0 || $production_plan->isGridEdit()) { ?>
<table id="tbl_production_planlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_plan_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_plan_list->renderListOptions();

// Render list options (header, left)
$production_plan_list->ListOptions->render("header", "left");
?>
<?php if ($production_plan->id->Visible) { // id ?>
	<?php if ($production_plan->sortUrl($production_plan->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_plan->id->headerCellClass() ?>"><div id="elh_production_plan_id" class="production_plan_id"><div class="ew-table-header-caption"><?php echo $production_plan->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_plan->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->id) ?>',2);"><div id="elh_production_plan_id" class="production_plan_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->grp->Visible) { // grp ?>
	<?php if ($production_plan->sortUrl($production_plan->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $production_plan->grp->headerCellClass() ?>"><div id="elh_production_plan_grp" class="production_plan_grp"><div class="ew-table-header-caption"><?php echo $production_plan->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $production_plan->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->grp) ?>',2);"><div id="elh_production_plan_grp" class="production_plan_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
	<?php if ($production_plan->sortUrl($production_plan->plan_type) == "") { ?>
		<th data-name="plan_type" class="<?php echo $production_plan->plan_type->headerCellClass() ?>"><div id="elh_production_plan_plan_type" class="production_plan_plan_type"><div class="ew-table-header-caption"><?php echo $production_plan->plan_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_type" class="<?php echo $production_plan->plan_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->plan_type) ?>',2);"><div id="elh_production_plan_plan_type" class="production_plan_plan_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->plan_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->plan_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->plan_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
	<?php if ($production_plan->sortUrl($production_plan->plan_for) == "") { ?>
		<th data-name="plan_for" class="<?php echo $production_plan->plan_for->headerCellClass() ?>"><div id="elh_production_plan_plan_for" class="production_plan_plan_for"><div class="ew-table-header-caption"><?php echo $production_plan->plan_for->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_for" class="<?php echo $production_plan->plan_for->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->plan_for) ?>',2);"><div id="elh_production_plan_plan_for" class="production_plan_plan_for">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->plan_for->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->plan_for->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->plan_for->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
	<?php if ($production_plan->sortUrl($production_plan->to_start_days_before) == "") { ?>
		<th data-name="to_start_days_before" class="<?php echo $production_plan->to_start_days_before->headerCellClass() ?>"><div id="elh_production_plan_to_start_days_before" class="production_plan_to_start_days_before"><div class="ew-table-header-caption"><?php echo $production_plan->to_start_days_before->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_start_days_before" class="<?php echo $production_plan->to_start_days_before->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->to_start_days_before) ?>',2);"><div id="elh_production_plan_to_start_days_before" class="production_plan_to_start_days_before">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->to_start_days_before->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->to_start_days_before->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->to_start_days_before->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
	<?php if ($production_plan->sortUrl($production_plan->to_finish_in_days) == "") { ?>
		<th data-name="to_finish_in_days" class="<?php echo $production_plan->to_finish_in_days->headerCellClass() ?>"><div id="elh_production_plan_to_finish_in_days" class="production_plan_to_finish_in_days"><div class="ew-table-header-caption"><?php echo $production_plan->to_finish_in_days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_finish_in_days" class="<?php echo $production_plan->to_finish_in_days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->to_finish_in_days) ?>',2);"><div id="elh_production_plan_to_finish_in_days" class="production_plan_to_finish_in_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->to_finish_in_days->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->to_finish_in_days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->to_finish_in_days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->operator->Visible) { // operator ?>
	<?php if ($production_plan->sortUrl($production_plan->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_plan->operator->headerCellClass() ?>"><div id="elh_production_plan_operator" class="production_plan_operator"><div class="ew-table-header-caption"><?php echo $production_plan->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_plan->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->operator) ?>',2);"><div id="elh_production_plan_operator" class="production_plan_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_plan->datetime->Visible) { // datetime ?>
	<?php if ($production_plan->sortUrl($production_plan->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_plan->datetime->headerCellClass() ?>"><div id="elh_production_plan_datetime" class="production_plan_datetime"><div class="ew-table-header-caption"><?php echo $production_plan->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_plan->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_plan->SortUrl($production_plan->datetime) ?>',2);"><div id="elh_production_plan_datetime" class="production_plan_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_plan->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_plan->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_plan->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_plan_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_plan->ExportAll && $production_plan->isExport()) {
	$production_plan_list->StopRec = $production_plan_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_plan_list->TotalRecs > $production_plan_list->StartRec + $production_plan_list->DisplayRecs - 1)
		$production_plan_list->StopRec = $production_plan_list->StartRec + $production_plan_list->DisplayRecs - 1;
	else
		$production_plan_list->StopRec = $production_plan_list->TotalRecs;
}
$production_plan_list->RecCnt = $production_plan_list->StartRec - 1;
if ($production_plan_list->Recordset && !$production_plan_list->Recordset->EOF) {
	$production_plan_list->Recordset->moveFirst();
	$selectLimit = $production_plan_list->UseSelectLimit;
	if (!$selectLimit && $production_plan_list->StartRec > 1)
		$production_plan_list->Recordset->move($production_plan_list->StartRec - 1);
} elseif (!$production_plan->AllowAddDeleteRow && $production_plan_list->StopRec == 0) {
	$production_plan_list->StopRec = $production_plan->GridAddRowCount;
}

// Initialize aggregate
$production_plan->RowType = ROWTYPE_AGGREGATEINIT;
$production_plan->resetAttributes();
$production_plan_list->renderRow();
while ($production_plan_list->RecCnt < $production_plan_list->StopRec) {
	$production_plan_list->RecCnt++;
	if ($production_plan_list->RecCnt >= $production_plan_list->StartRec) {
		$production_plan_list->RowCnt++;

		// Set up key count
		$production_plan_list->KeyCount = $production_plan_list->RowIndex;

		// Init row class and style
		$production_plan->resetAttributes();
		$production_plan->CssClass = "";
		if ($production_plan->isGridAdd()) {
		} else {
			$production_plan_list->loadRowValues($production_plan_list->Recordset); // Load row values
		}
		$production_plan->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_plan->RowAttrs = array_merge($production_plan->RowAttrs, array('data-rowindex'=>$production_plan_list->RowCnt, 'id'=>'r' . $production_plan_list->RowCnt . '_production_plan', 'data-rowtype'=>$production_plan->RowType));

		// Render row
		$production_plan_list->renderRow();

		// Render list options
		$production_plan_list->renderListOptions();
?>
	<tr<?php echo $production_plan->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_plan_list->ListOptions->render("body", "left", $production_plan_list->RowCnt);
?>
	<?php if ($production_plan->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_plan->id->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_id" class="production_plan_id">
<span<?php echo $production_plan->id->viewAttributes() ?>>
<?php echo $production_plan->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $production_plan->grp->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_grp" class="production_plan_grp">
<span<?php echo $production_plan->grp->viewAttributes() ?>>
<?php echo $production_plan->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
		<td data-name="plan_type"<?php echo $production_plan->plan_type->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_plan_type" class="production_plan_plan_type">
<span<?php echo $production_plan->plan_type->viewAttributes() ?>>
<?php echo $production_plan->plan_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
		<td data-name="plan_for"<?php echo $production_plan->plan_for->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_plan_for" class="production_plan_plan_for">
<span<?php echo $production_plan->plan_for->viewAttributes() ?>>
<?php echo $production_plan->plan_for->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
		<td data-name="to_start_days_before"<?php echo $production_plan->to_start_days_before->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_to_start_days_before" class="production_plan_to_start_days_before">
<span<?php echo $production_plan->to_start_days_before->viewAttributes() ?>>
<?php echo $production_plan->to_start_days_before->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
		<td data-name="to_finish_in_days"<?php echo $production_plan->to_finish_in_days->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_to_finish_in_days" class="production_plan_to_finish_in_days">
<span<?php echo $production_plan->to_finish_in_days->viewAttributes() ?>>
<?php echo $production_plan->to_finish_in_days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_plan->operator->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_operator" class="production_plan_operator">
<span<?php echo $production_plan->operator->viewAttributes() ?>>
<?php echo $production_plan->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_plan->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_plan->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_plan_list->RowCnt ?>_production_plan_datetime" class="production_plan_datetime">
<span<?php echo $production_plan->datetime->viewAttributes() ?>>
<?php echo $production_plan->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_plan_list->ListOptions->render("body", "right", $production_plan_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_plan->isGridAdd())
		$production_plan_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_plan->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_plan_list->Recordset)
	$production_plan_list->Recordset->Close();
?>
<?php if (!$production_plan->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_plan_list->Pager)) $production_plan_list->Pager = new PrevNextPager($production_plan_list->StartRec, $production_plan_list->DisplayRecs, $production_plan_list->TotalRecs, $production_plan_list->AutoHidePager) ?>
<?php if ($production_plan_list->Pager->RecordCount > 0 && $production_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_plan_list->pageUrl() ?>start=<?php echo $production_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_plan_list->TotalRecs > 0 && (!$production_plan_list->AutoHidePageSizeSelector || $production_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_plan_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_plan_list->TotalRecs == 0 && !$production_plan->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_plan_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_plan->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_plan", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_plan_list->terminate();
?>