<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_plan_view = new production_plan_view();

// Run the page
$production_plan_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_plan_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduction_planview = currentForm = new ew.Form("fproduction_planview", "view");

// Form_CustomValidate event
fproduction_planview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_planview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_planview.lists["x_grp"] = <?php echo $production_plan_view->grp->Lookup->toClientList() ?>;
fproduction_planview.lists["x_grp"].options = <?php echo JsonEncode($production_plan_view->grp->lookupOptions()) ?>;
fproduction_planview.lists["x_plan_type"] = <?php echo $production_plan_view->plan_type->Lookup->toClientList() ?>;
fproduction_planview.lists["x_plan_type"].options = <?php echo JsonEncode($production_plan_view->plan_type->lookupOptions()) ?>;
fproduction_planview.lists["x_plan_for"] = <?php echo $production_plan_view->plan_for->Lookup->toClientList() ?>;
fproduction_planview.lists["x_plan_for"].options = <?php echo JsonEncode($production_plan_view->plan_for->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_plan_view->ExportOptions->render("body") ?>
<?php $production_plan_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_plan_view->showPageHeader(); ?>
<?php
$production_plan_view->showMessage();
?>
<form name="fproduction_planview" id="fproduction_planview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_plan_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_plan_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_plan">
<input type="hidden" name="modal" value="<?php echo (int)$production_plan_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_plan->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_id"><?php echo $production_plan->id->caption() ?></span></td>
		<td data-name="id"<?php echo $production_plan->id->cellAttributes() ?>>
<span id="el_production_plan_id">
<span<?php echo $production_plan->id->viewAttributes() ?>>
<?php echo $production_plan->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_grp"><?php echo $production_plan->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $production_plan->grp->cellAttributes() ?>>
<span id="el_production_plan_grp">
<span<?php echo $production_plan->grp->viewAttributes() ?>>
<?php echo $production_plan->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->plan_type->Visible) { // plan_type ?>
	<tr id="r_plan_type">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_plan_type"><?php echo $production_plan->plan_type->caption() ?></span></td>
		<td data-name="plan_type"<?php echo $production_plan->plan_type->cellAttributes() ?>>
<span id="el_production_plan_plan_type">
<span<?php echo $production_plan->plan_type->viewAttributes() ?>>
<?php echo $production_plan->plan_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->plan_for->Visible) { // plan_for ?>
	<tr id="r_plan_for">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_plan_for"><?php echo $production_plan->plan_for->caption() ?></span></td>
		<td data-name="plan_for"<?php echo $production_plan->plan_for->cellAttributes() ?>>
<span id="el_production_plan_plan_for">
<span<?php echo $production_plan->plan_for->viewAttributes() ?>>
<?php echo $production_plan->plan_for->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->to_start_days_before->Visible) { // to_start_days_before ?>
	<tr id="r_to_start_days_before">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_to_start_days_before"><?php echo $production_plan->to_start_days_before->caption() ?></span></td>
		<td data-name="to_start_days_before"<?php echo $production_plan->to_start_days_before->cellAttributes() ?>>
<span id="el_production_plan_to_start_days_before">
<span<?php echo $production_plan->to_start_days_before->viewAttributes() ?>>
<?php echo $production_plan->to_start_days_before->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->to_finish_in_days->Visible) { // to_finish_in_days ?>
	<tr id="r_to_finish_in_days">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_to_finish_in_days"><?php echo $production_plan->to_finish_in_days->caption() ?></span></td>
		<td data-name="to_finish_in_days"<?php echo $production_plan->to_finish_in_days->cellAttributes() ?>>
<span id="el_production_plan_to_finish_in_days">
<span<?php echo $production_plan->to_finish_in_days->viewAttributes() ?>>
<?php echo $production_plan->to_finish_in_days->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_operator"><?php echo $production_plan->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $production_plan->operator->cellAttributes() ?>>
<span id="el_production_plan_operator">
<span<?php echo $production_plan->operator->viewAttributes() ?>>
<?php echo $production_plan->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_plan->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $production_plan_view->TableLeftColumnClass ?>"><span id="elh_production_plan_datetime"><?php echo $production_plan->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $production_plan->datetime->cellAttributes() ?>>
<span id="el_production_plan_datetime">
<span<?php echo $production_plan->datetime->viewAttributes() ?>>
<?php echo $production_plan->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$production_plan_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_plan_view->terminate();
?>