<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_process_f_search = new production_process_f_search();

// Run the page
$production_process_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_process_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($production_process_f_search->IsModal) { ?>
var fproduction_process_fsearch = currentAdvancedSearchForm = new ew.Form("fproduction_process_fsearch", "search");
<?php } else { ?>
var fproduction_process_fsearch = currentForm = new ew.Form("fproduction_process_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduction_process_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_process_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_process_fsearch.lists["x_grp"] = <?php echo $production_process_f_search->grp->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_grp"].options = <?php echo JsonEncode($production_process_f_search->grp->options(FALSE, TRUE)) ?>;
fproduction_process_fsearch.lists["x_s_grp"] = <?php echo $production_process_f_search->s_grp->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_s_grp"].options = <?php echo JsonEncode($production_process_f_search->s_grp->lookupOptions()) ?>;
fproduction_process_fsearch.lists["x_product"] = <?php echo $production_process_f_search->product->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_product"].options = <?php echo JsonEncode($production_process_f_search->product->lookupOptions()) ?>;
fproduction_process_fsearch.lists["x_rid"] = <?php echo $production_process_f_search->rid->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_rid"].options = <?php echo JsonEncode($production_process_f_search->rid->lookupOptions()) ?>;
fproduction_process_fsearch.lists["x_sequence"] = <?php echo $production_process_f_search->sequence->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_sequence"].options = <?php echo JsonEncode($production_process_f_search->sequence->options(FALSE, TRUE)) ?>;
fproduction_process_fsearch.lists["x_process"] = <?php echo $production_process_f_search->process->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_process"].options = <?php echo JsonEncode($production_process_f_search->process->lookupOptions()) ?>;
fproduction_process_fsearch.lists["x_operator"] = <?php echo $production_process_f_search->operator->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_operator"].options = <?php echo JsonEncode($production_process_f_search->operator->lookupOptions()) ?>;
fproduction_process_fsearch.lists["x_a_operator"] = <?php echo $production_process_f_search->a_operator->Lookup->toClientList() ?>;
fproduction_process_fsearch.lists["x_a_operator"].options = <?php echo JsonEncode($production_process_f_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduction_process_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_process_f->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_process_f->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_process_f->material->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_process_f->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($production_process_f->a_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_process_f_search->showPageHeader(); ?>
<?php
$production_process_f_search->showMessage();
?>
<form name="fproduction_process_fsearch" id="fproduction_process_fsearch" class="<?php echo $production_process_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_process_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_process_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_process_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$production_process_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($production_process_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_id"><?php echo $production_process_f->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->id->cellAttributes() ?>>
			<span id="el_production_process_f_id">
<input type="text" data-table="production_process_f" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($production_process_f->id->getPlaceHolder()) ?>" value="<?php echo $production_process_f->id->EditValue ?>"<?php echo $production_process_f->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_grp"><?php echo $production_process_f->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->grp->cellAttributes() ?>>
			<span id="el_production_process_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_grp" data-value-separator="<?php echo $production_process_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $production_process_f->grp->editAttributes() ?>>
		<?php echo $production_process_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_s_grp"><?php echo $production_process_f->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->s_grp->cellAttributes() ?>>
			<span id="el_production_process_f_s_grp">
<?php $production_process_f->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process_f->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_s_grp" data-value-separator="<?php echo $production_process_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $production_process_f->s_grp->editAttributes() ?>>
		<?php echo $production_process_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $production_process_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_product"><?php echo $production_process_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->product->cellAttributes() ?>>
			<span id="el_production_process_f_product">
<?php $production_process_f->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process_f->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_product" data-value-separator="<?php echo $production_process_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $production_process_f->product->editAttributes() ?>>
		<?php echo $production_process_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $production_process_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_rid"><?php echo $production_process_f->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->rid->cellAttributes() ?>>
			<span id="el_production_process_f_rid">
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="production_process_f" data-field="x_rid" data-value-separator="<?php echo $production_process_f->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $production_process_f->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $production_process_f->rid->radioButtonListHtml(FALSE, "x_rid") ?>
</div></div>
<?php echo $production_process_f->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_batch_no"><?php echo $production_process_f->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->batch_no->cellAttributes() ?>>
			<span id="el_production_process_f_batch_no">
<input type="text" data-table="production_process_f" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($production_process_f->batch_no->getPlaceHolder()) ?>" value="<?php echo $production_process_f->batch_no->EditValue ?>"<?php echo $production_process_f->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->sequence->Visible) { // sequence ?>
	<div id="r_sequence" class="form-group row">
		<label for="x_sequence" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_sequence"><?php echo $production_process_f->sequence->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sequence" id="z_sequence" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->sequence->cellAttributes() ?>>
			<span id="el_production_process_f_sequence">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_sequence" data-value-separator="<?php echo $production_process_f->sequence->displayValueSeparatorAttribute() ?>" id="x_sequence" name="x_sequence"<?php echo $production_process_f->sequence->editAttributes() ?>>
		<?php echo $production_process_f->sequence->selectOptionListHtml("x_sequence") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_process"><?php echo $production_process_f->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->process->cellAttributes() ?>>
			<span id="el_production_process_f_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_process" data-value-separator="<?php echo $production_process_f->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $production_process_f->process->editAttributes() ?>>
		<?php echo $production_process_f->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $production_process_f->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label for="x_material" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_material"><?php echo $production_process_f->material->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material" id="z_material" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->material->cellAttributes() ?>>
			<span id="el_production_process_f_material">
<input type="text" data-table="production_process_f" data-field="x_material" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($production_process_f->material->getPlaceHolder()) ?>" value="<?php echo $production_process_f->material->EditValue ?>"<?php echo $production_process_f->material->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->material_name->Visible) { // material_name ?>
	<div id="r_material_name" class="form-group row">
		<label for="x_material_name" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_material_name"><?php echo $production_process_f->material_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_material_name" id="z_material_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->material_name->cellAttributes() ?>>
			<span id="el_production_process_f_material_name">
<input type="text" data-table="production_process_f" data-field="x_material_name" name="x_material_name" id="x_material_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_process_f->material_name->getPlaceHolder()) ?>" value="<?php echo $production_process_f->material_name->EditValue ?>"<?php echo $production_process_f->material_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_quantity"><?php echo $production_process_f->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->quantity->cellAttributes() ?>>
			<span id="el_production_process_f_quantity">
<input type="text" data-table="production_process_f" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($production_process_f->quantity->getPlaceHolder()) ?>" value="<?php echo $production_process_f->quantity->EditValue ?>"<?php echo $production_process_f->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_remarks"><?php echo $production_process_f->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->remarks->cellAttributes() ?>>
			<span id="el_production_process_f_remarks">
<input type="text" data-table="production_process_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="31" maxlength="255" placeholder="<?php echo HtmlEncode($production_process_f->remarks->getPlaceHolder()) ?>" value="<?php echo $production_process_f->remarks->EditValue ?>"<?php echo $production_process_f->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_operator"><?php echo $production_process_f->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->operator->cellAttributes() ?>>
			<span id="el_production_process_f_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_operator" data-value-separator="<?php echo $production_process_f->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $production_process_f->operator->editAttributes() ?>>
		<?php echo $production_process_f->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $production_process_f->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_datetime"><?php echo $production_process_f->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($production_process_f->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_production_process_f_datetime">
<input type="text" data-table="production_process_f" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($production_process_f->datetime->getPlaceHolder()) ?>" value="<?php echo $production_process_f->datetime->EditValue ?>"<?php echo $production_process_f->datetime->editAttributes() ?>>
<?php if (!$production_process_f->datetime->ReadOnly && !$production_process_f->datetime->Disabled && !isset($production_process_f->datetime->EditAttrs["readonly"]) && !isset($production_process_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_process_fsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_production_process_f_datetime" class="btw1_datetime d-none">
<input type="text" data-table="production_process_f" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($production_process_f->datetime->getPlaceHolder()) ?>" value="<?php echo $production_process_f->datetime->EditValue2 ?>"<?php echo $production_process_f->datetime->editAttributes() ?>>
<?php if (!$production_process_f->datetime->ReadOnly && !$production_process_f->datetime->Disabled && !isset($production_process_f->datetime->EditAttrs["readonly"]) && !isset($production_process_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduction_process_fsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_a_operator"><?php echo $production_process_f->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->a_operator->cellAttributes() ?>>
			<span id="el_production_process_f_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process_f" data-field="x_a_operator" data-value-separator="<?php echo $production_process_f->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $production_process_f->a_operator->editAttributes() ?>>
		<?php echo $production_process_f->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $production_process_f->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($production_process_f->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $production_process_f_search->LeftColumnClass ?>"><span id="elh_production_process_f_a_datetime"><?php echo $production_process_f->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $production_process_f_search->RightColumnClass ?>"><div<?php echo $production_process_f->a_datetime->cellAttributes() ?>>
			<span id="el_production_process_f_a_datetime">
<input type="text" data-table="production_process_f" data-field="x_a_datetime" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($production_process_f->a_datetime->getPlaceHolder()) ?>" value="<?php echo $production_process_f->a_datetime->EditValue ?>"<?php echo $production_process_f->a_datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_process_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_process_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_process_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_process_f_search->terminate();
?>