<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_process_add = new production_process_add();

// Run the page
$production_process_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_process_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduction_processadd = currentForm = new ew.Form("fproduction_processadd", "add");

// Validate form
fproduction_processadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($production_process_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->grp->caption(), $production_process->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->s_grp->caption(), $production_process->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->product->caption(), $production_process->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->rid->caption(), $production_process->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->batch_no->caption(), $production_process->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->sequence->Required) { ?>
			elm = this.getElements("x" + infix + "_sequence");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->sequence->caption(), $production_process->sequence->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->process->caption(), $production_process->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->material->caption(), $production_process->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->remarks->caption(), $production_process->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->quantity->caption(), $production_process->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_process->quantity->errorMessage()) ?>");
		<?php if ($production_process_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->operator->caption(), $production_process->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->datetime->caption(), $production_process->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_add->a_process->Required) { ?>
			elm = this.getElements("x" + infix + "_a_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->a_process->caption(), $production_process->a_process->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduction_processadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_processadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_processadd.lists["x_grp"] = <?php echo $production_process_add->grp->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_grp"].options = <?php echo JsonEncode($production_process_add->grp->lookupOptions()) ?>;
fproduction_processadd.lists["x_s_grp"] = <?php echo $production_process_add->s_grp->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_s_grp"].options = <?php echo JsonEncode($production_process_add->s_grp->lookupOptions()) ?>;
fproduction_processadd.lists["x_product"] = <?php echo $production_process_add->product->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_product"].options = <?php echo JsonEncode($production_process_add->product->lookupOptions()) ?>;
fproduction_processadd.lists["x_rid"] = <?php echo $production_process_add->rid->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_rid"].options = <?php echo JsonEncode($production_process_add->rid->lookupOptions()) ?>;
fproduction_processadd.lists["x_batch_no"] = <?php echo $production_process_add->batch_no->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_batch_no"].options = <?php echo JsonEncode($production_process_add->batch_no->lookupOptions()) ?>;
fproduction_processadd.lists["x_process"] = <?php echo $production_process_add->process->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_process"].options = <?php echo JsonEncode($production_process_add->process->lookupOptions()) ?>;
fproduction_processadd.lists["x_material[]"] = <?php echo $production_process_add->material->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_material[]"].options = <?php echo JsonEncode($production_process_add->material->lookupOptions()) ?>;
fproduction_processadd.lists["x_operator"] = <?php echo $production_process_add->operator->Lookup->toClientList() ?>;
fproduction_processadd.lists["x_operator"].options = <?php echo JsonEncode($production_process_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $production_process_add->showPageHeader(); ?>
<?php
$production_process_add->showMessage();
?>
<form name="fproduction_processadd" id="fproduction_processadd" class="<?php echo $production_process_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_process_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_process_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_process">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$production_process_add->IsModal ?>">
<?php if ($production_process->getCurrentMasterTable() == "batch_no") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="batch_no">
<input type="hidden" name="fk_id" value="<?php echo $production_process->batch_no->getSessionValue() ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($production_process->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_production_process_grp" for="x_grp" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->grp->caption() ?><?php echo ($production_process->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->grp->cellAttributes() ?>>
<span id="el_production_process_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_grp" data-value-separator="<?php echo $production_process->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $production_process->grp->editAttributes() ?>>
		<?php echo $production_process->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $production_process->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $production_process->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_production_process_s_grp" for="x_s_grp" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->s_grp->caption() ?><?php echo ($production_process->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->s_grp->cellAttributes() ?>>
<span id="el_production_process_s_grp">
<?php $production_process->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_s_grp" data-value-separator="<?php echo $production_process->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $production_process->s_grp->editAttributes() ?>>
		<?php echo $production_process->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $production_process->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $production_process->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_production_process_product" for="x_product" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->product->caption() ?><?php echo ($production_process->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->product->cellAttributes() ?>>
<span id="el_production_process_product">
<?php $production_process->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_product" data-value-separator="<?php echo $production_process->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $production_process->product->editAttributes() ?>>
		<?php echo $production_process->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $production_process->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $production_process->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_production_process_rid" for="x_rid" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->rid->caption() ?><?php echo ($production_process->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->rid->cellAttributes() ?>>
<span id="el_production_process_rid">
<?php $production_process->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_rid" data-value-separator="<?php echo $production_process->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $production_process->rid->editAttributes() ?>>
		<?php echo $production_process->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $production_process->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $production_process->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_production_process_batch_no" for="x_batch_no" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->batch_no->caption() ?><?php echo ($production_process->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->batch_no->cellAttributes() ?>>
<?php if ($production_process->batch_no->getSessionValue() <> "") { ?>
<span id="el_production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_batch_no" name="x_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->CurrentValue) ?>">
<?php } else { ?>
<span id="el_production_process_batch_no">
<?php $production_process->batch_no->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->batch_no->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_batch_no" data-value-separator="<?php echo $production_process->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $production_process->batch_no->editAttributes() ?>>
		<?php echo $production_process->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $production_process->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php } ?>
<?php echo $production_process->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->sequence->Visible) { // sequence ?>
	<div id="r_sequence" class="form-group row">
		<label id="elh_production_process_sequence" for="x_sequence" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->sequence->caption() ?><?php echo ($production_process->sequence->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->sequence->cellAttributes() ?>>
<span id="el_production_process_sequence">
<input type="text" data-table="production_process" data-field="x_sequence" name="x_sequence" id="x_sequence" size="30" placeholder="<?php echo HtmlEncode($production_process->sequence->getPlaceHolder()) ?>" value="<?php echo $production_process->sequence->EditValue ?>"<?php echo $production_process->sequence->editAttributes() ?>>
</span>
<?php echo $production_process->sequence->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_production_process_process" for="x_process" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->process->caption() ?><?php echo ($production_process->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->process->cellAttributes() ?>>
<span id="el_production_process_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_process" data-value-separator="<?php echo $production_process->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $production_process->process->editAttributes() ?>>
		<?php echo $production_process->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $production_process->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $production_process->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label id="elh_production_process_material" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->material->caption() ?><?php echo ($production_process->material->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->material->cellAttributes() ?>>
<span id="el_production_process_material">
<div id="tp_x_material" class="ew-template"><input type="checkbox" class="form-check-input" data-table="production_process" data-field="x_material" data-value-separator="<?php echo $production_process->material->displayValueSeparatorAttribute() ?>" name="x_material[]" id="x_material[]" value="{value}"<?php echo $production_process->material->editAttributes() ?>></div>
<div id="dsl_x_material" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $production_process->material->checkBoxListHtml(FALSE, "x_material[]") ?>
</div></div>
<?php echo $production_process->material->Lookup->getParamTag("p_x_material") ?>
</span>
<?php echo $production_process->material->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_production_process_remarks" for="x_remarks" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->remarks->caption() ?><?php echo ($production_process->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->remarks->cellAttributes() ?>>
<span id="el_production_process_remarks">
<textarea data-table="production_process" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="5" placeholder="<?php echo HtmlEncode($production_process->remarks->getPlaceHolder()) ?>"<?php echo $production_process->remarks->editAttributes() ?>><?php echo $production_process->remarks->EditValue ?></textarea>
</span>
<?php echo $production_process->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_production_process_quantity" for="x_quantity" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->quantity->caption() ?><?php echo ($production_process->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->quantity->cellAttributes() ?>>
<span id="el_production_process_quantity">
<input type="text" data-table="production_process" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($production_process->quantity->getPlaceHolder()) ?>" value="<?php echo $production_process->quantity->EditValue ?>"<?php echo $production_process->quantity->editAttributes() ?>>
</span>
<?php echo $production_process->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_process->a_process->Visible) { // a_process ?>
	<div id="r_a_process" class="form-group row">
		<label id="elh_production_process_a_process" for="x_a_process" class="<?php echo $production_process_add->LeftColumnClass ?>"><?php echo $production_process->a_process->caption() ?><?php echo ($production_process->a_process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_process_add->RightColumnClass ?>"><div<?php echo $production_process->a_process->cellAttributes() ?>>
<span id="el_production_process_a_process">
<input type="text" data-table="production_process" data-field="x_a_process" name="x_a_process" id="x_a_process" size="30" maxlength="198" placeholder="<?php echo HtmlEncode($production_process->a_process->getPlaceHolder()) ?>" value="<?php echo $production_process->a_process->EditValue ?>"<?php echo $production_process->a_process->editAttributes() ?>>
</span>
<?php echo $production_process->a_process->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_process_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_process_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_process_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_process_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$production_process_add->terminate();
?>