<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($production_process_grid))
	$production_process_grid = new production_process_grid();

// Run the page
$production_process_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_process_grid->Page_Render();
?>
<?php if (!$production_process->isExport()) { ?>
<script>

// Form object
var fproduction_processgrid = new ew.Form("fproduction_processgrid", "grid");
fproduction_processgrid.formKeyCountName = '<?php echo $production_process_grid->FormKeyCountName ?>';

// Validate form
fproduction_processgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($production_process_grid->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->id->caption(), $production_process->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->product->caption(), $production_process->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->rid->caption(), $production_process->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->batch_no->caption(), $production_process->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->sequence->Required) { ?>
			elm = this.getElements("x" + infix + "_sequence");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->sequence->caption(), $production_process->sequence->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->process->caption(), $production_process->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->material_name->Required) { ?>
			elm = this.getElements("x" + infix + "_material_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->material_name->caption(), $production_process->material_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->remarks->caption(), $production_process->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->quantity->caption(), $production_process->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_process->quantity->errorMessage()) ?>");
		<?php if ($production_process_grid->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->operator->caption(), $production_process->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->datetime->caption(), $production_process->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->a_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_a_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->a_operator->caption(), $production_process->a_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($production_process_grid->a_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_a_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->a_datetime->caption(), $production_process->a_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_a_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($production_process->a_datetime->errorMessage()) ?>");
		<?php if ($production_process_grid->a_process->Required) { ?>
			elm = this.getElements("x" + infix + "_a_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_process->a_process->caption(), $production_process->a_process->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fproduction_processgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "batch_no", false)) return false;
	if (ew.valueChanged(fobj, infix, "sequence", false)) return false;
	if (ew.valueChanged(fobj, infix, "process", false)) return false;
	if (ew.valueChanged(fobj, infix, "material_name", false)) return false;
	if (ew.valueChanged(fobj, infix, "remarks", false)) return false;
	if (ew.valueChanged(fobj, infix, "quantity", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_operator", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_datetime", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_process", false)) return false;
	return true;
}

// Form_CustomValidate event
fproduction_processgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_processgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_processgrid.lists["x_product"] = <?php echo $production_process_grid->product->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_product"].options = <?php echo JsonEncode($production_process_grid->product->lookupOptions()) ?>;
fproduction_processgrid.lists["x_rid"] = <?php echo $production_process_grid->rid->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_rid"].options = <?php echo JsonEncode($production_process_grid->rid->lookupOptions()) ?>;
fproduction_processgrid.lists["x_batch_no"] = <?php echo $production_process_grid->batch_no->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_batch_no"].options = <?php echo JsonEncode($production_process_grid->batch_no->lookupOptions()) ?>;
fproduction_processgrid.lists["x_process"] = <?php echo $production_process_grid->process->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_process"].options = <?php echo JsonEncode($production_process_grid->process->lookupOptions()) ?>;
fproduction_processgrid.lists["x_operator"] = <?php echo $production_process_grid->operator->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_operator"].options = <?php echo JsonEncode($production_process_grid->operator->lookupOptions()) ?>;
fproduction_processgrid.lists["x_a_operator"] = <?php echo $production_process_grid->a_operator->Lookup->toClientList() ?>;
fproduction_processgrid.lists["x_a_operator"].options = <?php echo JsonEncode($production_process_grid->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$production_process_grid->renderOtherOptions();
?>
<?php $production_process_grid->showPageHeader(); ?>
<?php
$production_process_grid->showMessage();
?>
<?php if ($production_process_grid->TotalRecs > 0 || $production_process->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_process_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_process">
<?php if ($production_process_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $production_process_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fproduction_processgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_production_process" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_production_processgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_process_grid->RowType = ROWTYPE_HEADER;

// Render list options
$production_process_grid->renderListOptions();

// Render list options (header, left)
$production_process_grid->ListOptions->render("header", "left");
?>
<?php if ($production_process->id->Visible) { // id ?>
	<?php if ($production_process->sortUrl($production_process->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_process->id->headerCellClass() ?>"><div id="elh_production_process_id" class="production_process_id"><div class="ew-table-header-caption"><?php echo $production_process->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_process->id->headerCellClass() ?>"><div><div id="elh_production_process_id" class="production_process_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->product->Visible) { // product ?>
	<?php if ($production_process->sortUrl($production_process->product) == "") { ?>
		<th data-name="product" class="<?php echo $production_process->product->headerCellClass() ?>"><div id="elh_production_process_product" class="production_process_product"><div class="ew-table-header-caption"><?php echo $production_process->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $production_process->product->headerCellClass() ?>"><div><div id="elh_production_process_product" class="production_process_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->rid->Visible) { // rid ?>
	<?php if ($production_process->sortUrl($production_process->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $production_process->rid->headerCellClass() ?>"><div id="elh_production_process_rid" class="production_process_rid"><div class="ew-table-header-caption"><?php echo $production_process->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $production_process->rid->headerCellClass() ?>"><div><div id="elh_production_process_rid" class="production_process_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->batch_no->Visible) { // batch_no ?>
	<?php if ($production_process->sortUrl($production_process->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $production_process->batch_no->headerCellClass() ?>"><div id="elh_production_process_batch_no" class="production_process_batch_no"><div class="ew-table-header-caption"><?php echo $production_process->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $production_process->batch_no->headerCellClass() ?>"><div><div id="elh_production_process_batch_no" class="production_process_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->sequence->Visible) { // sequence ?>
	<?php if ($production_process->sortUrl($production_process->sequence) == "") { ?>
		<th data-name="sequence" class="<?php echo $production_process->sequence->headerCellClass() ?>"><div id="elh_production_process_sequence" class="production_process_sequence"><div class="ew-table-header-caption"><?php echo $production_process->sequence->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sequence" class="<?php echo $production_process->sequence->headerCellClass() ?>"><div><div id="elh_production_process_sequence" class="production_process_sequence">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->sequence->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->sequence->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->sequence->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->process->Visible) { // process ?>
	<?php if ($production_process->sortUrl($production_process->process) == "") { ?>
		<th data-name="process" class="<?php echo $production_process->process->headerCellClass() ?>"><div id="elh_production_process_process" class="production_process_process"><div class="ew-table-header-caption"><?php echo $production_process->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $production_process->process->headerCellClass() ?>"><div><div id="elh_production_process_process" class="production_process_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->material_name->Visible) { // material_name ?>
	<?php if ($production_process->sortUrl($production_process->material_name) == "") { ?>
		<th data-name="material_name" class="<?php echo $production_process->material_name->headerCellClass() ?>"><div id="elh_production_process_material_name" class="production_process_material_name"><div class="ew-table-header-caption"><?php echo $production_process->material_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_name" class="<?php echo $production_process->material_name->headerCellClass() ?>"><div><div id="elh_production_process_material_name" class="production_process_material_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->material_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->material_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->material_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->remarks->Visible) { // remarks ?>
	<?php if ($production_process->sortUrl($production_process->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $production_process->remarks->headerCellClass() ?>"><div id="elh_production_process_remarks" class="production_process_remarks"><div class="ew-table-header-caption"><?php echo $production_process->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $production_process->remarks->headerCellClass() ?>"><div><div id="elh_production_process_remarks" class="production_process_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->quantity->Visible) { // quantity ?>
	<?php if ($production_process->sortUrl($production_process->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $production_process->quantity->headerCellClass() ?>"><div id="elh_production_process_quantity" class="production_process_quantity"><div class="ew-table-header-caption"><?php echo $production_process->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $production_process->quantity->headerCellClass() ?>"><div><div id="elh_production_process_quantity" class="production_process_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->operator->Visible) { // operator ?>
	<?php if ($production_process->sortUrl($production_process->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_process->operator->headerCellClass() ?>"><div id="elh_production_process_operator" class="production_process_operator"><div class="ew-table-header-caption"><?php echo $production_process->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_process->operator->headerCellClass() ?>"><div><div id="elh_production_process_operator" class="production_process_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->datetime->Visible) { // datetime ?>
	<?php if ($production_process->sortUrl($production_process->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_process->datetime->headerCellClass() ?>"><div id="elh_production_process_datetime" class="production_process_datetime"><div class="ew-table-header-caption"><?php echo $production_process->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_process->datetime->headerCellClass() ?>"><div><div id="elh_production_process_datetime" class="production_process_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_operator->Visible) { // a_operator ?>
	<?php if ($production_process->sortUrl($production_process->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $production_process->a_operator->headerCellClass() ?>"><div id="elh_production_process_a_operator" class="production_process_a_operator"><div class="ew-table-header-caption"><?php echo $production_process->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $production_process->a_operator->headerCellClass() ?>"><div><div id="elh_production_process_a_operator" class="production_process_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
	<?php if ($production_process->sortUrl($production_process->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><div id="elh_production_process_a_datetime" class="production_process_a_datetime"><div class="ew-table-header-caption"><?php echo $production_process->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><div><div id="elh_production_process_a_datetime" class="production_process_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_process->Visible) { // a_process ?>
	<?php if ($production_process->sortUrl($production_process->a_process) == "") { ?>
		<th data-name="a_process" class="<?php echo $production_process->a_process->headerCellClass() ?>"><div id="elh_production_process_a_process" class="production_process_a_process"><div class="ew-table-header-caption"><?php echo $production_process->a_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_process" class="<?php echo $production_process->a_process->headerCellClass() ?>"><div><div id="elh_production_process_a_process" class="production_process_a_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_process_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$production_process_grid->StartRec = 1;
$production_process_grid->StopRec = $production_process_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $production_process_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($production_process_grid->FormKeyCountName) && ($production_process->isGridAdd() || $production_process->isGridEdit() || $production_process->isConfirm())) {
		$production_process_grid->KeyCount = $CurrentForm->getValue($production_process_grid->FormKeyCountName);
		$production_process_grid->StopRec = $production_process_grid->StartRec + $production_process_grid->KeyCount - 1;
	}
}
$production_process_grid->RecCnt = $production_process_grid->StartRec - 1;
if ($production_process_grid->Recordset && !$production_process_grid->Recordset->EOF) {
	$production_process_grid->Recordset->moveFirst();
	$selectLimit = $production_process_grid->UseSelectLimit;
	if (!$selectLimit && $production_process_grid->StartRec > 1)
		$production_process_grid->Recordset->move($production_process_grid->StartRec - 1);
} elseif (!$production_process->AllowAddDeleteRow && $production_process_grid->StopRec == 0) {
	$production_process_grid->StopRec = $production_process->GridAddRowCount;
}

// Initialize aggregate
$production_process->RowType = ROWTYPE_AGGREGATEINIT;
$production_process->resetAttributes();
$production_process_grid->renderRow();
if ($production_process->isGridAdd())
	$production_process_grid->RowIndex = 0;
if ($production_process->isGridEdit())
	$production_process_grid->RowIndex = 0;
while ($production_process_grid->RecCnt < $production_process_grid->StopRec) {
	$production_process_grid->RecCnt++;
	if ($production_process_grid->RecCnt >= $production_process_grid->StartRec) {
		$production_process_grid->RowCnt++;
		if ($production_process->isGridAdd() || $production_process->isGridEdit() || $production_process->isConfirm()) {
			$production_process_grid->RowIndex++;
			$CurrentForm->Index = $production_process_grid->RowIndex;
			if ($CurrentForm->hasValue($production_process_grid->FormActionName) && $production_process_grid->EventCancelled)
				$production_process_grid->RowAction = strval($CurrentForm->getValue($production_process_grid->FormActionName));
			elseif ($production_process->isGridAdd())
				$production_process_grid->RowAction = "insert";
			else
				$production_process_grid->RowAction = "";
		}

		// Set up key count
		$production_process_grid->KeyCount = $production_process_grid->RowIndex;

		// Init row class and style
		$production_process->resetAttributes();
		$production_process->CssClass = "";
		if ($production_process->isGridAdd()) {
			if ($production_process->CurrentMode == "copy") {
				$production_process_grid->loadRowValues($production_process_grid->Recordset); // Load row values
				$production_process_grid->setRecordKey($production_process_grid->RowOldKey, $production_process_grid->Recordset); // Set old record key
			} else {
				$production_process_grid->loadRowValues(); // Load default values
				$production_process_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$production_process_grid->loadRowValues($production_process_grid->Recordset); // Load row values
		}
		$production_process->RowType = ROWTYPE_VIEW; // Render view
		if ($production_process->isGridAdd()) // Grid add
			$production_process->RowType = ROWTYPE_ADD; // Render add
		if ($production_process->isGridAdd() && $production_process->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$production_process_grid->restoreCurrentRowFormValues($production_process_grid->RowIndex); // Restore form values
		if ($production_process->isGridEdit()) { // Grid edit
			if ($production_process->EventCancelled)
				$production_process_grid->restoreCurrentRowFormValues($production_process_grid->RowIndex); // Restore form values
			if ($production_process_grid->RowAction == "insert")
				$production_process->RowType = ROWTYPE_ADD; // Render add
			else
				$production_process->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($production_process->isGridEdit() && ($production_process->RowType == ROWTYPE_EDIT || $production_process->RowType == ROWTYPE_ADD) && $production_process->EventCancelled) // Update failed
			$production_process_grid->restoreCurrentRowFormValues($production_process_grid->RowIndex); // Restore form values
		if ($production_process->RowType == ROWTYPE_EDIT) // Edit row
			$production_process_grid->EditRowCnt++;
		if ($production_process->isConfirm()) // Confirm row
			$production_process_grid->restoreCurrentRowFormValues($production_process_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$production_process->RowAttrs = array_merge($production_process->RowAttrs, array('data-rowindex'=>$production_process_grid->RowCnt, 'id'=>'r' . $production_process_grid->RowCnt . '_production_process', 'data-rowtype'=>$production_process->RowType));

		// Render row
		$production_process_grid->renderRow();

		// Render list options
		$production_process_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($production_process_grid->RowAction <> "delete" && $production_process_grid->RowAction <> "insertdelete" && !($production_process_grid->RowAction == "insert" && $production_process->isConfirm() && $production_process_grid->emptyRow())) {
?>
	<tr<?php echo $production_process->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_process_grid->ListOptions->render("body", "left", $production_process_grid->RowCnt);
?>
	<?php if ($production_process->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_process->id->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="production_process" data-field="x_id" name="o<?php echo $production_process_grid->RowIndex ?>_id" id="o<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_id" class="form-group production_process_id">
<span<?php echo $production_process->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_id" name="x<?php echo $production_process_grid->RowIndex ?>_id" id="x<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->CurrentValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_id" class="production_process_id">
<span<?php echo $production_process->id->viewAttributes() ?>>
<?php echo $production_process->id->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_id" name="x<?php echo $production_process_grid->RowIndex ?>_id" id="x<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_id" name="o<?php echo $production_process_grid->RowIndex ?>_id" id="o<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_id" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_id" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_id" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_id" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->product->Visible) { // product ?>
		<td data-name="product"<?php echo $production_process->product->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_product" class="form-group production_process_product">
<?php $production_process->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_product" data-value-separator="<?php echo $production_process->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_product" name="x<?php echo $production_process_grid->RowIndex ?>_product"<?php echo $production_process->product->editAttributes() ?>>
		<?php echo $production_process->product->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $production_process->product->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="production_process" data-field="x_product" name="o<?php echo $production_process_grid->RowIndex ?>_product" id="o<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_product" class="form-group production_process_product">
<?php $production_process->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_product" data-value-separator="<?php echo $production_process->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_product" name="x<?php echo $production_process_grid->RowIndex ?>_product"<?php echo $production_process->product->editAttributes() ?>>
		<?php echo $production_process->product->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $production_process->product->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_product" class="production_process_product">
<span<?php echo $production_process->product->viewAttributes() ?>>
<?php echo $production_process->product->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_product" name="x<?php echo $production_process_grid->RowIndex ?>_product" id="x<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_product" name="o<?php echo $production_process_grid->RowIndex ?>_product" id="o<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_product" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_product" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_product" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_product" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $production_process->rid->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_rid" class="form-group production_process_rid">
<?php $production_process->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_rid" data-value-separator="<?php echo $production_process->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_rid" name="x<?php echo $production_process_grid->RowIndex ?>_rid"<?php echo $production_process->rid->editAttributes() ?>>
		<?php echo $production_process->rid->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $production_process->rid->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="production_process" data-field="x_rid" name="o<?php echo $production_process_grid->RowIndex ?>_rid" id="o<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_rid" class="form-group production_process_rid">
<?php $production_process->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_rid" data-value-separator="<?php echo $production_process->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_rid" name="x<?php echo $production_process_grid->RowIndex ?>_rid"<?php echo $production_process->rid->editAttributes() ?>>
		<?php echo $production_process->rid->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $production_process->rid->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_rid" class="production_process_rid">
<span<?php echo $production_process->rid->viewAttributes() ?>>
<?php echo $production_process->rid->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_rid" name="x<?php echo $production_process_grid->RowIndex ?>_rid" id="x<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_rid" name="o<?php echo $production_process_grid->RowIndex ?>_rid" id="o<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_rid" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_rid" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_rid" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_rid" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $production_process->batch_no->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($production_process->batch_no->getSessionValue() <> "") { ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_batch_no" class="form-group production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_batch_no" class="form-group production_process_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_batch_no" data-value-separator="<?php echo $production_process->batch_no->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no"<?php echo $production_process->batch_no->editAttributes() ?>>
		<?php echo $production_process->batch_no->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_batch_no") ?>
	</select>
</div>
<?php echo $production_process->batch_no->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_batch_no") ?>
</span>
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="o<?php echo $production_process_grid->RowIndex ?>_batch_no" id="o<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($production_process->batch_no->getSessionValue() <> "") { ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_batch_no" class="form-group production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_batch_no" class="form-group production_process_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_batch_no" data-value-separator="<?php echo $production_process->batch_no->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no"<?php echo $production_process->batch_no->editAttributes() ?>>
		<?php echo $production_process->batch_no->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_batch_no") ?>
	</select>
</div>
<?php echo $production_process->batch_no->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_batch_no") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_batch_no" class="production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<?php echo $production_process->batch_no->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="o<?php echo $production_process_grid->RowIndex ?>_batch_no" id="o<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_batch_no" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_batch_no" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->sequence->Visible) { // sequence ?>
		<td data-name="sequence"<?php echo $production_process->sequence->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_sequence" class="form-group production_process_sequence">
<input type="text" data-table="production_process" data-field="x_sequence" name="x<?php echo $production_process_grid->RowIndex ?>_sequence" id="x<?php echo $production_process_grid->RowIndex ?>_sequence" size="30" placeholder="<?php echo HtmlEncode($production_process->sequence->getPlaceHolder()) ?>" value="<?php echo $production_process->sequence->EditValue ?>"<?php echo $production_process->sequence->editAttributes() ?>>
</span>
<input type="hidden" data-table="production_process" data-field="x_sequence" name="o<?php echo $production_process_grid->RowIndex ?>_sequence" id="o<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_sequence" class="form-group production_process_sequence">
<input type="text" data-table="production_process" data-field="x_sequence" name="x<?php echo $production_process_grid->RowIndex ?>_sequence" id="x<?php echo $production_process_grid->RowIndex ?>_sequence" size="30" placeholder="<?php echo HtmlEncode($production_process->sequence->getPlaceHolder()) ?>" value="<?php echo $production_process->sequence->EditValue ?>"<?php echo $production_process->sequence->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_sequence" class="production_process_sequence">
<span<?php echo $production_process->sequence->viewAttributes() ?>>
<?php echo $production_process->sequence->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_sequence" name="x<?php echo $production_process_grid->RowIndex ?>_sequence" id="x<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_sequence" name="o<?php echo $production_process_grid->RowIndex ?>_sequence" id="o<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_sequence" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_sequence" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_sequence" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_sequence" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->process->Visible) { // process ?>
		<td data-name="process"<?php echo $production_process->process->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_process" class="form-group production_process_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_process" data-value-separator="<?php echo $production_process->process->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_process" name="x<?php echo $production_process_grid->RowIndex ?>_process"<?php echo $production_process->process->editAttributes() ?>>
		<?php echo $production_process->process->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_process") ?>
	</select>
</div>
<?php echo $production_process->process->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_process") ?>
</span>
<input type="hidden" data-table="production_process" data-field="x_process" name="o<?php echo $production_process_grid->RowIndex ?>_process" id="o<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_process" class="form-group production_process_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_process" data-value-separator="<?php echo $production_process->process->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_process" name="x<?php echo $production_process_grid->RowIndex ?>_process"<?php echo $production_process->process->editAttributes() ?>>
		<?php echo $production_process->process->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_process") ?>
	</select>
</div>
<?php echo $production_process->process->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_process") ?>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_process" class="production_process_process">
<span<?php echo $production_process->process->viewAttributes() ?>>
<?php echo $production_process->process->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_process" name="x<?php echo $production_process_grid->RowIndex ?>_process" id="x<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_process" name="o<?php echo $production_process_grid->RowIndex ?>_process" id="o<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_process" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_process" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_process" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_process" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->material_name->Visible) { // material_name ?>
		<td data-name="material_name"<?php echo $production_process->material_name->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_material_name" class="form-group production_process_material_name">
<input type="text" data-table="production_process" data-field="x_material_name" name="x<?php echo $production_process_grid->RowIndex ?>_material_name" id="x<?php echo $production_process_grid->RowIndex ?>_material_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_process->material_name->getPlaceHolder()) ?>" value="<?php echo $production_process->material_name->EditValue ?>"<?php echo $production_process->material_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="production_process" data-field="x_material_name" name="o<?php echo $production_process_grid->RowIndex ?>_material_name" id="o<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_material_name" class="form-group production_process_material_name">
<input type="text" data-table="production_process" data-field="x_material_name" name="x<?php echo $production_process_grid->RowIndex ?>_material_name" id="x<?php echo $production_process_grid->RowIndex ?>_material_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_process->material_name->getPlaceHolder()) ?>" value="<?php echo $production_process->material_name->EditValue ?>"<?php echo $production_process->material_name->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_material_name" class="production_process_material_name">
<span<?php echo $production_process->material_name->viewAttributes() ?>>
<?php echo $production_process->material_name->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_material_name" name="x<?php echo $production_process_grid->RowIndex ?>_material_name" id="x<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_material_name" name="o<?php echo $production_process_grid->RowIndex ?>_material_name" id="o<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_material_name" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_material_name" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_material_name" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_material_name" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $production_process->remarks->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_remarks" class="form-group production_process_remarks">
<textarea data-table="production_process" data-field="x_remarks" name="x<?php echo $production_process_grid->RowIndex ?>_remarks" id="x<?php echo $production_process_grid->RowIndex ?>_remarks" cols="31" rows="5" placeholder="<?php echo HtmlEncode($production_process->remarks->getPlaceHolder()) ?>"<?php echo $production_process->remarks->editAttributes() ?>><?php echo $production_process->remarks->EditValue ?></textarea>
</span>
<input type="hidden" data-table="production_process" data-field="x_remarks" name="o<?php echo $production_process_grid->RowIndex ?>_remarks" id="o<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_remarks" class="form-group production_process_remarks">
<textarea data-table="production_process" data-field="x_remarks" name="x<?php echo $production_process_grid->RowIndex ?>_remarks" id="x<?php echo $production_process_grid->RowIndex ?>_remarks" cols="31" rows="5" placeholder="<?php echo HtmlEncode($production_process->remarks->getPlaceHolder()) ?>"<?php echo $production_process->remarks->editAttributes() ?>><?php echo $production_process->remarks->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_remarks" class="production_process_remarks">
<span<?php echo $production_process->remarks->viewAttributes() ?>>
<?php echo $production_process->remarks->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_remarks" name="x<?php echo $production_process_grid->RowIndex ?>_remarks" id="x<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_remarks" name="o<?php echo $production_process_grid->RowIndex ?>_remarks" id="o<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_remarks" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_remarks" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_remarks" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_remarks" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $production_process->quantity->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_quantity" class="form-group production_process_quantity">
<input type="text" data-table="production_process" data-field="x_quantity" name="x<?php echo $production_process_grid->RowIndex ?>_quantity" id="x<?php echo $production_process_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($production_process->quantity->getPlaceHolder()) ?>" value="<?php echo $production_process->quantity->EditValue ?>"<?php echo $production_process->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="production_process" data-field="x_quantity" name="o<?php echo $production_process_grid->RowIndex ?>_quantity" id="o<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_quantity" class="form-group production_process_quantity">
<input type="text" data-table="production_process" data-field="x_quantity" name="x<?php echo $production_process_grid->RowIndex ?>_quantity" id="x<?php echo $production_process_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($production_process->quantity->getPlaceHolder()) ?>" value="<?php echo $production_process->quantity->EditValue ?>"<?php echo $production_process->quantity->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_quantity" class="production_process_quantity">
<span<?php echo $production_process->quantity->viewAttributes() ?>>
<?php echo $production_process->quantity->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_quantity" name="x<?php echo $production_process_grid->RowIndex ?>_quantity" id="x<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_quantity" name="o<?php echo $production_process_grid->RowIndex ?>_quantity" id="o<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_quantity" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_quantity" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_quantity" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_quantity" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_process->operator->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="production_process" data-field="x_operator" name="o<?php echo $production_process_grid->RowIndex ?>_operator" id="o<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_operator" class="production_process_operator">
<span<?php echo $production_process->operator->viewAttributes() ?>>
<?php echo $production_process->operator->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_operator" name="x<?php echo $production_process_grid->RowIndex ?>_operator" id="x<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_operator" name="o<?php echo $production_process_grid->RowIndex ?>_operator" id="o<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_operator" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_operator" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_operator" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_operator" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_process->datetime->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="production_process" data-field="x_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_datetime" class="production_process_datetime">
<span<?php echo $production_process->datetime->viewAttributes() ?>>
<?php echo $production_process->datetime->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_datetime" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_datetime" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_datetime" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_datetime" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $production_process->a_operator->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_operator" class="form-group production_process_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_a_operator" data-value-separator="<?php echo $production_process->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_a_operator" name="x<?php echo $production_process_grid->RowIndex ?>_a_operator"<?php echo $production_process->a_operator->editAttributes() ?>>
		<?php echo $production_process->a_operator->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $production_process->a_operator->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="o<?php echo $production_process_grid->RowIndex ?>_a_operator" id="o<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_operator" class="form-group production_process_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_a_operator" data-value-separator="<?php echo $production_process->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_a_operator" name="x<?php echo $production_process_grid->RowIndex ?>_a_operator"<?php echo $production_process->a_operator->editAttributes() ?>>
		<?php echo $production_process->a_operator->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $production_process->a_operator->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_a_operator") ?>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_operator" class="production_process_a_operator">
<span<?php echo $production_process->a_operator->viewAttributes() ?>>
<?php echo $production_process->a_operator->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="x<?php echo $production_process_grid->RowIndex ?>_a_operator" id="x<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="o<?php echo $production_process_grid->RowIndex ?>_a_operator" id="o<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_operator" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_operator" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $production_process->a_datetime->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_datetime" class="form-group production_process_a_datetime">
<input type="text" data-table="production_process" data-field="x_a_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($production_process->a_datetime->getPlaceHolder()) ?>" value="<?php echo $production_process->a_datetime->EditValue ?>"<?php echo $production_process->a_datetime->editAttributes() ?>>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_datetime" class="form-group production_process_a_datetime">
<input type="text" data-table="production_process" data-field="x_a_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($production_process->a_datetime->getPlaceHolder()) ?>" value="<?php echo $production_process->a_datetime->EditValue ?>"<?php echo $production_process->a_datetime->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_datetime" class="production_process_a_datetime">
<span<?php echo $production_process->a_datetime->viewAttributes() ?>>
<?php echo $production_process->a_datetime->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_process->a_process->Visible) { // a_process ?>
		<td data-name="a_process"<?php echo $production_process->a_process->cellAttributes() ?>>
<?php if ($production_process->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_process" class="form-group production_process_a_process">
<input type="text" data-table="production_process" data-field="x_a_process" name="x<?php echo $production_process_grid->RowIndex ?>_a_process" id="x<?php echo $production_process_grid->RowIndex ?>_a_process" size="30" maxlength="198" placeholder="<?php echo HtmlEncode($production_process->a_process->getPlaceHolder()) ?>" value="<?php echo $production_process->a_process->EditValue ?>"<?php echo $production_process->a_process->editAttributes() ?>>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_process" name="o<?php echo $production_process_grid->RowIndex ?>_a_process" id="o<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->OldValue) ?>">
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_process" class="form-group production_process_a_process">
<input type="text" data-table="production_process" data-field="x_a_process" name="x<?php echo $production_process_grid->RowIndex ?>_a_process" id="x<?php echo $production_process_grid->RowIndex ?>_a_process" size="30" maxlength="198" placeholder="<?php echo HtmlEncode($production_process->a_process->getPlaceHolder()) ?>" value="<?php echo $production_process->a_process->EditValue ?>"<?php echo $production_process->a_process->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production_process->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_process_grid->RowCnt ?>_production_process_a_process" class="production_process_a_process">
<span<?php echo $production_process->a_process->viewAttributes() ?>>
<?php echo $production_process->a_process->getViewValue() ?></span>
</span>
<?php if (!$production_process->isConfirm()) { ?>
<input type="hidden" data-table="production_process" data-field="x_a_process" name="x<?php echo $production_process_grid->RowIndex ?>_a_process" id="x<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_process" name="o<?php echo $production_process_grid->RowIndex ?>_a_process" id="o<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production_process" data-field="x_a_process" name="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_process" id="fproduction_processgrid$x<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->FormValue) ?>">
<input type="hidden" data-table="production_process" data-field="x_a_process" name="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_process" id="fproduction_processgrid$o<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_process_grid->ListOptions->render("body", "right", $production_process_grid->RowCnt);
?>
	</tr>
<?php if ($production_process->RowType == ROWTYPE_ADD || $production_process->RowType == ROWTYPE_EDIT) { ?>
<script>
fproduction_processgrid.updateLists(<?php echo $production_process_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$production_process->isGridAdd() || $production_process->CurrentMode == "copy")
		if (!$production_process_grid->Recordset->EOF)
			$production_process_grid->Recordset->moveNext();
}
?>
<?php
	if ($production_process->CurrentMode == "add" || $production_process->CurrentMode == "copy" || $production_process->CurrentMode == "edit") {
		$production_process_grid->RowIndex = '$rowindex$';
		$production_process_grid->loadRowValues();

		// Set row properties
		$production_process->resetAttributes();
		$production_process->RowAttrs = array_merge($production_process->RowAttrs, array('data-rowindex'=>$production_process_grid->RowIndex, 'id'=>'r0_production_process', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($production_process->RowAttrs["class"], "ew-template");
		$production_process->RowType = ROWTYPE_ADD;

		// Render row
		$production_process_grid->renderRow();

		// Render list options
		$production_process_grid->renderListOptions();
		$production_process_grid->StartRowCnt = 0;
?>
	<tr<?php echo $production_process->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_process_grid->ListOptions->render("body", "left", $production_process_grid->RowIndex);
?>
	<?php if ($production_process->id->Visible) { // id ?>
		<td data-name="id">
<?php if (!$production_process->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_production_process_id" class="form-group production_process_id">
<span<?php echo $production_process->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_id" name="x<?php echo $production_process_grid->RowIndex ?>_id" id="x<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_id" name="o<?php echo $production_process_grid->RowIndex ?>_id" id="o<?php echo $production_process_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($production_process->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->product->Visible) { // product ?>
		<td data-name="product">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_product" class="form-group production_process_product">
<?php $production_process->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_product" data-value-separator="<?php echo $production_process->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_product" name="x<?php echo $production_process_grid->RowIndex ?>_product"<?php echo $production_process->product->editAttributes() ?>>
		<?php echo $production_process->product->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $production_process->product->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_product") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_product" class="form-group production_process_product">
<span<?php echo $production_process->product->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->product->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_product" name="x<?php echo $production_process_grid->RowIndex ?>_product" id="x<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_product" name="o<?php echo $production_process_grid->RowIndex ?>_product" id="o<?php echo $production_process_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($production_process->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->rid->Visible) { // rid ?>
		<td data-name="rid">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_rid" class="form-group production_process_rid">
<?php $production_process->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$production_process->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_rid" data-value-separator="<?php echo $production_process->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_rid" name="x<?php echo $production_process_grid->RowIndex ?>_rid"<?php echo $production_process->rid->editAttributes() ?>>
		<?php echo $production_process->rid->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $production_process->rid->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_rid") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_rid" class="form-group production_process_rid">
<span<?php echo $production_process->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_rid" name="x<?php echo $production_process_grid->RowIndex ?>_rid" id="x<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_rid" name="o<?php echo $production_process_grid->RowIndex ?>_rid" id="o<?php echo $production_process_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($production_process->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no">
<?php if (!$production_process->isConfirm()) { ?>
<?php if ($production_process->batch_no->getSessionValue() <> "") { ?>
<span id="el$rowindex$_production_process_batch_no" class="form-group production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_production_process_batch_no" class="form-group production_process_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_batch_no" data-value-separator="<?php echo $production_process->batch_no->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no"<?php echo $production_process->batch_no->editAttributes() ?>>
		<?php echo $production_process->batch_no->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_batch_no") ?>
	</select>
</div>
<?php echo $production_process->batch_no->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_batch_no") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_production_process_batch_no" class="form-group production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->batch_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="x<?php echo $production_process_grid->RowIndex ?>_batch_no" id="x<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_batch_no" name="o<?php echo $production_process_grid->RowIndex ?>_batch_no" id="o<?php echo $production_process_grid->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($production_process->batch_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->sequence->Visible) { // sequence ?>
		<td data-name="sequence">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_sequence" class="form-group production_process_sequence">
<input type="text" data-table="production_process" data-field="x_sequence" name="x<?php echo $production_process_grid->RowIndex ?>_sequence" id="x<?php echo $production_process_grid->RowIndex ?>_sequence" size="30" placeholder="<?php echo HtmlEncode($production_process->sequence->getPlaceHolder()) ?>" value="<?php echo $production_process->sequence->EditValue ?>"<?php echo $production_process->sequence->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_sequence" class="form-group production_process_sequence">
<span<?php echo $production_process->sequence->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->sequence->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_sequence" name="x<?php echo $production_process_grid->RowIndex ?>_sequence" id="x<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_sequence" name="o<?php echo $production_process_grid->RowIndex ?>_sequence" id="o<?php echo $production_process_grid->RowIndex ?>_sequence" value="<?php echo HtmlEncode($production_process->sequence->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->process->Visible) { // process ?>
		<td data-name="process">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_process" class="form-group production_process_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_process" data-value-separator="<?php echo $production_process->process->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_process" name="x<?php echo $production_process_grid->RowIndex ?>_process"<?php echo $production_process->process->editAttributes() ?>>
		<?php echo $production_process->process->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_process") ?>
	</select>
</div>
<?php echo $production_process->process->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_process") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_process" class="form-group production_process_process">
<span<?php echo $production_process->process->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->process->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_process" name="x<?php echo $production_process_grid->RowIndex ?>_process" id="x<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_process" name="o<?php echo $production_process_grid->RowIndex ?>_process" id="o<?php echo $production_process_grid->RowIndex ?>_process" value="<?php echo HtmlEncode($production_process->process->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->material_name->Visible) { // material_name ?>
		<td data-name="material_name">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_material_name" class="form-group production_process_material_name">
<input type="text" data-table="production_process" data-field="x_material_name" name="x<?php echo $production_process_grid->RowIndex ?>_material_name" id="x<?php echo $production_process_grid->RowIndex ?>_material_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($production_process->material_name->getPlaceHolder()) ?>" value="<?php echo $production_process->material_name->EditValue ?>"<?php echo $production_process->material_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_material_name" class="form-group production_process_material_name">
<span<?php echo $production_process->material_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->material_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_material_name" name="x<?php echo $production_process_grid->RowIndex ?>_material_name" id="x<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_material_name" name="o<?php echo $production_process_grid->RowIndex ?>_material_name" id="o<?php echo $production_process_grid->RowIndex ?>_material_name" value="<?php echo HtmlEncode($production_process->material_name->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->remarks->Visible) { // remarks ?>
		<td data-name="remarks">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_remarks" class="form-group production_process_remarks">
<textarea data-table="production_process" data-field="x_remarks" name="x<?php echo $production_process_grid->RowIndex ?>_remarks" id="x<?php echo $production_process_grid->RowIndex ?>_remarks" cols="31" rows="5" placeholder="<?php echo HtmlEncode($production_process->remarks->getPlaceHolder()) ?>"<?php echo $production_process->remarks->editAttributes() ?>><?php echo $production_process->remarks->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_remarks" class="form-group production_process_remarks">
<span<?php echo $production_process->remarks->viewAttributes() ?>>
<?php echo $production_process->remarks->ViewValue ?></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_remarks" name="x<?php echo $production_process_grid->RowIndex ?>_remarks" id="x<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_remarks" name="o<?php echo $production_process_grid->RowIndex ?>_remarks" id="o<?php echo $production_process_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($production_process->remarks->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->quantity->Visible) { // quantity ?>
		<td data-name="quantity">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_quantity" class="form-group production_process_quantity">
<input type="text" data-table="production_process" data-field="x_quantity" name="x<?php echo $production_process_grid->RowIndex ?>_quantity" id="x<?php echo $production_process_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($production_process->quantity->getPlaceHolder()) ?>" value="<?php echo $production_process->quantity->EditValue ?>"<?php echo $production_process->quantity->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_quantity" class="form-group production_process_quantity">
<span<?php echo $production_process->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->quantity->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_quantity" name="x<?php echo $production_process_grid->RowIndex ?>_quantity" id="x<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_quantity" name="o<?php echo $production_process_grid->RowIndex ?>_quantity" id="o<?php echo $production_process_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($production_process->quantity->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->operator->Visible) { // operator ?>
		<td data-name="operator">
<?php if (!$production_process->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_production_process_operator" class="form-group production_process_operator">
<span<?php echo $production_process->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_operator" name="x<?php echo $production_process_grid->RowIndex ?>_operator" id="x<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_operator" name="o<?php echo $production_process_grid->RowIndex ?>_operator" id="o<?php echo $production_process_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($production_process->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<?php if (!$production_process->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_production_process_datetime" class="form-group production_process_datetime">
<span<?php echo $production_process->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($production_process->datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_a_operator" class="form-group production_process_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production_process" data-field="x_a_operator" data-value-separator="<?php echo $production_process->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_process_grid->RowIndex ?>_a_operator" name="x<?php echo $production_process_grid->RowIndex ?>_a_operator"<?php echo $production_process->a_operator->editAttributes() ?>>
		<?php echo $production_process->a_operator->selectOptionListHtml("x<?php echo $production_process_grid->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $production_process->a_operator->Lookup->getParamTag("p_x" . $production_process_grid->RowIndex . "_a_operator") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_a_operator" class="form-group production_process_a_operator">
<span<?php echo $production_process->a_operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->a_operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="x<?php echo $production_process_grid->RowIndex ?>_a_operator" id="x<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_a_operator" name="o<?php echo $production_process_grid->RowIndex ?>_a_operator" id="o<?php echo $production_process_grid->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($production_process->a_operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_a_datetime" class="form-group production_process_a_datetime">
<input type="text" data-table="production_process" data-field="x_a_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" placeholder="<?php echo HtmlEncode($production_process->a_datetime->getPlaceHolder()) ?>" value="<?php echo $production_process->a_datetime->EditValue ?>"<?php echo $production_process->a_datetime->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_a_datetime" class="form-group production_process_a_datetime">
<span<?php echo $production_process->a_datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->a_datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="x<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_a_datetime" name="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" id="o<?php echo $production_process_grid->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($production_process->a_datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_process->a_process->Visible) { // a_process ?>
		<td data-name="a_process">
<?php if (!$production_process->isConfirm()) { ?>
<span id="el$rowindex$_production_process_a_process" class="form-group production_process_a_process">
<input type="text" data-table="production_process" data-field="x_a_process" name="x<?php echo $production_process_grid->RowIndex ?>_a_process" id="x<?php echo $production_process_grid->RowIndex ?>_a_process" size="30" maxlength="198" placeholder="<?php echo HtmlEncode($production_process->a_process->getPlaceHolder()) ?>" value="<?php echo $production_process->a_process->EditValue ?>"<?php echo $production_process->a_process->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_process_a_process" class="form-group production_process_a_process">
<span<?php echo $production_process->a_process->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($production_process->a_process->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="production_process" data-field="x_a_process" name="x<?php echo $production_process_grid->RowIndex ?>_a_process" id="x<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production_process" data-field="x_a_process" name="o<?php echo $production_process_grid->RowIndex ?>_a_process" id="o<?php echo $production_process_grid->RowIndex ?>_a_process" value="<?php echo HtmlEncode($production_process->a_process->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_process_grid->ListOptions->render("body", "right", $production_process_grid->RowIndex);
?>
<script>
fproduction_processgrid.updateLists(<?php echo $production_process_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($production_process->CurrentMode == "add" || $production_process->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $production_process_grid->FormKeyCountName ?>" id="<?php echo $production_process_grid->FormKeyCountName ?>" value="<?php echo $production_process_grid->KeyCount ?>">
<?php echo $production_process_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($production_process->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $production_process_grid->FormKeyCountName ?>" id="<?php echo $production_process_grid->FormKeyCountName ?>" value="<?php echo $production_process_grid->KeyCount ?>">
<?php echo $production_process_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($production_process->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fproduction_processgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($production_process_grid->Recordset)
	$production_process_grid->Recordset->Close();
?>
</div>
<?php if ($production_process_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $production_process_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_process_grid->TotalRecs == 0 && !$production_process->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_process_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_process_grid->terminate();
?>
<?php if (!$production_process->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_process", "100%", "500px");
</script>
<?php } ?>