<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_process_list = new production_process_list();

// Run the page
$production_process_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_process_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$production_process->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduction_processlist = currentForm = new ew.Form("fproduction_processlist", "list");
fproduction_processlist.formKeyCountName = '<?php echo $production_process_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduction_processlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduction_processlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduction_processlist.lists["x_product"] = <?php echo $production_process_list->product->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_product"].options = <?php echo JsonEncode($production_process_list->product->lookupOptions()) ?>;
fproduction_processlist.lists["x_rid"] = <?php echo $production_process_list->rid->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_rid"].options = <?php echo JsonEncode($production_process_list->rid->lookupOptions()) ?>;
fproduction_processlist.lists["x_batch_no"] = <?php echo $production_process_list->batch_no->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_batch_no"].options = <?php echo JsonEncode($production_process_list->batch_no->lookupOptions()) ?>;
fproduction_processlist.lists["x_process"] = <?php echo $production_process_list->process->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_process"].options = <?php echo JsonEncode($production_process_list->process->lookupOptions()) ?>;
fproduction_processlist.lists["x_operator"] = <?php echo $production_process_list->operator->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_operator"].options = <?php echo JsonEncode($production_process_list->operator->lookupOptions()) ?>;
fproduction_processlist.lists["x_a_operator"] = <?php echo $production_process_list->a_operator->Lookup->toClientList() ?>;
fproduction_processlist.lists["x_a_operator"].options = <?php echo JsonEncode($production_process_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fproduction_processlistsrch = currentSearchForm = new ew.Form("fproduction_processlistsrch");

// Filters
fproduction_processlistsrch.filterList = <?php echo $production_process_list->getFilterList() ?>;

// Init search panel as collapsed
fproduction_processlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$production_process->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_process_list->TotalRecs > 0 && $production_process_list->ExportOptions->visible()) { ?>
<?php $production_process_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_process_list->ImportOptions->visible()) { ?>
<?php $production_process_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_process_list->SearchOptions->visible()) { ?>
<?php $production_process_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_process_list->FilterOptions->visible()) { ?>
<?php $production_process_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$production_process->isExport() || EXPORT_MASTER_RECORD && $production_process->isExport("print")) { ?>
<?php
if ($production_process_list->DbMasterFilter <> "" && $production_process->getCurrentMasterTable() == "batch_no") {
	if ($production_process_list->MasterRecordExists) {
		include_once "batch_nomaster.php";
	}
}
?>
<?php } ?>
<?php
$production_process_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_process->isExport() && !$production_process->CurrentAction) { ?>
<form name="fproduction_processlistsrch" id="fproduction_processlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($production_process_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduction_processlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production_process">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($production_process_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($production_process_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_process_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_process_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_process_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_process_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_process_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $production_process_list->showPageHeader(); ?>
<?php
$production_process_list->showMessage();
?>
<?php if ($production_process_list->TotalRecs > 0 || $production_process->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_process_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production_process">
<?php if (!$production_process->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_process_list->Pager)) $production_process_list->Pager = new PrevNextPager($production_process_list->StartRec, $production_process_list->DisplayRecs, $production_process_list->TotalRecs, $production_process_list->AutoHidePager) ?>
<?php if ($production_process_list->Pager->RecordCount > 0 && $production_process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_process_list->TotalRecs > 0 && (!$production_process_list->AutoHidePageSizeSelector || $production_process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduction_processlist" id="fproduction_processlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($production_process_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $production_process_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production_process">
<?php if ($production_process->getCurrentMasterTable() == "batch_no" && $production_process->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="batch_no">
<input type="hidden" name="fk_id" value="<?php echo $production_process->batch_no->getSessionValue() ?>">
<?php } ?>
<div id="gmp_production_process" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($production_process_list->TotalRecs > 0 || $production_process->isGridEdit()) { ?>
<table id="tbl_production_processlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production_process_list->RowType = ROWTYPE_HEADER;

// Render list options
$production_process_list->renderListOptions();

// Render list options (header, left)
$production_process_list->ListOptions->render("header", "left");
?>
<?php if ($production_process->id->Visible) { // id ?>
	<?php if ($production_process->sortUrl($production_process->id) == "") { ?>
		<th data-name="id" class="<?php echo $production_process->id->headerCellClass() ?>"><div id="elh_production_process_id" class="production_process_id"><div class="ew-table-header-caption"><?php echo $production_process->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $production_process->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->id) ?>',2);"><div id="elh_production_process_id" class="production_process_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->product->Visible) { // product ?>
	<?php if ($production_process->sortUrl($production_process->product) == "") { ?>
		<th data-name="product" class="<?php echo $production_process->product->headerCellClass() ?>"><div id="elh_production_process_product" class="production_process_product"><div class="ew-table-header-caption"><?php echo $production_process->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $production_process->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->product) ?>',2);"><div id="elh_production_process_product" class="production_process_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->rid->Visible) { // rid ?>
	<?php if ($production_process->sortUrl($production_process->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $production_process->rid->headerCellClass() ?>"><div id="elh_production_process_rid" class="production_process_rid"><div class="ew-table-header-caption"><?php echo $production_process->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $production_process->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->rid) ?>',2);"><div id="elh_production_process_rid" class="production_process_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->batch_no->Visible) { // batch_no ?>
	<?php if ($production_process->sortUrl($production_process->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $production_process->batch_no->headerCellClass() ?>"><div id="elh_production_process_batch_no" class="production_process_batch_no"><div class="ew-table-header-caption"><?php echo $production_process->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $production_process->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->batch_no) ?>',2);"><div id="elh_production_process_batch_no" class="production_process_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->sequence->Visible) { // sequence ?>
	<?php if ($production_process->sortUrl($production_process->sequence) == "") { ?>
		<th data-name="sequence" class="<?php echo $production_process->sequence->headerCellClass() ?>"><div id="elh_production_process_sequence" class="production_process_sequence"><div class="ew-table-header-caption"><?php echo $production_process->sequence->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sequence" class="<?php echo $production_process->sequence->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->sequence) ?>',2);"><div id="elh_production_process_sequence" class="production_process_sequence">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->sequence->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->sequence->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->sequence->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->process->Visible) { // process ?>
	<?php if ($production_process->sortUrl($production_process->process) == "") { ?>
		<th data-name="process" class="<?php echo $production_process->process->headerCellClass() ?>"><div id="elh_production_process_process" class="production_process_process"><div class="ew-table-header-caption"><?php echo $production_process->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $production_process->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->process) ?>',2);"><div id="elh_production_process_process" class="production_process_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->material_name->Visible) { // material_name ?>
	<?php if ($production_process->sortUrl($production_process->material_name) == "") { ?>
		<th data-name="material_name" class="<?php echo $production_process->material_name->headerCellClass() ?>"><div id="elh_production_process_material_name" class="production_process_material_name"><div class="ew-table-header-caption"><?php echo $production_process->material_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_name" class="<?php echo $production_process->material_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->material_name) ?>',2);"><div id="elh_production_process_material_name" class="production_process_material_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->material_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_process->material_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->material_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->remarks->Visible) { // remarks ?>
	<?php if ($production_process->sortUrl($production_process->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $production_process->remarks->headerCellClass() ?>"><div id="elh_production_process_remarks" class="production_process_remarks"><div class="ew-table-header-caption"><?php echo $production_process->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $production_process->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->remarks) ?>',2);"><div id="elh_production_process_remarks" class="production_process_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_process->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->quantity->Visible) { // quantity ?>
	<?php if ($production_process->sortUrl($production_process->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $production_process->quantity->headerCellClass() ?>"><div id="elh_production_process_quantity" class="production_process_quantity"><div class="ew-table-header-caption"><?php echo $production_process->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $production_process->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->quantity) ?>',2);"><div id="elh_production_process_quantity" class="production_process_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->operator->Visible) { // operator ?>
	<?php if ($production_process->sortUrl($production_process->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $production_process->operator->headerCellClass() ?>"><div id="elh_production_process_operator" class="production_process_operator"><div class="ew-table-header-caption"><?php echo $production_process->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $production_process->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->operator) ?>',2);"><div id="elh_production_process_operator" class="production_process_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->datetime->Visible) { // datetime ?>
	<?php if ($production_process->sortUrl($production_process->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $production_process->datetime->headerCellClass() ?>"><div id="elh_production_process_datetime" class="production_process_datetime"><div class="ew-table-header-caption"><?php echo $production_process->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $production_process->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->datetime) ?>',2);"><div id="elh_production_process_datetime" class="production_process_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_operator->Visible) { // a_operator ?>
	<?php if ($production_process->sortUrl($production_process->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $production_process->a_operator->headerCellClass() ?>"><div id="elh_production_process_a_operator" class="production_process_a_operator"><div class="ew-table-header-caption"><?php echo $production_process->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $production_process->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->a_operator) ?>',2);"><div id="elh_production_process_a_operator" class="production_process_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
	<?php if ($production_process->sortUrl($production_process->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><div id="elh_production_process_a_datetime" class="production_process_a_datetime"><div class="ew-table-header-caption"><?php echo $production_process->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->a_datetime) ?>',2);"><div id="elh_production_process_a_datetime" class="production_process_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_process->Visible) { // a_process ?>
	<?php if ($production_process->sortUrl($production_process->a_process) == "") { ?>
		<th data-name="a_process" class="<?php echo $production_process->a_process->headerCellClass() ?>"><div id="elh_production_process_a_process" class="production_process_a_process"><div class="ew-table-header-caption"><?php echo $production_process->a_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_process" class="<?php echo $production_process->a_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $production_process->SortUrl($production_process->a_process) ?>',2);"><div id="elh_production_process_a_process" class="production_process_a_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_process->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_process->a_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process->a_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_process_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_process->ExportAll && $production_process->isExport()) {
	$production_process_list->StopRec = $production_process_list->TotalRecs;
} else {

	// Set the last record to display
	if ($production_process_list->TotalRecs > $production_process_list->StartRec + $production_process_list->DisplayRecs - 1)
		$production_process_list->StopRec = $production_process_list->StartRec + $production_process_list->DisplayRecs - 1;
	else
		$production_process_list->StopRec = $production_process_list->TotalRecs;
}
$production_process_list->RecCnt = $production_process_list->StartRec - 1;
if ($production_process_list->Recordset && !$production_process_list->Recordset->EOF) {
	$production_process_list->Recordset->moveFirst();
	$selectLimit = $production_process_list->UseSelectLimit;
	if (!$selectLimit && $production_process_list->StartRec > 1)
		$production_process_list->Recordset->move($production_process_list->StartRec - 1);
} elseif (!$production_process->AllowAddDeleteRow && $production_process_list->StopRec == 0) {
	$production_process_list->StopRec = $production_process->GridAddRowCount;
}

// Initialize aggregate
$production_process->RowType = ROWTYPE_AGGREGATEINIT;
$production_process->resetAttributes();
$production_process_list->renderRow();
while ($production_process_list->RecCnt < $production_process_list->StopRec) {
	$production_process_list->RecCnt++;
	if ($production_process_list->RecCnt >= $production_process_list->StartRec) {
		$production_process_list->RowCnt++;

		// Set up key count
		$production_process_list->KeyCount = $production_process_list->RowIndex;

		// Init row class and style
		$production_process->resetAttributes();
		$production_process->CssClass = "";
		if ($production_process->isGridAdd()) {
		} else {
			$production_process_list->loadRowValues($production_process_list->Recordset); // Load row values
		}
		$production_process->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production_process->RowAttrs = array_merge($production_process->RowAttrs, array('data-rowindex'=>$production_process_list->RowCnt, 'id'=>'r' . $production_process_list->RowCnt . '_production_process', 'data-rowtype'=>$production_process->RowType));

		// Render row
		$production_process_list->renderRow();

		// Render list options
		$production_process_list->renderListOptions();
?>
	<tr<?php echo $production_process->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_process_list->ListOptions->render("body", "left", $production_process_list->RowCnt);
?>
	<?php if ($production_process->id->Visible) { // id ?>
		<td data-name="id"<?php echo $production_process->id->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_id" class="production_process_id">
<span<?php echo $production_process->id->viewAttributes() ?>>
<?php echo $production_process->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->product->Visible) { // product ?>
		<td data-name="product"<?php echo $production_process->product->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_product" class="production_process_product">
<span<?php echo $production_process->product->viewAttributes() ?>>
<?php echo $production_process->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $production_process->rid->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_rid" class="production_process_rid">
<span<?php echo $production_process->rid->viewAttributes() ?>>
<?php echo $production_process->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $production_process->batch_no->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_batch_no" class="production_process_batch_no">
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<?php echo $production_process->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->sequence->Visible) { // sequence ?>
		<td data-name="sequence"<?php echo $production_process->sequence->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_sequence" class="production_process_sequence">
<span<?php echo $production_process->sequence->viewAttributes() ?>>
<?php echo $production_process->sequence->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->process->Visible) { // process ?>
		<td data-name="process"<?php echo $production_process->process->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_process" class="production_process_process">
<span<?php echo $production_process->process->viewAttributes() ?>>
<?php echo $production_process->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->material_name->Visible) { // material_name ?>
		<td data-name="material_name"<?php echo $production_process->material_name->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_material_name" class="production_process_material_name">
<span<?php echo $production_process->material_name->viewAttributes() ?>>
<?php echo $production_process->material_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $production_process->remarks->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_remarks" class="production_process_remarks">
<span<?php echo $production_process->remarks->viewAttributes() ?>>
<?php echo $production_process->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $production_process->quantity->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_quantity" class="production_process_quantity">
<span<?php echo $production_process->quantity->viewAttributes() ?>>
<?php echo $production_process->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $production_process->operator->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_operator" class="production_process_operator">
<span<?php echo $production_process->operator->viewAttributes() ?>>
<?php echo $production_process->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $production_process->datetime->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_datetime" class="production_process_datetime">
<span<?php echo $production_process->datetime->viewAttributes() ?>>
<?php echo $production_process->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $production_process->a_operator->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_a_operator" class="production_process_a_operator">
<span<?php echo $production_process->a_operator->viewAttributes() ?>>
<?php echo $production_process->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $production_process->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_a_datetime" class="production_process_a_datetime">
<span<?php echo $production_process->a_datetime->viewAttributes() ?>>
<?php echo $production_process->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_process->a_process->Visible) { // a_process ?>
		<td data-name="a_process"<?php echo $production_process->a_process->cellAttributes() ?>>
<span id="el<?php echo $production_process_list->RowCnt ?>_production_process_a_process" class="production_process_a_process">
<span<?php echo $production_process->a_process->viewAttributes() ?>>
<?php echo $production_process->a_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_process_list->ListOptions->render("body", "right", $production_process_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$production_process->isGridAdd())
		$production_process_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$production_process->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_process_list->Recordset)
	$production_process_list->Recordset->Close();
?>
<?php if (!$production_process->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($production_process_list->Pager)) $production_process_list->Pager = new PrevNextPager($production_process_list->StartRec, $production_process_list->DisplayRecs, $production_process_list->TotalRecs, $production_process_list->AutoHidePager) ?>
<?php if ($production_process_list->Pager->RecordCount > 0 && $production_process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($production_process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($production_process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $production_process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($production_process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($production_process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $production_process_list->pageUrl() ?>start=<?php echo $production_process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $production_process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($production_process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $production_process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $production_process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $production_process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($production_process_list->TotalRecs > 0 && (!$production_process_list->AutoHidePageSizeSelector || $production_process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="production_process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($production_process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($production_process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($production_process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($production_process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($production_process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($production_process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_process_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_process_list->TotalRecs == 0 && !$production_process->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_process_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$production_process->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$production_process->isExport()) { ?>
<script>
ew.scrollableTable("gmp_production_process", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$production_process_list->terminate();
?>