<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$production_process_preview = new production_process_preview();

// Run the page
$production_process_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_process_preview->Page_Render();
?>
<?php $production_process_preview->showPageHeader(); ?>
<div class="card ew-grid production_process"><!-- .card -->
<?php if ($production_process_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$production_process_preview->renderListOptions();

// Render list options (header, left)
$production_process_preview->ListOptions->render("header", "left");
?>
<?php if ($production_process->id->Visible) { // id ?>
	<?php if ($production_process->SortUrl($production_process->id) == "") { ?>
		<th class="<?php echo $production_process->id->headerCellClass() ?>"><?php echo $production_process->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->id->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->id->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->id->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->product->Visible) { // product ?>
	<?php if ($production_process->SortUrl($production_process->product) == "") { ?>
		<th class="<?php echo $production_process->product->headerCellClass() ?>"><?php echo $production_process->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->product->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->product->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->product->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->rid->Visible) { // rid ?>
	<?php if ($production_process->SortUrl($production_process->rid) == "") { ?>
		<th class="<?php echo $production_process->rid->headerCellClass() ?>"><?php echo $production_process->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->rid->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->rid->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->rid->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->batch_no->Visible) { // batch_no ?>
	<?php if ($production_process->SortUrl($production_process->batch_no) == "") { ?>
		<th class="<?php echo $production_process->batch_no->headerCellClass() ?>"><?php echo $production_process->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->batch_no->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->batch_no->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->batch_no->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->sequence->Visible) { // sequence ?>
	<?php if ($production_process->SortUrl($production_process->sequence) == "") { ?>
		<th class="<?php echo $production_process->sequence->headerCellClass() ?>"><?php echo $production_process->sequence->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->sequence->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->sequence->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->sequence->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->sequence->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->sequence->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->process->Visible) { // process ?>
	<?php if ($production_process->SortUrl($production_process->process) == "") { ?>
		<th class="<?php echo $production_process->process->headerCellClass() ?>"><?php echo $production_process->process->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->process->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->process->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->process->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->process->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->material_name->Visible) { // material_name ?>
	<?php if ($production_process->SortUrl($production_process->material_name) == "") { ?>
		<th class="<?php echo $production_process->material_name->headerCellClass() ?>"><?php echo $production_process->material_name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->material_name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->material_name->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->material_name->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->material_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->material_name->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->remarks->Visible) { // remarks ?>
	<?php if ($production_process->SortUrl($production_process->remarks) == "") { ?>
		<th class="<?php echo $production_process->remarks->headerCellClass() ?>"><?php echo $production_process->remarks->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->remarks->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->remarks->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->remarks->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->remarks->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->quantity->Visible) { // quantity ?>
	<?php if ($production_process->SortUrl($production_process->quantity) == "") { ?>
		<th class="<?php echo $production_process->quantity->headerCellClass() ?>"><?php echo $production_process->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->quantity->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->quantity->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->quantity->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->operator->Visible) { // operator ?>
	<?php if ($production_process->SortUrl($production_process->operator) == "") { ?>
		<th class="<?php echo $production_process->operator->headerCellClass() ?>"><?php echo $production_process->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->operator->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->operator->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->operator->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->datetime->Visible) { // datetime ?>
	<?php if ($production_process->SortUrl($production_process->datetime) == "") { ?>
		<th class="<?php echo $production_process->datetime->headerCellClass() ?>"><?php echo $production_process->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->datetime->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->datetime->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->datetime->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_operator->Visible) { // a_operator ?>
	<?php if ($production_process->SortUrl($production_process->a_operator) == "") { ?>
		<th class="<?php echo $production_process->a_operator->headerCellClass() ?>"><?php echo $production_process->a_operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->a_operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->a_operator->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->a_operator->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->a_operator->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
	<?php if ($production_process->SortUrl($production_process->a_datetime) == "") { ?>
		<th class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><?php echo $production_process->a_datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->a_datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->a_datetime->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->a_datetime->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->a_datetime->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_process->a_process->Visible) { // a_process ?>
	<?php if ($production_process->SortUrl($production_process->a_process) == "") { ?>
		<th class="<?php echo $production_process->a_process->headerCellClass() ?>"><?php echo $production_process->a_process->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $production_process->a_process->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($production_process->a_process->Name) ?>" data-sort-order="<?php echo $production_process_preview->SortField == $production_process->a_process->Name && $production_process_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_process->a_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_process_preview->SortField == $production_process->a_process->Name) { ?><?php if ($production_process_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($production_process_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_process_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$production_process_preview->RecCount = 0;
$production_process_preview->RowCnt = 0;
while ($production_process_preview->Recordset && !$production_process_preview->Recordset->EOF) {

	// Init row class and style
	$production_process_preview->RecCount++;
	$production_process_preview->RowCnt++;
	$production_process_preview->CssStyle = "";
	$production_process_preview->loadListRowValues($production_process_preview->Recordset);

	// Render row
	$production_process_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$production_process_preview->resetAttributes();
	$production_process_preview->renderListRow();

	// Render list options
	$production_process_preview->renderListOptions();
?>
	<tr<?php echo $production_process_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_process_preview->ListOptions->render("body", "left", $production_process_preview->RowCnt);
?>
<?php if ($production_process->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $production_process->id->cellAttributes() ?>>
<span<?php echo $production_process->id->viewAttributes() ?>>
<?php echo $production_process->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $production_process->product->cellAttributes() ?>>
<span<?php echo $production_process->product->viewAttributes() ?>>
<?php echo $production_process->product->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $production_process->rid->cellAttributes() ?>>
<span<?php echo $production_process->rid->viewAttributes() ?>>
<?php echo $production_process->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $production_process->batch_no->cellAttributes() ?>>
<span<?php echo $production_process->batch_no->viewAttributes() ?>>
<?php echo $production_process->batch_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->sequence->Visible) { // sequence ?>
		<!-- sequence -->
		<td<?php echo $production_process->sequence->cellAttributes() ?>>
<span<?php echo $production_process->sequence->viewAttributes() ?>>
<?php echo $production_process->sequence->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->process->Visible) { // process ?>
		<!-- process -->
		<td<?php echo $production_process->process->cellAttributes() ?>>
<span<?php echo $production_process->process->viewAttributes() ?>>
<?php echo $production_process->process->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->material_name->Visible) { // material_name ?>
		<!-- material_name -->
		<td<?php echo $production_process->material_name->cellAttributes() ?>>
<span<?php echo $production_process->material_name->viewAttributes() ?>>
<?php echo $production_process->material_name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->remarks->Visible) { // remarks ?>
		<!-- remarks -->
		<td<?php echo $production_process->remarks->cellAttributes() ?>>
<span<?php echo $production_process->remarks->viewAttributes() ?>>
<?php echo $production_process->remarks->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $production_process->quantity->cellAttributes() ?>>
<span<?php echo $production_process->quantity->viewAttributes() ?>>
<?php echo $production_process->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $production_process->operator->cellAttributes() ?>>
<span<?php echo $production_process->operator->viewAttributes() ?>>
<?php echo $production_process->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $production_process->datetime->cellAttributes() ?>>
<span<?php echo $production_process->datetime->viewAttributes() ?>>
<?php echo $production_process->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->a_operator->Visible) { // a_operator ?>
		<!-- a_operator -->
		<td<?php echo $production_process->a_operator->cellAttributes() ?>>
<span<?php echo $production_process->a_operator->viewAttributes() ?>>
<?php echo $production_process->a_operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->a_datetime->Visible) { // a_datetime ?>
		<!-- a_datetime -->
		<td<?php echo $production_process->a_datetime->cellAttributes() ?>>
<span<?php echo $production_process->a_datetime->viewAttributes() ?>>
<?php echo $production_process->a_datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($production_process->a_process->Visible) { // a_process ?>
		<!-- a_process -->
		<td<?php echo $production_process->a_process->cellAttributes() ?>>
<span<?php echo $production_process->a_process->viewAttributes() ?>>
<?php echo $production_process->a_process->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$production_process_preview->ListOptions->render("body", "right", $production_process_preview->RowCnt);
?>
	</tr>
<?php
	$production_process_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($production_process_preview->TotalRecs > 0) { ?>
<?php if (!isset($production_process_preview->Pager)) $production_process_preview->Pager = new PrevNextPager($production_process_preview->StartRec, $production_process_preview->DisplayRecs, $production_process_preview->TotalRecs) ?>
<?php if ($production_process_preview->Pager->RecordCount > 0 && $production_process_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($production_process_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $production_process_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($production_process_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $production_process_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($production_process_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $production_process_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($production_process_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $production_process_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $production_process_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $production_process_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $production_process_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($production_process_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$production_process_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($production_process_preview->Recordset)
	$production_process_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$production_process_preview->terminate();
?>