<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_list = new product_list();

// Run the page
$product_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproductlist = currentForm = new ew.Form("fproductlist", "list");
fproductlist.formKeyCountName = '<?php echo $product_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproductlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproductlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproductlist.lists["x_grp[]"] = <?php echo $product_list->grp->Lookup->toClientList() ?>;
fproductlist.lists["x_grp[]"].options = <?php echo JsonEncode($product_list->grp->lookupOptions()) ?>;
fproductlist.lists["x_s_grp[]"] = <?php echo $product_list->s_grp->Lookup->toClientList() ?>;
fproductlist.lists["x_s_grp[]"].options = <?php echo JsonEncode($product_list->s_grp->lookupOptions()) ?>;
fproductlist.lists["x_publish"] = <?php echo $product_list->publish->Lookup->toClientList() ?>;
fproductlist.lists["x_publish"].options = <?php echo JsonEncode($product_list->publish->options(FALSE, TRUE)) ?>;
fproductlist.lists["x_status"] = <?php echo $product_list->status->Lookup->toClientList() ?>;
fproductlist.lists["x_status"].options = <?php echo JsonEncode($product_list->status->options(FALSE, TRUE)) ?>;
fproductlist.lists["x_company_id"] = <?php echo $product_list->company_id->Lookup->toClientList() ?>;
fproductlist.lists["x_company_id"].options = <?php echo JsonEncode($product_list->company_id->lookupOptions()) ?>;
fproductlist.lists["x_operator"] = <?php echo $product_list->operator->Lookup->toClientList() ?>;
fproductlist.lists["x_operator"].options = <?php echo JsonEncode($product_list->operator->lookupOptions()) ?>;

// Form object for search
var fproductlistsrch = currentSearchForm = new ew.Form("fproductlistsrch");

// Validate function for search
fproductlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproductlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproductlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproductlistsrch.lists["x_grp[]"] = <?php echo $product_list->grp->Lookup->toClientList() ?>;
fproductlistsrch.lists["x_grp[]"].options = <?php echo JsonEncode($product_list->grp->lookupOptions()) ?>;
fproductlistsrch.lists["x_s_grp[]"] = <?php echo $product_list->s_grp->Lookup->toClientList() ?>;
fproductlistsrch.lists["x_s_grp[]"].options = <?php echo JsonEncode($product_list->s_grp->lookupOptions()) ?>;

// Filters
fproductlistsrch.filterList = <?php echo $product_list->getFilterList() ?>;

// Init search panel as collapsed
fproductlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_list->TotalRecs > 0 && $product_list->ExportOptions->visible()) { ?>
<?php $product_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_list->ImportOptions->visible()) { ?>
<?php $product_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_list->SearchOptions->visible()) { ?>
<?php $product_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_list->FilterOptions->visible()) { ?>
<?php $product_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product->isExport() && !$product->CurrentAction) { ?>
<form name="fproductlistsrch" id="fproductlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproductlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product->RowType = ROWTYPE_SEARCH;

// Render row
$product->resetAttributes();
$product_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $product->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$product->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_grp" data-value-separator="<?php echo $product->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_s_grp" data-value-separator="<?php echo $product->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $product->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $product->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $product->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->product->getPlaceHolder()) ?>" value="<?php echo $product->product->EditValue ?>"<?php echo $product->product->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_list->showPageHeader(); ?>
<?php
$product_list->showMessage();
?>
<?php if ($product_list->TotalRecs > 0 || $product->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product">
<?php if (!$product->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_list->Pager)) $product_list->Pager = new PrevNextPager($product_list->StartRec, $product_list->DisplayRecs, $product_list->TotalRecs, $product_list->AutoHidePager) ?>
<?php if ($product_list->Pager->RecordCount > 0 && $product_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_list->TotalRecs > 0 && (!$product_list->AutoHidePageSizeSelector || $product_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproductlist" id="fproductlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product">
<div id="gmp_product" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_list->TotalRecs > 0 || $product->isGridEdit()) { ?>
<table id="tbl_productlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_list->renderListOptions();

// Render list options (header, left)
$product_list->ListOptions->render("header", "left");
?>
<?php if ($product->id->Visible) { // id ?>
	<?php if ($product->sortUrl($product->id) == "") { ?>
		<th data-name="id" class="<?php echo $product->id->headerCellClass() ?>"><div id="elh_product_id" class="product_id"><div class="ew-table-header-caption"><?php echo $product->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->id) ?>',2);"><div id="elh_product_id" class="product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->grp->Visible) { // grp ?>
	<?php if ($product->sortUrl($product->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product->grp->headerCellClass() ?>"><div id="elh_product_grp" class="product_grp"><div class="ew-table-header-caption"><?php echo $product->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->grp) ?>',2);"><div id="elh_product_grp" class="product_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->s_grp->Visible) { // s_grp ?>
	<?php if ($product->sortUrl($product->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product->s_grp->headerCellClass() ?>"><div id="elh_product_s_grp" class="product_s_grp"><div class="ew-table-header-caption"><?php echo $product->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->s_grp) ?>',2);"><div id="elh_product_s_grp" class="product_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->product->Visible) { // product ?>
	<?php if ($product->sortUrl($product->product) == "") { ?>
		<th data-name="product" class="<?php echo $product->product->headerCellClass() ?>"><div id="elh_product_product" class="product_product"><div class="ew-table-header-caption"><?php echo $product->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->product) ?>',2);"><div id="elh_product_product" class="product_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->publish->Visible) { // publish ?>
	<?php if ($product->sortUrl($product->publish) == "") { ?>
		<th data-name="publish" class="<?php echo $product->publish->headerCellClass() ?>"><div id="elh_product_publish" class="product_publish"><div class="ew-table-header-caption"><?php echo $product->publish->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="publish" class="<?php echo $product->publish->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->publish) ?>',2);"><div id="elh_product_publish" class="product_publish">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->publish->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->publish->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->publish->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->image->Visible) { // image ?>
	<?php if ($product->sortUrl($product->image) == "") { ?>
		<th data-name="image" class="<?php echo $product->image->headerCellClass() ?>"><div id="elh_product_image" class="product_image"><div class="ew-table-header-caption"><?php echo $product->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $product->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->image) ?>',2);"><div id="elh_product_image" class="product_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->status->Visible) { // status ?>
	<?php if ($product->sortUrl($product->status) == "") { ?>
		<th data-name="status" class="<?php echo $product->status->headerCellClass() ?>"><div id="elh_product_status" class="product_status"><div class="ew-table-header-caption"><?php echo $product->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->status) ?>',2);"><div id="elh_product_status" class="product_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->remarks->Visible) { // remarks ?>
	<?php if ($product->sortUrl($product->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $product->remarks->headerCellClass() ?>"><div id="elh_product_remarks" class="product_remarks"><div class="ew-table-header-caption"><?php echo $product->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $product->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->remarks) ?>',2);"><div id="elh_product_remarks" class="product_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->company_id->Visible) { // company_id ?>
	<?php if ($product->sortUrl($product->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product->company_id->headerCellClass() ?>"><div id="elh_product_company_id" class="product_company_id"><div class="ew-table-header-caption"><?php echo $product->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->company_id) ?>',2);"><div id="elh_product_company_id" class="product_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->prod_capacity->Visible) { // prod_capacity ?>
	<?php if ($product->sortUrl($product->prod_capacity) == "") { ?>
		<th data-name="prod_capacity" class="<?php echo $product->prod_capacity->headerCellClass() ?>"><div id="elh_product_prod_capacity" class="product_prod_capacity"><div class="ew-table-header-caption"><?php echo $product->prod_capacity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prod_capacity" class="<?php echo $product->prod_capacity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->prod_capacity) ?>',2);"><div id="elh_product_prod_capacity" class="product_prod_capacity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->prod_capacity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->prod_capacity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->prod_capacity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->operator->Visible) { // operator ?>
	<?php if ($product->sortUrl($product->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product->operator->headerCellClass() ?>"><div id="elh_product_operator" class="product_operator"><div class="ew-table-header-caption"><?php echo $product->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->operator) ?>',2);"><div id="elh_product_operator" class="product_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product->datetime->Visible) { // datetime ?>
	<?php if ($product->sortUrl($product->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product->datetime->headerCellClass() ?>"><div id="elh_product_datetime" class="product_datetime"><div class="ew-table-header-caption"><?php echo $product->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product->SortUrl($product->datetime) ?>',2);"><div id="elh_product_datetime" class="product_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product->ExportAll && $product->isExport()) {
	$product_list->StopRec = $product_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_list->TotalRecs > $product_list->StartRec + $product_list->DisplayRecs - 1)
		$product_list->StopRec = $product_list->StartRec + $product_list->DisplayRecs - 1;
	else
		$product_list->StopRec = $product_list->TotalRecs;
}
$product_list->RecCnt = $product_list->StartRec - 1;
if ($product_list->Recordset && !$product_list->Recordset->EOF) {
	$product_list->Recordset->moveFirst();
	$selectLimit = $product_list->UseSelectLimit;
	if (!$selectLimit && $product_list->StartRec > 1)
		$product_list->Recordset->move($product_list->StartRec - 1);
} elseif (!$product->AllowAddDeleteRow && $product_list->StopRec == 0) {
	$product_list->StopRec = $product->GridAddRowCount;
}

// Initialize aggregate
$product->RowType = ROWTYPE_AGGREGATEINIT;
$product->resetAttributes();
$product_list->renderRow();
while ($product_list->RecCnt < $product_list->StopRec) {
	$product_list->RecCnt++;
	if ($product_list->RecCnt >= $product_list->StartRec) {
		$product_list->RowCnt++;

		// Set up key count
		$product_list->KeyCount = $product_list->RowIndex;

		// Init row class and style
		$product->resetAttributes();
		$product->CssClass = "";
		if ($product->isGridAdd()) {
		} else {
			$product_list->loadRowValues($product_list->Recordset); // Load row values
		}
		$product->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product->RowAttrs = array_merge($product->RowAttrs, array('data-rowindex'=>$product_list->RowCnt, 'id'=>'r' . $product_list->RowCnt . '_product', 'data-rowtype'=>$product->RowType));

		// Render row
		$product_list->renderRow();

		// Render list options
		$product_list->renderListOptions();
?>
	<tr<?php echo $product->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_list->ListOptions->render("body", "left", $product_list->RowCnt);
?>
	<?php if ($product->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product->id->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_id" class="product_id">
<span<?php echo $product->id->viewAttributes() ?>>
<?php echo $product->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product->grp->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_grp" class="product_grp">
<span<?php echo $product->grp->viewAttributes() ?>>
<?php echo $product->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_s_grp" class="product_s_grp">
<span<?php echo $product->s_grp->viewAttributes() ?>>
<?php echo $product->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product->product->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_product" class="product_product">
<span<?php echo $product->product->viewAttributes() ?>>
<?php if ((!EmptyString($product->product->getViewValue())) && $product->product->linkAttributes() <> "") { ?>
<a<?php echo $product->product->linkAttributes() ?>><?php echo $product->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product->publish->Visible) { // publish ?>
		<td data-name="publish"<?php echo $product->publish->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_publish" class="product_publish">
<span<?php echo $product->publish->viewAttributes() ?>>
<?php echo $product->publish->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->image->Visible) { // image ?>
		<td data-name="image"<?php echo $product->image->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_image" class="product_image">
<span>
<?php echo GetFileViewTag($product->image, $product->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product->status->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_status" class="product_status">
<span<?php echo $product->status->viewAttributes() ?>>
<?php echo $product->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $product->remarks->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_remarks" class="product_remarks">
<span<?php echo $product->remarks->viewAttributes() ?>>
<?php echo $product->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_company_id" class="product_company_id">
<span<?php echo $product->company_id->viewAttributes() ?>>
<?php echo $product->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->prod_capacity->Visible) { // prod_capacity ?>
		<td data-name="prod_capacity"<?php echo $product->prod_capacity->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_prod_capacity" class="product_prod_capacity">
<span<?php echo $product->prod_capacity->viewAttributes() ?>>
<?php echo $product->prod_capacity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product->operator->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_operator" class="product_operator">
<span<?php echo $product->operator->viewAttributes() ?>>
<?php echo $product->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_list->RowCnt ?>_product_datetime" class="product_datetime">
<span<?php echo $product->datetime->viewAttributes() ?>>
<?php echo $product->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_list->ListOptions->render("body", "right", $product_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product->isGridAdd())
		$product_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_list->Recordset)
	$product_list->Recordset->Close();
?>
<?php if (!$product->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_list->Pager)) $product_list->Pager = new PrevNextPager($product_list->StartRec, $product_list->DisplayRecs, $product_list->TotalRecs, $product_list->AutoHidePager) ?>
<?php if ($product_list->Pager->RecordCount > 0 && $product_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_list->pageUrl() ?>start=<?php echo $product_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_list->TotalRecs > 0 && (!$product_list->AutoHidePageSizeSelector || $product_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($product_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($product_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($product_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($product->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_list->TotalRecs == 0 && !$product->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_list->terminate();
?>