<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_search = new product_search();

// Run the page
$product_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_search->IsModal) { ?>
var fproductsearch = currentAdvancedSearchForm = new ew.Form("fproductsearch", "search");
<?php } else { ?>
var fproductsearch = currentForm = new ew.Form("fproductsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproductsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproductsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproductsearch.lists["x_grp[]"] = <?php echo $product_search->grp->Lookup->toClientList() ?>;
fproductsearch.lists["x_grp[]"].options = <?php echo JsonEncode($product_search->grp->lookupOptions()) ?>;
fproductsearch.lists["x_s_grp[]"] = <?php echo $product_search->s_grp->Lookup->toClientList() ?>;
fproductsearch.lists["x_s_grp[]"].options = <?php echo JsonEncode($product_search->s_grp->lookupOptions()) ?>;
fproductsearch.lists["x_publish"] = <?php echo $product_search->publish->Lookup->toClientList() ?>;
fproductsearch.lists["x_publish"].options = <?php echo JsonEncode($product_search->publish->options(FALSE, TRUE)) ?>;
fproductsearch.lists["x_status"] = <?php echo $product_search->status->Lookup->toClientList() ?>;
fproductsearch.lists["x_status"].options = <?php echo JsonEncode($product_search->status->options(FALSE, TRUE)) ?>;
fproductsearch.lists["x_company_id"] = <?php echo $product_search->company_id->Lookup->toClientList() ?>;
fproductsearch.lists["x_company_id"].options = <?php echo JsonEncode($product_search->company_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproductsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
		return this.onError(elm, "<?php echo JsEncode($product->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_prod_capacity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product->prod_capacity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_search->showPageHeader(); ?>
<?php
$product_search->showMessage();
?>
<form name="fproductsearch" id="fproductsearch" class="<?php echo $product_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_id"><?php echo $product->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->id->cellAttributes() ?>>
			<span id="el_product_id">
<input type="text" data-table="product" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product->id->getPlaceHolder()) ?>" value="<?php echo $product->id->EditValue ?>"<?php echo $product->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_grp"><?php echo $product->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->grp->cellAttributes() ?>>
			<span id="el_product_grp">
<?php $product->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$product->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_grp" data-value-separator="<?php echo $product->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $product->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $product->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_s_grp"><?php echo $product->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->s_grp->cellAttributes() ?>>
			<span id="el_product_s_grp">
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="product" data-field="x_s_grp" data-value-separator="<?php echo $product->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $product->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $product->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $product->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_product"><?php echo $product->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->product->cellAttributes() ?>>
			<span id="el_product_product">
<input type="text" data-table="product" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->product->getPlaceHolder()) ?>" value="<?php echo $product->product->EditValue ?>"<?php echo $product->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label for="x_publish" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_publish"><?php echo $product->publish->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_publish" id="z_publish" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->publish->cellAttributes() ?>>
			<span id="el_product_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_publish" data-value-separator="<?php echo $product->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $product->publish->editAttributes() ?>>
		<?php echo $product->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_image"><?php echo $product->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->image->cellAttributes() ?>>
			<span id="el_product_image">
<input type="text" data-table="product" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($product->image->getPlaceHolder()) ?>" value="<?php echo $product->image->EditValue ?>"<?php echo $product->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_status"><?php echo $product->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->status->cellAttributes() ?>>
			<span id="el_product_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_status" data-value-separator="<?php echo $product->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product->status->editAttributes() ?>>
		<?php echo $product->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_remarks"><?php echo $product->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->remarks->cellAttributes() ?>>
			<span id="el_product_remarks">
<input type="text" data-table="product" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product->remarks->getPlaceHolder()) ?>" value="<?php echo $product->remarks->EditValue ?>"<?php echo $product->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_company_id"><?php echo $product->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->company_id->cellAttributes() ?>>
			<span id="el_product_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product" data-field="x_company_id" data-value-separator="<?php echo $product->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product->company_id->editAttributes() ?>>
		<?php echo $product->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product->prod_capacity->Visible) { // prod_capacity ?>
	<div id="r_prod_capacity" class="form-group row">
		<label for="x_prod_capacity" class="<?php echo $product_search->LeftColumnClass ?>"><span id="elh_product_prod_capacity"><?php echo $product->prod_capacity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_prod_capacity" id="z_prod_capacity" value="="></span>
		</label>
		<div class="<?php echo $product_search->RightColumnClass ?>"><div<?php echo $product->prod_capacity->cellAttributes() ?>>
			<span id="el_product_prod_capacity">
<input type="text" data-table="product" data-field="x_prod_capacity" name="x_prod_capacity" id="x_prod_capacity" size="30" placeholder="<?php echo HtmlEncode($product->prod_capacity->getPlaceHolder()) ?>" value="<?php echo $product->prod_capacity->EditValue ?>"<?php echo $product->prod_capacity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_search->terminate();
?>