<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$property_details_add = new property_details_add();

// Run the page
$property_details_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$property_details_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproperty_detailsadd = currentForm = new ew.Form("fproperty_detailsadd", "add");

// Validate form
fproperty_detailsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($property_details_add->image->Required) { ?>
			elm = this.getElements("x" + infix + "_image");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->image->caption(), $property_details->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->floor->Required) { ?>
			elm = this.getElements("x" + infix + "_floor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->floor->caption(), $property_details->floor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->no->Required) { ?>
			elm = this.getElements("x" + infix + "_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->no->caption(), $property_details->no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->length->Required) { ?>
			elm = this.getElements("x" + infix + "_length");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->length->caption(), $property_details->length->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->width->Required) { ?>
			elm = this.getElements("x" + infix + "_width");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->width->caption(), $property_details->width->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->type->caption(), $property_details->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->area->Required) { ?>
			elm = this.getElements("x" + infix + "_area");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->area->caption(), $property_details->area->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_area");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($property_details->area->errorMessage()) ?>");
		<?php if ($property_details_add->sa_area->Required) { ?>
			elm = this.getElements("x" + infix + "_sa_area");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->sa_area->caption(), $property_details->sa_area->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sa_area");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($property_details->sa_area->errorMessage()) ?>");
		<?php if ($property_details_add->coords->Required) { ?>
			elm = this.getElements("x" + infix + "_coords");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->coords->caption(), $property_details->coords->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->operator->caption(), $property_details->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_details_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_details->datetime->caption(), $property_details->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproperty_detailsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproperty_detailsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproperty_detailsadd.lists["x_floor"] = <?php echo $property_details_add->floor->Lookup->toClientList() ?>;
fproperty_detailsadd.lists["x_floor"].options = <?php echo JsonEncode($property_details_add->floor->lookupOptions()) ?>;
fproperty_detailsadd.lists["x_type"] = <?php echo $property_details_add->type->Lookup->toClientList() ?>;
fproperty_detailsadd.lists["x_type"].options = <?php echo JsonEncode($property_details_add->type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $property_details_add->showPageHeader(); ?>
<?php
$property_details_add->showMessage();
?>
<form name="fproperty_detailsadd" id="fproperty_detailsadd" class="<?php echo $property_details_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($property_details_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $property_details_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="property_details">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$property_details_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($property_details->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_property_details_image" for="x_image" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->image->caption() ?><?php echo ($property_details->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->image->cellAttributes() ?>>
<span id="el_property_details_image">
<input type="text" data-table="property_details" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($property_details->image->getPlaceHolder()) ?>" value="<?php echo $property_details->image->EditValue ?>"<?php echo $property_details->image->editAttributes() ?>>
</span>
<?php echo $property_details->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->floor->Visible) { // floor ?>
	<div id="r_floor" class="form-group row">
		<label id="elh_property_details_floor" for="x_floor" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->floor->caption() ?><?php echo ($property_details->floor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->floor->cellAttributes() ?>>
<span id="el_property_details_floor">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_details" data-field="x_floor" data-value-separator="<?php echo $property_details->floor->displayValueSeparatorAttribute() ?>" id="x_floor" name="x_floor"<?php echo $property_details->floor->editAttributes() ?>>
		<?php echo $property_details->floor->selectOptionListHtml("x_floor") ?>
	</select>
</div>
<?php echo $property_details->floor->Lookup->getParamTag("p_x_floor") ?>
</span>
<?php echo $property_details->floor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label id="elh_property_details_no" for="x_no" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->no->caption() ?><?php echo ($property_details->no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->no->cellAttributes() ?>>
<span id="el_property_details_no">
<input type="text" data-table="property_details" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($property_details->no->getPlaceHolder()) ?>" value="<?php echo $property_details->no->EditValue ?>"<?php echo $property_details->no->editAttributes() ?>>
</span>
<?php echo $property_details->no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->length->Visible) { // length ?>
	<div id="r_length" class="form-group row">
		<label id="elh_property_details_length" for="x_length" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->length->caption() ?><?php echo ($property_details->length->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->length->cellAttributes() ?>>
<span id="el_property_details_length">
<input type="text" data-table="property_details" data-field="x_length" name="x_length" id="x_length" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($property_details->length->getPlaceHolder()) ?>" value="<?php echo $property_details->length->EditValue ?>"<?php echo $property_details->length->editAttributes() ?>>
</span>
<?php echo $property_details->length->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->width->Visible) { // width ?>
	<div id="r_width" class="form-group row">
		<label id="elh_property_details_width" for="x_width" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->width->caption() ?><?php echo ($property_details->width->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->width->cellAttributes() ?>>
<span id="el_property_details_width">
<input type="text" data-table="property_details" data-field="x_width" name="x_width" id="x_width" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($property_details->width->getPlaceHolder()) ?>" value="<?php echo $property_details->width->EditValue ?>"<?php echo $property_details->width->editAttributes() ?>>
</span>
<?php echo $property_details->width->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_property_details_type" for="x_type" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->type->caption() ?><?php echo ($property_details->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->type->cellAttributes() ?>>
<span id="el_property_details_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_details" data-field="x_type" data-value-separator="<?php echo $property_details->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $property_details->type->editAttributes() ?>>
		<?php echo $property_details->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $property_details->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $property_details->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->area->Visible) { // area ?>
	<div id="r_area" class="form-group row">
		<label id="elh_property_details_area" for="x_area" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->area->caption() ?><?php echo ($property_details->area->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->area->cellAttributes() ?>>
<span id="el_property_details_area">
<input type="text" data-table="property_details" data-field="x_area" name="x_area" id="x_area" size="30" placeholder="<?php echo HtmlEncode($property_details->area->getPlaceHolder()) ?>" value="<?php echo $property_details->area->EditValue ?>"<?php echo $property_details->area->editAttributes() ?>>
</span>
<?php echo $property_details->area->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->sa_area->Visible) { // sa_area ?>
	<div id="r_sa_area" class="form-group row">
		<label id="elh_property_details_sa_area" for="x_sa_area" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->sa_area->caption() ?><?php echo ($property_details->sa_area->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->sa_area->cellAttributes() ?>>
<span id="el_property_details_sa_area">
<input type="text" data-table="property_details" data-field="x_sa_area" name="x_sa_area" id="x_sa_area" size="30" placeholder="<?php echo HtmlEncode($property_details->sa_area->getPlaceHolder()) ?>" value="<?php echo $property_details->sa_area->EditValue ?>"<?php echo $property_details->sa_area->editAttributes() ?>>
</span>
<?php echo $property_details->sa_area->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_details->coords->Visible) { // coords ?>
	<div id="r_coords" class="form-group row">
		<label id="elh_property_details_coords" for="x_coords" class="<?php echo $property_details_add->LeftColumnClass ?>"><?php echo $property_details->coords->caption() ?><?php echo ($property_details->coords->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_details_add->RightColumnClass ?>"><div<?php echo $property_details->coords->cellAttributes() ?>>
<span id="el_property_details_coords">
<textarea data-table="property_details" data-field="x_coords" name="x_coords" id="x_coords" cols="35" rows="4" placeholder="<?php echo HtmlEncode($property_details->coords->getPlaceHolder()) ?>"<?php echo $property_details->coords->editAttributes() ?>><?php echo $property_details->coords->EditValue ?></textarea>
</span>
<?php echo $property_details->coords->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$property_details_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $property_details_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $property_details_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$property_details_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$property_details_add->terminate();
?>