<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$property_details_list = new property_details_list();

// Run the page
$property_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$property_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$property_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproperty_detailslist = currentForm = new ew.Form("fproperty_detailslist", "list");
fproperty_detailslist.formKeyCountName = '<?php echo $property_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproperty_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproperty_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproperty_detailslist.lists["x_floor"] = <?php echo $property_details_list->floor->Lookup->toClientList() ?>;
fproperty_detailslist.lists["x_floor"].options = <?php echo JsonEncode($property_details_list->floor->lookupOptions()) ?>;
fproperty_detailslist.lists["x_type"] = <?php echo $property_details_list->type->Lookup->toClientList() ?>;
fproperty_detailslist.lists["x_type"].options = <?php echo JsonEncode($property_details_list->type->lookupOptions()) ?>;

// Form object for search
var fproperty_detailslistsrch = currentSearchForm = new ew.Form("fproperty_detailslistsrch");

// Validate function for search
fproperty_detailslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_area");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($property_details->area->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sa_area");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($property_details->sa_area->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproperty_detailslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproperty_detailslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproperty_detailslistsrch.lists["x_floor"] = <?php echo $property_details_list->floor->Lookup->toClientList() ?>;
fproperty_detailslistsrch.lists["x_floor"].options = <?php echo JsonEncode($property_details_list->floor->lookupOptions()) ?>;
fproperty_detailslistsrch.lists["x_type"] = <?php echo $property_details_list->type->Lookup->toClientList() ?>;
fproperty_detailslistsrch.lists["x_type"].options = <?php echo JsonEncode($property_details_list->type->lookupOptions()) ?>;

// Filters
fproperty_detailslistsrch.filterList = <?php echo $property_details_list->getFilterList() ?>;

// Init search panel as collapsed
fproperty_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$property_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($property_details_list->TotalRecs > 0 && $property_details_list->ExportOptions->visible()) { ?>
<?php $property_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($property_details_list->ImportOptions->visible()) { ?>
<?php $property_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($property_details_list->SearchOptions->visible()) { ?>
<?php $property_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($property_details_list->FilterOptions->visible()) { ?>
<?php $property_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$property_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$property_details->isExport() && !$property_details->CurrentAction) { ?>
<form name="fproperty_detailslistsrch" id="fproperty_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($property_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproperty_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="property_details">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$property_details_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$property_details->RowType = ROWTYPE_SEARCH;

// Render row
$property_details->resetAttributes();
$property_details_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($property_details->floor->Visible) { // floor ?>
	<div id="xsc_floor" class="ew-cell form-group">
		<label for="x_floor" class="ew-search-caption ew-label"><?php echo $property_details->floor->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_floor" id="z_floor" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_details" data-field="x_floor" data-value-separator="<?php echo $property_details->floor->displayValueSeparatorAttribute() ?>" id="x_floor" name="x_floor"<?php echo $property_details->floor->editAttributes() ?>>
		<?php echo $property_details->floor->selectOptionListHtml("x_floor") ?>
	</select>
</div>
<?php echo $property_details->floor->Lookup->getParamTag("p_x_floor") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($property_details->no->Visible) { // no ?>
	<div id="xsc_no" class="ew-cell form-group">
		<label for="x_no" class="ew-search-caption ew-label"><?php echo $property_details->no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no" id="z_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="property_details" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($property_details->no->getPlaceHolder()) ?>" value="<?php echo $property_details->no->EditValue ?>"<?php echo $property_details->no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($property_details->length->Visible) { // length ?>
	<div id="xsc_length" class="ew-cell form-group">
		<label for="x_length" class="ew-search-caption ew-label"><?php echo $property_details->length->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_length" id="z_length" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="property_details" data-field="x_length" name="x_length" id="x_length" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($property_details->length->getPlaceHolder()) ?>" value="<?php echo $property_details->length->EditValue ?>"<?php echo $property_details->length->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($property_details->width->Visible) { // width ?>
	<div id="xsc_width" class="ew-cell form-group">
		<label for="x_width" class="ew-search-caption ew-label"><?php echo $property_details->width->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_width" id="z_width" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="property_details" data-field="x_width" name="x_width" id="x_width" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($property_details->width->getPlaceHolder()) ?>" value="<?php echo $property_details->width->EditValue ?>"<?php echo $property_details->width->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
<?php if ($property_details->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $property_details->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_details" data-field="x_type" data-value-separator="<?php echo $property_details->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $property_details->type->editAttributes() ?>>
		<?php echo $property_details->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $property_details->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ew-row d-sm-flex">
<?php if ($property_details->area->Visible) { // area ?>
	<div id="xsc_area" class="ew-cell form-group">
		<label for="x_area" class="ew-search-caption ew-label"><?php echo $property_details->area->caption() ?></label>
		<span class="ew-search-operator"><select name="z_area" id="z_area" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($property_details->area->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($property_details->area->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($property_details->area->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($property_details->area->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($property_details->area->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($property_details->area->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($property_details->area->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="property_details" data-field="x_area" name="x_area" id="x_area" size="30" placeholder="<?php echo HtmlEncode($property_details->area->getPlaceHolder()) ?>" value="<?php echo $property_details->area->EditValue ?>"<?php echo $property_details->area->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_area style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_area style="d-none"">
<input type="text" data-table="property_details" data-field="x_area" name="y_area" id="y_area" size="30" placeholder="<?php echo HtmlEncode($property_details->area->getPlaceHolder()) ?>" value="<?php echo $property_details->area->EditValue2 ?>"<?php echo $property_details->area->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ew-row d-sm-flex">
<?php if ($property_details->sa_area->Visible) { // sa_area ?>
	<div id="xsc_sa_area" class="ew-cell form-group">
		<label for="x_sa_area" class="ew-search-caption ew-label"><?php echo $property_details->sa_area->caption() ?></label>
		<span class="ew-search-operator"><select name="z_sa_area" id="z_sa_area" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($property_details->sa_area->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="property_details" data-field="x_sa_area" name="x_sa_area" id="x_sa_area" size="30" placeholder="<?php echo HtmlEncode($property_details->sa_area->getPlaceHolder()) ?>" value="<?php echo $property_details->sa_area->EditValue ?>"<?php echo $property_details->sa_area->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_sa_area style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_sa_area style="d-none"">
<input type="text" data-table="property_details" data-field="x_sa_area" name="y_sa_area" id="y_sa_area" size="30" placeholder="<?php echo HtmlEncode($property_details->sa_area->getPlaceHolder()) ?>" value="<?php echo $property_details->sa_area->EditValue2 ?>"<?php echo $property_details->sa_area->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_8" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($property_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($property_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $property_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($property_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($property_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($property_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($property_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $property_details_list->showPageHeader(); ?>
<?php
$property_details_list->showMessage();
?>
<?php if ($property_details_list->TotalRecs > 0 || $property_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($property_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> property_details">
<?php if (!$property_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$property_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($property_details_list->Pager)) $property_details_list->Pager = new PrevNextPager($property_details_list->StartRec, $property_details_list->DisplayRecs, $property_details_list->TotalRecs, $property_details_list->AutoHidePager) ?>
<?php if ($property_details_list->Pager->RecordCount > 0 && $property_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($property_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($property_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $property_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($property_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($property_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $property_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($property_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $property_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $property_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $property_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($property_details_list->TotalRecs > 0 && (!$property_details_list->AutoHidePageSizeSelector || $property_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="property_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($property_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($property_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($property_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($property_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($property_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($property_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $property_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproperty_detailslist" id="fproperty_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($property_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $property_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="property_details">
<div id="gmp_property_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($property_details_list->TotalRecs > 0 || $property_details->isGridEdit()) { ?>
<table id="tbl_property_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$property_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$property_details_list->renderListOptions();

// Render list options (header, left)
$property_details_list->ListOptions->render("header", "left");
?>
<?php if ($property_details->id->Visible) { // id ?>
	<?php if ($property_details->sortUrl($property_details->id) == "") { ?>
		<th data-name="id" class="<?php echo $property_details->id->headerCellClass() ?>"><div id="elh_property_details_id" class="property_details_id"><div class="ew-table-header-caption"><?php echo $property_details->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $property_details->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->id) ?>',2);"><div id="elh_property_details_id" class="property_details_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->image->Visible) { // image ?>
	<?php if ($property_details->sortUrl($property_details->image) == "") { ?>
		<th data-name="image" class="<?php echo $property_details->image->headerCellClass() ?>"><div id="elh_property_details_image" class="property_details_image"><div class="ew-table-header-caption"><?php echo $property_details->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $property_details->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->image) ?>',2);"><div id="elh_property_details_image" class="property_details_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($property_details->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->floor->Visible) { // floor ?>
	<?php if ($property_details->sortUrl($property_details->floor) == "") { ?>
		<th data-name="floor" class="<?php echo $property_details->floor->headerCellClass() ?>"><div id="elh_property_details_floor" class="property_details_floor"><div class="ew-table-header-caption"><?php echo $property_details->floor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="floor" class="<?php echo $property_details->floor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->floor) ?>',2);"><div id="elh_property_details_floor" class="property_details_floor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->floor->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->floor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->floor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->no->Visible) { // no ?>
	<?php if ($property_details->sortUrl($property_details->no) == "") { ?>
		<th data-name="no" class="<?php echo $property_details->no->headerCellClass() ?>"><div id="elh_property_details_no" class="property_details_no"><div class="ew-table-header-caption"><?php echo $property_details->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $property_details->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->no) ?>',2);"><div id="elh_property_details_no" class="property_details_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($property_details->no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->length->Visible) { // length ?>
	<?php if ($property_details->sortUrl($property_details->length) == "") { ?>
		<th data-name="length" class="<?php echo $property_details->length->headerCellClass() ?>"><div id="elh_property_details_length" class="property_details_length"><div class="ew-table-header-caption"><?php echo $property_details->length->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="length" class="<?php echo $property_details->length->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->length) ?>',2);"><div id="elh_property_details_length" class="property_details_length">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->length->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($property_details->length->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->length->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->width->Visible) { // width ?>
	<?php if ($property_details->sortUrl($property_details->width) == "") { ?>
		<th data-name="width" class="<?php echo $property_details->width->headerCellClass() ?>"><div id="elh_property_details_width" class="property_details_width"><div class="ew-table-header-caption"><?php echo $property_details->width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="width" class="<?php echo $property_details->width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->width) ?>',2);"><div id="elh_property_details_width" class="property_details_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->width->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($property_details->width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->type->Visible) { // type ?>
	<?php if ($property_details->sortUrl($property_details->type) == "") { ?>
		<th data-name="type" class="<?php echo $property_details->type->headerCellClass() ?>"><div id="elh_property_details_type" class="property_details_type"><div class="ew-table-header-caption"><?php echo $property_details->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $property_details->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->type) ?>',2);"><div id="elh_property_details_type" class="property_details_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->area->Visible) { // area ?>
	<?php if ($property_details->sortUrl($property_details->area) == "") { ?>
		<th data-name="area" class="<?php echo $property_details->area->headerCellClass() ?>"><div id="elh_property_details_area" class="property_details_area"><div class="ew-table-header-caption"><?php echo $property_details->area->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="area" class="<?php echo $property_details->area->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->area) ?>',2);"><div id="elh_property_details_area" class="property_details_area">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->area->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->area->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->area->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->sa_area->Visible) { // sa_area ?>
	<?php if ($property_details->sortUrl($property_details->sa_area) == "") { ?>
		<th data-name="sa_area" class="<?php echo $property_details->sa_area->headerCellClass() ?>"><div id="elh_property_details_sa_area" class="property_details_sa_area"><div class="ew-table-header-caption"><?php echo $property_details->sa_area->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sa_area" class="<?php echo $property_details->sa_area->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->sa_area) ?>',2);"><div id="elh_property_details_sa_area" class="property_details_sa_area">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->sa_area->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->sa_area->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->sa_area->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->operator->Visible) { // operator ?>
	<?php if ($property_details->sortUrl($property_details->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $property_details->operator->headerCellClass() ?>"><div id="elh_property_details_operator" class="property_details_operator"><div class="ew-table-header-caption"><?php echo $property_details->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $property_details->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->operator) ?>',2);"><div id="elh_property_details_operator" class="property_details_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($property_details->datetime->Visible) { // datetime ?>
	<?php if ($property_details->sortUrl($property_details->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $property_details->datetime->headerCellClass() ?>"><div id="elh_property_details_datetime" class="property_details_datetime"><div class="ew-table-header-caption"><?php echo $property_details->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $property_details->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $property_details->SortUrl($property_details->datetime) ?>',2);"><div id="elh_property_details_datetime" class="property_details_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $property_details->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($property_details->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($property_details->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$property_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($property_details->ExportAll && $property_details->isExport()) {
	$property_details_list->StopRec = $property_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($property_details_list->TotalRecs > $property_details_list->StartRec + $property_details_list->DisplayRecs - 1)
		$property_details_list->StopRec = $property_details_list->StartRec + $property_details_list->DisplayRecs - 1;
	else
		$property_details_list->StopRec = $property_details_list->TotalRecs;
}
$property_details_list->RecCnt = $property_details_list->StartRec - 1;
if ($property_details_list->Recordset && !$property_details_list->Recordset->EOF) {
	$property_details_list->Recordset->moveFirst();
	$selectLimit = $property_details_list->UseSelectLimit;
	if (!$selectLimit && $property_details_list->StartRec > 1)
		$property_details_list->Recordset->move($property_details_list->StartRec - 1);
} elseif (!$property_details->AllowAddDeleteRow && $property_details_list->StopRec == 0) {
	$property_details_list->StopRec = $property_details->GridAddRowCount;
}

// Initialize aggregate
$property_details->RowType = ROWTYPE_AGGREGATEINIT;
$property_details->resetAttributes();
$property_details_list->renderRow();
while ($property_details_list->RecCnt < $property_details_list->StopRec) {
	$property_details_list->RecCnt++;
	if ($property_details_list->RecCnt >= $property_details_list->StartRec) {
		$property_details_list->RowCnt++;

		// Set up key count
		$property_details_list->KeyCount = $property_details_list->RowIndex;

		// Init row class and style
		$property_details->resetAttributes();
		$property_details->CssClass = "";
		if ($property_details->isGridAdd()) {
		} else {
			$property_details_list->loadRowValues($property_details_list->Recordset); // Load row values
		}
		$property_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$property_details->RowAttrs = array_merge($property_details->RowAttrs, array('data-rowindex'=>$property_details_list->RowCnt, 'id'=>'r' . $property_details_list->RowCnt . '_property_details', 'data-rowtype'=>$property_details->RowType));

		// Render row
		$property_details_list->renderRow();

		// Render list options
		$property_details_list->renderListOptions();
?>
	<tr<?php echo $property_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$property_details_list->ListOptions->render("body", "left", $property_details_list->RowCnt);
?>
	<?php if ($property_details->id->Visible) { // id ?>
		<td data-name="id"<?php echo $property_details->id->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_id" class="property_details_id">
<span<?php echo $property_details->id->viewAttributes() ?>>
<?php echo $property_details->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->image->Visible) { // image ?>
		<td data-name="image"<?php echo $property_details->image->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_image" class="property_details_image">
<span<?php echo $property_details->image->viewAttributes() ?>>
<?php echo $property_details->image->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->floor->Visible) { // floor ?>
		<td data-name="floor"<?php echo $property_details->floor->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_floor" class="property_details_floor">
<span<?php echo $property_details->floor->viewAttributes() ?>>
<?php echo $property_details->floor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->no->Visible) { // no ?>
		<td data-name="no"<?php echo $property_details->no->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_no" class="property_details_no">
<span<?php echo $property_details->no->viewAttributes() ?>>
<?php echo $property_details->no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->length->Visible) { // length ?>
		<td data-name="length"<?php echo $property_details->length->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_length" class="property_details_length">
<span<?php echo $property_details->length->viewAttributes() ?>>
<?php echo $property_details->length->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->width->Visible) { // width ?>
		<td data-name="width"<?php echo $property_details->width->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_width" class="property_details_width">
<span<?php echo $property_details->width->viewAttributes() ?>>
<?php echo $property_details->width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->type->Visible) { // type ?>
		<td data-name="type"<?php echo $property_details->type->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_type" class="property_details_type">
<span<?php echo $property_details->type->viewAttributes() ?>>
<?php echo $property_details->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->area->Visible) { // area ?>
		<td data-name="area"<?php echo $property_details->area->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_area" class="property_details_area">
<span<?php echo $property_details->area->viewAttributes() ?>>
<?php echo $property_details->area->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->sa_area->Visible) { // sa_area ?>
		<td data-name="sa_area"<?php echo $property_details->sa_area->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_sa_area" class="property_details_sa_area">
<span<?php echo $property_details->sa_area->viewAttributes() ?>>
<?php echo $property_details->sa_area->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $property_details->operator->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_operator" class="property_details_operator">
<span<?php echo $property_details->operator->viewAttributes() ?>>
<?php echo $property_details->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($property_details->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $property_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $property_details_list->RowCnt ?>_property_details_datetime" class="property_details_datetime">
<span<?php echo $property_details->datetime->viewAttributes() ?>>
<?php echo $property_details->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$property_details_list->ListOptions->render("body", "right", $property_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$property_details->isGridAdd())
		$property_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$property_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($property_details_list->Recordset)
	$property_details_list->Recordset->Close();
?>
<?php if (!$property_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$property_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($property_details_list->Pager)) $property_details_list->Pager = new PrevNextPager($property_details_list->StartRec, $property_details_list->DisplayRecs, $property_details_list->TotalRecs, $property_details_list->AutoHidePager) ?>
<?php if ($property_details_list->Pager->RecordCount > 0 && $property_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($property_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($property_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $property_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($property_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($property_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $property_details_list->pageUrl() ?>start=<?php echo $property_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $property_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($property_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $property_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $property_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $property_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($property_details_list->TotalRecs > 0 && (!$property_details_list->AutoHidePageSizeSelector || $property_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="property_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($property_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($property_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($property_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($property_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($property_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($property_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $property_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($property_details_list->TotalRecs == 0 && !$property_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $property_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$property_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$property_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$property_details_list->terminate();
?>