<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$property_details_view = new property_details_view();

// Run the page
$property_details_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$property_details_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$property_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproperty_detailsview = currentForm = new ew.Form("fproperty_detailsview", "view");

// Form_CustomValidate event
fproperty_detailsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproperty_detailsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproperty_detailsview.lists["x_floor"] = <?php echo $property_details_view->floor->Lookup->toClientList() ?>;
fproperty_detailsview.lists["x_floor"].options = <?php echo JsonEncode($property_details_view->floor->lookupOptions()) ?>;
fproperty_detailsview.lists["x_type"] = <?php echo $property_details_view->type->Lookup->toClientList() ?>;
fproperty_detailsview.lists["x_type"].options = <?php echo JsonEncode($property_details_view->type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$property_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $property_details_view->ExportOptions->render("body") ?>
<?php $property_details_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $property_details_view->showPageHeader(); ?>
<?php
$property_details_view->showMessage();
?>
<form name="fproperty_detailsview" id="fproperty_detailsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($property_details_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $property_details_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="property_details">
<input type="hidden" name="modal" value="<?php echo (int)$property_details_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($property_details->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_id"><?php echo $property_details->id->caption() ?></span></td>
		<td data-name="id"<?php echo $property_details->id->cellAttributes() ?>>
<span id="el_property_details_id">
<span<?php echo $property_details->id->viewAttributes() ?>>
<?php echo $property_details->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_image"><?php echo $property_details->image->caption() ?></span></td>
		<td data-name="image"<?php echo $property_details->image->cellAttributes() ?>>
<span id="el_property_details_image">
<span<?php echo $property_details->image->viewAttributes() ?>>
<?php echo $property_details->image->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->floor->Visible) { // floor ?>
	<tr id="r_floor">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_floor"><?php echo $property_details->floor->caption() ?></span></td>
		<td data-name="floor"<?php echo $property_details->floor->cellAttributes() ?>>
<span id="el_property_details_floor">
<span<?php echo $property_details->floor->viewAttributes() ?>>
<?php echo $property_details->floor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->no->Visible) { // no ?>
	<tr id="r_no">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_no"><?php echo $property_details->no->caption() ?></span></td>
		<td data-name="no"<?php echo $property_details->no->cellAttributes() ?>>
<span id="el_property_details_no">
<span<?php echo $property_details->no->viewAttributes() ?>>
<?php echo $property_details->no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->length->Visible) { // length ?>
	<tr id="r_length">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_length"><?php echo $property_details->length->caption() ?></span></td>
		<td data-name="length"<?php echo $property_details->length->cellAttributes() ?>>
<span id="el_property_details_length">
<span<?php echo $property_details->length->viewAttributes() ?>>
<?php echo $property_details->length->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->width->Visible) { // width ?>
	<tr id="r_width">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_width"><?php echo $property_details->width->caption() ?></span></td>
		<td data-name="width"<?php echo $property_details->width->cellAttributes() ?>>
<span id="el_property_details_width">
<span<?php echo $property_details->width->viewAttributes() ?>>
<?php echo $property_details->width->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_type"><?php echo $property_details->type->caption() ?></span></td>
		<td data-name="type"<?php echo $property_details->type->cellAttributes() ?>>
<span id="el_property_details_type">
<span<?php echo $property_details->type->viewAttributes() ?>>
<?php echo $property_details->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->area->Visible) { // area ?>
	<tr id="r_area">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_area"><?php echo $property_details->area->caption() ?></span></td>
		<td data-name="area"<?php echo $property_details->area->cellAttributes() ?>>
<span id="el_property_details_area">
<span<?php echo $property_details->area->viewAttributes() ?>>
<?php echo $property_details->area->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->sa_area->Visible) { // sa_area ?>
	<tr id="r_sa_area">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_sa_area"><?php echo $property_details->sa_area->caption() ?></span></td>
		<td data-name="sa_area"<?php echo $property_details->sa_area->cellAttributes() ?>>
<span id="el_property_details_sa_area">
<span<?php echo $property_details->sa_area->viewAttributes() ?>>
<?php echo $property_details->sa_area->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->coords->Visible) { // coords ?>
	<tr id="r_coords">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_coords"><?php echo $property_details->coords->caption() ?></span></td>
		<td data-name="coords"<?php echo $property_details->coords->cellAttributes() ?>>
<span id="el_property_details_coords">
<span<?php echo $property_details->coords->viewAttributes() ?>>
<?php echo $property_details->coords->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_operator"><?php echo $property_details->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $property_details->operator->cellAttributes() ?>>
<span id="el_property_details_operator">
<span<?php echo $property_details->operator->viewAttributes() ?>>
<?php echo $property_details->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($property_details->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $property_details_view->TableLeftColumnClass ?>"><span id="elh_property_details_datetime"><?php echo $property_details->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $property_details->datetime->cellAttributes() ?>>
<span id="el_property_details_datetime">
<span<?php echo $property_details->datetime->viewAttributes() ?>>
<?php echo $property_details->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$property_details_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$property_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$property_details_view->terminate();
?>