<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$property_misc_add = new property_misc_add();

// Run the page
$property_misc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$property_misc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproperty_miscadd = currentForm = new ew.Form("fproperty_miscadd", "add");

// Validate form
fproperty_miscadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($property_misc_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_misc->item->caption(), $property_misc->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_misc_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_misc->grp->caption(), $property_misc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_misc_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_misc->status->caption(), $property_misc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_misc_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_misc->operator->caption(), $property_misc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($property_misc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $property_misc->datetime->caption(), $property_misc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproperty_miscadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproperty_miscadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproperty_miscadd.lists["x_grp"] = <?php echo $property_misc_add->grp->Lookup->toClientList() ?>;
fproperty_miscadd.lists["x_grp"].options = <?php echo JsonEncode($property_misc_add->grp->lookupOptions()) ?>;
fproperty_miscadd.lists["x_status"] = <?php echo $property_misc_add->status->Lookup->toClientList() ?>;
fproperty_miscadd.lists["x_status"].options = <?php echo JsonEncode($property_misc_add->status->options(FALSE, TRUE)) ?>;
fproperty_miscadd.lists["x_operator"] = <?php echo $property_misc_add->operator->Lookup->toClientList() ?>;
fproperty_miscadd.lists["x_operator"].options = <?php echo JsonEncode($property_misc_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $property_misc_add->showPageHeader(); ?>
<?php
$property_misc_add->showMessage();
?>
<form name="fproperty_miscadd" id="fproperty_miscadd" class="<?php echo $property_misc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($property_misc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $property_misc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="property_misc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$property_misc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($property_misc->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_property_misc_item" for="x_item" class="<?php echo $property_misc_add->LeftColumnClass ?>"><?php echo $property_misc->item->caption() ?><?php echo ($property_misc->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_misc_add->RightColumnClass ?>"><div<?php echo $property_misc->item->cellAttributes() ?>>
<span id="el_property_misc_item">
<input type="text" data-table="property_misc" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($property_misc->item->getPlaceHolder()) ?>" value="<?php echo $property_misc->item->EditValue ?>"<?php echo $property_misc->item->editAttributes() ?>>
</span>
<?php echo $property_misc->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_misc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_property_misc_grp" for="x_grp" class="<?php echo $property_misc_add->LeftColumnClass ?>"><?php echo $property_misc->grp->caption() ?><?php echo ($property_misc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_misc_add->RightColumnClass ?>"><div<?php echo $property_misc->grp->cellAttributes() ?>>
<span id="el_property_misc_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_misc" data-field="x_grp" data-value-separator="<?php echo $property_misc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $property_misc->grp->editAttributes() ?>>
		<?php echo $property_misc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $property_misc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $property_misc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($property_misc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_property_misc_status" for="x_status" class="<?php echo $property_misc_add->LeftColumnClass ?>"><?php echo $property_misc->status->caption() ?><?php echo ($property_misc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $property_misc_add->RightColumnClass ?>"><div<?php echo $property_misc->status->cellAttributes() ?>>
<span id="el_property_misc_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="property_misc" data-field="x_status" data-value-separator="<?php echo $property_misc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $property_misc->status->editAttributes() ?>>
		<?php echo $property_misc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $property_misc->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$property_misc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $property_misc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $property_misc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$property_misc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$property_misc_add->terminate();
?>